/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.FieldInfo;
import com.tangosol.dev.compiler.PackageInfo;
import com.tangosol.dev.compiler.TypeInfo;
import com.tangosol.dev.compiler.java.Block;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.FieldAccessExpression;
import com.tangosol.dev.compiler.java.ThisExpression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.TokenConstants;
import com.tangosol.dev.compiler.java.TypeExpression;
import com.tangosol.dev.compiler.java.Variable;
import com.tangosol.dev.compiler.java.VariableExpression;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NameExpression
extends Expression
implements TokenConstants {
    private static final String CLASS = "NameExpression";
    private List listNames;
    private boolean fAssignee;

    public NameExpression(Block block, Token tokName) {
        super(block, tokName);
    }

    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression expr = this;
        boolean fQualified = this.isQualified();
        Block block = this.getBlock();
        Token tokName = this.getStartToken();
        String sName = tokName.getText();
        if (fQualified) {
            List listNames = this.listNames;
            int cNames = listNames.size();
            int iName = 0;
            Variable var = block.getVariable(sName);
            if (var != null) {
                VariableExpression exprVar = new VariableExpression(block, tokName);
                exprVar.setAssignee(this.fAssignee);
                expr = exprVar;
                iName = 1;
            } else {
                FieldInfo field = ctx.getMethodInfo().getTypeInfo().getFieldInfo(sName);
                if (field != null && !field.isViaAccessor()) {
                    Token tokThis = new Token(Token.TOK_THIS, tokName.getLine(), tokName.getOffset(), 0);
                    Token tokDot = new Token(Token.TOK_DOT, tokName.getLine(), tokName.getOffset(), 0);
                    expr = new FieldAccessExpression(tokDot, new ThisExpression(block, tokThis), tokName);
                    iName = 1;
                } else {
                    PackageInfo pkg = null;
                    TypeInfo type = null;
                    ArrayList<Token> listType = new ArrayList<Token>();
                    DataType dt = ctx.getImport(sName);
                    if (dt != null) {
                        type = ctx.getTypeInfo(dt);
                        if (type == null) {
                            tokName.logError(3, "JC-030", new String[]{dt.isComponent() ? dt.getComponentName() : dt.getClassName()}, errlist);
                        }
                    } else {
                        type = ctx.getMethodInfo().getTypeInfo().getPackageInfo().getTypeInfo(sName);
                        if (type == null && (type = ctx.getTypeInfo(sName)) == null && (pkg = ctx.getPackageInfo(sName)) == null) {
                            this.logError(3, "JC-060", new String[]{sName}, errlist);
                        }
                    }
                    if (pkg != null || type != null) {
                        block35: {
                            if (type != null) {
                                pkg = type.getPackageInfo().getPackageInfo(sName);
                            }
                            do {
                                listType.add(tokName);
                                tokName = (Token)listNames.get(++iName);
                                sName = tokName.getText();
                                if (type != null && (field = type.getFieldInfo(sName)) != null && !field.isViaAccessor()) {
                                    this.listNames = listType;
                                    expr = new TypeExpression(this);
                                    break block35;
                                }
                                if (pkg == null) {
                                    type = null;
                                } else {
                                    type = pkg.getTypeInfo(sName);
                                    pkg = pkg.getPackageInfo(sName);
                                }
                                if (pkg == null && type == null) break block35;
                            } while (iName != cNames - 1);
                            if (type != null) {
                                iName = cNames;
                                expr = new TypeExpression(this);
                            }
                        }
                        if (expr == this) {
                            StringBuffer sb = new StringBuffer();
                            int c = listType.size();
                            for (int i = 0; i < c; ++i) {
                                if (i > 0) {
                                    sb.append('.');
                                }
                                sb.append(((Token)listType.get(i)).getText());
                            }
                            String sTypeOrPkg = sb.toString();
                            if (ctx.getTypeInfo(sTypeOrPkg) != null) {
                                this.logError(3, "JC-062", new String[]{sName, sTypeOrPkg}, errlist);
                            } else {
                                this.logError(3, "JC-055", new String[]{sName, sTypeOrPkg}, errlist);
                            }
                        }
                    }
                }
            }
            if (expr != this) {
                while (iName < cNames) {
                    tokName = (Token)listNames.get(iName);
                    Token tokDot = new Token(Token.TOK_DOT, tokName.getLine(), tokName.getOffset(), 0);
                    expr = new FieldAccessExpression(tokDot, expr, tokName);
                    ++iName;
                }
            }
        } else {
            Variable var = block.getVariable(sName);
            if (var != null) {
                VariableExpression exprVar = new VariableExpression(block, tokName);
                exprVar.setAssignee(this.fAssignee);
                expr = exprVar;
            } else {
                FieldInfo field = ctx.getMethodInfo().getTypeInfo().getFieldInfo(sName);
                if (field != null && !field.isViaAccessor()) {
                    Token tokThis = new Token(Token.TOK_THIS, tokName.getLine(), tokName.getOffset(), 0);
                    Token tokDot = new Token(Token.TOK_DOT, tokName.getLine(), tokName.getOffset(), 0);
                    expr = new FieldAccessExpression(tokDot, new ThisExpression(block, tokThis), tokName);
                } else if (ctx.getImport(sName) != null) {
                    expr = new TypeExpression(this);
                } else if (ctx.getMethodInfo().getTypeInfo().getPackageInfo().getTypeInfo(sName) != null) {
                    expr = new TypeExpression(this);
                } else if (ctx.getTypeInfo(sName) != null) {
                    expr = new TypeExpression(this);
                } else {
                    this.logError(3, "JC-060", new String[]{sName}, errlist);
                }
            }
        }
        if (expr != this) {
            expr = (Expression)((Element)expr).precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        }
        return expr;
    }

    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        throw new IllegalStateException();
    }

    protected boolean checkAssignable(ErrorList errlist) throws CompilerException {
        this.setAssignee(true);
        return true;
    }

    public String getName() {
        String sName;
        if (this.isQualified()) {
            StringBuffer sb = new StringBuffer();
            List listNames = this.listNames;
            int c = listNames.size();
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    sb.append('.');
                }
                sb.append(((Token)listNames.get(i)).getText());
            }
            sName = sb.toString();
        } else {
            sName = this.getStartToken().getText();
        }
        return sName;
    }

    public int getTokenCount() {
        return this.listNames == null ? 1 : this.listNames.size();
    }

    public Token getToken(int i) {
        return this.listNames == null ? this.getStartToken() : (Token)this.listNames.get(i);
    }

    public boolean isQualified() {
        List listNames = this.listNames;
        return listNames != null && listNames.size() > 1;
    }

    protected void addName(Token tokName) {
        ArrayList<Token> listNames = this.listNames;
        if (listNames == null) {
            this.listNames = listNames = new ArrayList<Token>();
            listNames.add(this.getStartToken());
        }
        this.setEndToken(tokName);
        listNames.add(tokName);
    }

    protected Token removeName() {
        List listNames = this.listNames;
        if (listNames != null) {
            int iName = listNames.size() - 1;
            if (iName >= 1) {
                this.setEndToken((Token)listNames.get(iName - 1));
            }
            return (Token)listNames.remove(iName);
        }
        return this.getStartToken();
    }

    public boolean isAssignee() {
        return this.fAssignee;
    }

    protected void setAssignee(boolean fAssignee) {
        this.fAssignee = fAssignee;
    }

    public String toString() {
        return super.toString() + " " + this.getName();
    }
}

