/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.Anewarray;
import com.tangosol.dev.assembler.Bnewarray;
import com.tangosol.dev.assembler.Cnewarray;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Dnewarray;
import com.tangosol.dev.assembler.Fnewarray;
import com.tangosol.dev.assembler.Inewarray;
import com.tangosol.dev.assembler.Lnewarray;
import com.tangosol.dev.assembler.Multianewarray;
import com.tangosol.dev.assembler.Snewarray;
import com.tangosol.dev.assembler.Znewarray;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.ArrayExpression;
import com.tangosol.dev.compiler.java.Block;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.NewExpression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.TypeExpression;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.util.Map;

public class NewArrayExpression
extends NewExpression {
    private static final String CLASS = "NewArrayExpression";
    private static final DataType UNKNOWN = DataType.UNKNOWN;
    private static final DataType INT = DataType.INT;
    private Expression[] aexprDims;
    private ArrayExpression exprValue;

    public NewArrayExpression(Block block, Token tokFirst, Token tokLast, TypeExpression type, Expression[] dims, ArrayExpression value) {
        super(block, tokFirst, tokLast, type);
        this.aexprDims = dims;
        this.exprValue = value;
    }

    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        super.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        TypeExpression exprType = this.getTypeExpression();
        DataType dtArray = exprType.getType();
        Expression[] aDims = this.aexprDims;
        int cDims = aDims.length;
        boolean fDimExpr = false;
        for (int i = 0; i < cDims; ++i) {
            Expression expr = aDims[i];
            if (expr != null) {
                fDimExpr = true;
                if ((expr = (Expression)expr.precompile(ctx, setUVars, setFVars, mapThrown, errlist)).checkAssignable(ctx, INT, errlist)) {
                    expr = expr.promoteNumeric();
                }
                aDims[i] = expr;
            }
            dtArray = dtArray.getArrayType();
        }
        ArrayExpression exprValue = this.exprValue;
        if (exprValue != null) {
            if (fDimExpr) {
                this.logError(3, "JC-053", null, errlist);
            }
            if (dtArray != UNKNOWN) {
                exprValue.setType(dtArray);
                this.exprValue = exprValue = (ArrayExpression)exprValue.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
            }
        }
        this.setType(dtArray);
        return this;
    }

    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        block14: {
            DataType dtArray;
            int cExpr;
            block13: {
                Expression expr;
                ArrayExpression exprValue = this.exprValue;
                if (exprValue != null) {
                    return exprValue.compile(ctx, code, fReached, errlist);
                }
                Expression[] aDims = this.aexprDims;
                int cDims = aDims.length;
                cExpr = 0;
                for (int i = 0; i < cDims && (expr = aDims[i]) != null; ++i) {
                    expr.compile(ctx, code, fReached, errlist);
                    ++cExpr;
                }
                dtArray = this.getType();
                if (cDims != 1) break block13;
                switch (dtArray.getElementType().getTypeString().charAt(0)) {
                    case 'Z': {
                        code.add(new Znewarray());
                        break block14;
                    }
                    case 'B': {
                        code.add(new Bnewarray());
                        break block14;
                    }
                    case 'C': {
                        code.add(new Cnewarray());
                        break block14;
                    }
                    case 'S': {
                        code.add(new Snewarray());
                        break block14;
                    }
                    case 'I': {
                        code.add(new Inewarray());
                        break block14;
                    }
                    case 'J': {
                        code.add(new Lnewarray());
                        break block14;
                    }
                    case 'F': {
                        code.add(new Fnewarray());
                        break block14;
                    }
                    case 'D': {
                        code.add(new Dnewarray());
                        break block14;
                    }
                    case 'L': 
                    case 'N': 
                    case 'R': 
                    case '[': {
                        code.add(new Anewarray(dtArray.getElementType().getClassConstant()));
                        break block14;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            code.add(new Multianewarray(dtArray.getClassConstant(), cExpr));
        }
        return fReached;
    }

    public Expression[] getDimensions() {
        return this.aexprDims;
    }

    public ArrayExpression getInitializer() {
        return this.exprValue;
    }

    public boolean isConstant() {
        return this.exprValue != null && this.exprValue.isConstant();
    }

    public Object getValue() {
        return this.exprValue.getValue();
    }

    public void print(String sIndent) {
        super.print(sIndent);
        NewArrayExpression.out(sIndent + "  dimensions:");
        Expression[] aexpr = this.aexprDims;
        int cexpr = aexpr.length;
        for (int i = 0; i < cexpr; ++i) {
            if (aexpr[i] == null) {
                NewArrayExpression.out(sIndent + "    <null>");
                continue;
            }
            aexpr[i].print(sIndent + "    ");
        }
        if (this.exprValue != null) {
            NewArrayExpression.out(sIndent + "  value:");
            this.exprValue.print(sIndent + "    ");
        }
    }
}

