/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.ClassConstant;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Dup;
import com.tangosol.dev.assembler.New;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.TypeInfo;
import com.tangosol.dev.compiler.java.Block;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.InvocationExpression;
import com.tangosol.dev.compiler.java.NewExpression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.TokenConstants;
import com.tangosol.dev.compiler.java.TypeExpression;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.util.Map;

public class NewClassExpression
extends NewExpression
implements Constants,
TokenConstants {
    private static final String CLASS = "NewClassExpression";
    private Token m_tokLParen;
    private Expression[] m_aexprParams;
    private Token m_tokRParen;
    private TypeInfo m_typeinfo;
    private InvocationExpression m_exprInit;

    public NewClassExpression(Block block, Token tokNew, TypeExpression exprType, Token tokLParen, Expression[] params, Token tokRParen) {
        super(block, tokNew, tokRParen, exprType);
        this.m_tokLParen = tokLParen;
        this.m_aexprParams = params;
        this.m_tokRParen = tokRParen;
    }

    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        super.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        TypeExpression exprType = this.getTypeExpression();
        DataType dtClass = exprType.getType();
        if (dtClass.isClass() || dtClass.isComponent()) {
            TypeInfo info = ctx.getTypeInfo(dtClass);
            if (info == null) {
                String sFull = dtClass.toString();
                int ofDot = sFull.lastIndexOf(46);
                String sPkg = ofDot < 0 ? "" : sFull.substring(0, ofDot);
                String sName = ofDot < 0 ? sFull : sFull.substring(ofDot + 1);
                this.logError(3, "JC-055", new String[]{sName, sPkg}, errlist);
            } else if (info.isAbstract()) {
                this.logError(3, "JC-069", new String[]{dtClass.toString()}, errlist);
            } else if (info.isStatic() && info.getParentInfo() == null) {
                this.logError(3, "JC-070", new String[]{dtClass.toString()}, errlist);
            } else {
                this.m_typeinfo = info;
                Token tokName = new Token(1, 0, 105, null, "<init>", exprType.getEndLine(), exprType.getEndOffset(), 0);
                InvocationExpression exprInit = new InvocationExpression(exprType, tokName, this.m_tokLParen, this.m_aexprParams, this.m_tokRParen);
                this.m_exprInit = exprInit = (InvocationExpression)exprInit.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
            }
            this.setType(dtClass);
        }
        return this;
    }

    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        code.add(new New((ClassConstant)this.m_typeinfo.getConstant()));
        if (!this.isDiscarded()) {
            code.add(new Dup());
        }
        this.m_exprInit.compile(ctx, code, fReached, errlist);
        return fReached;
    }

    public Expression[] getParameters() {
        return this.m_aexprParams;
    }

    public void print(String sIndent) {
        super.print(sIndent);
        NewClassExpression.out(sIndent + "  parameters:");
        Expression[] aexpr = this.m_aexprParams;
        int cexpr = aexpr.length;
        for (int i = 0; i < cexpr; ++i) {
            aexpr[i].print(sIndent + "    ");
        }
    }
}

