/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.IntConstant;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.BinaryExpression;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.util.Map;

public abstract class RelationalExpression
extends BinaryExpression {
    private static final String CLASS = "RelationalExpression";
    protected static final DataType BOOLEAN = DataType.BOOLEAN;
    protected static final IntConstant TRUE = Constants.CONSTANT_ICONST_1;
    protected static final IntConstant FALSE = Constants.CONSTANT_ICONST_0;

    protected RelationalExpression(Expression left, Token operator, Expression right) {
        super(left, operator, right);
    }

    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        left = (Expression)left.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        right = (Expression)right.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        if (left.checkNumeric(errlist) & right.checkNumeric(errlist)) {
            left = left.promoteNumeric(right);
            right = right.promoteNumeric(left);
        }
        this.setLeftExpression(left);
        this.setRightExpression(right);
        this.setType(BOOLEAN);
        return this;
    }
}

