/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Dsub;
import com.tangosol.dev.assembler.Fsub;
import com.tangosol.dev.assembler.Isub;
import com.tangosol.dev.assembler.Lsub;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.AdditiveExpression;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.util.ErrorList;
import java.util.Map;

public class SubtractExpression
extends AdditiveExpression {
    private static final String CLASS = "SubtractExpression";

    public SubtractExpression(Expression left, Token operator, Expression right) {
        super(left, operator, right);
    }

    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        left = (Expression)left.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        right = (Expression)right.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        if (left.checkNumeric(errlist) & right.checkNumeric(errlist)) {
            left = left.promoteNumeric(right);
            right = right.promoteNumeric(left);
        }
        this.setLeftExpression(left);
        this.setRightExpression(right);
        this.setType(left.getType());
        return this;
    }

    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        if (!ctx.isDebug() && this.isConstant()) {
            return super.compile(ctx, code, fReached, errlist);
        }
        this.getLeftExpression().compile(ctx, code, fReached, errlist);
        this.getRightExpression().compile(ctx, code, fReached, errlist);
        switch (this.getType().getTypeString().charAt(0)) {
            case 'I': {
                code.add(new Isub());
                break;
            }
            case 'J': {
                code.add(new Lsub());
                break;
            }
            case 'F': {
                code.add(new Fsub());
                break;
            }
            case 'D': {
                code.add(new Dsub());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return fReached;
    }

    public Object getValue() {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        Number nbrLeft = (Number)left.getValue();
        Number nbrRight = (Number)right.getValue();
        switch (left.getType().getTypeString().charAt(0)) {
            case 'I': {
                return SubtractExpression.makeInteger(nbrLeft.intValue() - nbrRight.intValue());
            }
            case 'J': {
                return SubtractExpression.makeLong(nbrLeft.longValue() - nbrRight.longValue());
            }
            case 'F': {
                return new Float(nbrLeft.floatValue() - nbrRight.floatValue());
            }
            case 'D': {
                return new Double(nbrLeft.doubleValue() - nbrRight.doubleValue());
            }
        }
        throw new IllegalStateException();
    }
}

