/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.Begin;
import com.tangosol.dev.assembler.Case;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.End;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.assembler.Switch;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.Block;
import com.tangosol.dev.compiler.java.CaseClause;
import com.tangosol.dev.compiler.java.DefaultClause;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Statement;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SwitchStatement
extends Block {
    private static final String CLASS = "SwitchStatement";
    private Expression test;
    private DefaultClause stmtDefault;

    public SwitchStatement(Statement stmt, Token token) {
        super(stmt, token);
    }

    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Set setAssigned;
        Expression exprTest = this.getTest();
        Statement stmtBody = this.getBody();
        exprTest = (Expression)exprTest.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        exprTest.checkAssignable(ctx, DataType.INT, errlist);
        this.setTest(exprTest);
        DualSet setUBlockVars = new DualSet(setUVars);
        DualSet setFBlockVars = new DualSet(setFVars);
        HashSet<Integer> setCases = new HashSet<Integer>();
        for (Statement stmt = stmtBody; stmt != null; stmt = stmt.getNextStatement()) {
            stmt.precompile(ctx, setUBlockVars, setFBlockVars, mapThrown, errlist);
            if (stmt instanceof CaseClause) {
                CaseClause clause = (CaseClause)stmt;
                if (clause.isConstant()) {
                    Integer I = SwitchStatement.makeInteger(clause.getValue());
                    if (setCases.contains(I)) {
                        this.logError(3, "JC-011", new String[]{I.toString()}, errlist);
                    } else {
                        setCases.add(I);
                    }
                }
                setUBlockVars.reset();
                continue;
            }
            if (!(stmt instanceof DefaultClause)) continue;
            if (this.stmtDefault == null) {
                this.stmtDefault = (DefaultClause)stmt;
            } else {
                this.logError(3, "JC-010", null, errlist);
            }
            setUBlockVars.reset();
        }
        if (this.stmtDefault != null) {
            setUBlockVars.addAll(this.getBreakUVars());
            setAssigned = setUBlockVars.getRemoved();
            if (!setAssigned.isEmpty()) {
                setUVars.removeAll(setAssigned);
            }
        }
        setFBlockVars.addAll(this.getBreakFVars());
        setAssigned = setFBlockVars.getAdded();
        if (!setAssigned.isEmpty()) {
            setAssigned.retainAll(this.getBlock().getVariables());
            if (!setAssigned.isEmpty()) {
                setFVars.addAll(setAssigned);
            }
        }
        return this;
    }

    protected boolean compileImpl(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        Statement stmt;
        Expression exprTest = this.getTest();
        Statement stmtBody = this.getBody();
        boolean fSwitchReached = fReached;
        boolean fCompletes = fReached;
        exprTest.compile(ctx, code, fReached, errlist);
        Label lblDefault = this.stmtDefault == null ? this.getEndLabel() : this.stmtDefault.getStartLabel();
        code.add(new Switch(lblDefault));
        for (stmt = stmtBody; stmt != null; stmt = stmt.getNextStatement()) {
            if (!(stmt instanceof CaseClause)) continue;
            code.add(new Case(((CaseClause)stmt).getValue(), stmt.getStartLabel()));
        }
        code.add(new Begin());
        fReached = false;
        for (stmt = this.getInnerStatement(); stmt != null; stmt = stmt.getNextStatement()) {
            if (stmt instanceof CaseClause || stmt instanceof DefaultClause) {
                fReached = fSwitchReached;
            } else if (fReached && !fCompletes) {
                stmt.notReached(errlist);
                fReached = false;
            }
            fCompletes = stmt.compile(ctx, code, fReached, errlist);
        }
        code.add(new End());
        return fCompletes || this.stmtDefault == null;
    }

    public Expression getTest() {
        return this.test;
    }

    protected void setTest(Expression test) {
        this.test = test;
    }

    public Statement getBody() {
        return this.getInnerStatement();
    }

    public void print(String sIndent) {
        SwitchStatement.out(sIndent + this.toString());
        SwitchStatement.out(sIndent + "  Test:");
        this.test.print(sIndent + "    ");
        if (this.getInnerStatement() != null) {
            SwitchStatement.out(sIndent + "  Inner Statements:");
            this.getInnerStatement().printList(sIndent + "    ");
        }
    }
}

