/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.Aload;
import com.tangosol.dev.assembler.Astore;
import com.tangosol.dev.assembler.Athrow;
import com.tangosol.dev.assembler.Avar;
import com.tangosol.dev.assembler.Begin;
import com.tangosol.dev.assembler.Catch;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.End;
import com.tangosol.dev.assembler.Goto;
import com.tangosol.dev.assembler.Jsr;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.assembler.Try;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.CatchClause;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.FinallyClause;
import com.tangosol.dev.compiler.java.GuardedStatement;
import com.tangosol.dev.compiler.java.Statement;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TryStatement
extends GuardedStatement {
    private static final String CLASS = "TryStatement";
    private CatchClause stmtCatch;
    private FinallyClause stmtFinally;

    public TryStatement(Statement outer, Token token) {
        super(outer, token);
    }

    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Statement stmtBlock = this.getInnerStatement();
        CatchClause stmtCatch = this.stmtCatch;
        FinallyClause stmtFinally = this.stmtFinally;
        HashMap mapTryThrows = mapThrown;
        if (stmtCatch != null) {
            if (stmtFinally != null) {
                TryStatement stmtNested = new TryStatement(this, this.getStartToken());
                CatchClause prev = null;
                for (Statement cur = stmtCatch; cur != null; cur = cur.getNextStatement()) {
                    prev = cur;
                }
                stmtNested.setEndToken(prev.getEndToken());
                stmtNested.setInnerStatement(stmtBlock);
                stmtNested.setCatchClause(stmtCatch);
                stmtBlock.setOuterStatement(stmtNested);
                stmtCatch.setOuterStatement(stmtNested);
                stmtBlock = stmtNested;
                this.setInnerStatement(stmtBlock);
                stmtCatch = null;
                this.setCatchClause(null);
            } else {
                mapTryThrows = new HashMap();
            }
        }
        DualSet setUBlockVars = new DualSet(setUVars);
        stmtBlock.precompile(ctx, setUBlockVars, setFVars, mapTryThrows, errlist);
        Set setUAssigned = setUBlockVars.getRemoved();
        DualSet setFBlockVars = new DualSet(setFVars);
        HashSet setFAssigned = new HashSet();
        while (stmtCatch != null) {
            setUBlockVars.reset();
            stmtCatch.precompile(ctx, setUBlockVars, setFBlockVars, mapThrown, errlist);
            if (!setUAssigned.isEmpty()) {
                setUAssigned.retainAll(setUBlockVars.getRemoved());
            }
            if (!setFBlockVars.getAdded().isEmpty()) {
                setFAssigned.addAll(setFBlockVars.getAdded());
            }
            stmtCatch.getDeclaration().getTypeExpression().checkCaughtException(ctx, stmtCatch.getExceptionType(), mapTryThrows, errlist);
            stmtCatch = (CatchClause)stmtCatch.getNextStatement();
        }
        if (!setUAssigned.isEmpty()) {
            setUVars.removeAll(setUAssigned);
        }
        if (!setFAssigned.isEmpty()) {
            setFAssigned.retainAll(this.getBlock().getVariables());
            if (!setFAssigned.isEmpty()) {
                setFVars.addAll(setFAssigned);
            }
        }
        if (mapTryThrows != mapThrown) {
            Iterator iter = mapTryThrows.keySet().iterator();
            while (iter.hasNext()) {
                DataType dt = (DataType)iter.next();
                if (mapThrown.containsKey(dt)) {
                    ((Set)mapThrown.get(dt)).addAll((Set)mapTryThrows.get(dt));
                    continue;
                }
                mapThrown.put(dt, mapTryThrows.get(dt));
            }
        }
        if (stmtFinally != null) {
            setUBlockVars.reset();
            stmtFinally.precompile(ctx, setUBlockVars, setFVars, mapThrown, errlist);
            setUAssigned = setUBlockVars.getRemoved();
            if (!setUAssigned.isEmpty()) {
                setUVars.removeAll(setUAssigned);
            }
        }
        return this;
    }

    protected boolean compileImpl(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        boolean fCompletes = fReached;
        Statement stmtGuarded = this.getInnerStatement();
        CatchClause stmtCatch = this.stmtCatch;
        FinallyClause stmtFinally = this.stmtFinally;
        if (stmtCatch != null) {
            Try opTry = new Try();
            code.add(opTry);
            fCompletes &= stmtGuarded.compile(ctx, code, fReached, errlist);
            for (CatchClause stmt = stmtCatch; stmt != null; stmt = (CatchClause)stmt.getNextStatement()) {
                code.add(new Catch(opTry, stmt.getExceptionClass(), stmt.getStartLabel()));
            }
            Label lblExit = this.getEndLabel();
            code.add(new Goto(lblExit));
            for (CatchClause stmt = stmtCatch; stmt != null; stmt = (CatchClause)stmt.getNextStatement()) {
                fCompletes |= stmt.compile(ctx, code, fReached, errlist);
                code.add(new Goto(lblExit));
            }
        } else {
            Try opTry = new Try();
            Label lblGuard = new Label();
            Avar varExcept = new Avar();
            Label lblUnwind = this.getUnwindLabel();
            code.add(opTry);
            fCompletes &= stmtGuarded.compile(ctx, code, fReached, errlist);
            code.add(new Catch(opTry, null, lblGuard));
            code.add(new Jsr(lblUnwind));
            code.add(new Goto(this.getEndLabel()));
            code.add(lblGuard);
            code.add(new Begin());
            code.add(varExcept);
            code.add(new Astore(varExcept));
            code.add(new Jsr(lblUnwind));
            code.add(new Aload(varExcept));
            code.add(new Athrow());
            code.add(new End());
            fCompletes &= stmtFinally.compile(ctx, code, fReached, errlist);
        }
        return fCompletes;
    }

    public void print(String sIndent) {
        TryStatement.out(sIndent + this.toString());
        TryStatement.out(sIndent + "  Guarded:");
        this.getInnerStatement().print(sIndent + "    ");
        if (this.stmtCatch != null) {
            TryStatement.out(sIndent + "  Catch clauses:");
            this.stmtCatch.printList(sIndent + "    ");
        }
        if (this.stmtFinally != null) {
            TryStatement.out(sIndent + "  Finally clause:");
            this.stmtFinally.print(sIndent + "    ");
        }
    }

    public CatchClause getCatchClause() {
        return this.stmtCatch;
    }

    protected void setCatchClause(CatchClause stmtCatch) {
        this.stmtCatch = stmtCatch;
    }

    public FinallyClause getFinallyClause() {
        return this.stmtFinally;
    }

    protected void setFinallyClause(FinallyClause stmtFinally) {
        this.stmtFinally = stmtFinally;
    }
}

