/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.Aload;
import com.tangosol.dev.assembler.Avar;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Dload;
import com.tangosol.dev.assembler.Dvar;
import com.tangosol.dev.assembler.Fload;
import com.tangosol.dev.assembler.Fvar;
import com.tangosol.dev.assembler.Iload;
import com.tangosol.dev.assembler.Ivar;
import com.tangosol.dev.assembler.Lload;
import com.tangosol.dev.assembler.Lvar;
import com.tangosol.dev.assembler.OpDeclare;
import com.tangosol.dev.assembler.OpLoad;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.Block;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.Variable;
import com.tangosol.util.ErrorList;
import java.util.Map;

public class VariableExpression
extends Expression {
    private static final String CLASS = "VariableExpression";
    private boolean fAssignee;

    public VariableExpression(Block block, Token name) {
        super(block, name);
    }

    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Block block = this.getBlock();
        String sName = this.getStartToken().getText();
        Variable var = block.getVariable(sName);
        if (this.isAssignee()) {
            if (var.isFinal() && setFVars.contains(var)) {
                this.logError(3, "JC-033", new String[]{var.getName()}, errlist);
            }
        } else if (setUVars.contains(var)) {
            this.logError(3, "JC-035", new String[]{sName}, errlist);
        }
        this.setType(var.getType());
        return this;
    }

    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        if (!ctx.isDebug() && this.isConstant() && !(this.getValue() instanceof Object[])) {
            return super.compile(ctx, code, fReached, errlist);
        }
        Variable var = this.getVariable();
        OpDeclare opVar = var.getOp();
        OpLoad opLoad = null;
        switch (this.getType().getTypeString().charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                opLoad = new Iload((Ivar)opVar);
                break;
            }
            case 'J': {
                opLoad = new Lload((Lvar)opVar);
                break;
            }
            case 'F': {
                opLoad = new Fload((Fvar)opVar);
                break;
            }
            case 'D': {
                opLoad = new Dload((Dvar)opVar);
                break;
            }
            case 'L': 
            case 'R': 
            case '[': {
                opLoad = new Aload((Avar)opVar);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        code.add(opLoad);
        return fReached;
    }

    public boolean isConstant() {
        return this.getVariable().isConstant();
    }

    public Object getValue() {
        return this.getVariable().getValue();
    }

    protected boolean checkAssignable(ErrorList errlist) throws CompilerException {
        this.setAssignee(true);
        return true;
    }

    public String getName() {
        return this.getStartToken().getText();
    }

    public Variable getVariable() {
        return this.getBlock().getVariable(this.getName());
    }

    public boolean isAssignee() {
        return this.fAssignee;
    }

    protected void setAssignee(boolean fAssignee) {
        this.fAssignee = fAssignee;
    }
}

