/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Goto;
import com.tangosol.dev.assembler.Ifne;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.BooleanExpression;
import com.tangosol.dev.compiler.java.ConditionalStatement;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Statement;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.Variable;
import com.tangosol.util.ErrorList;
import com.tangosol.util.NullImplementation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WhileStatement
extends ConditionalStatement {
    private static final String CLASS = "WhileStatement";

    public WhileStatement(Statement stmt, Token token) {
        super(stmt, token);
    }

    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        HashSet setFInitAssigned = NullImplementation.getSet();
        if (!setFVars.isEmpty()) {
            setFInitAssigned = new HashSet(setFVars);
        }
        this.precompileTest(ctx, setUVars, setFVars, mapThrown, errlist);
        DualSet setUTrueVars = new DualSet(setUVars.getTrueSet());
        DualSet setFTrueVars = new DualSet(setFVars.getTrueSet());
        this.getInnerStatement().precompile(ctx, setUTrueVars, setFTrueVars, mapThrown, errlist);
        setUTrueVars.addAll(this.getBreakUVars());
        setUTrueVars.resolve();
        setUVars.merge();
        setFTrueVars.addAll(this.getBreakFVars());
        Set setFAssigned = setFTrueVars.getAdded();
        setFTrueVars.resolve();
        setFVars.merge();
        if (!setFVars.equals(setFInitAssigned)) {
            Iterator iter = setFVars.iterator();
            while (iter.hasNext()) {
                Variable var = (Variable)iter.next();
                if (setFInitAssigned.contains(var)) continue;
                this.logError(3, "JC-034", new String[]{var.getName()}, errlist);
            }
        }
        return this;
    }

    protected boolean compileImpl(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        boolean fEndless = false;
        Label lblAgain = new Label();
        Statement stmt = this.getInnerStatement();
        Label lblTest = this.getContinuationLabel();
        Expression exprTest = this.getTest();
        if (exprTest instanceof BooleanExpression || !ctx.isDebug() && exprTest.isConstant()) {
            if (((Boolean)exprTest.getValue()).booleanValue()) {
                fEndless = true;
            } else {
                if (fReached) {
                    stmt.notReached(errlist);
                }
                return fReached;
            }
        }
        if (!fEndless) {
            code.add(new Goto(lblTest));
        }
        code.add(lblAgain);
        stmt.compile(ctx, code, fReached, errlist);
        code.add(lblTest);
        if (fEndless) {
            code.add(new Goto(lblAgain));
        } else {
            exprTest.compile(ctx, code, fReached, errlist);
            code.add(new Ifne(lblAgain));
        }
        return fReached && !fEndless;
    }
}

