/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.component;

import com.tangosol.dev.assembler.ClassFile;
import com.tangosol.dev.component.Component;
import com.tangosol.dev.component.ComponentException;
import com.tangosol.dev.component.JarStorage;
import com.tangosol.util.ErrorList;
import com.tangosol.util.StringTable;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ArchivedStorage
extends JarStorage {
    private static final String CLASS = "ArchivedStorage";
    private static final String ROOT = "Root";
    private static final String[] SUBDIR = new String[6];
    private static final String[] SUFFIX;
    private StringTable[] m_contents = new StringTable[6];
    private StringTable[] m_packages = new StringTable[6];

    public ArchivedStorage(String sPath) {
        super(sPath, null);
    }

    public ArchivedStorage(File file) {
        super(file, null);
    }

    public Component loadComponent(String sName, boolean fReadOnly, ErrorList errlist) throws ComponentException {
        if (sName.length() == 0) {
            sName = ROOT;
        }
        try {
            DataInputStream stream = this.loadFile(0, sName);
            if (stream == null) {
                return Component.isQualifiedNameLegal(sName) ? null : this.loadSignature(sName);
            }
            Component cd = new Component(stream);
            if (fReadOnly) {
                cd.setModifiable(false);
            }
            return cd;
        }
        catch (IOException e) {
            throw new ComponentException(e.toString());
        }
    }

    public Component loadSignature(String sName) throws ComponentException {
        try {
            DataInputStream stream = this.loadFile(1, sName);
            return stream == null ? null : new Component(stream);
        }
        catch (IOException e) {
            throw new ComponentException(e.toString());
        }
    }

    public ClassFile loadClass(String sName) throws ComponentException {
        try {
            DataInputStream stream = this.loadFile(2, sName);
            return stream == null ? null : new ClassFile(stream);
        }
        catch (IOException e) {
            throw new ComponentException(e.toString());
        }
    }

    public String loadJava(String sName) throws IOException {
        return null;
    }

    public byte[] loadOriginalResource(String sName) throws IOException {
        return null;
    }

    public byte[] loadResourceSignature(String sName) throws IOException {
        return this.loadFileBytes(this.buildFile(4, sName));
    }

    public byte[] loadResource(String sName) throws IOException {
        return this.loadFileBytes(this.buildFile(5, sName));
    }

    public StringTable getSubComponents(String sComponent, boolean fQualify) {
        this.ensureContents();
        Object oLocator = this.getLocator();
        if (sComponent == null || sComponent.length() == 0) {
            StringTable tbl = new StringTable();
            sComponent = Component.getRootName();
            if (this.getJar().getEntry(this.buildFile(0, sComponent)) != null) {
                tbl.put(sComponent, oLocator);
            }
            return tbl;
        }
        return this.getNamesFromPackage(this.m_contents[0], sComponent, fQualify, '.');
    }

    public StringTable getPackageComponents(String sPackage, boolean fQualify) {
        this.ensureContents();
        return this.getNamesFromPackage(this.m_contents[0], sPackage, fQualify, '.');
    }

    public StringTable getComponentPackages(String sPackage, boolean fQualify, boolean fSubs) {
        StringTable tblAll;
        if (fSubs) {
            fQualify = true;
        }
        if ((tblAll = this.m_packages[0]) == null) {
            this.ensureContents();
            this.m_packages[0] = tblAll = this.ensurePackages(this.m_contents[0]);
        }
        return this.extractPackages(tblAll, sPackage, fQualify, fSubs, '.');
    }

    public StringTable getPackageSignatures(String sPackage, boolean fQualify) {
        this.ensureContents();
        return this.getNamesFromPackage(this.m_contents[1], sPackage, fQualify, '.');
    }

    public StringTable getSignaturePackages(String sPackage, boolean fQualify, boolean fSubs) {
        StringTable tblAll = this.m_packages[1];
        if (tblAll == null) {
            this.ensureContents();
            this.m_packages[1] = tblAll = this.ensurePackages(this.m_contents[1]);
        }
        return this.extractPackages(tblAll, sPackage, fQualify, fSubs, '.');
    }

    public StringTable getPackageResources(String sPackage, boolean fQualify) {
        this.ensureContents();
        return this.getNamesFromPackage(this.m_contents[4], sPackage, fQualify, '/');
    }

    public StringTable getResourcePackages(String sPackage, boolean fQualify, boolean fSubs) {
        StringTable tblAll = this.m_packages[4];
        if (tblAll == null) {
            this.ensureContents();
            this.m_packages[4] = tblAll = this.ensurePackages(this.m_contents[4]);
        }
        return this.extractPackages(tblAll, sPackage, fQualify, fSubs, '/');
    }

    protected DataInputStream loadFile(int nType, String sName) throws IOException {
        String sEntry;
        JarFile jar = this.getJar();
        JarEntry entry = jar.getJarEntry(sEntry = this.buildFile(nType, sName));
        return entry == null ? null : new DataInputStream(jar.getInputStream(entry));
    }

    protected String buildFile(int nType, String sName) {
        String sSubDir = SUBDIR[nType];
        String sSuffix = SUFFIX[nType];
        if (nType < 4) {
            sName = sName.replace('.', '/');
        }
        return sSubDir + sName + sSuffix;
    }

    protected void ensureContents() {
        if (this.m_contents[0] != null) {
            return;
        }
        StringTable[] contents = this.m_contents;
        contents[0] = new StringTable();
        contents[1] = new StringTable();
        contents[2] = new StringTable();
        contents[4] = new StringTable();
        Object oLocator = this.getLocator();
        Enumeration<JarEntry> enmr = this.getJar().entries();
        while (enmr.hasMoreElements()) {
            JarEntry entry = enmr.nextElement();
            String sName = entry.getName();
            int c = contents.length;
            for (int i = 0; i < c; ++i) {
                StringTable tblContent = contents[i];
                if (tblContent == null || sName.endsWith("/") || !sName.startsWith(SUBDIR[i]) || !sName.endsWith(SUFFIX[i]) || (sName = sName.substring(SUBDIR[i].length(), sName.length() - SUFFIX[i].length())).length() <= 0) continue;
                tblContent.put(sName, oLocator);
            }
        }
    }

    public String toString() {
        return "ArchivedStorage(" + this.getJar().getName() + ')';
    }

    static {
        ArchivedStorage.SUBDIR[0] = "cdb/";
        ArchivedStorage.SUBDIR[1] = "jcs/";
        ArchivedStorage.SUBDIR[2] = "classes/";
        ArchivedStorage.SUBDIR[3] = "java/";
        ArchivedStorage.SUBDIR[4] = "resource/";
        ArchivedStorage.SUBDIR[5] = "classes/";
        SUFFIX = new String[6];
        ArchivedStorage.SUFFIX[0] = ".cdb";
        ArchivedStorage.SUFFIX[1] = ".jcs";
        ArchivedStorage.SUFFIX[2] = ".class";
        ArchivedStorage.SUFFIX[3] = ".java";
        ArchivedStorage.SUFFIX[4] = "";
        ArchivedStorage.SUFFIX[5] = "";
    }
}

