/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.component;

import com.tangosol.dev.assembler.Method;
import com.tangosol.dev.component.Component;
import com.tangosol.dev.component.ComponentException;
import com.tangosol.dev.component.DataType;
import com.tangosol.dev.component.DerivationException;
import com.tangosol.dev.component.Implementation;
import com.tangosol.dev.component.Integration;
import com.tangosol.dev.component.Interface;
import com.tangosol.dev.component.Loader;
import com.tangosol.dev.component.Parameter;
import com.tangosol.dev.component.Property;
import com.tangosol.dev.component.ReturnValue;
import com.tangosol.dev.component.Throwee;
import com.tangosol.dev.component.Trait;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.ChainedEnumerator;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ErrorList;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.StringTable;
import com.tangosol.util.UID;
import java.beans.PropertyVetoException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.CollationKey;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class Behavior
extends Trait {
    public static final String ATTR_FROMMANUAL = "FromManual";
    public static final String ATTR_ACCESS = "Access";
    public static final String ATTR_VISIBLE = "Visible";
    public static final String ATTR_SYNCHRONIZED = "Synchronized";
    public static final String ATTR_STATIC = "Static";
    public static final String ATTR_ABSTRACT = "Abstract";
    public static final String ATTR_FINAL = "Final";
    public static final String ATTR_DEPRECATED = "Deprecated";
    public static final String ATTR_REMOTE = "Remote";
    public static final String ATTR_NAME = "Name";
    public static final String ATTR_PARAMETER = "Parameter";
    public static final String ATTR_EXCEPTION = "Exception";
    public static final String ATTR_IMPLEMENTATION = "Implementation";
    public static final String ATTR_OVERRIDEBASE = "OverrideBase";
    private static final String CLASS = "Behavior";
    protected static final String DESCRIPTOR = "Behavior";
    private static final int DEFAULT_FLAGS = 524288;
    private static final int SPECABLE_FLAGS = 17061193;
    private static final int CLASSGEN_FLAGS = 102279856;
    private static final String[] EVENT_REG_PARAM = new String[]{"l"};
    private String m_sName;
    private String m_sSig;
    private int m_nFlags = 524288;
    private int m_nPrevFlags = 524288;
    private ReturnValue m_retval;
    private Vector m_vectParam = new Vector();
    private StringTable m_tblExcept = new StringTable();
    private Vector m_vectScript = new Vector();
    private int m_cBaseLevelImpl;
    private boolean m_fOverrideBase;
    private transient boolean m_fPrevOverrideBase;

    protected Behavior(Component cd, DataType dtRet, String sName, boolean fStatic, int nAccess, DataType[] adtParam, String[] asParam, int[] anDir) {
        super((Trait)cd, 1);
        this.m_nFlags |= 2 | nAccess | (fStatic ? 512 : 0);
        this.m_nPrevFlags |= 6;
        this.m_sName = sName;
        this.m_retval = new ReturnValue(this, dtRet);
        if (adtParam != null) {
            int c = adtParam.length;
            for (int i = 0; i < c; ++i) {
                DataType dt = adtParam[i];
                String sParam = asParam == null ? "Param_" + i : asParam[i];
                int nDir = anDir == null ? 0x400000 : anDir[i];
                Parameter param = new Parameter(this, dt, sParam, nDir);
                this.m_vectParam.addElement(param);
            }
        }
        this.updateSignature();
        if (!cd.isSignature()) {
            this.assignUID();
        }
    }

    protected Behavior(Component cd, Integration map, String sName, Behavior method) {
        this(cd, method.m_retval.getDataType(), sName, method.isStatic(), method.getAccess(), method.getParameterTypes(), method.getParameterNames(), null);
        this.addOriginTrait(map);
        Enumeration enmr = method.m_tblExcept.elements();
        while (enmr.hasMoreElements()) {
            Throwee except = (Throwee)enmr.nextElement();
            Throwee throwee = new Throwee(this, except.getDataType());
            throwee.addOriginTrait(map);
            this.m_tblExcept.put(throwee.getUniqueName(), throwee);
        }
    }

    protected Behavior(Component cd, Interface iface, Behavior method) {
        this(cd, method.m_retval.getDataType(), method.m_sName, method.isStatic(), method.getAccess(), method.getParameterTypes(), method.getParameterNames(), null);
        this.addOriginTrait(iface);
        if (cd.isInterface()) {
            this.m_nFlags = this.m_nFlags & 0xFFFFF7FF | 0x800;
        }
        Enumeration enmr = method.m_tblExcept.elements();
        while (enmr.hasMoreElements()) {
            Throwee except = (Throwee)enmr.nextElement();
            Throwee throwee = new Throwee(this, except.getDataType());
            throwee.addOriginTrait(iface);
            this.m_tblExcept.put(throwee.getUniqueName(), throwee);
        }
    }

    protected Behavior(Component cd, Interface iface, String sSig) {
        this(cd, DataType.VOID, Interface.getDispatchesVerb(sSig) + Interface.getDispatchesName(sSig) + "Listener", false, 48, new DataType[]{DataType.getClassType(iface.getName())}, EVENT_REG_PARAM, null);
        this.addOriginTrait(iface);
    }

    protected Behavior(Component cdJCS, Method method, Map mapParam) {
        super((Trait)cdJCS, 1);
        int nFlags = 524290;
        if (method.isPublic()) {
            nFlags |= 0x30;
        } else if (method.isProtected()) {
            nFlags |= 0x20;
        } else if (method.isPackage()) {
            nFlags |= 0x10;
        } else if (method.isPrivate()) {
            nFlags |= 0;
        }
        if (method.isSynthetic()) {
            nFlags |= 0x2000000;
        }
        nFlags |= method.isDeprecated() ? 32768 : 0;
        nFlags |= method.isStatic() ? 512 : 0;
        nFlags |= method.isSynchronized() ? 128 : 0;
        nFlags |= method.isAbstract() ? 2048 : 0;
        int n = method.isFinal() ? 8192 : 0;
        this.m_sName = method.getName();
        this.m_nFlags = nFlags |= n;
        String[] asTypes = method.getTypes();
        String[] asNames = method.getNames();
        this.m_retval = new ReturnValue(this, DataType.getJVMType(asTypes[0]));
        int cParams = asTypes.length - 1;
        Vector vect = this.m_vectParam;
        vect.setSize(cParams);
        for (int i = 1; i <= cParams; ++i) {
            DataType dt = DataType.getJVMType(asTypes[i]);
            String sName = "Param_" + i;
            if (asNames[i] != null) {
                sName = asNames[i];
            }
            vect.setElementAt(new Parameter(this, dt, sName, 0x400000), i - 1);
        }
        this.updateSignature();
        if (!mapParam.isEmpty()) {
            StringBuffer sb = new StringBuffer(this.getComponent().getName());
            sb.append('.').append(this.getName()).append('(');
            DataType[] adt = this.getParameterTypes();
            int c = adt.length;
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(Component.toSimpleSignature(adt[i].getType()));
            }
            sb.append(')');
            String[] asParam = (String[])mapParam.get(sb.toString());
            if (asParam != null) {
                int c2 = Math.min(asParam.length, this.getParameterCount());
                for (int i = 0; i < c2; ++i) {
                    Parameter param = this.getParameter(i);
                    String sOldName = param.getName();
                    String sNewName = asParam[i];
                    if (sNewName == null || sNewName.length() <= 0 || !sOldName.startsWith("Param_")) continue;
                    try {
                        param.setName(sNewName, false);
                        continue;
                    }
                    catch (PropertyVetoException e) {
                        // empty catch block
                    }
                }
            }
        }
        StringTable tbl = this.m_tblExcept;
        Enumeration enmr = method.getExceptions();
        while (enmr.hasMoreElements()) {
            DataType dt = DataType.getClassType(((String)enmr.nextElement()).replace('/', '.'));
            tbl.put(dt.getClassName(), new Throwee(this, dt));
        }
    }

    protected Behavior(Behavior base, Component cd, int nMode) {
        super((Trait)base, cd, nMode);
        this.m_sName = base.m_sName;
        this.m_sSig = base.m_sSig;
        this.m_nFlags = 0;
    }

    protected Behavior(Component cd, Behavior that) {
        super((Trait)cd, that);
        int i;
        int c;
        Vector dest;
        Vector src;
        this.m_sName = that.m_sName;
        this.m_sSig = that.m_sSig;
        this.m_nFlags = that.m_nFlags;
        this.m_nPrevFlags = that.m_nPrevFlags;
        this.m_fOverrideBase = that.m_fOverrideBase;
        this.m_fPrevOverrideBase = that.m_fPrevOverrideBase;
        this.m_cBaseLevelImpl = that.m_cBaseLevelImpl;
        this.m_retval = new ReturnValue(this, that.m_retval);
        if (!that.m_vectParam.isEmpty()) {
            src = that.m_vectParam;
            dest = this.m_vectParam;
            c = src.size();
            dest.setSize(c);
            for (i = 0; i < c; ++i) {
                dest.setElementAt(new Parameter(this, (Parameter)src.elementAt(i)), i);
            }
        }
        if (!that.m_vectScript.isEmpty()) {
            src = that.m_vectScript;
            dest = this.m_vectScript;
            c = src.size();
            dest.setSize(c);
            for (i = 0; i < c; ++i) {
                dest.setElementAt(new Implementation(this, (Implementation)src.elementAt(i)), i);
            }
        }
        if (!that.m_tblExcept.isEmpty()) {
            StringTable tblThat = that.m_tblExcept;
            StringTable tblThis = this.m_tblExcept;
            Enumeration enmr = tblThat.keys();
            while (enmr.hasMoreElements()) {
                String sExcept = (String)enmr.nextElement();
                Throwee throwee = new Throwee(this, (Throwee)tblThat.get(sExcept));
                if (cd.isSignature()) {
                    throwee.addOriginTrait(cd);
                }
                tblThis.put(sExcept, throwee);
            }
            this.m_tblExcept = tblThis;
        }
    }

    protected Behavior(Component cd, DataInput stream, int nVersion) throws IOException {
        super((Trait)cd, stream, nVersion);
        this.m_sName = stream.readUTF();
        this.m_nFlags = stream.readInt();
        this.m_nPrevFlags = stream.readInt();
        this.m_retval = new ReturnValue(this, stream, nVersion);
        int cParam = stream.readInt();
        this.m_vectParam.setSize(cParam);
        for (int i = 0; i < cParam; ++i) {
            Parameter param = new Parameter(this, stream, nVersion);
            this.m_vectParam.setElementAt(param, i);
        }
        this.updateSignature();
        int cExcept = stream.readInt();
        for (int i = 0; i < cExcept; ++i) {
            Throwee except = new Throwee(this, stream, nVersion);
            this.m_tblExcept.put(except.getUniqueName(), except);
        }
        int cImpl = stream.readInt();
        this.m_vectScript.setSize(cImpl);
        for (int i = 0; i < cImpl; ++i) {
            Implementation impl = new Implementation(this, stream, nVersion);
            this.m_vectScript.setElementAt(impl, i);
        }
        this.m_fOverrideBase = stream.readBoolean();
        this.m_cBaseLevelImpl = stream.readInt();
    }

    protected Behavior(Trait parent, XmlElement xml, int nVersion) throws IOException {
        super(parent, xml, nVersion);
    }

    protected synchronized void save(DataOutput stream) throws IOException {
        super.save(stream);
        stream.writeUTF(this.m_sName);
        stream.writeInt(this.m_nFlags);
        stream.writeInt(this.m_nPrevFlags);
        this.m_retval.save(stream);
        int cParam = this.m_vectParam.size();
        stream.writeInt(cParam);
        for (int i = 0; i < cParam; ++i) {
            ((Parameter)this.m_vectParam.elementAt(i)).save(stream);
        }
        int cExcept = this.m_tblExcept.getSize();
        stream.writeInt(cExcept);
        Enumeration enmrExcept = this.m_tblExcept.elements();
        for (int i = 0; i < cExcept; ++i) {
            ((Throwee)enmrExcept.nextElement()).save(stream);
        }
        int cImpl = this.m_vectScript.size() - this.m_cBaseLevelImpl;
        stream.writeInt(cImpl);
        for (int i = 0; i < cImpl; ++i) {
            ((Implementation)this.m_vectScript.elementAt(i)).save(stream);
        }
        stream.writeBoolean(this.m_fOverrideBase);
        stream.writeInt(this.m_cBaseLevelImpl);
    }

    protected synchronized void save(XmlElement xml) throws IOException {
        xml.addElement("name").setString(this.m_sName);
        super.save(xml);
        Behavior.saveFlags(xml, "flags", this.m_nFlags, 0);
        Behavior.saveFlags(xml, "prev-flags", this.m_nPrevFlags, 0);
        this.m_retval.save(xml.addElement("return-value"));
        Vector list = this.m_vectParam;
        if (list != null && !list.isEmpty()) {
            XmlElement xmlParams = xml.addElement("params");
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                ((Parameter)iter.next()).save(xml.addElement("param"));
            }
        }
        Behavior.saveTable(xml, this.m_tblExcept, "exceptions", "exception");
        int cImpl = this.m_vectScript.size() - this.m_cBaseLevelImpl;
        if (cImpl > 0) {
            for (int i = 0; i < cImpl; ++i) {
                ((Implementation)this.m_vectScript.elementAt(i)).save(xml.addElement("implementation"));
            }
        }
        if (this.m_fOverrideBase) {
            xml.addElement("override-base").setBoolean(true);
        }
        if (this.m_cBaseLevelImpl != 0) {
            xml.addElement("base-implementations").setInt(this.m_cBaseLevelImpl);
        }
    }

    protected Trait getBlankDerivedTrait(Trait parent, int nMode) {
        Behavior beh = new Behavior(this, (Component)parent, nMode);
        if (this.getComponent().isSignature() && !this.m_tblExcept.isEmpty()) {
            StringTable tblExcept = (StringTable)this.m_tblExcept.clone();
            Enumeration enmr = tblExcept.keys();
            while (enmr.hasMoreElements()) {
                String sExcept = (String)enmr.nextElement();
                Throwee throwee = (Throwee)tblExcept.get(sExcept);
                tblExcept.put(sExcept, throwee.getBlankDerivedTrait(this, nMode));
            }
            beh.m_tblExcept = tblExcept;
        }
        return beh;
    }

    protected Trait resolve(Trait traitDelta, Trait parent, Loader loader, ErrorList errlist) throws ComponentException {
        Behavior base = this;
        Behavior delta = (Behavior)this.resolveDelta(traitDelta, loader, errlist);
        Behavior derived = (Behavior)super.resolve(delta, parent, loader, errlist);
        boolean fSignature = base.getComponent().isSignature();
        delta.verifyMatch(base, true, errlist);
        int nBaseMode = base.getMode();
        boolean fBaseResolved = nBaseMode == 1;
        int nDeltaMode = delta.getMode();
        if (nDeltaMode == 1) {
            nDeltaMode = delta.getExtractMode(base);
        }
        int nBaseFlags = base.m_nFlags;
        int nDeltaFlags = delta.m_nFlags;
        int nPrevFlags = derived.resolveFlags(nBaseFlags, delta.m_nPrevFlags);
        int nDerivedFlags = derived.resolveFlags(nPrevFlags, nDeltaFlags);
        int nExists = 0;
        if (nDeltaMode == 3 && (nBaseFlags & 6) == 2) {
            nExists = 2;
        }
        if (fSignature && (nDeltaFlags & 6) == 6) {
            nExists = 6;
        }
        nDerivedFlags = nDerivedFlags & 0xFFFFFFF8 | nExists;
        derived.m_sName = base.m_sName;
        derived.m_nFlags = nDerivedFlags;
        derived.m_nPrevFlags = nPrevFlags;
        ReturnValue retBase = base.m_retval;
        ReturnValue retDelta = delta.m_retval;
        if (retDelta == null) {
            retDelta = (ReturnValue)retBase.getNullDerivedTrait(delta, nDeltaMode);
        }
        derived.m_retval = (ReturnValue)retBase.resolve(retDelta, derived, loader, errlist);
        Vector vectBaseParam = base.m_vectParam;
        Vector vectDeltaParam = delta.matchParameters(base, true, errlist);
        Vector vectDerivedParam = derived.m_vectParam;
        int cParam = vectBaseParam.size();
        vectDerivedParam.setSize(cParam);
        for (int i = 0; i < cParam; ++i) {
            Parameter paramBase = (Parameter)vectBaseParam.get(i);
            Parameter paramDelta = (Parameter)vectDeltaParam.get(i);
            if (paramDelta == null) {
                paramDelta = (Parameter)paramBase.getNullDerivedTrait(delta, nDeltaMode);
            }
            vectDerivedParam.set(i, (Parameter)paramBase.resolve(paramDelta, derived, loader, errlist));
        }
        this.updateSignature();
        StringTable tblBaseExcept = base.m_tblExcept;
        StringTable tblDeltaExcept = delta.matchExceptions(base, true, errlist);
        StringTable tblDerivedExcept = derived.m_tblExcept;
        Enumeration enmr = tblDeltaExcept.keys();
        while (enmr.hasMoreElements()) {
            String sExcept = (String)enmr.nextElement();
            Throwee exceptBase = (Throwee)tblBaseExcept.get(sExcept);
            Throwee exceptDelta = (Throwee)tblDeltaExcept.get(sExcept);
            Throwee exceptDerived = null;
            if (exceptBase == null) {
                exceptDerived = new Throwee(derived, exceptDelta);
                if (fBaseResolved) {
                    nExists = exceptDerived.getExists();
                    if (nExists == 2) {
                        exceptDerived.setExists(4);
                    } else if (nExists == 0) {
                        exceptDerived.setExists(6);
                    }
                }
            } else {
                if (exceptDelta == null) {
                    if (fSignature && nDeltaMode == 2) {
                        exceptDerived = new Throwee(derived, exceptBase);
                        exceptDerived.setExists(4);
                    } else {
                        exceptDelta = (Throwee)exceptBase.getNullDerivedTrait(delta, nDeltaMode);
                    }
                }
                if (exceptDelta != null) {
                    exceptDerived = (Throwee)exceptBase.resolve(exceptDelta, derived, loader, errlist);
                }
            }
            tblDerivedExcept.put(sExcept, exceptDerived);
        }
        Vector vectBaseScript = base.m_vectScript;
        Vector vectDeltaScript = delta.m_vectScript;
        Vector vectDerivedScript = derived.m_vectScript;
        int cScripts = vectDeltaScript.size();
        vectDerivedScript.setSize(cScripts);
        for (int i = 0; i < cScripts; ++i) {
            Implementation script = (Implementation)vectDeltaScript.get(i);
            vectDerivedScript.set(i, new Implementation(derived, script));
        }
        if (nDeltaMode == 3 && !delta.m_fPrevOverrideBase) {
            int cBaseImpl = vectBaseScript.size();
            if (base.m_fOverrideBase) {
                cBaseImpl -= base.m_cBaseLevelImpl;
            }
            for (int i = 0; i < cBaseImpl; ++i) {
                Implementation scriptBase = (Implementation)vectBaseScript.get(i);
                Implementation scriptDelta = (Implementation)scriptBase.getNullDerivedTrait(delta, 3);
                Implementation scriptDerived = (Implementation)scriptBase.resolve(scriptDelta, derived, loader, errlist);
                vectDerivedScript.addElement(scriptDerived);
            }
            derived.m_cBaseLevelImpl = delta.m_cBaseLevelImpl + cBaseImpl;
            derived.m_fOverrideBase = delta.m_fOverrideBase;
            derived.m_fPrevOverrideBase = base.m_fOverrideBase || base.m_fPrevOverrideBase;
        } else {
            derived.m_cBaseLevelImpl = delta.m_cBaseLevelImpl;
            derived.m_fOverrideBase = delta.m_fOverrideBase;
            derived.m_fPrevOverrideBase = delta.m_fPrevOverrideBase;
        }
        return derived;
    }

    protected int resolveFlags(int nBaseFlags, int nDeltaFlags) {
        Component cd;
        boolean fBaseResolved;
        boolean fSignature = this.getComponent().isSignature();
        int nDerivedFlags = nBaseFlags;
        if (!fSignature && nDeltaFlags == 0) {
            return nDerivedFlags;
        }
        boolean bl = fBaseResolved = this.getMode() == 1;
        if ((fBaseResolved || (nBaseFlags & 0x1000) != 0) && (nBaseFlags & 0x2000) == 8192) {
            return nDerivedFlags;
        }
        if ((nDeltaFlags & 0x1000000) != 0) {
            nDerivedFlags = nDerivedFlags & 0xF8FFFFFF | nDeltaFlags & 0x7000000;
        }
        if (fSignature || (nDeltaFlags & 8) != 0) {
            int nDeltaAccess;
            int nBaseAccess = nBaseFlags & 0x30;
            int nDerivedAccess = nDeltaAccess = nDeltaFlags & 0x30;
            if ((fBaseResolved || (nBaseFlags & 8) != 0) && nDeltaAccess != nBaseAccess) {
                switch (nBaseAccess) {
                    case 0: {
                        break;
                    }
                    case 16: {
                        if (nDeltaAccess == 32) break;
                    }
                    case 32: {
                        if (nDeltaAccess == 48) break;
                    }
                    case 48: {
                        nDerivedAccess = nBaseAccess;
                    }
                }
            }
            nDerivedFlags = nDerivedFlags & 0xFFFFFFCF | 8 | nDerivedAccess;
        }
        if (fSignature || (nDeltaFlags & 0x40) != 0) {
            nDerivedFlags = nDerivedFlags & 0xFFFFFF3F | nDeltaFlags & 0xC0;
        }
        if (fSignature || (nDeltaFlags & 0x400) != 0) {
            nDerivedFlags = nDerivedFlags & 0xFFFFF3FF | nDeltaFlags & 0xC00;
        }
        if ((fSignature || (nDeltaFlags & 0x1000) != 0) && (nDeltaFlags & 0x2000) == 8192) {
            nDerivedFlags = nDerivedFlags & 0xFFFFCFFF | nDeltaFlags & 0x3000;
        }
        if (fSignature || (nDeltaFlags & 0x4000) != 0) {
            nDerivedFlags = nDerivedFlags & 0xFFFF3FFF | nDeltaFlags & 0xC000;
        }
        if ((nDeltaFlags & 0x40000) != 0 && (nDeltaFlags & 0x180000) == 0x180000 && (!fBaseResolved && (nBaseFlags & 0x40000) == 0 || (nBaseFlags & 0x180000) != 0x180000) && (cd = this.getComponent()).isGlobal() && (cd.getMode() != 1 || cd.isRemote())) {
            boolean fPublic;
            boolean bl2 = fPublic = (nDerivedFlags & 0x30) == 48;
            if (!fBaseResolved && (nDerivedFlags & 8) == 0) {
                fPublic = true;
            }
            if (fPublic) {
                nDerivedFlags = nDerivedFlags & 0xFFE3FFFF | nDeltaFlags & 0x1C0000;
            }
        }
        return nDerivedFlags;
    }

    protected synchronized void finalizeResolve(Loader loader, ErrorList errlist) throws ComponentException {
        super.finalizeResolve(loader, errlist);
        this.m_nFlags &= 0xF6DAAAB6;
        this.m_nPrevFlags &= 0xF6DAAAB6;
        this.m_fPrevOverrideBase = false;
        this.m_retval.finalizeResolve(loader, errlist);
        int c = this.m_vectParam.size();
        for (int i = 0; i < c; ++i) {
            ((Parameter)this.m_vectParam.elementAt(i)).finalizeResolve(loader, errlist);
        }
        if (!this.m_tblExcept.isEmpty()) {
            Enumeration enmr = this.m_tblExcept.elements();
            while (enmr.hasMoreElements()) {
                Throwee except = (Throwee)enmr.nextElement();
                except.finalizeResolve(loader, errlist);
                if (!except.isDiscardable()) continue;
                this.m_tblExcept.remove(except.getUniqueName());
                except.invalidate();
            }
        }
    }

    protected Trait extract(Trait traitBase, Trait parent, Loader loader, ErrorList errlist) throws ComponentException {
        Behavior derived = this;
        Behavior base = (Behavior)traitBase;
        Behavior delta = (Behavior)super.extract(base, parent, loader, errlist);
        boolean fSignature = this.getComponent().isSignature();
        derived.verifyMatch(base, false, errlist);
        boolean fBaseResolved = base.getMode() == 1;
        int nDeltaMode = delta.getMode();
        int nBaseFlags = base.m_nFlags;
        int nDerivedFlags = derived.m_nFlags;
        int nDifFlags = nBaseFlags ^ nDerivedFlags;
        int nDeltaFlags = nDerivedFlags & 0xF6DAAAB6;
        nDeltaFlags = nDeltaFlags & 0xFFFFFFF8 | 0;
        if ((nDifFlags & 0x6000000) != 0 && (fBaseResolved || (nBaseFlags & 0x1000000) != 0)) {
            nDeltaFlags |= 0x1000000;
        }
        if ((nDifFlags & 0x30) != 0 && (fBaseResolved || (nBaseFlags & 8) != 0)) {
            nDeltaFlags |= 8;
        }
        if ((nDifFlags & 0x80) != 0 && (fBaseResolved || (nBaseFlags & 0x40) != 0)) {
            nDeltaFlags |= 0x40;
        }
        if ((nDifFlags & 0x800) != 0 && (fBaseResolved || (nBaseFlags & 0x400) != 0)) {
            nDeltaFlags |= 0x400;
        }
        if ((nDifFlags & 0x2000) != 0 && (fBaseResolved || (nBaseFlags & 0x1000) != 0)) {
            nDeltaFlags |= 0x1000;
        }
        if ((nDifFlags & 0x8000) != 0 && (fBaseResolved || (nBaseFlags & 0x4000) != 0)) {
            nDeltaFlags |= 0x4000;
        }
        if ((nDifFlags & 0x180000) != 0 && (fBaseResolved || (nBaseFlags & 0x40000) != 0)) {
            nDeltaFlags |= 0x40000;
        }
        delta.m_sName = base.m_sName;
        delta.m_nFlags = nDeltaFlags;
        delta.m_nPrevFlags = 0;
        delta.m_retval = (ReturnValue)derived.m_retval.extract(base.m_retval, delta, loader, errlist);
        Vector vectBaseParam = base.m_vectParam;
        Vector vectDerivedParam = derived.matchParameters(base, false, errlist);
        Vector vectDeltaParam = delta.m_vectParam;
        int cParam = vectBaseParam.size();
        vectDeltaParam.setSize(cParam);
        for (int i = 0; i < cParam; ++i) {
            Parameter paramBase = (Parameter)vectBaseParam.get(i);
            Parameter paramDerived = (Parameter)vectDerivedParam.get(i);
            Parameter paramDelta = null;
            paramDelta = paramDerived == null ? (Parameter)paramBase.getNullDerivedTrait(delta, nDeltaMode) : (Parameter)paramDerived.extract(paramBase, delta, loader, errlist);
            vectDeltaParam.set(i, paramDelta);
        }
        delta.updateSignature();
        StringTable tblBaseExcept = base.m_tblExcept;
        StringTable tblDerivedExcept = derived.matchExceptions(base, false, errlist);
        StringTable tblDeltaExcept = delta.m_tblExcept;
        Enumeration enmr = tblDerivedExcept.keys();
        while (enmr.hasMoreElements()) {
            String sExcept = (String)enmr.nextElement();
            Throwee exceptBase = (Throwee)tblBaseExcept.get(sExcept);
            Throwee exceptDerived = (Throwee)tblDerivedExcept.get(sExcept);
            Throwee exceptDelta = null;
            if (exceptBase == null) {
                exceptDelta = new Throwee(delta, exceptDerived);
            } else {
                if (fSignature && exceptDerived == null) {
                    exceptDerived = (Throwee)exceptBase.resolve(exceptBase.getNullDerivedTrait(delta, nDeltaMode), derived, loader, errlist);
                    exceptDerived.setExists(4);
                }
                if (exceptDerived != null) {
                    exceptDelta = (Throwee)exceptDerived.extract(exceptBase, delta, loader, errlist);
                }
            }
            if (exceptDelta == null) continue;
            tblDeltaExcept.put(sExcept, exceptDelta);
        }
        Vector vectBaseScripts = base.m_vectScript;
        Vector vectDerivedScripts = derived.m_vectScript;
        Vector vectDeltaScripts = delta.m_vectScript;
        int cScripts = vectDerivedScripts.size();
        if (cScripts > 0) {
            if (this.isJcsImplementation(cScripts - 1)) {
                --cScripts;
            }
            if (derived.m_fOverrideBase) {
                cScripts -= derived.m_cBaseLevelImpl;
            }
        }
        delta.m_fOverrideBase = derived.m_fOverrideBase;
        delta.m_cBaseLevelImpl = nDeltaMode == 2 ? derived.m_cBaseLevelImpl : 0;
        block2: for (int i = 0; i < cScripts; ++i) {
            Implementation script = (Implementation)vectDerivedScripts.get(i);
            if (nDeltaMode == 3) {
                int cBaseScripts = vectBaseScripts.size();
                for (int iBase = 0; iBase < cBaseScripts; ++iBase) {
                    if (script.equalsUID((Implementation)vectBaseScripts.get(iBase))) break block2;
                }
            }
            vectDeltaScripts.add(new Implementation(delta, script));
        }
        return delta;
    }

    protected synchronized void finalizeExtract(Loader loader, ErrorList errlist) throws ComponentException {
        super.finalizeExtract(loader, errlist);
        boolean fSignature = this.getComponent().isSignature();
        this.m_retval.finalizeExtract(loader, errlist);
        int c = this.m_vectParam.size();
        for (int i = 0; i < c; ++i) {
            ((Parameter)this.m_vectParam.get(i)).finalizeExtract(loader, errlist);
        }
        if (!this.m_tblExcept.isEmpty()) {
            Enumeration enmr = this.m_tblExcept.elements();
            while (enmr.hasMoreElements()) {
                Throwee except = (Throwee)enmr.nextElement();
                except.finalizeExtract(loader, errlist);
                if (fSignature || !except.isDiscardable()) continue;
                this.m_tblExcept.remove(except.getUniqueName());
                except.invalidate();
            }
        }
        Vector vectScript = this.m_vectScript;
        int cScripts = vectScript.size();
        while (cScripts > 0 && !((Implementation)vectScript.get(cScripts - 1)).isDeclaredAtThisLevel()) {
            vectScript.remove(--cScripts);
        }
        this.m_cBaseLevelImpl = 0;
    }

    protected void verifyMatch(Behavior base, boolean fResolve, ErrorList errlist) throws DerivationException {
        if (!this.m_sName.equals(base.m_sName)) {
            String sCode = fResolve ? "RES-201" : "EXT-201";
            Object[] aoParam = new Object[]{this.m_sName, base.m_sName, this.toPathString()};
            this.logError(sCode, 2, aoParam, errlist);
        }
    }

    protected Vector matchParameters(Behavior base, boolean fResolve, ErrorList errlist) throws DerivationException {
        Parameter paramBase;
        UID uid;
        int i;
        int cBaseParam;
        Vector vectThisParam = this.m_vectParam;
        Vector vectBaseParam = base.m_vectParam;
        int cThisParam = vectThisParam.size();
        if (cThisParam == (cBaseParam = vectBaseParam.size())) {
            boolean fMatch = true;
            if (!this.getComponent().isSignature()) {
                for (int i2 = 0; i2 < cBaseParam; ++i2) {
                    Parameter pBase = (Parameter)vectBaseParam.get(i2);
                    Parameter pThis = (Parameter)vectThisParam.get(i2);
                    if (pThis.getUID() != null && pThis.equalsUID(pBase)) continue;
                    fMatch = false;
                    break;
                }
            }
            if (fMatch) {
                return vectThisParam;
            }
        }
        Vector<Parameter> vectResultParam = new Vector<Parameter>(cBaseParam);
        vectResultParam.setSize(cBaseParam);
        if (cThisParam == 0) {
            return vectResultParam;
        }
        Hashtable<UID, Parameter> tblParamByUID = new Hashtable<UID, Parameter>(cBaseParam);
        StringTable tblParamByName = new StringTable(INSENS);
        for (i = 0; i < cThisParam; ++i) {
            Parameter paramThis = (Parameter)vectThisParam.get(i);
            uid = paramThis.getUID();
            if (uid != null) {
                tblParamByUID.put(paramThis.getUID(), paramThis);
            }
            tblParamByName.put(paramThis.getUniqueName(), paramThis);
        }
        if (!tblParamByUID.isEmpty()) {
            for (i = 0; i < cBaseParam; ++i) {
                Parameter paramThis;
                paramBase = (Parameter)vectBaseParam.get(i);
                uid = paramBase.getUID();
                if (uid == null || (paramThis = (Parameter)tblParamByUID.get(uid)) == null) continue;
                vectResultParam.set(i, paramThis);
                tblParamByName.remove(paramThis.getUniqueName());
            }
        }
        for (i = 0; i < cBaseParam; ++i) {
            Parameter paramThis;
            if (vectResultParam.get(i) != null || (paramThis = (Parameter)tblParamByName.get((paramBase = (Parameter)vectBaseParam.get(i)).getUniqueName())) == null) continue;
            vectResultParam.set(i, paramThis);
            tblParamByName.remove(paramThis.getUniqueName());
        }
        Enumeration enmr = tblParamByName.elements();
        while (enmr.hasMoreElements()) {
            Parameter param = (Parameter)enmr.nextElement();
            String sCode = fResolve ? "RES-202" : "EXT-202";
            Object[] aoParam = new Object[]{param.getName(), base.m_sSig, this.toPathString()};
            this.logError(sCode, 2, aoParam, errlist);
        }
        return vectResultParam;
    }

    protected StringTable matchExceptions(Behavior base, boolean fResolve, ErrorList errlist) throws DerivationException {
        UID uid;
        Throwee except;
        StringTable tblThis = this.m_tblExcept;
        StringTable tblBase = base.m_tblExcept;
        StringTable tblResult = tblThis;
        if (tblThis.keysEquals(tblBase)) {
            return tblResult;
        }
        if (tblThis.isEmpty()) {
            tblResult = (StringTable)tblBase.clone();
            Enumeration enmr = tblResult.keys();
            while (enmr.hasMoreElements()) {
                tblResult.put((String)enmr.nextElement(), null);
            }
            return tblResult;
        }
        tblResult = new StringTable();
        Hashtable<UID, Throwee> tblByUID = new Hashtable<UID, Throwee>();
        StringTable tblByName = new StringTable();
        Enumeration enmr = tblThis.elements();
        while (enmr.hasMoreElements()) {
            except = (Throwee)enmr.nextElement();
            uid = except.getUID();
            if (uid != null) {
                tblByUID.put(uid, except);
            }
            tblByName.put(except.getUniqueName(), except);
        }
        if (!tblByUID.isEmpty()) {
            enmr = tblBase.elements();
            while (enmr.hasMoreElements()) {
                Throwee exceptThis;
                Throwee exceptBase = (Throwee)enmr.nextElement();
                uid = exceptBase.getUID();
                if (uid == null || (exceptThis = (Throwee)tblByUID.get(uid)) == null) continue;
                tblResult.put(exceptBase.getUniqueName(), exceptThis);
                tblByName.remove(exceptThis.getUniqueName());
            }
        }
        enmr = tblBase.keys();
        while (enmr.hasMoreElements()) {
            String sExcept = (String)enmr.nextElement();
            if (tblResult.contains(sExcept)) continue;
            Throwee except2 = (Throwee)tblByName.get(sExcept);
            tblResult.put(sExcept, except2);
            if (except2 == null) continue;
            tblByName.remove(sExcept);
        }
        enmr = tblByName.elements();
        while (enmr.hasMoreElements()) {
            except = (Throwee)enmr.nextElement();
            String sExcept = except.getUniqueName();
            if (tblResult.contains(sExcept)) {
                String sCode = fResolve ? "RES-203" : "EXT-203";
                Object[] aoParam = new Object[]{except.getUniqueName(), base.m_sSig, this.toPathString()};
                this.logError(sCode, 2, aoParam, errlist);
                continue;
            }
            tblResult.put(sExcept, except);
        }
        return tblResult;
    }

    protected boolean isClassDiscardable(Trait base) {
        Behavior that = (Behavior)base;
        if (that == null || !this.isFromSuper()) {
            return false;
        }
        if (((this.m_nFlags ^ that.m_nFlags) & 0x618AAB0) != 0) {
            return false;
        }
        if (!this.m_retval.isClassDiscardable(that.m_retval)) {
            return false;
        }
        Vector vectParamThis = this.m_vectParam;
        Vector vectParamThat = that.m_vectParam;
        int c = vectParamThis.size();
        for (int i = 0; i < c; ++i) {
            Parameter paramThat;
            Parameter paramThis = (Parameter)vectParamThis.get(i);
            if (paramThis.isClassDiscardable(paramThat = (Parameter)vectParamThat.get(i))) continue;
            return false;
        }
        if (!this.isClassDiscardableFromSubtraitTable(this.m_tblExcept, that.m_tblExcept)) {
            return false;
        }
        if (this.m_vectScript.size() != (this.m_fOverrideBase ? this.m_cBaseLevelImpl : 0)) {
            return false;
        }
        return super.isClassDiscardable(base);
    }

    public boolean isModifiable() {
        if ((this.m_nPrevFlags & 0x2000) == 8192) {
            return false;
        }
        if (this.getComponent().isSignature() && this.getName().indexOf(60) != -1) {
            return false;
        }
        return super.isModifiable();
    }

    protected boolean isDiscardable() {
        switch (this.getMode()) {
            case 1: {
                if (!((Component)this.getParentTrait()).isSignature()) break;
                return false;
            }
            case 2: 
            case 3: {
                if ((this.m_nFlags & 0x9255549) == 0 && !this.m_fOverrideBase) break;
                return false;
            }
        }
        return super.isDiscardable();
    }

    protected Enumeration getSubTraits() {
        ChainedEnumerator enmr = new ChainedEnumerator();
        enmr.addEnumeration(new SimpleEnumerator(new Object[]{this.m_retval}));
        enmr.addEnumeration(this.m_vectParam.elements());
        enmr.addEnumeration(this.m_tblExcept.elements());
        enmr.addEnumeration(this.m_vectScript.elements());
        return enmr;
    }

    protected synchronized void invalidate() {
        super.invalidate();
        this.m_sName = null;
        this.m_sSig = null;
        this.m_retval = null;
        this.m_vectParam = null;
        this.m_tblExcept = null;
        this.m_vectScript = null;
    }

    protected String getUniqueName() {
        return this.m_sSig;
    }

    protected String getUniqueDescription() {
        return "Behavior " + this.getUniqueName();
    }

    public Component getComponent() {
        return (Component)this.getParentTrait();
    }

    public static String getSignature(String sName, DataType[] adtParam) {
        return Behavior.getSignature(sName, adtParam, 0);
    }

    public static String getSignature(String sName, DataType[] adtParam, int iFirst) {
        StringBuffer sb = new StringBuffer();
        sb.append(sName).append('(');
        int cParam = adtParam != null ? adtParam.length : 0;
        for (int i = iFirst; i < cParam; ++i) {
            sb.append(adtParam[i].getTypeString());
        }
        sb.append(')');
        return sb.toString();
    }

    public String getSignature() {
        return this.m_sSig;
    }

    protected void updateSignature() {
        String sOldSig = this.m_sSig;
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_sName).append('(');
        int c = this.getParameterCount();
        for (int i = 0; i < c; ++i) {
            sb.append(this.getParameter(i).getSignature());
        }
        sb.append(')');
        String sNewSig = sb.toString();
        if (!sNewSig.equals(sOldSig)) {
            this.m_sSig = sNewSig;
            if (sOldSig != null) {
                this.getComponent().renameBehavior(sOldSig, sNewSig);
            }
        }
    }

    public String getJVMSignature() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        int c = this.getParameterCount();
        for (int i = 0; i < c; ++i) {
            sb.append(this.getParameter(i).getDataType().getJVMSignature());
        }
        sb.append(')').append(this.m_retval.getDataType().getJVMSignature());
        return sb.toString();
    }

    protected void setDeclaredByIntegration(Integration map, Behavior method) {
        this.setDeclaredByTrait(map, true, method);
    }

    protected void setDeclaredByInterface(Interface iface, Behavior method) {
        this.setDeclaredByTrait(iface, false, method);
    }

    private void setDeclaredByTrait(Trait trait, boolean fIntegration, Behavior method) {
        DataType dtRet = DataType.VOID;
        String sParamDirs = "I";
        StringTable tblExcept = null;
        if (method != null) {
            dtRet = method.m_retval.getDataType();
            sParamDirs = method.getParameterDirections();
            tblExcept = method.m_tblExcept;
        }
        try {
            String sExcept;
            Enumeration enmr;
            if (fIntegration) {
                if (this.getAccess() == 0) {
                    this.setAccess(48, false);
                }
            } else if (this.getAccess() != 48) {
                this.setAccess(48, false);
            }
            this.setStatic(false, false);
            this.m_retval.setDataType(dtRet, false);
            this.setParameterDirections(sParamDirs, false);
            StringTable tblThrowee = this.m_tblExcept;
            if (tblExcept != null) {
                enmr = tblExcept.keys();
                while (enmr.hasMoreElements()) {
                    sExcept = (String)enmr.nextElement();
                    Throwee except = (Throwee)tblExcept.get(sExcept);
                    Throwee throwee = (Throwee)tblThrowee.get(sExcept);
                    if (throwee == null) {
                        throwee = new Throwee(this, except.getDataType());
                        if (this.isFromSuper() || this.isFromImplements() || this.isFromDispatches() || this.isFromIntegration()) {
                            throwee.setExists(4);
                        }
                        tblThrowee.put(sExcept, throwee);
                        throwee.validate();
                    }
                    throwee.addOriginTrait(trait);
                }
            }
            enmr = tblThrowee.keys();
            while (enmr.hasMoreElements()) {
                sExcept = (String)enmr.nextElement();
                if (tblExcept.contains(sExcept)) continue;
                this.removeException(sExcept, false);
            }
            this.addOriginTrait(trait);
        }
        catch (PropertyVetoException e) {
            throw new IllegalStateException(e.toString());
        }
    }

    protected void mergeJCSExceptions(Behavior that) {
        if (!this.m_tblExcept.equals(that.m_tblExcept)) {
            this.m_tblExcept.retainAll(that.m_tblExcept);
        }
    }

    public boolean isFromImplements() {
        return this.isFromTraitDescriptor("Implements");
    }

    public Enumeration enumImplements() {
        return this.getOriginTraits("Implements");
    }

    public boolean isFromDispatches() {
        return this.isFromTraitDescriptor("Dispatches");
    }

    public Enumeration enumDispatches() {
        return this.getOriginTraits("Dispatches");
    }

    public boolean isFromIntegration() {
        return this.isFromTraitDescriptor("Integration");
    }

    public boolean isFromProperty() {
        return this.isFromTraitDescriptor("Property");
    }

    /*
     * WARNING - void declaration
     */
    public String getPropertyName() {
        void var1_1;
        String sProp;
        if (this.m_sName.startsWith("is")) {
            sProp = this.m_sName.substring("is".length());
        } else if (this.m_sName.startsWith("get")) {
            sProp = this.m_sName.substring("get".length());
        } else if (this.m_sName.startsWith("set")) {
            sProp = this.m_sName.substring("set".length());
        } else {
            return null;
        }
        Property prop = this.getComponent().getProperty((String)var1_1);
        return prop == null ? null : var1_1;
    }

    public boolean isFromManualSettable() {
        return this.isDeclaredAtThisLevel() && this.isFromNonManual() && this.isModifiable();
    }

    public void setFromManual(boolean fManual) throws PropertyVetoException {
        this.setFromManual(fManual, true);
    }

    protected synchronized void setFromManual(boolean fManual, boolean fVetoable) throws PropertyVetoException {
        boolean fPrev = this.isFromManual();
        if (fManual == fPrev) {
            return;
        }
        Boolean prev = Behavior.toBoolean(fPrev);
        Boolean value = Behavior.toBoolean(fManual);
        if (fVetoable) {
            if (!this.isFromManualSettable()) {
                this.readOnlyAttribute(ATTR_FROMMANUAL, prev, value);
            }
            this.fireVetoableChange(ATTR_FROMMANUAL, prev, value);
        }
        if (fManual) {
            this.setFromManual();
        } else {
            this.clearFromManual();
        }
        this.firePropertyChange(ATTR_FROMMANUAL, prev, value);
    }

    public int getExists() {
        return this.m_nFlags & 6;
    }

    protected void setExists(int nExists) {
        this.m_nFlags = this.m_nFlags & 0xFFFFFFF9 | nExists;
    }

    public int getAccess() {
        return this.m_nFlags & 0x30;
    }

    public boolean isAccessSettable() {
        return this.isModifiable() && !this.isFromImplements() && !this.isFromDispatches();
    }

    public boolean isAccessLegal(int nAccess) {
        switch (nAccess) {
            case 0: 
            case 32: 
            case 48: {
                break;
            }
            default: {
                return false;
            }
        }
        if (this.isRemote() && nAccess != 48) {
            return false;
        }
        if (this.isDeclaredAtThisLevel()) {
            if (this.isFromImplements() || this.isFromDispatches()) {
                return false;
            }
            if (this.isFromIntegration()) {
                return nAccess != 0;
            }
            return true;
        }
        switch (this.m_nPrevFlags & 0x30) {
            case 48: {
                if (nAccess == 32) {
                    return false;
                }
            }
            case 32: {
                if (nAccess != 0) break;
                return false;
            }
        }
        return true;
    }

    public void setAccess(int nAccess) throws PropertyVetoException {
        this.setAccess(nAccess, true);
    }

    protected synchronized void setAccess(int nAccess, boolean fVetoable) throws PropertyVetoException {
        int nPrev = this.getAccess();
        if (nAccess == nPrev) {
            return;
        }
        Integer prev = Behavior.makeInteger(nPrev);
        Integer value = Behavior.makeInteger(nAccess);
        if (fVetoable) {
            if (!this.isAccessSettable()) {
                this.readOnlyAttribute(ATTR_ACCESS, prev, value);
            }
            if (!this.isAccessLegal(nAccess)) {
                this.illegalAttributeValue(ATTR_ACCESS, prev, value);
            }
            this.fireVetoableChange(ATTR_ACCESS, prev, value);
        }
        this.m_nFlags = this.m_nFlags & 0xFFFFFFCF | nAccess;
        this.firePropertyChange(ATTR_ACCESS, prev, value);
    }

    public int getVisible() {
        return this.m_nFlags & 0x6000000;
    }

    public boolean isVisibleSettable() {
        return this.isModifiable();
    }

    public boolean isVisibleLegal(int nVis) {
        switch (nVis) {
            case 0: 
            case 0x2000000: 
            case 0x4000000: 
            case 0x6000000: {
                return true;
            }
        }
        return false;
    }

    public void setVisible(int nVis) throws PropertyVetoException {
        this.setVisible(nVis, true);
    }

    protected synchronized void setVisible(int nVis, boolean fVetoable) throws PropertyVetoException {
        int nPrevVis = this.getVisible();
        if (nVis == nPrevVis) {
            return;
        }
        Integer prev = Behavior.makeInteger(nPrevVis);
        Integer value = Behavior.makeInteger(nVis);
        if (fVetoable) {
            if (!this.isVisibleSettable()) {
                this.readOnlyAttribute(ATTR_VISIBLE, prev, value);
            }
            if (!this.isVisibleLegal(nVis)) {
                this.illegalAttributeValue(ATTR_VISIBLE, prev, value);
            }
            this.fireVetoableChange(ATTR_VISIBLE, prev, value);
        }
        this.m_nFlags = this.m_nFlags & 0xF9FFFFFF | nVis;
        this.firePropertyChange(ATTR_VISIBLE, prev, value);
    }

    public boolean isSynchronized() {
        return (this.m_nFlags & 0x80) == 128;
    }

    public boolean isSynchronizedSettable() {
        return this.isModifiable();
    }

    public void setSynchronized(boolean fSync) throws PropertyVetoException {
        this.setSynchronized(fSync, true);
    }

    protected synchronized void setSynchronized(boolean fSync, boolean fVetoable) throws PropertyVetoException {
        boolean fPrevSync = this.isSynchronized();
        if (fSync == fPrevSync) {
            return;
        }
        Boolean prev = Behavior.toBoolean(fPrevSync);
        Boolean value = Behavior.toBoolean(fSync);
        if (fVetoable) {
            if (!this.isSynchronizedSettable()) {
                this.readOnlyAttribute(ATTR_SYNCHRONIZED, prev, value);
            }
            this.fireVetoableChange(ATTR_SYNCHRONIZED, prev, value);
        }
        this.m_nFlags = this.m_nFlags & 0xFFFFFF7F | (fSync ? 128 : 0);
        this.firePropertyChange(ATTR_SYNCHRONIZED, prev, value);
    }

    public boolean isAbstract() {
        return (this.m_nFlags & 0x800) == 2048;
    }

    public boolean isAbstractSettable() {
        return this.isModifiable() && !this.isStatic() && !this.isFinal();
    }

    public void setAbstract(boolean fAbstract) throws PropertyVetoException {
        this.setAbstract(fAbstract, true);
    }

    protected synchronized void setAbstract(boolean fAbstract, boolean fVetoable) throws PropertyVetoException {
        boolean fPrevAbstract = this.isAbstract();
        if (fAbstract == fPrevAbstract) {
            return;
        }
        Boolean prev = Behavior.toBoolean(fPrevAbstract);
        Boolean value = Behavior.toBoolean(fAbstract);
        if (fVetoable) {
            if (!this.isAbstractSettable()) {
                this.readOnlyAttribute(ATTR_ABSTRACT, prev, value);
            }
            this.fireVetoableChange(ATTR_ABSTRACT, prev, value);
        }
        this.m_nFlags = this.m_nFlags & 0xFFFFF7FF | (fAbstract ? 2048 : 0);
        this.firePropertyChange(ATTR_ABSTRACT, prev, value);
    }

    public boolean isStatic() {
        return (this.m_nFlags & 0x200) == 512;
    }

    public boolean isStaticSettable() {
        return this.isModifiable() && !this.isFromNonManual() && !this.isAbstract();
    }

    public void setStatic(boolean fStatic) throws PropertyVetoException {
        this.setStatic(fStatic, true);
    }

    protected synchronized void setStatic(boolean fStatic, boolean fVetoable) throws PropertyVetoException {
        boolean fPrevStatic = this.isStatic();
        if (fStatic == fPrevStatic) {
            return;
        }
        Boolean prev = Behavior.toBoolean(fPrevStatic);
        Boolean value = Behavior.toBoolean(fStatic);
        if (fVetoable) {
            if (!this.isStaticSettable()) {
                this.readOnlyAttribute(ATTR_STATIC, prev, value);
            }
            this.fireVetoableChange(ATTR_STATIC, prev, value);
        }
        this.m_nFlags = this.m_nFlags & 0xFFFFFDFF | (fStatic ? 512 : 0);
        this.firePropertyChange(ATTR_STATIC, prev, value);
    }

    public boolean isFinal() {
        return (this.m_nFlags & 0x2000) == 8192;
    }

    public boolean isFinalSettable() {
        return this.isModifiable() && !this.isAbstract();
    }

    public void setFinal(boolean fFinal) throws PropertyVetoException {
        this.setFinal(fFinal, true);
    }

    protected synchronized void setFinal(boolean fFinal, boolean fVetoable) throws PropertyVetoException {
        boolean fPrevFinal = this.isFinal();
        if (fFinal == fPrevFinal) {
            return;
        }
        Boolean prev = Behavior.toBoolean(fPrevFinal);
        Boolean value = Behavior.toBoolean(fFinal);
        if (fVetoable) {
            if (!this.isFinalSettable()) {
                this.readOnlyAttribute(ATTR_FINAL, prev, value);
            }
            this.fireVetoableChange(ATTR_FINAL, prev, value);
        }
        this.m_nFlags = this.m_nFlags & 0xFFFFDFFF | (fFinal ? 8192 : 0);
        this.firePropertyChange(ATTR_FINAL, prev, value);
    }

    public boolean isDeprecated() {
        return (this.m_nFlags & 0x8000) == 32768;
    }

    public boolean isDeprecatedSettable() {
        return this.isModifiable();
    }

    public void setDeprecated(boolean fDeprecated) throws PropertyVetoException {
        this.setDeprecated(fDeprecated, true);
    }

    protected synchronized void setDeprecated(boolean fDeprecated, boolean fVetoable) throws PropertyVetoException {
        boolean fPrevDeprecated = this.isDeprecated();
        if (fDeprecated == fPrevDeprecated) {
            return;
        }
        Boolean prev = Behavior.toBoolean(fPrevDeprecated);
        Boolean value = Behavior.toBoolean(fDeprecated);
        if (fVetoable) {
            if (!this.isDeprecatedSettable()) {
                this.readOnlyAttribute(ATTR_DEPRECATED, prev, value);
            }
            this.fireVetoableChange(ATTR_DEPRECATED, prev, value);
        }
        this.m_nFlags = this.m_nFlags & 0xFFFF7FFF | (fDeprecated ? 32768 : 0);
        this.firePropertyChange(ATTR_DEPRECATED, prev, value);
    }

    public boolean isRemote() {
        return (this.m_nFlags & 0x180000) == 0x180000;
    }

    public boolean isRemoteSettable() {
        Component cd = this.getComponent();
        return this.isModifiable() && this.getAccess() == 48 && cd.isRemote() && cd.isGlobal() && (this.m_nPrevFlags & 0x180000) == 524288;
    }

    public void setRemote(boolean fRemote) throws PropertyVetoException {
        this.setRemote(fRemote, true);
    }

    protected synchronized void setRemote(boolean fRemote, boolean fVetoable) throws PropertyVetoException {
        boolean fPrevRemote = this.isRemote();
        if (fRemote == fPrevRemote) {
            return;
        }
        Boolean prev = Behavior.toBoolean(fPrevRemote);
        Boolean value = Behavior.toBoolean(fRemote);
        if (fVetoable) {
            if (!this.isRemoteSettable()) {
                this.readOnlyAttribute(ATTR_REMOTE, prev, value);
            }
            this.fireVetoableChange(ATTR_REMOTE, prev, value);
        }
        this.m_nFlags = this.m_nFlags & 0xFFE7FFFF | (fRemote ? 0x180000 : 524288);
        if (fPrevRemote) {
            int c = this.getParameterCount();
            for (int i = 0; i < c; ++i) {
                Parameter param = this.getParameter(i);
                if (param.getDirection() == 0x400000) continue;
                param.setDirection(0x400000, false);
            }
        }
        this.firePropertyChange(ATTR_REMOTE, prev, value);
    }

    public ReturnValue getReturnValue() {
        return this.m_retval;
    }

    public String getName() {
        return this.m_sName;
    }

    public boolean isConstructor() {
        return Behavior.isConstructor(this.m_sName);
    }

    public static boolean isConstructor(String sName) {
        return sName.charAt(0) == '<';
    }

    public boolean isNameSettable() {
        return this.isModifiable() && !this.isFromNonManual();
    }

    public boolean isNameLegal(String sName) {
        if (sName == null || sName.length() == 0 || !ClassHelper.isSimpleNameLegal(sName)) {
            return false;
        }
        if (sName.equals(this.m_sName)) {
            return true;
        }
        String sSig = Behavior.getSignature(sName, this.getParameterTypes());
        return !this.isSignatureReserved(sSig);
    }

    public void setName(String sName) throws PropertyVetoException {
        this.setName(sName, true);
    }

    protected synchronized void setName(String sName, boolean fVetoable) throws PropertyVetoException {
        String sPrev = this.m_sName;
        if (sName.equals(sPrev)) {
            return;
        }
        if (fVetoable) {
            if (!this.isNameSettable()) {
                this.readOnlyAttribute(ATTR_NAME, sPrev, sName);
            }
            if (!this.isNameLegal(sName)) {
                this.illegalAttributeValue(ATTR_NAME, sPrev, sName);
            }
            this.fireVetoableChange(ATTR_NAME, sPrev, sName);
        }
        this.m_sName = sName;
        this.updateSignature();
        this.firePropertyChange(ATTR_NAME, sPrev, sName);
    }

    public Parameter[] getParameter() {
        int c = this.getParameterCount();
        Parameter[] aparam = new Parameter[c];
        for (int i = 0; i < c; ++i) {
            aparam[i] = this.getParameter(i);
        }
        return aparam;
    }

    public boolean isParameterSettable() {
        return this.isModifiable() && !this.isFromNonManual();
    }

    public boolean isParameterLegal(Parameter[] aparam) {
        int c = this.getParameterCount();
        if (aparam == null || aparam.length != c) {
            return false;
        }
        StringBuffer sb = new StringBuffer(this.m_sName);
        sb.append('(');
        boolean[] afFound = new boolean[c];
        for (int i = 0; i < c; ++i) {
            Parameter param = aparam[i];
            int iCurrent = this.getParameterPosition(param);
            if (iCurrent < 0 || afFound[iCurrent]) {
                return false;
            }
            afFound[iCurrent] = true;
            sb.append(param.getSignature());
        }
        sb.append(')');
        String sSig = sb.toString();
        return !this.isSignatureReserved(sSig);
    }

    public void setParameter(Parameter[] aparam) throws PropertyVetoException {
        this.setParameter(aparam, true);
    }

    protected synchronized void setParameter(Parameter[] aParam, boolean fVetoable) throws PropertyVetoException {
        Parameter[] aPrev = this.getParameter();
        int cParam = (fVetoable ? aPrev : aParam).length;
        try {
            boolean fSame = true;
            for (int i = 0; i < cParam; ++i) {
                if (aParam[i] == aPrev[i]) continue;
                fSame = false;
                break;
            }
            if (fSame) {
                return;
            }
        }
        catch (NullPointerException e) {
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        if (fVetoable) {
            if (!this.isParameterSettable()) {
                this.readOnlyAttribute(ATTR_PARAMETER, aPrev, aParam);
            }
            if (!this.isParameterLegal(aParam)) {
                this.illegalAttributeValue(ATTR_PARAMETER, aPrev, aParam);
            }
            this.fireVetoableChange(ATTR_PARAMETER, aPrev, aParam);
        }
        this.m_vectParam.removeAllElements();
        for (int i = 0; i < cParam; ++i) {
            this.m_vectParam.addElement(aParam[i]);
        }
        this.updateSignature();
        this.firePropertyChange(ATTR_PARAMETER, aPrev, aParam);
    }

    public void setParameter(DataType[] adt, String[] asName) throws PropertyVetoException {
        if (adt == null || asName == null) {
            adt = new DataType[]{};
            asName = new String[]{};
        }
        Parameter[] aPrev = this.getParameter();
        int cPrev = aPrev.length;
        if (adt.length != asName.length) {
            this.illegalAttributeValue(ATTR_PARAMETER, aPrev, new Object[]{adt, asName});
        }
        if (cPrev == adt.length) {
            boolean fSame = true;
            for (int i = 0; i < cPrev; ++i) {
                Parameter param = aPrev[i];
                if (param.getDataType() == adt[i] && param.getName().equals(asName[i])) continue;
                fSame = false;
                break;
            }
            if (fSame) {
                return;
            }
        }
        if (!this.isModifiable() || !this.isDeclaredAtThisLevel()) {
            this.illegalAttributeValue(ATTR_PARAMETER, aPrev, new Object[]{adt, asName});
        }
        StringBuffer sb = new StringBuffer(this.m_sName);
        sb.append('(');
        StringTable tblNames = new StringTable(INSENS);
        int cParam = adt.length;
        for (int i = 0; i < cParam; ++i) {
            DataType dt = adt[i];
            String sName = asName[i];
            if (dt == null || dt == DataType.VOID || sName == null || !ClassHelper.isSimpleNameLegal(sName) || tblNames.contains(sName)) {
                this.illegalAttributeValue(ATTR_PARAMETER, aPrev, new Object[]{adt, asName});
            }
            sb.append(dt.getTypeString());
            tblNames.put(sName, Behavior.makeInteger(i));
        }
        sb.append(')');
        String sSig = sb.toString();
        if (this.isSignatureReserved(sSig)) {
            this.illegalAttributeValue(ATTR_PARAMETER, aPrev, new Object[]{adt, asName});
        }
        Parameter[] aParam = new Parameter[cParam];
        boolean fOrderUnchanged = sSig.equals(this.getSignature());
        if (!fOrderUnchanged && !this.isParameterSettable()) {
            this.readOnlyAttribute(ATTR_PARAMETER, aPrev, aParam);
        }
        this.fireVetoableChange(ATTR_PARAMETER, aPrev, aParam);
        if (fOrderUnchanged) {
            for (int i = 0; i < cParam; ++i) {
                aPrev[i].setName(asName[i], false);
            }
        } else {
            Vector<Parameter> vectNoMatch = new Vector<Parameter>();
            for (int i = 0; i < cPrev; ++i) {
                Parameter prev = aPrev[i];
                String sPrev = prev.getName();
                Integer index = (Integer)tblNames.get(sPrev);
                if (index == null) {
                    vectNoMatch.add(prev);
                    continue;
                }
                int iParam = index;
                aParam[iParam] = prev;
                prev.setDataType(adt[iParam], false);
                prev.setName(asName[iParam], false);
            }
            boolean fMatch = true;
            boolean c = false;
            for (int i = 0; i < cParam; ++i) {
                Parameter param = aParam[i];
                if (param != null) continue;
                DataType dt = adt[i];
                String sName = asName[i];
                if (fMatch) {
                    if (vectNoMatch.isEmpty()) {
                        fMatch = false;
                    } else {
                        Parameter prev = (Parameter)vectNoMatch.get(0);
                        if (dt == prev.getDataType()) {
                            prev.setName(sName, false);
                            param = prev;
                            vectNoMatch.remove(0);
                        } else {
                            fMatch = false;
                        }
                    }
                }
                if (param == null) {
                    param = new Parameter(this, dt, sName, 0x400000);
                    param.validate();
                }
                aParam[i] = param;
            }
            if (!vectNoMatch.isEmpty()) {
                Enumeration enmr = vectNoMatch.elements();
                while (enmr.hasMoreElements()) {
                    ((Parameter)enmr.nextElement()).invalidate();
                }
            }
            Vector<Parameter> vectParam = new Vector<Parameter>(cParam);
            for (int i = 0; i < cParam; ++i) {
                vectParam.add(aParam[i]);
            }
            this.m_vectParam = vectParam;
            this.updateSignature();
        }
        this.firePropertyChange(ATTR_PARAMETER, aPrev, aParam);
    }

    public boolean isParameterAddable(int iParam, DataType dt, String sName) {
        int c;
        block8: {
            block7: {
                c = this.getParameterCount();
                if (iParam < 0) {
                    iParam = c;
                }
                if (!this.isParameterSettable() || iParam > c || sName == null || sName.length() == 0 || !ClassHelper.isSimpleNameLegal(sName) || this.getParameter(sName) != null || dt == null) break block7;
                if (dt != DataType.VOID) break block8;
            }
            return false;
        }
        StringBuffer sb = new StringBuffer(this.m_sName);
        sb.append('(');
        for (int i = 0; i < c; ++i) {
            if (i == iParam) {
                sb.append(dt.getTypeString());
            }
            sb.append(this.getParameter(i).getSignature());
        }
        if (iParam == c) {
            sb.append(dt.getTypeString());
        }
        sb.append(')');
        String sSig = sb.toString();
        return !this.isSignatureReserved(sSig);
    }

    public Parameter addParameter(int iParam, DataType dt, String sName) throws PropertyVetoException {
        return this.addParameter(iParam, dt, sName, true);
    }

    protected synchronized Parameter addParameter(int iParam, DataType dt, String sName, boolean fVetoable) throws PropertyVetoException {
        if (fVetoable && !this.isParameterAddable(iParam, dt, sName)) {
            this.subNotAddable(ATTR_PARAMETER, sName);
        }
        Parameter param = new Parameter(this, dt, sName, 0x400000);
        param.setUID(new UID(), fVetoable);
        if (fVetoable) {
            try {
                this.fireVetoableSubChange(param, 1);
            }
            catch (PropertyVetoException e) {
                param.invalidate();
                throw e;
            }
        }
        if (iParam < 0) {
            this.m_vectParam.addElement(param);
        } else {
            this.m_vectParam.insertElementAt(param, iParam);
        }
        this.updateSignature();
        param.validate();
        this.fireSubChange(param, 1);
        return param;
    }

    public boolean isParameterRemovable(int iParam) {
        int c = this.getParameterCount();
        if (!this.isParameterSettable() || iParam < 0 || iParam >= c) {
            return false;
        }
        StringBuffer sb = new StringBuffer(this.m_sName);
        sb.append('(');
        for (int i = 0; i < c; ++i) {
            if (i == iParam) continue;
            sb.append(this.getParameter(i).getSignature());
        }
        sb.append(')');
        String sSig = sb.toString();
        return !this.isSignatureReserved(sSig);
    }

    public void removeParameter(int iParam) throws PropertyVetoException {
        this.removeParameter(iParam, true);
    }

    protected synchronized void removeParameter(int iParam, boolean fVetoable) throws PropertyVetoException {
        Parameter param = null;
        try {
            param = this.getParameter(iParam);
        }
        catch (IndexOutOfBoundsException e) {
            if (fVetoable) {
                this.subNotRemovable(ATTR_PARAMETER, e);
            }
            return;
        }
        if (fVetoable) {
            if (!this.isParameterRemovable(iParam)) {
                this.subNotRemovable(ATTR_PARAMETER, param);
            }
            this.fireVetoableSubChange(param, 2);
        }
        this.m_vectParam.removeElementAt(iParam);
        this.updateSignature();
        this.fireSubChange(param, 2);
        param.invalidate();
    }

    public int getParameterCount() {
        return this.m_vectParam.size();
    }

    public Parameter getParameter(int i) {
        return (Parameter)this.m_vectParam.elementAt(i);
    }

    public int getParameterPosition(Parameter param) {
        return this.m_vectParam.indexOf(param);
    }

    public Parameter getParameter(String sName) {
        CollationKey ckName = INSENS.getCollationKey(sName);
        int c = this.getParameterCount();
        for (int i = 0; i < c; ++i) {
            Parameter param = this.getParameter(i);
            CollationKey ckParam = INSENS.getCollationKey(param.getName());
            if (ckName.compareTo(ckParam) != 0) continue;
            return param;
        }
        return null;
    }

    public DataType[] getParameterTypes() {
        int cdt = this.m_vectParam.size();
        DataType[] adt = new DataType[cdt];
        for (int i = 0; i < cdt; ++i) {
            adt[i] = ((Parameter)this.m_vectParam.elementAt(i)).getDataType();
        }
        return adt;
    }

    public String[] getParameterNames() {
        int cNames = this.m_vectParam.size();
        String[] asName = new String[cNames];
        for (int i = 0; i < cNames; ++i) {
            asName[i] = ((Parameter)this.m_vectParam.elementAt(i)).getName();
        }
        return asName;
    }

    public static final String[] getDefaultParameterNames(DataType[] adtParam) {
        int cParams = adtParam != null ? adtParam.length : 0;
        String[] asParam = new String[cParams];
        for (int i = 0; i < cParams; ++i) {
            asParam[i] = "Param_" + (i + 1);
        }
        return asParam;
    }

    protected String getParameterDirections() {
        int c = this.m_vectParam.size();
        char[] ach = new char[c];
        block4: for (int i = 0; i < c; ++i) {
            switch (((Parameter)this.m_vectParam.elementAt(i)).getDirection()) {
                default: {
                    ach[i] = 73;
                    continue block4;
                }
                case 0x800000: {
                    ach[i] = 79;
                    continue block4;
                }
                case 0xC00000: {
                    ach[i] = 66;
                }
            }
        }
        return new String(ach);
    }

    /*
     * WARNING - void declaration
     */
    protected void setParameterDirections(String sDir, boolean fVetoable) throws PropertyVetoException {
        int c = this.m_vectParam.size();
        if (c != sDir.length()) {
            throw new IllegalArgumentException("Behavior.setParameterDirections:  Invalid direction string (" + sDir + ")!");
        }
        for (int i = 0; i < c; ++i) {
            void var5_5;
            switch (sDir.charAt(i)) {
                case 'I': {
                    int nDir = 0x400000;
                    break;
                }
                case 'O': {
                    int nDir = 0x800000;
                    break;
                }
                case 'B': {
                    int nDir = 0xC00000;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Behavior.setParameterDirections:  Invalid direction string (" + sDir + ")!");
                }
            }
            ((Parameter)this.m_vectParam.elementAt(i)).setDirection((int)var5_5, fVetoable);
        }
    }

    public String[] getExceptionNames() {
        return this.m_tblExcept.strings();
    }

    public Throwee getException(String sExcept) {
        int nExists;
        Throwee except = (Throwee)this.m_tblExcept.get(sExcept);
        if (except != null && ((nExists = except.getExists()) == 4 || nExists == 6)) {
            return null;
        }
        return except;
    }

    public boolean isExceptionSettable() {
        if (!this.isModifiable()) {
            return false;
        }
        if (!(this.isFromSuper() || this.isFromImplements() || this.isFromDispatches() || this.isFromIntegration())) {
            return true;
        }
        Enumeration enmr = this.m_tblExcept.keys();
        while (enmr.hasMoreElements()) {
            String sExcept = (String)enmr.nextElement();
            if (!this.isExceptionRemovable(sExcept) && !this.isExceptionUnremovable(sExcept)) continue;
            return true;
        }
        return false;
    }

    public boolean isExceptionLegal(String[] asExcept) {
        StringTable tblOld = new StringTable();
        Enumeration enmr = this.m_tblExcept.keys();
        while (enmr.hasMoreElements()) {
            String sExcept = (String)enmr.nextElement();
            if (this.getException(sExcept) == null) continue;
            tblOld.add(sExcept);
        }
        StringTable tblNew = new StringTable();
        for (int i = asExcept.length - 1; i >= 0; --i) {
            tblNew.add(asExcept[i]);
        }
        if (tblNew.keysEquals(tblOld)) {
            return true;
        }
        StringTable tblAdded = (StringTable)tblNew.clone();
        tblAdded.removeAll(tblOld);
        Enumeration enmr2 = tblAdded.keys();
        while (enmr2.hasMoreElements()) {
            String sExcept = (String)enmr2.nextElement();
            if (this.isExceptionAddable(sExcept) || this.isExceptionUnremovable(sExcept)) continue;
            return false;
        }
        StringTable tblRemoved = tblOld;
        tblRemoved.removeAll(tblNew);
        Enumeration enmr3 = tblRemoved.keys();
        while (enmr3.hasMoreElements()) {
            if (this.isExceptionRemovable((String)enmr3.nextElement())) continue;
            return false;
        }
        return true;
    }

    public void setException(String[] asExcept) throws PropertyVetoException {
        this.setException(asExcept, true);
    }

    protected synchronized void setException(String[] asExcept, boolean fVetoable) throws PropertyVetoException {
        StringTable tblOld = new StringTable();
        Enumeration enmr = this.m_tblExcept.keys();
        while (enmr.hasMoreElements()) {
            String sExcept = (String)enmr.nextElement();
            if (this.getException(sExcept) == null) continue;
            tblOld.add(sExcept);
        }
        StringTable tblNew = new StringTable();
        for (int i = asExcept.length - 1; i >= 0; --i) {
            tblNew.add(asExcept[i]);
        }
        if (tblNew.keysEquals(tblOld)) {
            return;
        }
        String[] asOld = tblOld.strings();
        String[] asNew = tblNew.strings();
        if (fVetoable) {
            if (!this.isExceptionSettable()) {
                this.readOnlyAttribute(ATTR_EXCEPTION, asOld, asNew);
            }
            if (!this.isExceptionLegal(asExcept)) {
                this.illegalAttributeValue(ATTR_EXCEPTION, asOld, asNew);
            }
            this.fireVetoableChange(ATTR_EXCEPTION, asOld, asNew);
        }
        StringTable tblAdded = (StringTable)tblNew.clone();
        tblAdded.removeAll(tblOld);
        Enumeration enmr2 = tblAdded.keys();
        while (enmr2.hasMoreElements()) {
            String sExcept = (String)enmr2.nextElement();
            if (this.isExceptionUnremovable(sExcept)) {
                this.unremoveException(sExcept, false);
                continue;
            }
            this.addException(sExcept, false);
        }
        StringTable tblRemoved = tblOld;
        tblRemoved.removeAll(tblNew);
        Enumeration enmr3 = tblRemoved.keys();
        while (enmr3.hasMoreElements()) {
            this.removeException((String)enmr3.nextElement(), false);
        }
        this.firePropertyChange(ATTR_EXCEPTION, asOld, asNew);
    }

    public boolean isExceptionAddable(String sExcept) {
        if (!this.isModifiable() || this.isFromSuper() || this.isFromImplements() || this.isFromDispatches() || this.isFromIntegration()) {
            return false;
        }
        if (this.m_tblExcept.contains(sExcept)) {
            return false;
        }
        try {
            return DataType.getClassType(sExcept) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public Throwee addException(String sExcept) throws PropertyVetoException {
        return this.addException(sExcept, true);
    }

    protected synchronized Throwee addException(String sExcept, boolean fVetoable) throws PropertyVetoException {
        if (fVetoable && !this.isExceptionAddable(sExcept)) {
            this.subNotAddable(ATTR_EXCEPTION, sExcept);
        }
        Throwee except = new Throwee(this, DataType.getClassType(sExcept));
        except.setFromManual(true, false);
        except.setUID(new UID(), fVetoable);
        if (fVetoable) {
            try {
                this.fireVetoableSubChange(except, 1);
            }
            catch (PropertyVetoException e) {
                except.invalidate();
                throw e;
            }
        }
        this.m_tblExcept.put(except.getUniqueName(), except);
        except.validate();
        this.fireSubChange(except, 1);
        return except;
    }

    public boolean isExceptionRemovable(String sExcept) {
        if (!this.isModifiable()) {
            return false;
        }
        Throwee except = this.getException(sExcept);
        if (except == null) {
            return false;
        }
        int nExists = except.getExists();
        return nExists == 2 || nExists == 0;
    }

    public void removeException(String sExcept) throws PropertyVetoException {
        this.removeException(sExcept, true);
    }

    protected synchronized void removeException(String sExcept, boolean fVetoable) throws PropertyVetoException {
        boolean fDestroy;
        Throwee except = this.getException(sExcept);
        if (except == null) {
            if (fVetoable) {
                this.subNotRemovable(ATTR_EXCEPTION, sExcept);
            }
            return;
        }
        int nExists = except.getExists();
        if (nExists != 2 && nExists != 0) {
            return;
        }
        if (fVetoable) {
            if (!this.isExceptionRemovable(sExcept)) {
                this.subNotRemovable(ATTR_EXCEPTION, sExcept);
            }
            this.fireVetoableSubChange(except, 2);
        }
        boolean bl = fDestroy = this.isDeclaredAtThisLevel() && !except.isFromNonManual();
        if (fDestroy) {
            this.m_tblExcept.remove(sExcept);
        } else {
            except.setExists(4);
        }
        this.fireSubChange(except, 2);
        if (fDestroy) {
            except.invalidate();
        }
    }

    public boolean isExceptionUnremovable(String sExcept) {
        Throwee except = (Throwee)this.m_tblExcept.get(sExcept);
        if (except == null || except.getExists() != 4) {
            return false;
        }
        if (this.equalsOriginSansManual(except)) {
            return true;
        }
        return this.isFromSuper() == except.isFromSuper() && this.isFromIntegration() == except.isFromIntegration() && Behavior.isEqual(this.enumImplements(), except.enumImplements()) && Behavior.isEqual(this.enumDispatches(), except.enumDispatches());
    }

    private static boolean isEqual(Enumeration enmr1, Enumeration enmr2) {
        while (enmr1.hasMoreElements() && enmr2.hasMoreElements()) {
            if (enmr1.nextElement().equals(enmr2.nextElement())) continue;
            return false;
        }
        return !enmr1.hasMoreElements() && !enmr2.hasMoreElements();
    }

    private static boolean VectMatchesEnum(Vector vect, Enumeration enmr) {
        int cEnum = 0;
        while (enmr.hasMoreElements()) {
            if (!vect.contains(enmr.nextElement())) {
                return false;
            }
            ++cEnum;
        }
        return cEnum == vect.size();
    }

    public void unremoveException(String sExcept) throws PropertyVetoException {
        this.unremoveException(sExcept, true);
    }

    protected synchronized void unremoveException(String sExcept, boolean fVetoable) throws PropertyVetoException {
        Throwee except = (Throwee)this.m_tblExcept.get(sExcept);
        if (except == null) {
            if (fVetoable) {
                this.subNotUnremovable(ATTR_EXCEPTION, sExcept);
            }
            return;
        }
        int nExists = except.getExists();
        if (nExists == 2 || nExists == 0) {
            return;
        }
        if (fVetoable) {
            if (!this.isExceptionUnremovable(sExcept)) {
                this.subNotUnremovable(ATTR_EXCEPTION, sExcept);
            }
            this.fireSubChange(except, 3);
        }
        except.setExists(0);
        this.fireSubChange(except, 3);
    }

    protected void renameException(String sOld, String sNew) {
        this.m_tblExcept.put(sNew, this.m_tblExcept.remove(sOld));
    }

    public Implementation[] getImplementation() {
        Vector vect = this.m_vectScript;
        int cImpl = vect.size();
        Implementation[] aImpl = new Implementation[cImpl];
        while (cImpl-- > 0) {
            aImpl[cImpl] = (Implementation)vect.get(cImpl);
        }
        return aImpl;
    }

    public Implementation getImplementation(int i) {
        return (Implementation)this.m_vectScript.elementAt(i);
    }

    public int getImplementationCount() {
        return this.m_vectScript.size();
    }

    public int getModifiableImplementationCount() {
        return this.m_vectScript.size() - this.m_cBaseLevelImpl;
    }

    public int getBaseImplementationCount() {
        return this.m_cBaseLevelImpl;
    }

    public int getCallableImplementationCount() {
        int cImpl = this.m_vectScript.size();
        if (this.m_fOverrideBase) {
            cImpl -= this.m_cBaseLevelImpl;
        }
        return cImpl;
    }

    public boolean isImplementationSettable() {
        return this.isModifiable();
    }

    public boolean isImplementationLegal(Implementation[] aImpl) {
        int cMove;
        Implementation[] aPrev = this.getImplementation();
        int cImpl = aPrev.length;
        if (aImpl == null || aImpl.length != cImpl) {
            return false;
        }
        for (int i = cMove = this.getModifiableImplementationCount(); i < cImpl; ++i) {
            if (aImpl[i] == aPrev[i]) continue;
            return false;
        }
        boolean[] afFound = new boolean[cMove];
        for (int i = 0; i < cMove; ++i) {
            Implementation impl = aImpl[i];
            if (impl == null) {
                return false;
            }
            int iCurrent = this.getImplementationPosition(impl);
            if (iCurrent < 0 || iCurrent >= cMove || afFound[iCurrent]) {
                return false;
            }
            afFound[iCurrent] = true;
        }
        return true;
    }

    public void setImplementation(Implementation[] aImpl) throws PropertyVetoException {
        this.setImplementation(aImpl, true);
    }

    protected synchronized void setImplementation(Implementation[] aImpl, boolean fVetoable) throws PropertyVetoException {
        int i;
        Implementation[] aPrev = this.getImplementation();
        int cImpl = (fVetoable ? aPrev : aImpl).length;
        try {
            boolean fSame = true;
            for (i = 0; i < cImpl; ++i) {
                if (aImpl[i] == aPrev[i]) continue;
                fSame = false;
                break;
            }
            if (fSame) {
                return;
            }
        }
        catch (NullPointerException e) {
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        if (fVetoable) {
            if (!this.isImplementationSettable()) {
                this.readOnlyAttribute(ATTR_IMPLEMENTATION, aPrev, aImpl);
            }
            if (!this.isImplementationLegal(aImpl)) {
                this.illegalAttributeValue(ATTR_IMPLEMENTATION, aPrev, aImpl);
            }
            this.fireVetoableChange(ATTR_IMPLEMENTATION, aPrev, aImpl);
        }
        Vector<Implementation> vectScript = new Vector<Implementation>();
        for (i = 0; i < cImpl; ++i) {
            vectScript.add(aImpl[i]);
        }
        this.m_vectScript = vectScript;
        this.firePropertyChange(ATTR_IMPLEMENTATION, aPrev, aImpl);
    }

    public boolean isImplementationAddable(int iImpl, String sLang, String sScript) {
        return this.isImplementationSettable() && iImpl <= this.getModifiableImplementationCount() && Implementation.isLanguageLegal(sLang) && Implementation.isScriptLegal(sScript);
    }

    public Implementation addImplementation(int iImpl, String sLang, String sScript) throws PropertyVetoException {
        return this.addImplementation(iImpl, sLang, sScript, true);
    }

    protected synchronized Implementation addImplementation(int iImpl, String sLang, String sScript, boolean fVetoable) throws PropertyVetoException {
        if (fVetoable && !this.isImplementationAddable(iImpl, sLang, sScript)) {
            this.subNotAddable(ATTR_IMPLEMENTATION, sScript);
        }
        Implementation impl = new Implementation(this, sLang, sScript);
        impl.assignUID();
        if (fVetoable) {
            try {
                this.fireVetoableSubChange(impl, 1);
            }
            catch (PropertyVetoException e) {
                impl.invalidate();
                throw e;
            }
        }
        if (iImpl < 0) {
            iImpl = this.getModifiableImplementationCount();
        }
        if (iImpl >= this.m_vectScript.size()) {
            this.m_vectScript.addElement(impl);
        } else {
            this.m_vectScript.insertElementAt(impl, iImpl);
        }
        if ((this.m_nFlags & 0x800) == 2048 && (this.m_nPrevFlags & 0x800) == 2048 && this.isFromSuper()) {
            this.setAbstract(false, false);
        }
        this.fireSubChange(impl, 1);
        return impl;
    }

    void setJcsImplementation(String sLang, String sScript) {
        Behavior.azzert(sLang.indexOf(40) != -1);
        Implementation impl = new Implementation(this, sLang, sScript);
        impl.assignUID();
        this.removeJcsImplementation();
        this.m_vectScript.addElement(impl);
        ++this.m_cBaseLevelImpl;
    }

    void removeJcsImplementation() {
        Vector vectScript = this.m_vectScript;
        if (vectScript.isEmpty()) {
            return;
        }
        int iScript = vectScript.size() - 1;
        if (this.isJcsImplementation(iScript)) {
            vectScript.remove(iScript);
            if (this.m_cBaseLevelImpl > 0) {
                --this.m_cBaseLevelImpl;
            }
        }
    }

    private boolean isJcsImplementation(int iImpl) {
        Implementation impl = (Implementation)this.m_vectScript.get(iImpl);
        return impl.getLanguage().indexOf(40) != -1;
    }

    public boolean isImplementationRemovable(int iImpl) {
        return this.isImplementationSettable() && iImpl >= 0 && iImpl < this.getModifiableImplementationCount();
    }

    public void removeImplementation(int iImpl) throws PropertyVetoException {
        this.removeImplementation(iImpl, true);
    }

    protected synchronized void removeImplementation(int iImpl, boolean fVetoable) throws PropertyVetoException {
        Implementation impl = null;
        try {
            impl = this.getImplementation(iImpl);
        }
        catch (IndexOutOfBoundsException e) {
            if (fVetoable) {
                this.subNotRemovable(ATTR_PARAMETER, e);
            }
            return;
        }
        if (fVetoable) {
            if (!this.isImplementationRemovable(iImpl)) {
                this.subNotRemovable(ATTR_IMPLEMENTATION, this.getImplementation(iImpl));
            }
            this.fireVetoableSubChange(impl, 2);
        }
        this.m_vectScript.removeElementAt(iImpl);
        if ((this.m_nFlags & 0x800) == 0 && (this.m_nPrevFlags & 0x800) == 2048 && this.isFromSuper()) {
            this.setAbstract(true, false);
        }
        this.fireSubChange(impl, 2);
        impl.invalidate();
    }

    public int getImplementationPosition(Implementation impl) {
        return this.m_vectScript.indexOf(impl);
    }

    public boolean isOverrideBase() {
        return this.m_fOverrideBase;
    }

    public void setOverrideBase(boolean fOverride) throws PropertyVetoException {
        this.setOverrideBase(fOverride, true);
    }

    protected synchronized void setOverrideBase(boolean fOverride, boolean fVetoable) throws PropertyVetoException {
        boolean fPrev = this.isOverrideBase();
        if (fOverride == fPrev) {
            return;
        }
        Boolean prev = Behavior.toBoolean(fPrev);
        Boolean value = Behavior.toBoolean(fOverride);
        if (fVetoable) {
            if (!this.isModifiable()) {
                this.readOnlyAttribute(ATTR_OVERRIDEBASE, prev, value);
            }
            this.fireVetoableChange(ATTR_OVERRIDEBASE, prev, value);
        }
        this.m_fOverrideBase = fOverride;
        this.firePropertyChange(ATTR_OVERRIDEBASE, prev, value);
    }

    protected boolean isSignatureReserved(String sSig) {
        Behavior behavior = this.getComponent().getBehavior(sSig);
        if (behavior != null && behavior != this) {
            return true;
        }
        return Behavior.isSignatureReserved(this.getComponent(), sSig);
    }

    protected static boolean isSignatureReserved(Component cd, String sSig) {
        Property prop;
        if (cd.isSignature()) {
            return false;
        }
        if (sSig.startsWith("__")) {
            return true;
        }
        String sProp = Property.getPropertyName(sSig);
        if (sProp != null && (prop = cd.getProperty(sProp)) != null && prop.isReservedBehaviorSignature(sSig)) {
            if (!sProp.equals(prop.getName())) {
                return false;
            }
            if (prop.isFromSuper()) {
                return false;
            }
            for (int i = 0; i <= 5; ++i) {
                if (!sSig.equals(prop.getAccessorSignature(i)) || prop.isAccessorApplicable(i)) continue;
                return true;
            }
        }
        return false;
    }

    public static DataType[] getParameterTypes(String sSig) {
        return DataType.parseSignature(sSig);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Behavior) {
            Behavior that = (Behavior)obj;
            return this == that || this.m_nFlags == that.m_nFlags && this.m_nPrevFlags == that.m_nPrevFlags && this.m_fOverrideBase == that.m_fOverrideBase && this.m_cBaseLevelImpl == that.m_cBaseLevelImpl && this.m_sName.equals(that.m_sName) && this.m_sSig.equals(that.m_sSig) && this.m_retval.equals(that.m_retval) && this.m_tblExcept.equals(that.m_tblExcept) && this.m_vectParam.equals(that.m_vectParam) && this.m_vectScript.equals(that.m_vectScript) && super.equals(that);
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.m_retval != null && !this.isConstructor()) {
            sb.append(this.m_retval.getDataType().toString()).append(' ');
        }
        sb.append(this.m_sName).append('(');
        int c = this.getParameterCount();
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            Parameter parameter = this.getParameter(i);
            sb.append(parameter.getDataType().toString());
            sb.append(" " + parameter.getName());
        }
        sb.append(')');
        return sb.toString();
    }

    public void dump(PrintWriter out, String sIndent) {
        boolean fDerOrMod = this.getMode() == 3 || this.getMode() == 2;
        out.println(sIndent + "Behavior " + this.toString());
        out.println(sIndent + "Signature=\"" + this.m_sSig + '\"');
        super.dump(out, sIndent);
        out.print(sIndent + "flags=0x" + Integer.toHexString(this.m_nFlags));
        out.println(" (" + Behavior.flagsDescription(this.m_nFlags, 17061193, fDerOrMod) + ')');
        out.print(sIndent + "previous flags=0x" + Integer.toHexString(this.m_nPrevFlags));
        out.println(" (" + Behavior.flagsDescription(this.m_nPrevFlags, 17061193, fDerOrMod) + ')');
        out.print(sIndent + "Return Value:");
        if (this.m_retval == null) {
            out.println("  <null>");
        } else {
            out.println();
            this.m_retval.dump(out, Behavior.nextIndent(sIndent));
        }
        out.println(sIndent + this.m_vectParam.size() + " parameter(s)");
        int i = 0;
        Enumeration enmr = this.m_vectParam.elements();
        while (enmr.hasMoreElements()) {
            Parameter param = (Parameter)enmr.nextElement();
            out.print(sIndent + "Parameter " + ++i + ":");
            if (param == null) {
                out.println("  <null>");
                continue;
            }
            out.println();
            param.dump(out, Behavior.nextIndent(sIndent));
        }
        out.println(sIndent + this.m_tblExcept.getSize() + " exception(s)");
        enmr = this.m_tblExcept.keys();
        while (enmr.hasMoreElements()) {
            String sExcept = (String)enmr.nextElement();
            Throwee except = (Throwee)this.m_tblExcept.get(sExcept);
            out.print(sIndent + "Exception \"" + sExcept + "\":");
            if (except == null) {
                out.println("  <null>");
                continue;
            }
            out.println();
            except.dump(out, Behavior.nextIndent(sIndent));
        }
        out.print(sIndent + this.m_vectScript.size() + " implementation(s), ");
        out.print(this.m_cBaseLevelImpl + " at the base level (");
        out.println((this.m_fOverrideBase ? "overidden" : "supplemented") + ')');
        i = 0;
        enmr = this.m_vectScript.elements();
        while (enmr.hasMoreElements()) {
            Implementation impl = (Implementation)enmr.nextElement();
            out.print(sIndent + "Implementation " + ++i + ":");
            if (impl == null) {
                out.println("  <null>");
                continue;
            }
            out.println();
            impl.dump(out, Behavior.nextIndent(sIndent));
        }
    }
}

