/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.component;

import com.tangosol.dev.component.Behavior;
import com.tangosol.dev.component.ComponentException;
import com.tangosol.dev.component.DataType;
import com.tangosol.dev.component.DerivationException;
import com.tangosol.dev.component.Loader;
import com.tangosol.dev.component.Trait;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ErrorList;
import java.beans.PropertyVetoException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;

public class Parameter
extends Trait {
    public static final String ATTR_DATATYPE = "DataType";
    public static final String ATTR_NAME = "Name";
    public static final String ATTR_DIRECTION = "Direction";
    private static final String CLASS = "Parameter";
    protected static final String DESCRIPTOR = "Parameter";
    private String m_sName;
    private DataType m_dt;
    private int m_nFlags;

    protected Parameter(Behavior behavior, DataType dt, String sName, int nDir) {
        super((Trait)behavior, 1);
        if (behavior == null) {
            throw new IllegalArgumentException("Parameter:  Containing behavior required.");
        }
        if (dt == null) {
            throw new IllegalArgumentException("Parameter:  DataType required.");
        }
        if (dt == DataType.VOID) {
            throw new IllegalArgumentException("Parameter:  Illegal DataType (" + dt.toString() + ")");
        }
        if (sName == null || sName.length() == 0 || !ClassHelper.isSimpleNameLegal(sName)) {
            throw new IllegalArgumentException("Parameter:  Illegal name (" + sName + ")");
        }
        if (nDir != 0x400000 && nDir != 0x800000 && nDir != 0xC00000) {
            throw new IllegalArgumentException("Parameter:  Illegal direction (" + nDir + ")");
        }
        this.m_sName = sName;
        this.m_dt = dt;
        this.m_nFlags = nDir;
        if (!behavior.getComponent().isSignature()) {
            this.assignUID();
        }
    }

    protected Parameter(Parameter base, Behavior behavior, int nMode) {
        super((Trait)base, behavior, nMode);
        this.m_sName = base.m_sName;
        this.m_dt = base.m_dt;
        this.m_nFlags = base.m_nFlags;
    }

    protected Parameter(Behavior behavior, Parameter that) {
        super((Trait)behavior, that);
        this.m_sName = that.m_sName;
        this.m_dt = that.m_dt;
        this.m_nFlags = that.m_nFlags;
    }

    protected Parameter(Behavior behavior, DataInput stream, int nVersion) throws IOException {
        super((Trait)behavior, stream, nVersion);
        this.m_sName = stream.readUTF();
        this.m_dt = DataType.getType(stream.readUTF());
        this.m_nFlags = stream.readInt();
    }

    protected Parameter(Trait parent, XmlElement xml, int nVersion) throws IOException {
        super(parent, xml, nVersion);
        String sName = Parameter.readString(xml.getElement("name"));
        String sType = Parameter.readString(xml.getElement("type"));
        if (sName == "" || sType == "") {
            throw new IOException("name or type is missing");
        }
        int nFlags = Parameter.readFlags(xml, "flags", 0x400000);
        this.m_sName = sName;
        this.m_dt = DataType.getType(sType);
        this.m_nFlags = nFlags;
    }

    protected synchronized void save(DataOutput stream) throws IOException {
        super.save(stream);
        stream.writeUTF(this.m_sName);
        stream.writeUTF(this.m_dt.getTypeString());
        stream.writeInt(this.m_nFlags);
    }

    protected synchronized void save(XmlElement xml) throws IOException {
        xml.addElement("name").setString(this.m_sName);
        xml.addElement("type").setString(this.m_dt.getTypeString());
        super.save(xml);
        Parameter.saveFlags(xml, "flags", this.m_nFlags, 0x400000);
    }

    protected Trait getBlankDerivedTrait(Trait parent, int nMode) {
        return new Parameter(this, (Behavior)parent, nMode);
    }

    protected Trait resolve(Trait traitDelta, Trait parent, Loader loader, ErrorList errlist) throws ComponentException {
        Parameter base = this;
        Parameter delta = (Parameter)this.resolveDelta(traitDelta, loader, errlist);
        Parameter derived = (Parameter)super.resolve(delta, parent, loader, errlist);
        delta.verifyMatch(base, true, errlist);
        derived.m_dt = base.m_dt;
        derived.m_sName = base.m_sName;
        derived.m_nFlags = base.m_nFlags;
        return derived;
    }

    protected Trait extract(Trait traitBase, Trait parent, Loader loader, ErrorList errlist) throws ComponentException {
        Parameter derived = this;
        Parameter base = (Parameter)traitBase;
        Parameter delta = (Parameter)super.extract(base, parent, loader, errlist);
        derived.verifyMatch(base, false, errlist);
        delta.m_dt = base.m_dt;
        delta.m_sName = base.m_sName;
        delta.m_nFlags = base.m_nFlags;
        return delta;
    }

    protected void verifyMatch(Parameter base, boolean fResolve, ErrorList errlist) throws DerivationException {
        Object[] aoParam;
        String sCode;
        if (this.m_dt != base.m_dt) {
            sCode = fResolve ? "RES-301" : "EXT-301";
            aoParam = new Object[]{Integer.toString(base.getBehavior().getParameterPosition(base) + 1), base.getBehavior().toString(), this.m_dt.toString(), base.m_dt.toString(), this.toPathString()};
            this.logError(sCode, 2, aoParam, errlist);
        }
        if (!this.getBehavior().getComponent().isSignature() && !this.m_sName.equals(base.m_sName)) {
            sCode = fResolve ? "RES-302" : "EXT-302";
            aoParam = new Object[]{Integer.toString(base.getBehavior().getParameterPosition(base) + 1), base.getBehavior().toString(), this.m_sName, base.m_sName, this.toPathString()};
            this.logError(sCode, 2, aoParam, errlist);
        }
        if (this.m_nFlags != base.m_nFlags) {
            sCode = fResolve ? "RES-303" : "EXT-303";
            aoParam = new Object[]{Integer.toString(base.getBehavior().getParameterPosition(base) + 1), base.getBehavior().toString(), Parameter.getDirectionString(this.m_nFlags), Parameter.getDirectionString(base.m_nFlags), this.toPathString()};
            this.logError(sCode, 2, aoParam, errlist);
        }
    }

    protected synchronized void invalidate() {
        super.invalidate();
        this.m_dt = null;
        this.m_sName = null;
    }

    protected String getUniqueName() {
        return this.m_sName;
    }

    protected String getUniqueDescription() {
        return "Parameter " + this.getUniqueName();
    }

    public Behavior getBehavior() {
        return (Behavior)this.getParentTrait();
    }

    public DataType getDataType() {
        return this.m_dt;
    }

    public boolean isDataTypeSettable() {
        return this.getBehavior().isParameterSettable();
    }

    public boolean isDataTypeLegal(DataType dt) {
        block5: {
            block4: {
                if (dt == null) break block4;
                if (dt != DataType.VOID) break block5;
            }
            return false;
        }
        if (dt == this.m_dt) {
            return true;
        }
        Behavior behavior = this.getBehavior();
        DataType[] adt = behavior.getParameterTypes();
        adt[behavior.getParameterPosition((Parameter)this)] = dt;
        String sSig = Behavior.getSignature(behavior.getName(), adt);
        return !behavior.isSignatureReserved(sSig);
    }

    public void setDataType(DataType dt) throws PropertyVetoException {
        this.setDataType(dt, true);
    }

    protected synchronized void setDataType(DataType dt, boolean fVetoable) throws PropertyVetoException {
        DataType dtPrev = this.m_dt;
        if (dt == dtPrev) {
            return;
        }
        if (fVetoable) {
            if (!this.isDataTypeSettable()) {
                this.readOnlyAttribute(ATTR_DATATYPE, dtPrev, dt);
            }
            if (!this.isDataTypeLegal(dt)) {
                this.illegalAttributeValue(ATTR_DATATYPE, dtPrev, dt);
            }
            this.fireVetoableChange(ATTR_DATATYPE, dtPrev, dt);
        }
        this.m_dt = dt;
        this.getBehavior().updateSignature();
        this.firePropertyChange(ATTR_DATATYPE, dtPrev, dt);
    }

    public String getSignature() {
        return this.m_dt.getTypeString();
    }

    public String getName() {
        return this.m_sName;
    }

    public boolean isNameSettable() {
        return this.isModifiable() && this.getBehavior().isDeclaredAtThisLevel();
    }

    public boolean isNameLegal(String sName) {
        if (sName == null || sName.length() == 0 || !ClassHelper.isSimpleNameLegal(sName)) {
            return false;
        }
        if (sName.equals(this.m_sName)) {
            return true;
        }
        Parameter param = this.getBehavior().getParameter(sName);
        return param == null || param == this;
    }

    public void setName(String sName) throws PropertyVetoException {
        this.setName(sName, true);
    }

    protected synchronized void setName(String sName, boolean fVetoable) throws PropertyVetoException {
        String sPrev = this.m_sName;
        if (sName.equals(sPrev)) {
            return;
        }
        if (fVetoable) {
            if (!this.isNameSettable()) {
                this.readOnlyAttribute(ATTR_NAME, sPrev, sName);
            }
            if (!this.isNameLegal(sName)) {
                this.illegalAttributeValue(ATTR_NAME, sPrev, sName);
            }
            this.fireVetoableChange(ATTR_NAME, sPrev, sName);
        }
        this.m_sName = sName;
        this.firePropertyChange(ATTR_NAME, sPrev, sName);
    }

    public int getDirection() {
        return this.m_nFlags & 0xC00000;
    }

    public boolean isDirectionSettable() {
        Behavior behavior = this.getBehavior();
        return behavior.isParameterSettable() && behavior.isRemote();
    }

    public boolean isDirectionLegal(int nDir) {
        return nDir == 0x400000 || nDir == 0x800000 || nDir == 0xC00000;
    }

    public void setDirection(int nDir) throws PropertyVetoException {
        this.setDirection(nDir, true);
    }

    protected synchronized void setDirection(int nDir, boolean fVetoable) throws PropertyVetoException {
        int nPrev = this.getDirection();
        if (nDir == nPrev) {
            return;
        }
        Integer prev = Parameter.makeInteger(nPrev);
        Integer value = Parameter.makeInteger(nDir);
        if (fVetoable) {
            if (!this.isDirectionSettable()) {
                this.readOnlyAttribute(ATTR_DIRECTION, prev, value);
            }
            if (!this.isDirectionLegal(nDir)) {
                this.illegalAttributeValue(ATTR_DIRECTION, prev, value);
            }
            this.fireVetoableChange(ATTR_DIRECTION, prev, value);
        }
        this.m_nFlags = this.m_nFlags & 0xFF3FFFFF | nDir;
        this.firePropertyChange(ATTR_DIRECTION, prev, value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Parameter) {
            Parameter that = (Parameter)obj;
            return this == that || this.m_nFlags == that.m_nFlags && this.m_dt == that.m_dt && this.m_sName.equals(that.m_sName) && super.equals(that);
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_dt.toString()).append(' ').append(this.m_sName).append(' ').append(Parameter.getDirectionString(this.getDirection()));
        return sb.toString();
    }

    public void dump(PrintWriter out, String sIndent) {
        out.print(sIndent + "Parameter type=" + this.m_dt.getTypeString());
        out.print(" (" + this.m_dt.toString() + "), name=" + this.m_sName);
        out.println(", direction=" + Parameter.getDirectionString(this.getDirection()));
        super.dump(out, sIndent);
    }

    public static String getDirectionString(int nDir) {
        switch (nDir & 0xC00000) {
            case 0x400000: {
                return "in";
            }
            case 0x800000: {
                return "out";
            }
            case 0xC00000: {
                return "inout";
            }
        }
        return "<invalid direction>";
    }
}

