/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.component;

import com.tangosol.dev.assembler.ClassFile;
import com.tangosol.dev.component.Component;
import com.tangosol.dev.component.ComponentException;
import com.tangosol.dev.component.Constants;
import com.tangosol.dev.component.Loader;
import com.tangosol.dev.component.Trait;
import com.tangosol.util.Base;
import com.tangosol.util.ErrorList;
import java.io.IOException;
import java.util.Iterator;

public class Resolver
extends Base
implements Constants,
Loader {
    private static final String CLASS = "Resolver";
    private Loader m_loader;
    private String m_sPkg;
    private ClassFile.Relocator m_relocator;

    public Resolver(Loader loader) {
        this(loader, null);
    }

    public Resolver(Loader loader, String sPkg) {
        this.m_loader = loader;
        if (sPkg != null) {
            this.m_sPkg = sPkg;
            this.m_relocator = new ClassFile.Relocator(sPkg);
        }
    }

    public Component loadComponent(String sName, boolean fReadOnly, ErrorList errlist) throws ComponentException {
        Component cd = this.m_loader.loadComponent(sName, true, errlist);
        if (cd != null) {
            switch (cd.getMode()) {
                case 1: {
                    if (cd.isInterface()) {
                        throw new ComponentException("Resolver.loadComponent:  Interface " + sName + " should be a derivation");
                    }
                    if (fReadOnly) break;
                    cd.setModifiable(true);
                    break;
                }
                case 2: {
                    Component cdSuper;
                    Component component = cdSuper = cd.isInterface() ? new Component(null, 2, "") : this.loadComponent(cd.getSuperName(), true, errlist);
                    if (cdSuper == null) {
                        throw new ComponentException("Failed to load the super component: \"" + cd.getSuperName() + "\" of component \"" + sName + '\"');
                    }
                    if (Trait.DEBUG) {
                        Resolver.out();
                        Resolver.out("***Resolver*** Component Super before resolve:");
                        cdSuper.dump();
                        Resolver.out();
                        Resolver.out("***Resolver*** Component Delta before resolve:");
                        cd.dump();
                    }
                    cd = cdSuper.resolve(cd, this, errlist);
                    if (Trait.DEBUG) {
                        Resolver.out();
                        Resolver.out("***Resolver*** Component Derived after resolve:");
                        cd.dump();
                    }
                    cd.finalizeResolve(this, errlist);
                    if (Trait.DEBUG) {
                        Resolver.out();
                        Resolver.out("***Resolver*** Component Derived after finalizeResolve:");
                        cd.dump();
                    }
                    if (!fReadOnly) break;
                    cd.setModifiable(false);
                    break;
                }
                default: {
                    throw new ComponentException("Resolver.loadComponent:  Loader returned invalid mode \"" + sName + "\"(" + (cd.getMode() == 3 ? "MODIFICATION" : "INVALID") + ")");
                }
            }
        }
        return cd;
    }

    public Component loadSignature(String sName) throws ComponentException {
        Component signature = this.m_loader.loadSignature(sName);
        if (signature != null) {
            switch (signature.getMode()) {
                case 1: {
                    break;
                }
                case 2: {
                    Component signatureSuper;
                    String sSuperName = signature.getSuperName();
                    if (sSuperName.length() == 0) {
                        signatureSuper = new Component(null, 2, "");
                    } else {
                        signatureSuper = this.loadSignature(sSuperName);
                        if (signatureSuper == null) {
                            throw new ComponentException("Resolver.loadSignature:  Failure to load the super " + signature.getSuperName() + " for class " + sName);
                        }
                    }
                    Component signatureDelta = signature;
                    if (Trait.DEBUG) {
                        Resolver.out();
                        Resolver.out("***Resolver*** Signature Super before resolve:");
                        signatureSuper.dump();
                        Resolver.out();
                        Resolver.out("***Resolver*** Signature Delta before resolve:");
                        signatureDelta.dump();
                    }
                    ErrorList errlist = new ErrorList();
                    signature = signatureSuper.resolve(signatureDelta, this, errlist);
                    if (Trait.DEBUG) {
                        Resolver.out();
                        Resolver.out("***Resolver*** Signature Derived after resolve:");
                        signature.dump();
                    }
                    if (!errlist.isEmpty()) {
                        throw new ComponentException(this.formatErrorList(sName, errlist, false));
                    }
                    signature.finalizeResolve(this, errlist);
                    if (Trait.DEBUG) {
                        Resolver.out();
                        Resolver.out("***Resolver*** Signature Derived after finalizeResolve:");
                        signature.dump();
                    }
                    if (errlist.isEmpty()) break;
                    throw new ComponentException(this.formatErrorList(sName, errlist, true));
                }
                default: {
                    throw new ComponentException("Resolver.loadSignature:  Loader returned invalid mode \"" + sName + "\"(" + (signature.getMode() == 3 ? "MODIFICATION" : "INVALID") + ")");
                }
            }
        }
        return signature;
    }

    private String formatErrorList(String sName, ErrorList errlist, boolean fFinalize) {
        StringBuffer sb = new StringBuffer();
        if (fFinalize) {
            sb.append("Finalize ");
        }
        sb.append("Resolve of Java Class Signature ");
        sb.append(sName);
        sb.append(" contains ");
        sb.append(errlist.size());
        sb.append(" errors:");
        Iterator iter = errlist.iterator();
        while (iter.hasNext()) {
            sb.append("\n    ");
            sb.append(iter.next().toString());
        }
        return sb.toString();
    }

    public ClassFile loadOriginalClass(String sName) throws ComponentException {
        return this.m_loader.loadOriginalClass(sName);
    }

    public ClassFile loadClass(String sName) throws ComponentException {
        ClassFile clz = this.m_loader.loadClass(sName);
        if (this.m_sPkg != null) {
            if (clz == null && sName.startsWith(this.m_sPkg)) {
                sName = "_package/" + sName.substring(this.m_sPkg.length());
                clz = this.m_loader.loadClass(sName);
            }
            if (clz != null) {
                clz.resolve(this.m_relocator);
            }
        }
        return clz;
    }

    public String loadJava(String sName) throws IOException {
        String sScript = this.m_loader.loadJava(sName);
        if (sScript == null && this.m_sPkg != null && sName.startsWith(this.m_sPkg)) {
            sName = "_package/" + sName.substring(this.m_sPkg.length());
            sScript = this.m_loader.loadJava(sName);
        }
        return sScript;
    }

    public byte[] loadOriginalResource(String sName) throws IOException {
        return this.m_loader.loadOriginalResource(sName);
    }

    public byte[] loadResourceSignature(String sName) throws IOException {
        return this.m_loader.loadResourceSignature(sName);
    }

    public byte[] loadResource(String sName) throws IOException {
        byte[] ab = this.m_loader.loadResource(sName);
        if (ab == null && this.m_sPkg != null && sName.startsWith(this.m_sPkg)) {
            sName = "_package/" + sName.substring(this.m_sPkg.length());
            ab = this.m_loader.loadResource(sName);
        }
        return ab;
    }

    public String toString() {
        return "Resolver(" + this.m_loader + ')';
    }
}

