/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.packager;

import com.tangosol.dev.packager.FilePackagerPath;
import com.tangosol.dev.packager.PackagerPath;
import com.tangosol.dev.packager.ResourceSet;
import com.tangosol.dev.packager.UnexpectedPackagerException;
import com.tangosol.util.Base;
import java.io.IOException;
import java.util.zip.ZipFile;

public class ExistingArchiveResourceSet
extends ResourceSet {
    private transient ZipFile zipFile;
    private String zipFilePathName;

    public ExistingArchiveResourceSet(String zipFilePathName) throws IOException {
        this.zipFilePathName = zipFilePathName;
        this.getZipFile();
    }

    public ExistingArchiveResourceSet(ZipFile zipFile) {
        this.setZipFile(zipFile);
    }

    public boolean containsKey(PackagerPath path) {
        String pathName = path.getPathName();
        try {
            return this.getZipFile().getEntry(pathName) != null;
        }
        catch (IOException ioe) {
            throw new UnexpectedPackagerException(ioe);
        }
    }

    public ZipFile getZipFile() throws IOException {
        if (this.zipFile == null && this.zipFilePathName != null) {
            this.zipFile = new ZipFile(this.zipFilePathName);
        }
        return this.zipFile;
    }

    public void setZipFile(ZipFile zipFile) {
        this.zipFile = zipFile;
        this.zipFilePathName = zipFile == null ? null : zipFile.getName();
    }

    public static void main(String[] args) {
        try {
            ExistingArchiveResourceSet archive = new ExistingArchiveResourceSet(args[0]);
            for (int i = 1; i < args.length; ++i) {
                Base.out(archive.containsKey(new FilePackagerPath(args[i])) + "\t" + args[i]);
            }
        }
        catch (Exception e) {
            Base.out(e);
        }
    }
}

