/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.packager;

import com.tangosol.dev.packager.PackagerPath;
import com.tangosol.dev.packager.ResourceSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PackageOwnerResourceSet
extends ResourceSet {
    private List ownedPackageList = new LinkedList();

    public PackageOwnerResourceSet() {
    }

    public PackageOwnerResourceSet(String packageName) {
        this.addOwnedPackageName(packageName);
    }

    public boolean containsKey(PackagerPath entryPath) {
        String pathName = entryPath.getPathName();
        Iterator iter = this.ownedPackageList.iterator();
        while (iter.hasNext()) {
            String packageName = (String)iter.next();
            if (!pathName.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    public String[] getOwnedPackageNames() {
        return this.ownedPackageList.toArray(new String[this.ownedPackageList.size()]);
    }

    public void setOwnedPackageNames(String[] packageNames) {
        PackageOwnerResourceSet.azzert(packageNames != null);
        this.ownedPackageList = new LinkedList<String>(Arrays.asList(packageNames));
    }

    public void addOwnedPackageName(String packageName) {
        PackageOwnerResourceSet.azzert(packageName != null);
        String packagePath = packageName.replace('.', '/');
        if (!packagePath.endsWith("/")) {
            packagePath = packagePath + "/";
        }
        this.ownedPackageList.add(packagePath);
    }
}

