/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.packager;

import com.tangosol.dev.packager.PackagerEntry;
import com.tangosol.dev.packager.PackagerEntryNotFoundException;
import com.tangosol.dev.packager.PackagerPath;
import com.tangosol.util.Base;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class PackagerBaseEntry
extends Base
implements Serializable,
PackagerEntry {
    private Properties attributes;
    private static String[] classpathEntries;

    protected PackagerBaseEntry() {
    }

    public abstract PackagerPath getPath();

    public abstract byte[] getData(ClassLoader var1) throws PackagerEntryNotFoundException;

    public long getModificationTime() {
        return new Date().getTime();
    }

    public String getComment() {
        return null;
    }

    public boolean isSecured() {
        return false;
    }

    public Properties getAttributes() {
        return this.attributes;
    }

    public String getAttributeValue(String attributeName) {
        return this.attributes == null ? null : this.attributes.getProperty(attributeName);
    }

    public String getAttributeValue(String attributeName, String defaultValue) {
        return this.attributes == null ? null : this.attributes.getProperty(attributeName, defaultValue);
    }

    public void setAttributeValue(String attributeName, String value) {
        if (this.attributes == null) {
            this.attributes = new Properties();
        }
        this.attributes.setProperty(attributeName, value);
    }

    protected File findEntryFile() {
        String[] classpathEntries = PackagerBaseEntry.getClasspathEntries();
        int n = classpathEntries.length;
        for (int i = 0; i < n; ++i) {
            File entryFile;
            File classpathEntryFile = new File(classpathEntries[i]);
            if (!classpathEntryFile.exists() || !classpathEntryFile.isDirectory() || !(entryFile = new File(classpathEntryFile, this.getPath().getPathName())).exists()) continue;
            return entryFile;
        }
        return null;
    }

    private static String[] getClasspathEntries() {
        if (classpathEntries == null) {
            String classpath = System.getProperty("java.class.path");
            StringTokenizer toks = new StringTokenizer(classpath, File.pathSeparator);
            ArrayList<String> elems = new ArrayList<String>();
            while (toks.hasMoreTokens()) {
                elems.add(toks.nextToken());
            }
            classpathEntries = new String[elems.size()];
            elems.toArray(classpathEntries);
        }
        return classpathEntries;
    }
}

