/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.packager;

import com.tangosol.dev.packager.FilePackagerPath;
import com.tangosol.dev.packager.PackagerBaseEntry;
import com.tangosol.dev.packager.PackagerDependencyElement;
import com.tangosol.dev.packager.PackagerEntryNotFoundException;
import com.tangosol.dev.packager.PackagerPath;
import com.tangosol.dev.packager.UnexpectedPackagerException;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class PackagerFileEntry
extends PackagerBaseEntry
implements PackagerDependencyElement {
    private String filePath;
    private String packagedDirectoryPath;

    public PackagerFileEntry() {
    }

    public PackagerFileEntry(String filePath, String packagedDirectoryPath) {
        this.setFilePath(filePath);
        this.setPackagedDirectoryPath(packagedDirectoryPath);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getPackagedDirectoryPath() {
        return this.packagedDirectoryPath;
    }

    public void setPackagedDirectoryPath(String directoryPath) {
        if ((directoryPath = directoryPath.replace('\\', '/')).length() > 0 && !directoryPath.endsWith("/")) {
            directoryPath = directoryPath + "/";
        }
        this.packagedDirectoryPath = directoryPath;
    }

    public PackagerPath getPath() {
        File entryFile = this.getFile();
        String directoryPath = this.getPackagedDirectoryPath();
        return new FilePackagerPath(directoryPath + entryFile.getName());
    }

    public File getFile() {
        return new File(this.getFilePath());
    }

    public byte[] getData(ClassLoader classLoader) throws PackagerEntryNotFoundException {
        File entryFile = this.getFile();
        if (!entryFile.exists()) {
            throw new PackagerEntryNotFoundException(entryFile.toString());
        }
        try {
            return PackagerFileEntry.read(entryFile);
        }
        catch (IOException ioe) {
            throw new UnexpectedPackagerException(ioe);
        }
    }

    public String getComment() {
        return null;
    }

    public String toString() {
        return "FileEntry: " + this.getPath();
    }

    public List getDependents(ClassLoader classLoader) {
        return null;
    }

    public List getPackagerEntries() {
        LinkedList<PackagerFileEntry> list = new LinkedList<PackagerFileEntry>();
        list.add(this);
        return list;
    }
}

