/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.engarde;

import com.tangosol.engarde.DebugStubManagerHookup;
import com.tangosol.engarde.StubManagerHookup;
import com.tangosol.engarde.StubRouter;
import com.tangosol.run.xml.SimpleParser;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.util.Base;
import com.tangosol.util.SimpleEnumerator;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class StubManager
extends Base {
    private static StubManager s_manager;
    private Map m_mapRouter = new HashMap();
    private StubManagerHookup m_hookup;

    private StubManager() {
        StubManager.azzert(s_manager == null);
        this.m_hookup = this.createHookup();
        this.m_hookup.registerManager(this);
    }

    static StubManager getInstance() {
        StubManager manager = s_manager;
        if (manager == null) {
            s_manager = manager = new StubManager();
        }
        return manager;
    }

    private StubManagerHookup createHookup() {
        StubManagerHookup hookup = null;
        try {
            InputStream stream = this.getClass().getResourceAsStream("/tangosol-engarde.xml");
            XmlDocument xml = new SimpleParser().parseXml(stream);
            String sClz = xml.findElement("stub-manager/hookup-class").getString();
            hookup = (StubManagerHookup)Class.forName(sClz).newInstance();
        }
        catch (NullPointerException e) {
            StubManager.out("StubManager: Missing or invalid descriptor \"tangosol-engarde.xml\"");
        }
        catch (Throwable e) {
            StubManager.out("StubManager: Failed to instantiate the specified hookup: " + e);
            StubManager.out(this.getClass());
        }
        if (hookup == null) {
            hookup = new DebugStubManagerHookup();
        }
        return hookup;
    }

    public static StubRouter register(String sResourceType, String sResourceId) {
        return StubManager.getInstance().ensureStubRouter(sResourceType, sResourceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateResources() {
        Object[] asId;
        Map map;
        Map map2 = map = this.m_mapRouter;
        synchronized (map2) {
            asId = map.keySet().toArray(new String[map.size()]);
        }
        return new SimpleEnumerator(asId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateRouters() {
        Object[] arouter;
        Map map;
        Map map2 = map = this.m_mapRouter;
        synchronized (map2) {
            arouter = map.values().toArray(new StubRouter[map.size()]);
        }
        return new SimpleEnumerator(arouter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubRouter getStubRouter(String sResourceId) {
        Map map;
        StubRouter router = null;
        Map map2 = map = this.m_mapRouter;
        synchronized (map2) {
            router = (StubRouter)map.get(sResourceId);
        }
        return router;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubRouter ensureStubRouter(String sResourceType, String sResourceId) {
        Map map;
        StubRouter router = null;
        boolean fRegister = false;
        StubManagerHookup hookup = this.m_hookup;
        Map map2 = map = this.m_mapRouter;
        synchronized (map2) {
            router = (StubRouter)map.get(sResourceId);
            if (router == null) {
                router = hookup.instantiateRouter(sResourceType);
                router.setResourceType(sResourceType);
                router.setResourceId(sResourceId);
                map.put(sResourceId, router);
                fRegister = true;
            } else if (!sResourceType.equals(router.getResourceType())) {
                throw new IllegalStateException("StubManager: Unable to register resource identity \"" + sResourceId + "\" as type \"" + sResourceType + "\" because it is already registered as type \"" + router.getResourceType() + '\"');
            }
        }
        if (fRegister) {
            hookup.registerRouter(router);
        }
        return router;
    }

    public void setActive(StubRouter router, boolean fActive) {
        router.setActive(fActive);
    }

    public void setUsesExtra(StubRouter router, boolean fUsesExtra) {
        router.setUsesExtra(fUsesExtra);
    }
}

