/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.engarde.websphere;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.IExtendedSecurity.Current;
import com.ibm.IExtendedSecurity._LoginHelper;
import com.ibm.ejs.oa.EJSORB;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import java.util.Arrays;
import javax.servlet.http.HttpSession;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.Security.Attribute;
import org.omg.Security.AttributeType;
import org.omg.Security.CredentialType;
import org.omg.Security.ExtensibleFamily;
import org.omg.Security.OpaqueHolder;
import org.omg.SecurityLevel2.Credentials;
import org.omg.SecurityLevel2.CredentialsHolder;

public abstract class SecurityHelper
extends Base {
    public static void ensureSecurityToken(HttpSession session, String sUser, byte[] abToken) {
        try {
            Object oCredentials = session.getAttribute("com.tangosol.engarde.credentials");
            if (oCredentials == null) {
                oCredentials = SecurityHelper.createCredentials(sUser, "password", "engarde", abToken);
                session.setAttribute("com.tangosol.engarde.credentials", oCredentials);
            }
            SecurityHelper.setCurrentInvocationCredentials((Credentials)oCredentials);
        }
        catch (Exception e) {
            throw SecurityHelper.ensureRuntimeException(e);
        }
    }

    public static byte[] getSecurityToken() {
        try {
            Credentials credentials = SecurityHelper.getCurrentInvocationCredentials();
            ExtensibleFamily familyOMG = new ExtensibleFamily(0, 1);
            AttributeType[] aType = new AttributeType[]{new AttributeType(familyOMG, 1), new AttributeType(familyOMG, 2)};
            Attribute[] aAttribute = credentials.get_attributes(aType);
            byte[] abPublic = aAttribute[0] == null ? null : aAttribute[0].value;
            byte[] abAccess = aAttribute[1] == null ? null : aAttribute[1].value;
            return Arrays.equals(abPublic, abAccess) ? null : abAccess;
        }
        catch (Exception e) {
            throw SecurityHelper.ensureRuntimeException(e);
        }
    }

    public static Credentials createCredentials(String sUser, String sPassword, String sRealm, byte[] abData) {
        if (sPassword == null) {
            sPassword = "";
        }
        if (sRealm == null) {
            sRealm = "";
        }
        try {
            Current currentSecurity = SecurityHelper.getSecurityCurrent();
            _LoginHelper loginHelper = currentSecurity.login_helper();
            Credentials credentials = loginHelper.request_login(sUser, sRealm, sPassword, new CredentialsHolder(), new OpaqueHolder());
            if (credentials == null) {
                throw new RuntimeException("SecurityHelperWebsphere: Failed to create credentials: user=" + sUser + ", realm=" + sRealm);
            }
            ExtensibleFamily familyOMG = new ExtensibleFamily(0, 1);
            Attribute[] aAttribute = new Attribute[]{new Attribute(new AttributeType(familyOMG, 2), null, abData)};
            try {
                ClassHelper.invoke(credentials, "set_attributes", new Object[]{aAttribute});
            }
            catch (Exception e) {
                throw new RuntimeException("SecurityHelperWebsphere: Unsupported credentials type: " + credentials.getClass().getName() + "\nreason=" + e);
            }
            return credentials;
        }
        catch (Exception e) {
            throw SecurityHelper.ensureRuntimeException(e);
        }
    }

    public static void setCurrentInvocationCredentials(Credentials credentials) {
        try {
            Current currentSecurity = SecurityHelper.getSecurityCurrent();
            currentSecurity.set_credentials(CredentialType.SecInvocationCredentials, credentials);
        }
        catch (Exception e) {
            throw SecurityHelper.ensureRuntimeException(e);
        }
    }

    public static Credentials getCurrentInvocationCredentials() {
        try {
            Current currentSecurity = SecurityHelper.getSecurityCurrent();
            return currentSecurity.get_credentials(CredentialType.SecInvocationCredentials);
        }
        catch (Exception e) {
            throw SecurityHelper.ensureRuntimeException(e);
        }
    }

    private static Current getSecurityCurrent() {
        Current currentSecurity;
        ORB orb = EJSORB.getORBInstance();
        if (orb == null) {
            throw new RuntimeException("SecurityHelperWebsphere: Cannot get ORB instance");
        }
        try {
            currentSecurity = (Current)orb.resolve_initial_references("SecurityCurrent");
        }
        catch (InvalidName e) {
            throw new RuntimeException((Object)((Object)e) + " - Failed to obtain \"SecurityCurrent\"" + ", make sure the global Websphere security is enabled");
        }
        if (currentSecurity == null) {
            throw new RuntimeException("SecurityHelperWebsphere: Cannot get SecurityCurrent service");
        }
        return currentSecurity;
    }
}

