/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.BinaryStore;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import java.io.File;
import java.util.Iterator;

public abstract class AbstractBinaryStore
extends Base
implements BinaryStore {
    private static File s_dirDefault;

    public abstract Binary load(Binary var1);

    public void store(Binary binKey, Binary binValue) {
        throw new UnsupportedOperationException();
    }

    public void erase(Binary binKey) {
        throw new UnsupportedOperationException();
    }

    public void eraseAll() {
        Iterator iter = this.keys();
        while (iter.hasNext()) {
            this.erase((Binary)iter.next());
        }
    }

    public Iterator keys() {
        throw new UnsupportedOperationException();
    }

    public static File getDefaultDirectory() {
        File dir = s_dirDefault;
        if (dir != null) {
            return dir;
        }
        String sDir = null;
        try {
            sDir = System.getProperty("java.io.tmpdir");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (sDir == null) {
            try {
                File fileTemp = File.createTempFile("temp", null, null);
                fileTemp.delete();
                dir = fileTemp.getParentFile();
            }
            catch (Exception e) {
                throw new IllegalStateException("Temporary directory (java.io.tmpdir property) undefined or inaccessible.");
            }
        } else {
            dir = new File(sDir);
            if (!dir.exists() || !dir.isDirectory()) {
                throw new IllegalStateException("Temporary directory (" + sDir + ") does not exist.");
            }
        }
        s_dirDefault = dir;
        return dir;
    }
}

