/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.AbstractReadBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import java.io.EOFException;
import java.io.IOException;

public abstract class AbstractByteArrayReadBuffer
extends AbstractReadBuffer {
    protected byte[] m_ab;
    protected int m_of;
    protected int m_cb;

    protected AbstractByteArrayReadBuffer() {
    }

    protected AbstractByteArrayReadBuffer(byte[] ab, int of, int cb) {
        this.m_ab = ab;
        this.resetRange(of, cb);
    }

    public void resetRange(int of, int cb) {
        byte[] ab = this.m_ab;
        if (of < 0 || cb < 0 || of + cb > ab.length) {
            throw new IndexOutOfBoundsException("of=" + of + ", cb=" + cb + ", ab.length=" + ab.length);
        }
        this.m_of = of;
        this.m_cb = cb;
    }

    public int length() {
        return this.m_cb;
    }

    public byte byteAt(int of) {
        if (of >= 0 && of < this.m_cb) {
            return this.m_ab[this.m_of + of];
        }
        throw new IndexOutOfBoundsException("of=" + of + ", length()=" + this.m_cb);
    }

    public void copyBytes(int ofBegin, int ofEnd, byte[] abDest, int ofDest) {
        if (ofBegin < 0 || ofEnd > this.m_cb || ofBegin > ofEnd) {
            throw new IndexOutOfBoundsException("ofBegin=" + ofBegin + ", ofEnd=" + ofEnd + ", Binary.length=" + this.m_cb);
        }
        System.arraycopy(this.m_ab, this.m_of + ofBegin, abDest, ofDest, ofEnd - ofBegin);
    }

    public byte[] toByteArray(int of, int cb) {
        byte[] abNew;
        int cbBuf = this.m_cb;
        if (of < 0 || cb < 0 || of + cb > cbBuf) {
            throw new IndexOutOfBoundsException("of=" + of + ", cb=" + cb + ", length()=" + cbBuf);
        }
        if (cb == 0) {
            return NO_BYTES;
        }
        byte[] ab = this.m_ab;
        if ((of += this.m_of) == 0 && cb == ab.length) {
            abNew = this.isByteArrayPrivate() ? (byte[])ab.clone() : ab;
        } else {
            abNew = new byte[cb];
            System.arraycopy(ab, of, abNew, 0, cb);
        }
        return abNew;
    }

    public Binary toBinary() {
        int cb = this.m_cb;
        return cb == 0 ? NO_BINARY : new Binary(this.m_ab, this.m_of, cb);
    }

    public Binary toBinary(int of, int cb) {
        int cbBuf = this.m_cb;
        if (of < 0 || cb < 0 || of + cb > cbBuf) {
            throw new IndexOutOfBoundsException("of=" + of + ", cb=" + cb + ", length()=" + cbBuf);
        }
        return cb == 0 ? NO_BINARY : new Binary(this.m_ab, this.m_of + of, cb);
    }

    protected ReadBuffer.BufferInput instantiateBufferInput() {
        return new ByteArrayBufferInput();
    }

    protected abstract boolean isByteArrayPrivate();

    public class ByteArrayBufferInput
    extends AbstractReadBuffer.AbstractBufferInput {
        public ByteArrayBufferInput() {
            super(AbstractByteArrayReadBuffer.this);
        }

        public int read() throws IOException {
            int cb;
            int of = this.getOffset();
            if (of < (cb = AbstractByteArrayReadBuffer.this.m_cb)) {
                this.setOffsetInternal(of + 1);
                return AbstractByteArrayReadBuffer.this.m_ab[AbstractByteArrayReadBuffer.this.m_of + of] & 0xFF;
            }
            return -1;
        }

        public int read(byte[] ab, int of, int cb) throws IOException {
            int cbRead;
            int cbDest = ab.length;
            if (of < 0 || cb < 0 || of + cb > cbDest) {
                throw new IndexOutOfBoundsException("ab.length=" + cbDest + ", of=" + of + ", cb=" + cb);
            }
            if (cb == 0) {
                return 0;
            }
            int ofIn = this.getOffset();
            int cbRem = AbstractByteArrayReadBuffer.this.m_cb - ofIn;
            int n = cbRead = cb > cbRem ? cbRem : cb;
            if (cbRead == 0) {
                return -1;
            }
            System.arraycopy(AbstractByteArrayReadBuffer.this.m_ab, AbstractByteArrayReadBuffer.this.m_of + ofIn, ab, of, cbRead);
            this.setOffsetInternal(ofIn + cbRead);
            return cbRead;
        }

        public byte readByte() throws IOException {
            int cb;
            int ofAdd = this.getOffset();
            if (ofAdd < (cb = AbstractByteArrayReadBuffer.this.m_cb)) {
                this.setOffsetInternal(ofAdd + 1);
                return AbstractByteArrayReadBuffer.this.m_ab[AbstractByteArrayReadBuffer.this.m_of + ofAdd];
            }
            throw new EOFException();
        }

        public int readUnsignedShort() throws IOException {
            int cb = AbstractByteArrayReadBuffer.this.m_cb;
            int ofAdd = this.getOffset();
            if (cb - ofAdd < 2) {
                this.setOffsetInternal(cb);
                throw new EOFException();
            }
            this.setOffsetInternal(ofAdd + 2);
            byte[] ab = AbstractByteArrayReadBuffer.this.m_ab;
            int of = AbstractByteArrayReadBuffer.this.m_of + ofAdd;
            return (ab[of] & 0xFF) << 8 | ab[of + 1] & 0xFF;
        }

        public int readInt() throws IOException {
            int cb = AbstractByteArrayReadBuffer.this.m_cb;
            int ofAdd = this.getOffset();
            if (cb - ofAdd < 4) {
                this.setOffsetInternal(cb);
                throw new EOFException();
            }
            this.setOffsetInternal(ofAdd + 4);
            byte[] ab = AbstractByteArrayReadBuffer.this.m_ab;
            int of = AbstractByteArrayReadBuffer.this.m_of + ofAdd;
            return ab[of] << 24 | (ab[of + 1] & 0xFF) << 16 | (ab[of + 2] & 0xFF) << 8 | ab[of + 3] & 0xFF;
        }

        public long readLong() throws IOException {
            int cb = AbstractByteArrayReadBuffer.this.m_cb;
            int ofAdd = this.getOffset();
            if (cb - ofAdd < 8) {
                this.setOffsetInternal(cb);
                throw new EOFException();
            }
            this.setOffsetInternal(ofAdd + 8);
            byte[] ab = AbstractByteArrayReadBuffer.this.m_ab;
            int of = AbstractByteArrayReadBuffer.this.m_of + ofAdd;
            long n1 = ab[of] << 24 | (ab[of + 1] & 0xFF) << 16 | (ab[of + 2] & 0xFF) << 8 | ab[of + 3] & 0xFF;
            long n2 = ab[of + 4] << 24 | (ab[of + 5] & 0xFF) << 16 | (ab[of + 6] & 0xFF) << 8 | ab[of + 7] & 0xFF;
            return n1 << 32 | n2 & 0xFFFFFFFFL;
        }

        public int readPackedInt() throws IOException {
            boolean fNeg;
            int cb;
            byte[] ab = AbstractByteArrayReadBuffer.this.m_ab;
            int ofRaw = AbstractByteArrayReadBuffer.this.m_of;
            int of = ofRaw + this.getOffset();
            if (of >= (cb = ofRaw + AbstractByteArrayReadBuffer.this.m_cb)) {
                throw new EOFException();
            }
            int b = ab[of++] & 0xFF;
            int n = b & 0x3F;
            int cBits = 6;
            boolean bl = fNeg = (b & 0x40) != 0;
            while ((b & 0x80) != 0) {
                if (of >= cb) {
                    throw new EOFException();
                }
                b = ab[of++] & 0xFF;
                n |= (b & 0x7F) << cBits;
                cBits += 7;
            }
            if (fNeg) {
                n ^= 0xFFFFFFFF;
            }
            this.setOffsetInternal(of - ofRaw);
            return n;
        }

        public long readPackedLong() throws IOException {
            boolean fNeg;
            int cb;
            byte[] ab = AbstractByteArrayReadBuffer.this.m_ab;
            int ofRaw = AbstractByteArrayReadBuffer.this.m_of;
            int of = ofRaw + this.getOffset();
            if (of >= (cb = ofRaw + AbstractByteArrayReadBuffer.this.m_cb)) {
                throw new EOFException();
            }
            int b = ab[of++] & 0xFF;
            long l = b & 0x3F;
            int cBits = 6;
            boolean bl = fNeg = (b & 0x40) != 0;
            while ((b & 0x80) != 0) {
                if (of >= cb) {
                    throw new EOFException();
                }
                b = ab[of++] & 0xFF;
                l |= (long)(b & 0x7F) << cBits;
                cBits += 7;
            }
            if (fNeg) {
                l ^= 0xFFFFFFFFFFFFFFFFL;
            }
            this.setOffsetInternal(of - ofRaw);
            return l;
        }

        protected String convertUTF(int of, int cb) throws IOException {
            return ExternalizableHelper.convertUTF(AbstractByteArrayReadBuffer.this.m_ab, AbstractByteArrayReadBuffer.this.m_of + of, cb, this.getCharBuf(cb));
        }
    }
}

