/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.ReadBuffer;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractReadBuffer
extends Base
implements ReadBuffer {
    public static final byte[] NO_BYTES = new byte[0];
    public static final Binary NO_BINARY = new Binary(NO_BYTES);
    static final int MIN_BUF = 64;

    public ReadBuffer.BufferInput getBufferInput() {
        return this.instantiateBufferInput();
    }

    public ReadBuffer getReadBuffer(int of, int cb) {
        this.checkBounds(of, cb);
        if (of == 0 && cb == this.length()) {
            return this;
        }
        return this.instantiateReadBuffer(of, cb);
    }

    public byte[] toByteArray() {
        return this.toByteArray(0, this.length());
    }

    public byte[] toByteArray(int of, int cb) {
        byte[] ab;
        this.checkBounds(of, cb);
        if (cb == 0) {
            ab = NO_BYTES;
        } else {
            ab = new byte[cb];
            this.copyBytes(of, of + cb, ab, 0);
        }
        return ab;
    }

    public Binary toBinary() {
        return this.toBinary(0, this.length());
    }

    public Binary toBinary(int of, int cb) {
        this.checkBounds(of, cb);
        BinaryWriteBuffer buf = new BinaryWriteBuffer(cb, cb);
        buf.write(0, this, of, cb);
        return buf.toBinary();
    }

    public boolean equals(Object o) {
        if (o instanceof ReadBuffer) {
            ReadBuffer that = (ReadBuffer)o;
            return this == that || this.toBinary().equals(that.toBinary());
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw AbstractReadBuffer.ensureRuntimeException(e);
        }
    }

    protected abstract ReadBuffer instantiateReadBuffer(int var1, int var2);

    protected ReadBuffer.BufferInput instantiateBufferInput() {
        return new AbstractBufferInput();
    }

    protected void checkBounds(int of, int cb) {
        if (of < 0 || cb < 0 || of + cb > this.length()) {
            throw new IndexOutOfBoundsException("of=" + of + ", cb=" + cb + ", length()=" + this.length());
        }
    }

    public class AbstractBufferInput
    extends InputStream
    implements ReadBuffer.BufferInput {
        private int m_of;
        private int m_ofMark;
        private transient char[] m_achBuf;

        public int read() throws IOException {
            try {
                int of = this.getOffset();
                int b = AbstractReadBuffer.this.byteAt(of) & 0xFF;
                this.setOffsetInternal(of + 1);
                return b;
            }
            catch (IndexOutOfBoundsException e) {
                return -1;
            }
        }

        public int read(byte[] ab) throws IOException {
            return this.read(ab, 0, ab.length);
        }

        public int read(byte[] ab, int of, int cb) throws IOException {
            int cbRead;
            int cbDest = ab.length;
            if (of < 0 || cb < 0 || of + cb > cbDest) {
                throw new IndexOutOfBoundsException("ab.length=" + cbDest + ", of=" + of + ", cb=" + cb);
            }
            if (cb == 0) {
                return 0;
            }
            int ofIn = this.getOffset();
            int cbRem = AbstractReadBuffer.this.length() - ofIn;
            int n = cbRead = cb > cbRem ? cbRem : cb;
            if (cbRead == 0) {
                return -1;
            }
            int ofEnd = ofIn + cbRead;
            AbstractReadBuffer.this.copyBytes(ofIn, ofEnd, ab, of);
            this.setOffsetInternal(ofEnd);
            return cbRead;
        }

        public long skip(long cb) throws IOException {
            int cbReq = cb > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)cb;
            return this.skipBytes(cbReq);
        }

        public int available() throws IOException {
            return AbstractReadBuffer.this.length() - this.getOffset();
        }

        public void close() throws IOException {
        }

        public void mark(int cbReadLimit) {
            this.setMarkInternal(this.getOffset());
        }

        public void reset() throws IOException {
            this.setOffsetInternal(this.getMarkInternal());
        }

        public boolean markSupported() {
            return true;
        }

        public void readFully(byte[] ab) throws IOException {
            this.readFully(ab, 0, ab.length);
        }

        public void readFully(byte[] ab, int of, int cb) throws IOException {
            int cbRead = this.read(ab, of, cb);
            if (cbRead < cb) {
                throw new EOFException("requested=" + cb + ", read=" + cbRead);
            }
        }

        public int skipBytes(int cb) throws IOException {
            int of = this.getOffset();
            int cbRem = AbstractReadBuffer.this.length() - of;
            int cbSkip = cb > cbRem ? cbRem : cb;
            this.setOffsetInternal(of + cbSkip);
            return cbSkip;
        }

        public boolean readBoolean() throws IOException {
            return this.readByte() != 0;
        }

        public byte readByte() throws IOException {
            try {
                int of = this.getOffset();
                byte b = AbstractReadBuffer.this.byteAt(of);
                this.setOffsetInternal(of + 1);
                return b;
            }
            catch (IndexOutOfBoundsException e) {
                throw new EOFException(e.getMessage());
            }
        }

        public int readUnsignedByte() throws IOException {
            return this.readByte() & 0xFF;
        }

        public short readShort() throws IOException {
            return (short)this.readUnsignedShort();
        }

        public int readUnsignedShort() throws IOException {
            return this.readUnsignedByte() << 8 | this.readUnsignedByte();
        }

        public char readChar() throws IOException {
            return (char)this.readUnsignedShort();
        }

        public int readInt() throws IOException {
            return this.readUnsignedByte() << 24 | this.readUnsignedByte() << 16 | this.readUnsignedByte() << 8 | this.readUnsignedByte();
        }

        public long readLong() throws IOException {
            return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
        }

        public float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readInt());
        }

        public double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readLong());
        }

        public String readLine() throws IOException {
            return new DataInputStream(this).readLine();
        }

        public String readUTF() throws IOException {
            return this.readUTF(this.readUnsignedShort());
        }

        public ReadBuffer getBuffer() {
            return AbstractReadBuffer.this;
        }

        public String readSafeUTF() throws IOException {
            return this.readUTF(this.readPackedInt());
        }

        public int readPackedInt() throws IOException {
            boolean fNeg;
            int b = this.readUnsignedByte();
            int n = b & 0x3F;
            int cBits = 6;
            boolean bl = fNeg = (b & 0x40) != 0;
            while ((b & 0x80) != 0) {
                b = this.readUnsignedByte();
                n |= (b & 0x7F) << cBits;
                cBits += 7;
            }
            if (fNeg) {
                n ^= 0xFFFFFFFF;
            }
            return n;
        }

        public long readPackedLong() throws IOException {
            boolean fNeg;
            int b = this.readUnsignedByte();
            long l = b & 0x3F;
            int cBits = 6;
            boolean bl = fNeg = (b & 0x40) != 0;
            while ((b & 0x80) != 0) {
                b = this.readUnsignedByte();
                l |= (long)(b & 0x7F) << cBits;
                cBits += 7;
            }
            if (fNeg) {
                l ^= 0xFFFFFFFFFFFFFFFFL;
            }
            return l;
        }

        public ReadBuffer readBuffer(int cb) throws IOException {
            ReadBuffer buf;
            if (cb < 0) {
                throw new IllegalArgumentException("cb=" + cb);
            }
            int of = this.getOffset();
            try {
                buf = AbstractReadBuffer.this.getReadBuffer(of, cb);
            }
            catch (IndexOutOfBoundsException e) {
                this.setOffsetInternal(AbstractReadBuffer.this.length());
                throw new EOFException(e.getMessage());
            }
            this.setOffsetInternal(of + cb);
            return buf;
        }

        public int getOffset() {
            return this.m_of;
        }

        public void setOffset(int of) {
            if (of < 0 && of > AbstractReadBuffer.this.length()) {
                throw new IndexOutOfBoundsException("of=" + of + ", getBuffer().length()=" + AbstractReadBuffer.this.length());
            }
            this.setOffsetInternal(of);
        }

        protected void setOffsetInternal(int of) {
            this.m_of = of;
        }

        protected int getMarkInternal() {
            return this.m_ofMark;
        }

        protected void setMarkInternal(int of) {
            this.m_ofMark = of;
        }

        protected char[] getCharBuf(int cchMax) {
            char[] ach = this.m_achBuf;
            if (ach == null || ach.length < cchMax) {
                this.m_achBuf = ach = new char[Math.max(64, cchMax)];
            }
            return ach;
        }

        protected String readUTF(int cb) throws IOException {
            int cbBuf;
            if (cb < 0) {
                return null;
            }
            if (cb == 0) {
                return "";
            }
            int of = this.getOffset();
            if (of + cb > (cbBuf = AbstractReadBuffer.this.length())) {
                this.setOffsetInternal(cbBuf);
                throw new EOFException();
            }
            this.setOffsetInternal(of + cb);
            return this.convertUTF(of, cb);
        }

        protected String convertUTF(int of, int cb) throws IOException {
            return ExternalizableHelper.convertUTF(AbstractReadBuffer.this.toByteArray(of, cb), 0, cb, this.getCharBuf(cb));
        }
    }
}

