/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.AbstractByteArrayReadBuffer;
import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.DelegatingWriteBuffer;
import com.tangosol.io.InputStreaming;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.Binary;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;

public abstract class AbstractWriteBuffer
implements WriteBuffer {
    public static final byte[] NO_BYTES = AbstractByteArrayReadBuffer.NO_BYTES;
    public static final Binary NO_BINARY = AbstractByteArrayReadBuffer.NO_BINARY;
    private static final int MIN_BUF = 64;
    protected static final int CHAR_BUF_SIZE = 256;
    protected static final int CHAR_BUF_MASK = 255;
    private transient byte[] m_abBuf;
    protected transient char[] m_achBuf;

    public abstract void write(int var1, byte var2);

    public void write(int ofDest, byte[] abSrc) {
        this.write(ofDest, abSrc, 0, abSrc.length);
    }

    public abstract void write(int var1, byte[] var2, int var3, int var4);

    public void write(int ofDest, ReadBuffer bufSrc) {
        this.write(ofDest, bufSrc, 0, bufSrc.length());
    }

    public void write(int ofDest, ReadBuffer bufSrc, int ofSrc, int cbSrc) {
        this.write(ofDest, bufSrc.toByteArray(ofSrc, cbSrc), 0, cbSrc);
    }

    public void write(int ofDest, InputStreaming stream) throws IOException {
        this.copyStream(ofDest, stream, this.getMaximumCapacity() - ofDest);
    }

    public void write(int ofDest, InputStreaming stream, int cbSrc) throws IOException {
        int cbActual;
        if (stream instanceof ReadBuffer.BufferInput) {
            ReadBuffer.BufferInput in = (ReadBuffer.BufferInput)stream;
            try {
                this.write(ofDest, in.getBuffer(), in.getOffset(), cbSrc);
            }
            catch (IndexOutOfBoundsException e) {
                throw new EOFException(e.getMessage());
            }
            return;
        }
        byte[] ab = this.tmpbuf(cbSrc);
        for (int cb = 0; cb < cbSrc; cb += cbActual) {
            cbActual = stream.read(ab, cb, cbSrc - cb);
            if (cbActual >= 0) continue;
            throw new EOFException("requested to read " + cbSrc + " bytes but only " + cb + " bytes were available");
        }
        this.write(ofDest, ab, 0, cbSrc);
    }

    public abstract int length();

    public void retain(int of) {
        this.retain(of, this.length() - of);
    }

    public abstract void retain(int var1, int var2);

    public void clear() {
        this.retain(0, 0);
    }

    public abstract int getCapacity();

    public int getMaximumCapacity() {
        return this.getCapacity();
    }

    public WriteBuffer getWriteBuffer(int of) {
        return this.getWriteBuffer(of, this.getMaximumCapacity() - of);
    }

    public WriteBuffer getWriteBuffer(int of, int cb) {
        if (of < 0 || cb < 0 || of + cb > this.getMaximumCapacity()) {
            throw new IndexOutOfBoundsException("of=" + of + ", cb=" + cb + ", max=" + this.getMaximumCapacity());
        }
        return new DelegatingWriteBuffer(this, of, cb);
    }

    public WriteBuffer.BufferOutput getBufferOutput() {
        return this.getBufferOutput(0);
    }

    public WriteBuffer.BufferOutput getBufferOutput(int of) {
        return new AbstractBufferOutput(of);
    }

    public WriteBuffer.BufferOutput getAppendingBufferOutput() {
        return this.getBufferOutput(this.length());
    }

    public ReadBuffer getReadBuffer() {
        return new ByteArrayReadBuffer(this.getUnsafeReadBuffer().toByteArray());
    }

    public abstract ReadBuffer getUnsafeReadBuffer();

    public byte[] toByteArray() {
        return this.getUnsafeReadBuffer().toByteArray();
    }

    public Binary toBinary() {
        return this.getUnsafeReadBuffer().toBinary();
    }

    public Object clone() {
        ByteArrayWriteBuffer buf = new ByteArrayWriteBuffer(this.getCapacity(), this.getMaximumCapacity());
        if (this.length() > 0) {
            buf.write(0, this.getUnsafeReadBuffer());
        }
        return buf;
    }

    protected int copyStream(int ofDest, InputStreaming stream, int cbLimit) throws IOException {
        int ofOrig;
        block11: {
            int b;
            byte[] abAvail;
            int cbActual;
            if (stream instanceof ReadBuffer.BufferInput) {
                ReadBuffer.BufferInput in = (ReadBuffer.BufferInput)stream;
                int cb = in.available();
                try {
                    this.write(ofDest, in.getBuffer(), in.getOffset(), Math.min(cb, cbLimit));
                }
                catch (IndexOutOfBoundsException e) {
                    throw new IOException("IndexOutOfBoundsException: " + e.getMessage());
                }
                if (cb > cbLimit) {
                    throw new IOException("Overflow: attempted to write " + cb + " bytes, but limited to " + cbLimit + " bytes");
                }
                return cb;
            }
            ofOrig = ofDest;
            int cbRemain = cbLimit;
            int cbAvail = stream.available();
            if (cbAvail > 0 && (cbActual = stream.read(abAvail = this.tmpbuf(cbAvail), 0, cbAvail)) > 0) {
                this.write(ofDest, abAvail, 0, Math.min(cbActual, cbRemain));
                ofDest += cbActual;
                if ((cbRemain -= cbActual) < 0) {
                    throw new IOException("Overflow: attempted to copy " + cbActual + " available bytes, but limited to " + cbLimit + " bytes");
                }
            }
            if ((b = stream.read()) < 0) break block11;
            if (cbRemain > 0) {
                this.write(ofDest, (byte)b);
            }
            ++ofDest;
            if (--cbRemain < 0) {
                throw new IOException("Overflow: attempted to copy at least " + (ofDest - ofOrig) + " bytes, but limited to " + cbLimit + " bytes");
            }
            byte[] abBlock = this.tmpbuf(1024);
            int cbBlock = abBlock.length;
            try {
                int cbActual2;
                while ((cbActual2 = stream.read(abBlock, 0, cbBlock)) >= 0) {
                    if (cbActual2 <= 0) continue;
                    this.write(ofDest, abBlock, 0, Math.min(cbActual2, cbRemain));
                    ofDest += cbActual2;
                    if ((cbRemain -= cbActual2) >= 0) continue;
                    throw new IOException("Overflow: attempted to copy at least " + (ofDest - ofOrig) + " bytes, but limited to " + cbLimit + " bytes");
                }
            }
            catch (EOFException e) {}
        }
        return ofDest - ofOrig;
    }

    protected byte[] tmpbuf() {
        byte[] ab = this.m_abBuf;
        if (ab == null) {
            this.m_abBuf = ab = new byte[64];
        }
        return ab;
    }

    protected byte[] tmpbuf(int cb) {
        byte[] ab = this.m_abBuf;
        if (ab == null || ab.length < cb) {
            this.m_abBuf = ab = new byte[Math.max(64, cb)];
        }
        return ab;
    }

    public class AbstractBufferOutput
    implements WriteBuffer.BufferOutput {
        protected int m_ofWrite;

        public AbstractBufferOutput() {
        }

        public AbstractBufferOutput(int of) {
            this.setOffset(of);
        }

        public void write(int b) throws IOException {
            int ofWrite = this.m_ofWrite;
            AbstractWriteBuffer.this.write(ofWrite, (byte)b);
            this.m_ofWrite = ofWrite + 1;
        }

        public void write(byte[] ab) throws IOException {
            int ofWrite = this.m_ofWrite;
            AbstractWriteBuffer.this.write(ofWrite, ab);
            this.m_ofWrite = ofWrite + ab.length;
        }

        public void write(byte[] ab, int of, int cb) throws IOException {
            int ofWrite = this.m_ofWrite;
            AbstractWriteBuffer.this.write(ofWrite, ab, of, cb);
            this.m_ofWrite = ofWrite + cb;
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }

        public void writeBoolean(boolean f) throws IOException {
            this.write(f ? 1 : 0);
        }

        public void writeByte(int b) throws IOException {
            this.write(b);
        }

        public void writeShort(int n) throws IOException {
            byte[] ab = AbstractWriteBuffer.this.tmpbuf();
            ab[0] = (byte)(n >>> 8);
            ab[1] = (byte)n;
            this.write(ab, 0, 2);
        }

        public void writeChar(int ch) throws IOException {
            this.writeShort(ch);
        }

        public void writeInt(int n) throws IOException {
            byte[] ab = AbstractWriteBuffer.this.tmpbuf();
            ab[0] = (byte)(n >>> 24);
            ab[1] = (byte)(n >>> 16);
            ab[2] = (byte)(n >>> 8);
            ab[3] = (byte)n;
            this.write(ab, 0, 4);
        }

        public void writeLong(long l) throws IOException {
            byte[] ab = AbstractWriteBuffer.this.tmpbuf();
            int n = (int)(l >>> 32);
            ab[0] = (byte)(n >>> 24);
            ab[1] = (byte)(n >>> 16);
            ab[2] = (byte)(n >>> 8);
            ab[3] = (byte)n;
            n = (int)l;
            ab[4] = (byte)(n >>> 24);
            ab[5] = (byte)(n >>> 16);
            ab[6] = (byte)(n >>> 8);
            ab[7] = (byte)n;
            this.write(ab, 0, 8);
        }

        public void writeFloat(float fl) throws IOException {
            this.writeInt(Float.floatToIntBits(fl));
        }

        public void writeDouble(double dfl) throws IOException {
            this.writeLong(Double.doubleToLongBits(dfl));
        }

        public void writeBytes(String s) throws IOException {
            int cb = s.length();
            byte[] ab = AbstractWriteBuffer.this.tmpbuf(cb);
            s.getBytes(0, cb, ab, 0);
            this.write(ab, 0, cb);
        }

        public void writeChars(String s) throws IOException {
            char[] ach = s.toCharArray();
            int cch = ach.length;
            int cb = cch << 1;
            byte[] ab = AbstractWriteBuffer.this.tmpbuf(cb);
            int ofb = 0;
            for (int ofch = 0; ofch < cch; ++ofch) {
                char ch = ach[ofch];
                ab[ofb++] = (byte)(ch >>> 8);
                ab[ofb++] = (byte)ch;
            }
            this.write(ab, 0, cb);
        }

        public void writeUTF(String s) throws IOException {
            if (s.length() == 0) {
                this.writeShort(0);
            } else {
                int cb = this.calcUTF(s);
                if (cb > 65535) {
                    throw new UTFDataFormatException("UTF binary length=" + cb + ", max=65535");
                }
                byte[] ab = AbstractWriteBuffer.this.tmpbuf(2 + cb);
                ab[0] = (byte)(cb >>> 8);
                ab[1] = (byte)cb;
                this.formatUTF(ab, 2, cb, s);
                this.write(ab, 0, 2 + cb);
            }
        }

        public WriteBuffer getBuffer() {
            return AbstractWriteBuffer.this;
        }

        public void writeSafeUTF(String s) throws IOException {
            if (s == null) {
                this.writePackedInt(-1);
            } else if (s.length() == 0) {
                this.writePackedInt(0);
            } else {
                int cb = this.calcUTF(s);
                this.writePackedInt(cb);
                byte[] ab = AbstractWriteBuffer.this.tmpbuf(cb);
                this.formatUTF(ab, 0, cb, s);
                this.write(ab, 0, cb);
            }
        }

        public void writePackedInt(int n) throws IOException {
            byte[] ab = AbstractWriteBuffer.this.tmpbuf();
            int cb = 0;
            int b = 0;
            if (n < 0) {
                b = 64;
                n ^= 0xFFFFFFFF;
            }
            b |= (byte)(n & 0x3F);
            n >>>= 6;
            while (n != 0) {
                ab[cb++] = (byte)(b |= 0x80);
                b = n & 0x7F;
                n >>>= 7;
            }
            if (cb == 0) {
                this.write(b);
            } else {
                ab[cb++] = (byte)b;
                this.write(ab, 0, cb);
            }
        }

        public void writePackedLong(long l) throws IOException {
            byte[] ab = AbstractWriteBuffer.this.tmpbuf();
            int cb = 0;
            int b = 0;
            if (l < 0L) {
                b = 64;
                l ^= 0xFFFFFFFFFFFFFFFFL;
            }
            b |= (byte)((int)l & 0x3F);
            l >>>= 6;
            while (l != 0L) {
                ab[cb++] = (byte)(b |= 0x80);
                b = (int)l & 0x7F;
                l >>>= 7;
            }
            if (cb == 0) {
                this.write(b);
            } else {
                ab[cb++] = (byte)b;
                this.write(ab, 0, cb);
            }
        }

        public void writeBuffer(ReadBuffer buf) throws IOException {
            int ofWrite = this.m_ofWrite;
            AbstractWriteBuffer.this.write(ofWrite, buf);
            this.m_ofWrite = ofWrite + buf.length();
        }

        public void writeBuffer(ReadBuffer buf, int of, int cb) throws IOException {
            int ofWrite = this.m_ofWrite;
            AbstractWriteBuffer.this.write(ofWrite, buf, of, cb);
            this.m_ofWrite = ofWrite + cb;
        }

        public void writeStream(InputStreaming stream) throws IOException {
            int ofWrite = this.m_ofWrite;
            int cb = AbstractWriteBuffer.this.copyStream(ofWrite, stream, AbstractWriteBuffer.this.getMaximumCapacity() - ofWrite);
            this.m_ofWrite = ofWrite + cb;
        }

        public void writeStream(InputStreaming stream, int cb) throws IOException {
            int ofWrite = this.m_ofWrite;
            AbstractWriteBuffer.this.write(ofWrite, stream, cb);
            this.m_ofWrite = ofWrite + cb;
        }

        public int getOffset() {
            return this.m_ofWrite;
        }

        public void setOffset(int of) {
            if (of < 0 || of > AbstractWriteBuffer.this.getMaximumCapacity()) {
                throw new IndexOutOfBoundsException("of=" + of + ", min=0, max=" + AbstractWriteBuffer.this.getMaximumCapacity());
            }
            this.m_ofWrite = of;
        }

        protected final char[] getCharBuf() {
            char[] ach = AbstractWriteBuffer.this.m_achBuf;
            if (ach == null) {
                AbstractWriteBuffer.this.m_achBuf = ach = new char[256];
            }
            return ach;
        }

        protected final int calcUTF(String s) {
            boolean fSmall;
            int cch;
            int cb = cch = s.length();
            char[] ach = this.getCharBuf();
            boolean bl = fSmall = cch <= 256;
            if (fSmall) {
                s.getChars(0, cch, ach, 0);
            }
            for (int ofch = 0; ofch < cch; ++ofch) {
                char ch;
                if (fSmall) {
                    ch = ach[ofch];
                } else {
                    int ofBuf = ofch & 0xFF;
                    if (ofBuf == 0) {
                        s.getChars(ofch, Math.min(ofch + 256, cch), ach, 0);
                    }
                    ch = ach[ofBuf];
                }
                if (ch <= '\u007f') {
                    if (ch != '\u0000') continue;
                    ++cb;
                    continue;
                }
                cb += ch <= '\u07ff' ? 1 : 2;
            }
            return cb;
        }

        protected final void formatUTF(byte[] ab, int ofb, int cb, String s) {
            int cch = s.length();
            if (cb == cch) {
                s.getBytes(0, cch, ab, ofb);
            } else {
                char[] ach = this.getCharBuf();
                boolean fSmall = cch <= 256;
                for (int ofch = 0; ofch < cch; ++ofch) {
                    char ch;
                    if (fSmall) {
                        ch = ach[ofch];
                    } else {
                        int ofBuf = ofch & 0xFF;
                        if (ofBuf == 0) {
                            s.getChars(ofch, Math.min(ofch + 256, cch), ach, 0);
                        }
                        ch = ach[ofBuf];
                    }
                    if (ch >= '\u0001' && ch <= '\u007f') {
                        ab[ofb++] = (byte)ch;
                        continue;
                    }
                    if (ch <= '\u07ff') {
                        ab[ofb++] = (byte)(0xC0 | ch >>> 6 & 0x1F);
                        ab[ofb++] = (byte)(0x80 | ch & 0x3F);
                        continue;
                    }
                    ab[ofb++] = (byte)(0xE0 | ch >>> 12 & 0xF);
                    ab[ofb++] = (byte)(0x80 | ch >>> 6 & 0x3F);
                    ab[ofb++] = (byte)(0x80 | ch & 0x3F);
                }
            }
        }
    }
}

