/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.AbstractByteArrayReadBuffer;
import com.tangosol.io.ReadBuffer;

public class ByteArrayReadBuffer
extends AbstractByteArrayReadBuffer {
    private transient boolean m_fPrivate;
    private transient boolean m_fShallowClone;

    protected ByteArrayReadBuffer() {
    }

    public ByteArrayReadBuffer(byte[] ab) {
        this(ab, 0, ab.length);
    }

    public ByteArrayReadBuffer(byte[] ab, int of, int cb) {
        this(ab, of, cb, false, false, false);
    }

    public ByteArrayReadBuffer(byte[] ab, int of, int cb, boolean fCopy, boolean fPrivate, boolean fShallowClone) {
        super(fCopy ? (byte[])ab.clone() : ab, of, cb);
        this.m_fPrivate = fPrivate;
        this.m_fShallowClone = fShallowClone;
    }

    public byte[] getRawByteArray() {
        return this.isByteArrayPrivate() ? this.toByteArray() : this.m_ab;
    }

    public int getRawOffset() {
        return this.isByteArrayPrivate() ? 0 : this.m_of;
    }

    protected ReadBuffer instantiateReadBuffer(int of, int cb) {
        return new ByteArrayReadBuffer(this.m_ab, this.m_of + of, cb, false, this.isByteArrayPrivate(), this.isShallowCloneable());
    }

    public Object clone() {
        byte[] abNew;
        if (this.isShallowCloneable()) {
            return this;
        }
        byte[] ab = this.m_ab;
        int of = this.m_of;
        int cb = this.m_cb;
        if (of == 0 && cb == ab.length) {
            abNew = (byte[])ab.clone();
        } else {
            abNew = new byte[cb];
            System.arraycopy(ab, of, abNew, 0, cb);
        }
        boolean fPrivate = this.isByteArrayPrivate();
        return new ByteArrayReadBuffer(abNew, 0, cb, false, fPrivate, fPrivate);
    }

    public String toString() {
        return "ByteArrayReadBuffer(length=" + this.m_cb + ", value=" + ByteArrayReadBuffer.toHexEscape(this.m_ab, this.m_of, this.m_cb) + ')';
    }

    protected boolean isByteArrayPrivate() {
        return this.m_fPrivate;
    }

    protected boolean isShallowCloneable() {
        return this.m_fShallowClone;
    }

    void updateLength(int cb) {
        this.m_cb = cb;
    }
}

