/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.AbstractWriteBuffer;
import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.InputStreaming;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;

public class ByteArrayWriteBuffer
extends AbstractWriteBuffer {
    protected byte[] m_ab;
    protected int m_cb;
    protected int m_cbMax;
    protected transient ByteArrayReadBuffer m_bufUnsafe;
    private boolean m_fPrivate;

    protected ByteArrayWriteBuffer() {
    }

    public ByteArrayWriteBuffer(byte[] ab) {
        this.m_ab = ab;
        this.m_cbMax = ab.length;
    }

    public ByteArrayWriteBuffer(int cbCap) {
        this(cbCap, Integer.MAX_VALUE);
    }

    public ByteArrayWriteBuffer(int cbCap, int cbMax) {
        if (cbCap < 0 || cbMax < 0 || cbCap > cbMax) {
            throw new IllegalArgumentException();
        }
        this.m_ab = new byte[cbCap];
        this.m_cbMax = cbMax;
    }

    public void write(int ofDest, byte b) {
        this.checkBounds(ofDest, 1);
        this.m_ab[ofDest] = b;
        this.updateLength(ofDest + 1);
    }

    public void write(int ofDest, byte[] abSrc, int ofSrc, int cbSrc) {
        this.checkBounds(ofDest, cbSrc);
        System.arraycopy(abSrc, ofSrc, this.m_ab, ofDest, cbSrc);
        this.updateLength(ofDest + cbSrc);
    }

    public void write(int ofDest, ReadBuffer bufSrc, int ofSrc, int cbSrc) {
        this.checkBounds(ofDest, cbSrc);
        bufSrc.copyBytes(ofSrc, ofSrc + cbSrc, this.m_ab, ofDest);
        this.updateLength(ofDest + cbSrc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int ofDest, InputStreaming stream, int cbSrc) throws IOException {
        int cbRead;
        if (stream instanceof ReadBuffer.BufferInput) {
            ReadBuffer.BufferInput in = (ReadBuffer.BufferInput)stream;
            int cbMax = in.available();
            this.write(ofDest, in.getBuffer(), in.getOffset(), Math.min(cbSrc, cbMax));
            if (cbSrc > cbMax) {
                throw new EOFException("instructed to copy " + cbSrc + " bytes, but only " + cbMax + " were available");
            }
            return;
        }
        this.checkBounds(ofDest, cbSrc);
        try {
            int cbActual;
            for (cbRead = 0; cbRead < cbSrc; cbRead += cbActual) {
                cbActual = stream.read(this.m_ab, ofDest + cbRead, cbSrc - cbRead);
                if (cbActual >= 0) continue;
                throw new EOFException("instructed to copy " + cbSrc + " bytes, but only " + cbRead + " were available");
            }
        }
        finally {
            this.updateLength(ofDest + cbRead);
        }
    }

    public int length() {
        return this.m_cb;
    }

    public void retain(int of, int cb) {
        if (of < 0 || cb < 0 || of + cb > this.m_cb) {
            throw new IndexOutOfBoundsException("of=" + of + ", cb=" + cb + ", length()=" + this.m_cb);
        }
        if (of > 0 && cb > 0) {
            byte[] ab = this.m_ab;
            System.arraycopy(ab, of, ab, 0, cb);
        }
        this.m_cb = cb;
        this.m_bufUnsafe = null;
    }

    public int getCapacity() {
        return this.m_ab.length;
    }

    public int getMaximumCapacity() {
        return this.m_cbMax;
    }

    public WriteBuffer.BufferOutput getBufferOutput(int of) {
        return new ByteArrayBufferOutput(of);
    }

    public ReadBuffer getUnsafeReadBuffer() {
        ByteArrayReadBuffer buf = this.m_bufUnsafe;
        if (buf == null) {
            this.m_bufUnsafe = buf = new ByteArrayReadBuffer(this.m_ab, 0, this.m_cb, false, this.isByteArrayPrivate(), false);
        } else {
            buf.updateLength(this.m_cb);
        }
        return buf;
    }

    public boolean isByteArrayPrivate() {
        return this.m_fPrivate;
    }

    public void makeByteArrayPrivate() {
        this.m_fPrivate = true;
    }

    public byte[] getRawByteArray() {
        return this.isByteArrayPrivate() ? this.toByteArray() : this.m_ab;
    }

    protected int copyStream(int ofDest, InputStreaming stream, int cbLimit) throws IOException {
        if (stream instanceof ReadBuffer.BufferInput) {
            ReadBuffer.BufferInput in = (ReadBuffer.BufferInput)stream;
            int cbStream = in.available();
            int cbCopy = Math.min(cbStream, cbLimit);
            this.checkBounds(ofDest, cbCopy);
            this.write(ofDest, in.getBuffer(), in.getOffset(), cbCopy);
            if (cbStream > cbLimit) {
                throw new IOException("stream contained " + cbStream + " bytes, but copy was limited to " + cbLimit + " bytes");
            }
            return cbCopy;
        }
        int ofOrig = ofDest;
        int cbRemain = cbLimit;
        do {
            byte[] ab = this.m_ab;
            int cbCap = Math.min(ab.length, ofDest + cbRemain);
            while (ofDest < cbCap) {
                int cbActual;
                try {
                    cbActual = stream.read(ab, ofDest, cbCap - ofDest);
                }
                catch (EOFException e) {
                    cbActual = -1;
                }
                if (cbActual < 0) {
                    this.updateLength(ofDest);
                    return ofDest - ofOrig;
                }
                ofDest += cbActual;
                cbRemain -= cbActual;
            }
            if (cbRemain <= 0) continue;
            this.grow(ofDest);
        } while (ofDest < this.m_ab.length && cbRemain != 0 || stream.read() < 0);
        throw new IOException("buffer limit has been reached but the stream is not exhausted");
    }

    protected void checkBounds(int of, int cb) {
        int cbTotal = of + cb;
        if (of < 0 || cb < 0 || cbTotal > this.m_cbMax) {
            throw new IndexOutOfBoundsException("of=" + of + ", cb=" + cb + ", max=" + this.m_cbMax);
        }
        if (cbTotal > this.m_ab.length) {
            this.grow(cbTotal);
        }
    }

    protected void grow(int cbCap) {
        int cbOld;
        byte[] abOld = this.m_ab;
        int cbAdd = Math.max(1024, (cbOld = abOld.length) > 0x100000 ? cbOld >>> 1 : cbOld);
        int cbNew = (int)Math.min((long)this.m_cbMax, Math.max((long)cbCap + 1024L, (long)cbOld + (long)cbAdd));
        if (cbNew > cbOld) {
            byte[] abNew = new byte[cbNew];
            int cbData = this.m_cb;
            if (cbData > 0) {
                System.arraycopy(abOld, 0, abNew, 0, cbData);
            }
            this.m_ab = abNew;
            this.m_bufUnsafe = null;
        }
    }

    protected void updateLength(int cb) {
        if (cb > this.m_cb) {
            this.m_cb = cb;
        }
    }

    public class ByteArrayBufferOutput
    extends AbstractWriteBuffer.AbstractBufferOutput {
        public ByteArrayBufferOutput() {
        }

        public ByteArrayBufferOutput(int of) {
            super(of);
        }

        public void writeShort(int n) throws IOException {
            int of = this.m_ofWrite;
            ByteArrayWriteBuffer.this.checkBounds(of, 2);
            byte[] ab = ByteArrayWriteBuffer.this.m_ab;
            ab[of] = (byte)(n >>> 8);
            ab[of + 1] = (byte)n;
            this.moveOffset(2);
        }

        public void writeInt(int n) throws IOException {
            int of = this.m_ofWrite;
            ByteArrayWriteBuffer.this.checkBounds(of, 4);
            byte[] ab = ByteArrayWriteBuffer.this.m_ab;
            ab[of] = (byte)(n >>> 24);
            ab[of + 1] = (byte)(n >>> 16);
            ab[of + 2] = (byte)(n >>> 8);
            ab[of + 3] = (byte)n;
            this.moveOffset(4);
        }

        public void writeLong(long l) throws IOException {
            int of = this.m_ofWrite;
            ByteArrayWriteBuffer.this.checkBounds(of, 8);
            byte[] ab = ByteArrayWriteBuffer.this.m_ab;
            int n = (int)(l >>> 32);
            ab[of] = (byte)(n >>> 24);
            ab[of + 1] = (byte)(n >>> 16);
            ab[of + 2] = (byte)(n >>> 8);
            ab[of + 3] = (byte)n;
            n = (int)l;
            ab[of + 4] = (byte)(n >>> 24);
            ab[of + 5] = (byte)(n >>> 16);
            ab[of + 6] = (byte)(n >>> 8);
            ab[of + 7] = (byte)n;
            this.moveOffset(8);
        }

        public void writeBytes(String s) throws IOException {
            int of = this.m_ofWrite;
            int cb = s.length();
            ByteArrayWriteBuffer.this.checkBounds(of, cb);
            s.getBytes(0, cb, ByteArrayWriteBuffer.this.m_ab, of);
            this.moveOffset(cb);
        }

        public void writeChars(String s) throws IOException {
            char[] ach = s.toCharArray();
            int cch = ach.length;
            int of = this.m_ofWrite;
            int cb = cch << 1;
            ByteArrayWriteBuffer.this.checkBounds(of, cb);
            byte[] ab = ByteArrayWriteBuffer.this.m_ab;
            for (int ofch = 0; ofch < cch; ++ofch) {
                char ch = ach[ofch];
                ab[of++] = (byte)(ch >>> 8);
                ab[of++] = (byte)ch;
            }
            this.moveOffset(cb);
        }

        public void writeUTF(String s) throws IOException {
            if (s.length() == 0) {
                this.writeShort(0);
            } else {
                int cb = this.calcUTF(s);
                if (cb > 65535) {
                    throw new UTFDataFormatException("UTF binary length=" + cb + ", max=65535");
                }
                int ofb = this.m_ofWrite;
                ByteArrayWriteBuffer.this.checkBounds(ofb, 2 + cb);
                byte[] ab = ByteArrayWriteBuffer.this.m_ab;
                ab[ofb++] = (byte)(cb >>> 8);
                ab[ofb++] = (byte)cb;
                this.formatUTF(ab, ofb, cb, s);
                this.moveOffset(2 + cb);
            }
        }

        public void writeSafeUTF(String s) throws IOException {
            if (s == null) {
                this.writePackedInt(-1);
            } else if (s.length() == 0) {
                this.writePackedInt(0);
            } else {
                int cb = this.calcUTF(s);
                this.writePackedInt(cb);
                int ofb = this.m_ofWrite;
                ByteArrayWriteBuffer.this.checkBounds(ofb, cb);
                this.formatUTF(ByteArrayWriteBuffer.this.m_ab, ofb, cb, s);
                this.moveOffset(cb);
            }
        }

        public void writePackedInt(int n) throws IOException {
            int ofb = this.m_ofWrite;
            ByteArrayWriteBuffer.this.checkBounds(ofb, 5);
            byte[] ab = ByteArrayWriteBuffer.this.m_ab;
            int ofOrig = ofb;
            int b = 0;
            if (n < 0) {
                b = 64;
                n ^= 0xFFFFFFFF;
            }
            b |= (byte)(n & 0x3F);
            n >>>= 6;
            while (n != 0) {
                ab[ofb++] = (byte)(b |= 0x80);
                b = n & 0x7F;
                n >>>= 7;
            }
            ab[ofb++] = (byte)b;
            this.moveOffset(ofb - ofOrig);
        }

        public void writePackedLong(long l) throws IOException {
            int ofb = this.m_ofWrite;
            ByteArrayWriteBuffer.this.checkBounds(ofb, 10);
            byte[] ab = ByteArrayWriteBuffer.this.m_ab;
            int ofOrig = ofb;
            int b = 0;
            if (l < 0L) {
                b = 64;
                l ^= 0xFFFFFFFFFFFFFFFFL;
            }
            b |= (byte)((int)l & 0x3F);
            l >>>= 6;
            while (l != 0L) {
                ab[ofb++] = (byte)(b |= 0x80);
                b = (int)l & 0x7F;
                l >>>= 7;
            }
            ab[ofb++] = (byte)b;
            this.moveOffset(ofb - ofOrig);
        }

        protected void moveOffset(int cb) {
            int of;
            this.m_ofWrite = of = this.m_ofWrite + cb;
            ByteArrayWriteBuffer.this.updateLength(of);
        }
    }
}

