/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.AbstractReadBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.util.BitHelper;
import java.io.IOException;

public class MultiBufferReadBuffer
extends AbstractReadBuffer {
    private ReadBuffer[] m_abuf;
    private int[] m_aofBuffer;
    private int m_ofStart;
    private int m_ofEnd;
    private transient int m_ofLastOffset;
    private transient int m_iBufLastAnswer;
    static /* synthetic */ Class class$com$tangosol$io$MultiBufferReadBuffer;

    public MultiBufferReadBuffer(ReadBuffer[] abuf) {
        abuf = (ReadBuffer[])abuf.clone();
        int cBuffers = abuf.length;
        int[] aof = new int[cBuffers];
        int cb = 0;
        for (int i = 0; i < cBuffers; ++i) {
            aof[i] = cb;
            cb += abuf[i].length();
        }
        this.m_abuf = abuf;
        this.m_aofBuffer = aof;
        this.m_ofStart = 0;
        this.m_ofEnd = cb;
    }

    MultiBufferReadBuffer(ReadBuffer[] abuf, int[] aofBuffer, int ofStart, int ofEnd) {
        this.m_abuf = abuf;
        this.m_aofBuffer = aofBuffer;
        this.m_ofStart = ofStart;
        this.m_ofEnd = ofEnd;
    }

    public int length() {
        return this.m_ofEnd - this.m_ofStart;
    }

    public byte byteAt(int of) {
        this.checkBounds(of, 1);
        int iBuf = this.getBufferIndexByOffset(of);
        return this.getBuffer(iBuf).byteAt(of - this.getBufferOffset(iBuf));
    }

    public void copyBytes(int ofBegin, int ofEnd, byte[] abDest, int ofDest) {
        int cbDest = ofEnd - ofBegin;
        this.checkBounds(ofBegin, cbDest);
        if (ofDest < 0 || ofDest + cbDest > abDest.length) {
            throw new IndexOutOfBoundsException("ofDest=" + ofDest + ", abDest.length=" + abDest.length + ", bytes requested=" + cbDest);
        }
        int iBuf = this.getBufferIndexByOffset(ofBegin);
        ReadBuffer buf = this.getBuffer(iBuf);
        int ofBuf = this.getBufferOffset(iBuf);
        int ofSrc = ofBegin - ofBuf;
        int cbSrc = Math.min(cbDest, buf.length() - ofSrc);
        buf.copyBytes(ofSrc, ofSrc + cbSrc, abDest, ofDest);
        ofDest += cbSrc;
        cbDest -= cbSrc;
        while (cbDest > 0) {
            buf = this.getBuffer(++iBuf);
            cbSrc = Math.min(cbDest, buf.length());
            buf.copyBytes(0, cbSrc, abDest, ofDest);
            ofDest += cbSrc;
            cbDest -= cbSrc;
        }
    }

    protected ReadBuffer instantiateReadBuffer(int of, int cb) {
        int iBufFirst = this.getBufferIndexByOffset(of);
        int iBufLast = this.getBufferIndexByOffset(of + cb - 1);
        of -= this.getBufferOffset(iBufFirst);
        if (iBufFirst == iBufLast) {
            ReadBuffer buf = this.getBuffer(iBufFirst);
            return cb == buf.length() ? buf : buf.getReadBuffer(of, cb);
        }
        int cBuffers = iBufLast - iBufFirst + 1;
        ReadBuffer[] abuf = new ReadBuffer[cBuffers];
        int[] aof = new int[cBuffers];
        int cbTotal = 0;
        for (int i = 0; i < cBuffers; ++i) {
            ReadBuffer buf;
            abuf[i] = buf = this.getBuffer(iBufFirst + i);
            aof[i] = cbTotal;
            cbTotal += buf.length();
        }
        return new MultiBufferReadBuffer(abuf, aof, of, of + cb);
    }

    protected ReadBuffer.BufferInput instantiateBufferInput() {
        return new MultiBufferInput();
    }

    protected int getBufferCount() {
        return this.m_abuf.length;
    }

    protected int getBufferOffset(int iBuffer) {
        return this.m_aofBuffer[iBuffer] - this.m_ofStart;
    }

    protected ReadBuffer getBuffer(int iBuffer) {
        return this.m_abuf[iBuffer];
    }

    protected int getBufferIndexByOffset(int of) {
        int iBuf;
        int[] aof = this.m_aofBuffer;
        int cBuffers = aof.length;
        if (cBuffers == 1) {
            return 0;
        }
        if ((of += this.m_ofStart) >= this.m_ofLastOffset && ((iBuf = this.m_iBufLastAnswer) + 1 >= cBuffers || of < aof[iBuf + 1])) {
            return iBuf;
        }
        iBuf = 0;
        int iMSB = BitHelper.indexOfMSB(cBuffers);
        int iPos = (1 << iMSB) - 1;
        int cJmp = 1 << iMSB;
        do {
            int ofBuf;
            cJmp >>>= 1;
            int n = ofBuf = iPos >= cBuffers ? Integer.MAX_VALUE : aof[iPos];
            if (of == ofBuf) {
                iBuf = iPos;
                break;
            }
            if (of < ofBuf) {
                iPos -= cJmp;
                continue;
            }
            iBuf = iPos;
            iPos += cJmp;
        } while (cJmp > 0);
        this.m_ofLastOffset = of;
        this.m_iBufLastAnswer = iBuf;
        return iBuf;
    }

    public class MultiBufferInput
    extends AbstractReadBuffer.AbstractBufferInput {
        private ReadBuffer.BufferInput m_in;
        static final /* synthetic */ boolean $assertionsDisabled;

        public MultiBufferInput() {
            this.setOffset(0);
        }

        public int read() throws IOException {
            int b;
            ReadBuffer.BufferInput in = this.getIn();
            if (in.available() >= 1) {
                b = in.read();
                this.adjust(1);
            } else {
                b = super.read();
                this.sync();
            }
            return b;
        }

        public int read(byte[] ab, int of, int cb) throws IOException {
            int cbActual;
            ReadBuffer.BufferInput in = this.getIn();
            if (in.available() >= cb) {
                cbActual = in.read(ab, of, cb);
                if (!$assertionsDisabled && cbActual != cb) {
                    throw new AssertionError();
                }
                if (cbActual > 0) {
                    this.adjust(cbActual);
                }
            } else {
                cbActual = super.read(ab, of, cb);
                this.sync();
            }
            return cbActual;
        }

        public void reset() throws IOException {
            int of = this.getOffset();
            int ofMark = this.getMarkInternal();
            ReadBuffer.BufferInput in = this.getIn();
            if (of > ofMark) {
                int cbRewind = of - ofMark;
                int ofCurrent = in.getOffset();
                if (cbRewind < ofCurrent) {
                    in.setOffset(ofCurrent - cbRewind);
                    this.adjust(-cbRewind);
                    return;
                }
            } else {
                int cbForward = ofMark - of;
                if (cbForward < in.available()) {
                    in.setOffset(in.getOffset() + cbForward);
                    this.adjust(cbForward);
                    return;
                }
            }
            super.reset();
            this.sync();
        }

        public int skipBytes(int cb) throws IOException {
            int cbActual;
            ReadBuffer.BufferInput in = this.getIn();
            if (in.available() >= cb) {
                cbActual = in.skipBytes(cb);
                if (!$assertionsDisabled && cbActual != cb) {
                    throw new AssertionError();
                }
                if (cbActual > 0) {
                    this.adjust(cbActual);
                }
            } else {
                cbActual = super.skipBytes(cb);
                this.sync();
            }
            return cbActual;
        }

        public byte readByte() throws IOException {
            byte b;
            ReadBuffer.BufferInput in = this.getIn();
            if (in.available() >= 1) {
                b = in.readByte();
                this.adjust(1);
            } else {
                b = super.readByte();
                this.sync();
            }
            return b;
        }

        public short readShort() throws IOException {
            short n;
            ReadBuffer.BufferInput in = this.getIn();
            if (in.available() >= 2) {
                n = in.readShort();
                this.adjust(2);
            } else {
                n = super.readShort();
                this.sync();
            }
            return n;
        }

        public int readUnsignedShort() throws IOException {
            int n;
            ReadBuffer.BufferInput in = this.getIn();
            if (in.available() >= 2) {
                n = in.readUnsignedShort();
                this.adjust(2);
            } else {
                n = super.readUnsignedShort();
                this.sync();
            }
            return n;
        }

        public char readChar() throws IOException {
            char ch;
            ReadBuffer.BufferInput in = this.getIn();
            if (in.available() >= 2) {
                ch = in.readChar();
                this.adjust(2);
            } else {
                ch = super.readChar();
                this.sync();
            }
            return ch;
        }

        public int readInt() throws IOException {
            int n;
            ReadBuffer.BufferInput in = this.getIn();
            if (in.available() >= 4) {
                n = in.readInt();
                this.adjust(4);
            } else {
                n = super.readInt();
                this.sync();
            }
            return n;
        }

        public long readLong() throws IOException {
            long l;
            ReadBuffer.BufferInput in = this.getIn();
            if (in.available() >= 8) {
                l = in.readLong();
                this.adjust(8);
            } else {
                l = super.readLong();
                this.sync();
            }
            return l;
        }

        public float readFloat() throws IOException {
            float fl;
            ReadBuffer.BufferInput in = this.getIn();
            if (in.available() >= 4) {
                fl = in.readFloat();
                this.adjust(4);
            } else {
                fl = super.readFloat();
                this.sync();
            }
            return fl;
        }

        public double readDouble() throws IOException {
            double dfl;
            ReadBuffer.BufferInput in = this.getIn();
            if (in.available() >= 8) {
                dfl = in.readDouble();
                this.adjust(8);
            } else {
                dfl = super.readDouble();
                this.sync();
            }
            return dfl;
        }

        public String readUTF() throws IOException {
            int cbChars;
            ReadBuffer.BufferInput in = this.getIn();
            int cbAvail = in.available();
            if (cbAvail >= 2) {
                int ofBefore = in.getOffset();
                cbChars = in.readUnsignedShort();
                int cbTotal = 2 + cbChars;
                if (cbAvail >= cbTotal) {
                    in.setOffset(ofBefore);
                    String s = in.readUTF();
                    this.adjust(cbTotal);
                    return s;
                }
                this.adjust(2);
            } else {
                cbChars = this.readUnsignedShort();
            }
            String s = this.readUTF(cbChars);
            this.sync();
            return s;
        }

        public String readSafeUTF() throws IOException {
            int cbChars;
            ReadBuffer.BufferInput in = this.getIn();
            int cbAvail = in.available();
            if (cbAvail >= 5) {
                int ofBefore = in.getOffset();
                cbChars = in.readPackedInt();
                int cbLength = in.getOffset() - ofBefore;
                int cbTotal = cbLength + cbChars;
                if (cbChars > 0 && cbAvail >= cbTotal) {
                    in.setOffset(ofBefore);
                    String s = in.readSafeUTF();
                    this.adjust(cbTotal);
                    return s;
                }
                this.adjust(cbLength);
                if (cbChars < 0) {
                    return null;
                }
                if (cbChars == 0) {
                    return "";
                }
            } else {
                cbChars = this.readPackedInt();
            }
            String s = this.readUTF(cbChars);
            this.sync();
            return s;
        }

        public int readPackedInt() throws IOException {
            int n;
            ReadBuffer.BufferInput in = this.getIn();
            if (in.available() >= 5) {
                int of = in.getOffset();
                n = in.readPackedInt();
                this.adjust(in.getOffset() - of);
            } else {
                n = super.readPackedInt();
                this.sync();
            }
            return n;
        }

        public long readPackedLong() throws IOException {
            long l;
            ReadBuffer.BufferInput in = this.getIn();
            if (in.available() >= 10) {
                int of = in.getOffset();
                l = in.readPackedLong();
                this.adjust(in.getOffset() - of);
            } else {
                l = super.readPackedLong();
                this.sync();
            }
            return l;
        }

        public ReadBuffer readBuffer(int cb) throws IOException {
            ReadBuffer buf;
            ReadBuffer.BufferInput in = this.getIn();
            if (in.available() >= cb) {
                buf = in.readBuffer(cb);
                this.adjust(cb);
            } else {
                buf = super.readBuffer(cb);
                this.sync();
            }
            return buf;
        }

        public void setOffset(int of) {
            super.setOffset(of);
            this.sync();
        }

        protected ReadBuffer.BufferInput getIn() {
            return this.m_in;
        }

        protected void adjust(int cb) {
            this.setOffsetInternal(this.getOffset() + cb);
        }

        protected void sync() {
            MultiBufferReadBuffer bufMulti = MultiBufferReadBuffer.this;
            int of = this.getOffset();
            int iBuf = bufMulti.getBufferIndexByOffset(of);
            ReadBuffer buf = bufMulti.getBuffer(iBuf);
            of -= bufMulti.getBufferOffset(iBuf);
            ReadBuffer.BufferInput inPrev = this.m_in;
            if (inPrev != null && buf == inPrev.getBuffer()) {
                inPrev.setOffset(of);
            } else {
                ReadBuffer.BufferInput in = buf.getBufferInput();
                in.setOffset(of);
                this.m_in = in;
            }
        }

        static {
            $assertionsDisabled = !(class$com$tangosol$io$MultiBufferReadBuffer == null ? (class$com$tangosol$io$MultiBufferReadBuffer = MultiBufferReadBuffer.class$("com.tangosol.io.MultiBufferReadBuffer")) : class$com$tangosol$io$MultiBufferReadBuffer).desiredAssertionStatus();
        }
    }
}

