/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.AbstractWriteBuffer;
import com.tangosol.io.InputStreaming;
import com.tangosol.io.MultiBufferReadBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.BitHelper;
import java.io.IOException;

public class MultiBufferWriteBuffer
extends AbstractWriteBuffer {
    private static final byte[] FILL;
    private WriteBufferPool m_bufferpool;
    private WriteBuffer m_bufCurrent;
    private int m_ofCurrent;
    private int m_cBuffers;
    private WriteBuffer[] m_abuf;
    private int[] m_aofBuffer;
    private transient int m_ofLastOffset;
    private transient int m_iBufLastAnswer;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MultiBufferWriteBuffer(WriteBufferPool bufferpool) {
        this.m_bufferpool = bufferpool;
        this.advance();
    }

    public WriteBufferPool getBufferPool() {
        return this.m_bufferpool;
    }

    public int getBufferCount() {
        return this.m_cBuffers;
    }

    public int getBufferOffset(int iBuffer) {
        int cBuffers = this.getBufferCount();
        if (iBuffer < cBuffers) {
            return cBuffers == 1 ? this.m_ofCurrent : this.m_aofBuffer[iBuffer];
        }
        throw new IndexOutOfBoundsException("iBuffer=" + iBuffer + ", BufferCount=" + this.getBufferCount());
    }

    public WriteBuffer getBuffer(int iBuffer) {
        int cBuffers = this.getBufferCount();
        if (iBuffer < cBuffers) {
            return cBuffers == 1 ? this.m_bufCurrent : this.m_abuf[iBuffer];
        }
        throw new IndexOutOfBoundsException("iBuffer=" + iBuffer + ", BufferCount=" + this.getBufferCount());
    }

    public void write(int ofDest, byte b) {
        int cbTotal = this.length();
        if (ofDest == cbTotal) {
            WriteBuffer buf = this.getCurrentBuffer();
            int of = buf.length();
            if (of == buf.getCapacity()) {
                buf = this.advance();
                of = 0;
            }
            buf.write(of, b);
        } else if (ofDest < cbTotal) {
            int iBuf = this.getBufferIndexByOffset(ofDest);
            int ofBuf = this.getBufferOffset(iBuf);
            WriteBuffer buf = this.getBuffer(iBuf);
            buf.write(ofDest - ofBuf, b);
        } else {
            WriteBuffer buf = this.advanceTo(ofDest);
            buf.write(buf.length(), b);
        }
    }

    public void write(int ofDest, byte[] abSrc, int ofSrc, int cbSrc) {
        int cbTotal = this.length();
        if (ofDest != cbTotal) {
            if (ofDest < cbTotal) {
                int cbAppend = 0;
                int ofAppend = 0;
                int ofEnd = ofDest + cbSrc;
                if (ofEnd > cbTotal) {
                    cbAppend = ofEnd - cbTotal;
                    ofAppend = ofSrc + cbSrc - cbAppend;
                    cbSrc -= cbAppend;
                }
                int iBuf = this.getBufferIndexByOffset(ofDest);
                WriteBuffer buf = this.getBuffer(iBuf);
                int ofWrite = ofDest - this.getBufferOffset(iBuf);
                int cbWrite = Math.min(buf.length() - ofWrite, cbSrc);
                buf.write(ofWrite, abSrc, ofSrc, cbWrite);
                ofDest += cbWrite;
                ofSrc += cbWrite;
                cbSrc -= cbWrite;
                while (cbSrc > 0) {
                    buf = this.getBuffer(++iBuf);
                    cbWrite = Math.min(buf.length(), cbSrc);
                    buf.write(0, abSrc, ofSrc, cbWrite);
                    ofDest += cbWrite;
                    ofSrc += cbWrite;
                    cbSrc -= cbWrite;
                }
                if (cbAppend == 0) {
                    return;
                }
                ofSrc = ofAppend;
                cbSrc = cbAppend;
                if (!$assertionsDisabled && ofDest != cbTotal) {
                    throw new AssertionError();
                }
            } else {
                this.advanceTo(ofDest);
            }
        }
        WriteBuffer buf = this.getCurrentBuffer();
        int cbWrite = Math.min(cbSrc, this.getCurrentBufferRemaining());
        if (cbWrite > 0) {
            buf.write(buf.length(), abSrc, ofSrc, cbWrite);
            ofSrc += cbWrite;
            cbSrc -= cbWrite;
        }
        while (cbSrc > 0) {
            buf = this.advance();
            cbWrite = Math.min(cbSrc, buf.getCapacity());
            buf.write(0, abSrc, ofSrc, cbWrite);
            ofSrc += cbWrite;
            cbSrc -= cbWrite;
        }
    }

    public void write(int ofDest, ReadBuffer bufSrc, int ofSrc, int cbSrc) {
        int cbTotal = this.length();
        if (ofDest != cbTotal) {
            if (ofDest < cbTotal) {
                int cbAppend = 0;
                int ofAppend = 0;
                int ofEnd = ofDest + cbSrc;
                if (ofEnd > cbTotal) {
                    cbAppend = ofEnd - cbTotal;
                    ofAppend = ofSrc + cbSrc - cbAppend;
                    cbSrc -= cbAppend;
                }
                int iBuf = this.getBufferIndexByOffset(ofDest);
                WriteBuffer buf = this.getBuffer(iBuf);
                int ofWrite = ofDest - this.getBufferOffset(iBuf);
                int cbWrite = Math.min(buf.length() - ofWrite, cbSrc);
                buf.write(ofWrite, bufSrc, ofSrc, cbWrite);
                ofDest += cbWrite;
                ofSrc += cbWrite;
                cbSrc -= cbWrite;
                while (cbSrc > 0) {
                    buf = this.getBuffer(++iBuf);
                    cbWrite = Math.min(buf.length(), cbSrc);
                    buf.write(0, bufSrc, ofSrc, cbWrite);
                    ofDest += cbWrite;
                    ofSrc += cbWrite;
                    cbSrc -= cbWrite;
                }
                if (cbAppend == 0) {
                    return;
                }
                ofSrc = ofAppend;
                cbSrc = cbAppend;
                if (!$assertionsDisabled && ofDest != cbTotal) {
                    throw new AssertionError();
                }
            } else {
                this.advanceTo(ofDest);
            }
        }
        WriteBuffer buf = this.getCurrentBuffer();
        int cbWrite = Math.min(cbSrc, this.getCurrentBufferRemaining());
        if (cbWrite > 0) {
            buf.write(buf.length(), bufSrc, ofSrc, cbWrite);
            ofSrc += cbWrite;
            cbSrc -= cbWrite;
        }
        while (cbSrc > 0) {
            buf = this.advance();
            cbWrite = Math.min(cbSrc, buf.getCapacity());
            buf.write(0, bufSrc, ofSrc, cbWrite);
            ofSrc += cbWrite;
            cbSrc -= cbWrite;
        }
    }

    public int length() {
        return this.getCurrentBufferAbsoluteOffset() + this.getCurrentBuffer().length();
    }

    public void retain(int of, int cb) {
        int cBuffers = this.getBufferCount();
        if (cBuffers == 1) {
            this.getCurrentBuffer().retain(of, cb);
        } else {
            WriteBufferPool pool = this.getBufferPool();
            if (cb == 0) {
                WriteBuffer[] abuf = this.m_abuf;
                int[] aof = this.m_aofBuffer;
                WriteBuffer buf = abuf[0];
                buf.clear();
                this.m_bufCurrent = buf;
                this.m_ofCurrent = 0;
                this.m_cBuffers = 1;
                for (int i = 0; i < cBuffers; ++i) {
                    if (i > 0) {
                        pool.release(abuf[i]);
                    }
                    abuf[i] = null;
                    aof[i] = 0;
                }
            } else {
                ReadBuffer bufSrc = this.getUnsafeReadBuffer();
                WriteBuffer[] abuf = this.m_abuf;
                this.m_bufCurrent = null;
                this.m_ofCurrent = 0;
                this.m_cBuffers = 0;
                this.m_abuf = null;
                this.m_aofBuffer = null;
                this.advance();
                this.write(0, bufSrc, of, cb);
                for (int i = 0; i < cBuffers; ++i) {
                    pool.release(abuf[i]);
                }
            }
        }
    }

    public int getCapacity() {
        return this.getCurrentBufferAbsoluteOffset() + this.getCurrentBuffer().getCapacity();
    }

    public int getMaximumCapacity() {
        return this.getBufferPool().getMaximumCapacity();
    }

    public ReadBuffer getUnsafeReadBuffer() {
        int cBuffers = this.getBufferCount();
        if (cBuffers == 1) {
            return this.getBuffer(0).getUnsafeReadBuffer();
        }
        ReadBuffer[] abuf = new ReadBuffer[cBuffers];
        int[] aof = new int[cBuffers];
        for (int i = 0; i < cBuffers; ++i) {
            abuf[i] = this.getBuffer(i).getUnsafeReadBuffer();
            aof[i] = this.getBufferOffset(i);
        }
        return new MultiBufferReadBuffer(abuf, aof, 0, this.length());
    }

    public WriteBuffer.BufferOutput getBufferOutput(int of) {
        return new MultiBufferOutput(of);
    }

    public Object clone() {
        MultiBufferWriteBuffer that = new MultiBufferWriteBuffer(this.getBufferPool());
        if (this.length() > 0) {
            that.write(0, this.getUnsafeReadBuffer());
        }
        return that;
    }

    protected int getBufferIndexByOffset(int of) {
        int iBuf;
        int cBuffers = this.getBufferCount();
        if (cBuffers == 1) {
            return 0;
        }
        int[] aof = this.m_aofBuffer;
        if (of >= this.m_ofLastOffset && ((iBuf = this.m_iBufLastAnswer) + 1 >= cBuffers || of < aof[iBuf + 1])) {
            return iBuf;
        }
        iBuf = 0;
        int iMSB = BitHelper.indexOfMSB(cBuffers);
        int iPos = (1 << iMSB) - 1;
        int cJmp = 1 << iMSB;
        do {
            int ofBuf;
            cJmp >>>= 1;
            int n = ofBuf = iPos >= cBuffers ? Integer.MAX_VALUE : aof[iPos];
            if (of == ofBuf) {
                iBuf = iPos;
                break;
            }
            if (of < ofBuf) {
                iPos -= cJmp;
                continue;
            }
            iBuf = iPos;
            iPos += cJmp;
        } while (cJmp > 0);
        this.m_ofLastOffset = of;
        this.m_iBufLastAnswer = iBuf;
        return iBuf;
    }

    protected WriteBuffer advance() {
        WriteBuffer bufNew;
        WriteBufferPool bufferfactory = this.getBufferPool();
        int cBuffers = this.m_cBuffers;
        if (cBuffers == 0) {
            this.m_bufCurrent = bufNew = bufferfactory.allocate(0);
            this.m_cBuffers = 1;
        } else {
            int cElements;
            WriteBuffer buf = this.m_bufCurrent;
            int of = this.m_ofCurrent;
            WriteBuffer[] abuf = this.m_abuf;
            int[] aof = this.m_aofBuffer;
            int n = cElements = abuf == null ? 0 : abuf.length;
            if (cBuffers >= cElements) {
                int cNew = cElements + 16;
                WriteBuffer[] abufNew = new WriteBuffer[cNew];
                int[] aofNew = new int[cNew];
                if (abuf == null) {
                    abufNew[0] = this.m_bufCurrent;
                    aofNew[0] = this.m_ofCurrent;
                } else {
                    System.arraycopy(abuf, 0, abufNew, 0, cBuffers);
                    System.arraycopy(aof, 0, aofNew, 0, cBuffers);
                }
                abuf = abufNew;
                this.m_abuf = abufNew;
                aof = aofNew;
                this.m_aofBuffer = aofNew;
            }
            abuf[cBuffers] = bufNew = bufferfactory.allocate(of += buf.length());
            aof[cBuffers] = of;
            this.m_bufCurrent = bufNew;
            this.m_ofCurrent = of;
            this.m_cBuffers = ++cBuffers;
        }
        return bufNew;
    }

    protected WriteBuffer advanceTo(int of) {
        int cb = this.length();
        if (of <= cb) {
            throw new IllegalArgumentException("of=" + of + ", length()=" + cb);
        }
        byte[] abFill = FILL;
        int cbFill = abFill.length;
        while (cb < of) {
            int cbWrite = Math.min(of - cb, cbFill);
            this.write(cb, abFill, 0, cbWrite);
            cb += cbWrite;
        }
        if (this.getCurrentBufferRemaining() == 0) {
            this.advance();
        }
        return this.getCurrentBuffer();
    }

    protected WriteBuffer getCurrentBuffer() {
        return this.m_bufCurrent;
    }

    protected int getCurrentBufferAbsoluteOffset() {
        return this.m_ofCurrent;
    }

    protected int getCurrentBufferRemaining() {
        WriteBuffer buf = this.getCurrentBuffer();
        return buf.getCapacity() - buf.length();
    }

    static {
        $assertionsDisabled = !MultiBufferWriteBuffer.class.desiredAssertionStatus();
        FILL = new byte[1024];
    }

    public static interface WriteBufferPool {
        public int getMaximumCapacity();

        public WriteBuffer allocate(int var1);

        public void release(WriteBuffer var1);
    }

    public class MultiBufferOutput
    extends AbstractWriteBuffer.AbstractBufferOutput {
        private WriteBuffer.BufferOutput m_out;

        public MultiBufferOutput(int of) {
            this.setOffset(of);
        }

        public void write(int b) throws IOException {
            if (this.hasRemaining(1)) {
                this.getOut().write(b);
                this.adjust(1);
            } else {
                super.write(b);
                this.sync();
            }
        }

        public void write(byte[] ab) throws IOException {
            this.write(ab, 0, ab.length);
        }

        public void write(byte[] ab, int of, int cb) throws IOException {
            if (this.hasRemaining(cb)) {
                this.getOut().write(ab, of, cb);
                this.adjust(cb);
            } else {
                super.write(ab, of, cb);
                this.sync();
            }
        }

        public void writeShort(int n) throws IOException {
            if (this.hasRemaining(2)) {
                this.getOut().writeShort(n);
                this.adjust(2);
            } else {
                super.writeShort(n);
                this.sync();
            }
        }

        public void writeChar(int ch) throws IOException {
            if (this.hasRemaining(2)) {
                this.getOut().writeChar(ch);
                this.adjust(2);
            } else {
                super.writeChar(ch);
                this.sync();
            }
        }

        public void writeInt(int n) throws IOException {
            if (this.hasRemaining(4)) {
                this.getOut().writeInt(n);
                this.adjust(4);
            } else {
                super.writeInt(n);
                this.sync();
            }
        }

        public void writeLong(long l) throws IOException {
            if (this.hasRemaining(8)) {
                this.getOut().writeLong(l);
                this.adjust(8);
            } else {
                super.writeLong(l);
                this.sync();
            }
        }

        public void writeFloat(float fl) throws IOException {
            if (this.hasRemaining(4)) {
                this.getOut().writeFloat(fl);
                this.adjust(4);
            } else {
                super.writeFloat(fl);
                this.sync();
            }
        }

        public void writeDouble(double dfl) throws IOException {
            if (this.hasRemaining(8)) {
                this.getOut().writeDouble(dfl);
                this.adjust(8);
            } else {
                super.writeDouble(dfl);
                this.sync();
            }
        }

        public void writeBuffer(ReadBuffer buf) throws IOException {
            super.writeBuffer(buf);
            this.sync();
        }

        public void writeBuffer(ReadBuffer buf, int of, int cb) throws IOException {
            super.writeBuffer(buf, of, cb);
            this.sync();
        }

        public void writeStream(InputStreaming stream) throws IOException {
            super.writeStream(stream);
            this.sync();
        }

        public void writeStream(InputStreaming stream, int cb) throws IOException {
            super.writeStream(stream, cb);
            this.sync();
        }

        public void setOffset(int of) {
            super.setOffset(of);
            MultiBufferWriteBuffer bufMulti = MultiBufferWriteBuffer.this;
            if (of > bufMulti.length()) {
                bufMulti.advanceTo(of);
            }
            this.sync();
        }

        protected WriteBuffer.BufferOutput getOut() {
            return this.m_out;
        }

        protected boolean hasRemaining(int cb) {
            WriteBuffer.BufferOutput out = this.getOut();
            return out.getOffset() + cb <= out.getBuffer().getCapacity();
        }

        protected void adjust(int cb) {
            this.m_ofWrite += cb;
        }

        protected void sync() {
            MultiBufferWriteBuffer bufMulti = MultiBufferWriteBuffer.this;
            int of = this.getOffset();
            int iBuf = bufMulti.getBufferIndexByOffset(of);
            WriteBuffer buf = bufMulti.getBuffer(iBuf);
            of -= bufMulti.getBufferOffset(iBuf);
            WriteBuffer.BufferOutput outPrev = this.m_out;
            if (outPrev != null && buf == outPrev.getBuffer()) {
                outPrev.setOffset(of);
            } else {
                this.m_out = buf.getBufferOutput(of);
            }
        }
    }
}

