/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.InputStreaming;
import java.io.IOException;
import java.io.InputStream;

public class MultiByteArrayInputStream
extends InputStream
implements InputStreaming {
    protected static final byte[] EMPTY_BYTES = new byte[0];
    protected boolean m_fEOF;
    protected byte[][] m_aabArray;
    protected int m_iArray;
    protected byte[] m_ab;
    protected int m_of;
    protected int m_iArrayMarked;
    protected int m_ofMarked;

    public MultiByteArrayInputStream(byte[][] aab) {
        this.m_aabArray = aab;
        this.reset();
    }

    public int read() throws IOException {
        if (this.m_fEOF) {
            return -1;
        }
        byte[] ab = this.m_ab;
        int cb = ab.length;
        int of = this.m_of;
        int n = ab[of++] & 0xFF;
        if (of == cb) {
            int iab = this.m_iArray;
            byte[][] aab = this.m_aabArray;
            int cab = aab.length;
            if (iab == cab - 1) {
                this.m_fEOF = true;
            } else {
                this.m_iArray = ++iab;
                this.m_ab = aab[iab];
                this.m_of = 0;
            }
        } else {
            this.m_of = of;
        }
        return n;
    }

    public int read(byte[] abDest, int ofDest, int cbDest) throws IOException {
        if (this.m_fEOF) {
            return -1;
        }
        int cbRead = 0;
        while (true) {
            int of;
            byte[] ab;
            int cb;
            int cbLeft;
            if (cbDest < (cbLeft = (cb = (ab = this.m_ab).length) - (of = this.m_of))) {
                System.arraycopy(ab, of, abDest, ofDest, cbDest);
                this.m_of = of + cbDest;
                return cbRead += cbDest;
            }
            System.arraycopy(ab, of, abDest, ofDest, cbLeft);
            cbRead += cbLeft;
            byte[][] aab = this.m_aabArray;
            int cab = aab.length;
            int iab = this.m_iArray;
            if (iab == cab - 1) {
                this.m_of = ab.length;
                this.m_fEOF = true;
                return cbRead;
            }
            this.m_iArray = ++iab;
            this.m_ab = aab[iab];
            this.m_of = 0;
            ofDest += cbLeft;
            cbDest -= cbLeft;
        }
    }

    public int available() {
        if (this.m_fEOF) {
            return 0;
        }
        byte[][] aab = this.m_aabArray;
        int of = this.m_of;
        int cb = 0;
        int c = aab.length;
        for (int i = this.m_iArray; i < c; ++i) {
            cb += aab[i].length - of;
            of = 0;
        }
        return cb;
    }

    public long skip(long n) {
        if (n < 0L || n > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("out of bounds: skip(n=" + n + ")");
        }
        if (this.m_fEOF) {
            return 0L;
        }
        int cbSkip = (int)n;
        byte[] ab = this.m_ab;
        int cb = ab.length;
        int of = this.m_of;
        int cbLeft = cb - of;
        if (cbSkip < cbLeft) {
            this.m_of = of + cbSkip;
            return cbSkip;
        }
        int iab = this.m_iArray;
        byte[][] aab = this.m_aabArray;
        int cab = aab.length;
        if (iab == cab - 1 && cbSkip > cbLeft) {
            this.m_of = ab.length;
            this.m_fEOF = true;
            return cbLeft;
        }
        this.m_iArray = ++iab;
        this.m_ab = aab[iab];
        this.m_of = 0;
        return (long)cbLeft + this.skip(cbSkip - cbLeft);
    }

    public void close() {
    }

    public void mark(int readlimit) {
        this.m_iArrayMarked = this.m_iArray;
        this.m_ofMarked = this.m_of;
    }

    public void reset() {
        byte[][] aabArray = this.m_aabArray;
        this.m_iArray = this.m_iArrayMarked;
        this.m_of = this.m_ofMarked;
        this.m_ab = aabArray == null || aabArray.length == 0 ? EMPTY_BYTES : aabArray[this.m_iArray];
        this.m_fEOF = this.m_iArray >= aabArray.length - 1 && this.m_of == this.m_ab.length;
    }

    public boolean markSupported() {
        return true;
    }
}

