/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.OutputStreaming;
import com.tangosol.util.Base;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class MultiByteArrayOutputStream
extends OutputStream
implements OutputStreaming {
    protected byte[] m_ab;
    protected int m_of;
    protected int m_cbBlock;
    protected int m_cbPadFront;
    protected int m_cbPadBack;
    protected List m_listBlock = new ArrayList(1);
    protected boolean m_fClosed;

    public MultiByteArrayOutputStream(int cbBlock) {
        this(cbBlock, 0, 0);
    }

    public MultiByteArrayOutputStream(int cbBlock, int cbPadFront, int cbPadBack) {
        this.m_cbBlock = cbBlock;
        this.m_cbPadFront = cbPadFront;
        this.m_cbPadBack = cbPadBack;
    }

    public void write(int b) throws IOException {
        this.check();
        byte[] ab = this.m_ab;
        int cb = ab == null ? 0 : ab.length - this.m_cbPadBack;
        int of = this.m_of;
        if (of >= cb) {
            this.requestCapacity(1);
            ab = this.m_ab;
            of = this.m_of;
        }
        ab[of] = (byte)b;
        this.m_of = of + 1;
    }

    public void write(byte[] abSrc, int ofSrc, int cbSrc) throws IOException {
        this.check();
        byte[] ab = this.m_ab;
        int of = this.m_of;
        int cbBack = this.m_cbPadBack;
        while (cbSrc > 0) {
            int cb;
            int n = cb = ab == null ? 0 : ab.length - cbBack;
            if (of >= cb) {
                this.m_of = of;
                cb = this.requestCapacity(cbSrc);
                ab = this.m_ab;
                of = this.m_of;
            }
            int cbMax = cb - of;
            int cbActual = Math.min(cbSrc, cbMax);
            System.arraycopy(abSrc, ofSrc, ab, of, cbActual);
            of += cbActual;
            ofSrc += cbActual;
            cbSrc -= cbActual;
        }
        this.m_ab = ab;
        this.m_of = of;
    }

    public void flush() throws IOException {
        this.check();
        byte[] ab = this.m_ab;
        int of = this.m_of;
        int cbFront = this.m_cbPadFront;
        int cbBack = this.m_cbPadBack;
        if (ab != null && of > cbFront) {
            int cb = ab.length - cbBack;
            if (of < cb) {
                byte[] abNew = new byte[of + cbBack];
                System.arraycopy(ab, cbFront, abNew, cbFront, of - cbFront);
                ab = abNew;
            }
            this.m_listBlock.add(ab);
            this.m_ab = null;
            this.m_of = 0;
        }
    }

    public void close() throws IOException {
        if (!this.m_fClosed) {
            this.flush();
            this.m_fClosed = true;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int cBlocks = this.getBlockCount();
        sb.append("Results: ").append(cBlocks).append(" blocks:");
        for (int i = 0; i < cBlocks; ++i) {
            sb.append("\nBlock ").append(i).append(": ");
            byte[] ab = this.getBlock(i);
            sb.append(ab == null ? "null" : Base.toHexEscape(ab));
        }
        return sb.toString();
    }

    public int getBlockCount() {
        return this.m_listBlock.size();
    }

    public byte[] getBlock(int i) {
        return (byte[])this.m_listBlock.get(i);
    }

    public int getBlockDataSize() {
        return this.m_cbBlock;
    }

    public int getFrontPaddingSize() {
        return this.m_cbPadFront;
    }

    public int getBackPaddingSize() {
        return this.m_cbPadBack;
    }

    protected void check() throws IOException {
        if (this.m_fClosed) {
            throw new IOException("MultiByteArrayOutputStream is closed");
        }
    }

    protected int requestCapacity(int cbMore) {
        int cbMax = this.m_cbBlock;
        int cbFront = this.m_cbPadFront;
        int cbPad = this.m_cbPadBack + cbFront;
        byte[] abOld = this.m_ab;
        if (cbMore == 0) {
            return abOld == null ? 0 : abOld.length - cbPad;
        }
        if (abOld == null) {
            int cbNew = Math.min(cbMax, Math.max(cbMore, 1024));
            this.m_ab = new byte[cbNew + cbPad];
            this.m_of = cbFront;
            return cbNew;
        }
        int cbOld = abOld.length - cbPad;
        if (cbOld == cbMax) {
            this.m_listBlock.add(abOld);
            this.m_ab = new byte[cbMax + cbPad];
            this.m_of = cbFront;
            return cbMax;
        }
        int cbNew = Math.min(cbMax, cbOld + Math.max(cbOld, cbMore));
        byte[] abNew = new byte[cbNew + cbPad];
        System.arraycopy(abOld, cbFront, abNew, cbFront, cbOld);
        this.m_ab = abNew;
        return cbNew;
    }
}

