/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.WrapperInputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class PackedDataInputStream
extends WrapperInputStream
implements DataInput {
    static final int MAX_BUF = 32;
    private byte[] m_abBuf = new byte[32];

    public PackedDataInputStream(InputStream in) {
        super(in);
    }

    public void readFully(byte[] ab) throws IOException {
        this.readFully(ab, 0, ab.length);
    }

    public void readFully(byte[] ab, int of, int cb) throws IOException {
        if (of < 0 || cb < 0 || of + cb > ab.length) {
            throw new IndexOutOfBoundsException("ab.length=" + ab.length + ", of=" + of + ", cb=" + cb);
        }
        while (cb > 0) {
            int cbRead = this.read(ab, of, cb);
            if (cbRead < 0) {
                throw new EOFException(cb + " bytes remaining to be read");
            }
            of += cbRead;
            cb -= cbRead;
        }
    }

    public int skipBytes(int cb) throws IOException {
        return (int)this.skip(cb);
    }

    public boolean readBoolean() throws IOException {
        return this.readUnsignedByte() != 0;
    }

    public byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public short readShort() throws IOException {
        return (short)this.readInt();
    }

    public int readUnsignedShort() throws IOException {
        return this.readInt() & 0xFFFF;
    }

    public char readChar() throws IOException {
        int ch = this.readUnsignedByte();
        switch ((ch & 0xF0) >>> 4) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return (char)ch;
            }
            case 12: 
            case 13: {
                int ch2 = this.readUnsignedByte();
                if ((ch2 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                return (char)((ch & 0x1F) << 6 | ch2 & 0x3F);
            }
            case 14: {
                int ch2 = this.readUnsignedByte();
                int ch3 = this.readUnsignedByte();
                if ((ch2 & 0xC0) != 128 || (ch3 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                return (char)((ch & 0xF) << 12 | (ch2 & 0x3F) << 6 | ch3 & 0x3F);
            }
        }
        throw new UTFDataFormatException("illegal leading UTF byte: " + ch);
    }

    public int readInt() throws IOException {
        boolean fNeg;
        int b = this.readUnsignedByte();
        int n = b & 0x3F;
        int cBits = 6;
        boolean bl = fNeg = (b & 0x40) != 0;
        while ((b & 0x80) != 0) {
            b = this.readUnsignedByte();
            n |= (b & 0x7F) << cBits;
            cBits += 7;
        }
        if (fNeg) {
            n ^= 0xFFFFFFFF;
        }
        return n;
    }

    public long readLong() throws IOException {
        boolean fNeg;
        int b = this.readUnsignedByte();
        long l = b & 0x3F;
        int cBits = 6;
        boolean bl = fNeg = (b & 0x40) != 0;
        while ((b & 0x80) != 0) {
            b = this.readUnsignedByte();
            l |= (long)(b & 0x7F) << cBits;
            cBits += 7;
        }
        if (fNeg) {
            l ^= 0xFFFFFFFFFFFFFFFFL;
        }
        return l;
    }

    public float readFloat() throws IOException {
        byte[] ab = this.m_abBuf;
        this.readFully(ab, 0, 4);
        int n = ab[0] << 24 | (ab[1] & 0xFF) << 16 | (ab[2] & 0xFF) << 8 | ab[3] & 0xFF;
        return Float.intBitsToFloat(n);
    }

    public double readDouble() throws IOException {
        byte[] ab = this.m_abBuf;
        this.readFully(ab, 0, 8);
        int nMSB = ab[0] << 24 | (ab[1] & 0xFF) << 16 | (ab[2] & 0xFF) << 8 | ab[3] & 0xFF;
        int nLSB = ab[4] << 24 | (ab[5] & 0xFF) << 16 | (ab[6] & 0xFF) << 8 | ab[7] & 0xFF;
        long l = (long)nMSB << 32 | (long)nLSB & 0xFFFFFFFFL;
        return Double.longBitsToDouble(l);
    }

    public String readLine() throws IOException {
        throw new IOException("unsupported");
    }

    public String readUTF() throws IOException {
        int cch = this.readInt();
        if (cch == 0) {
            return "";
        }
        int cb = this.readInt();
        byte[] ab = cb <= 32 ? this.m_abBuf : new byte[cb];
        this.readFully(ab, 0, cb);
        char[] ach = new char[cch];
        int ofb = 0;
        block5: for (int of = 0; of < cch; ++of) {
            byte ch = ab[ofb++];
            switch ((ch & 0xF0) >>> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ach[of] = (char)ch;
                    continue block5;
                }
                case 12: 
                case 13: {
                    byte ch2 = ab[ofb++];
                    if ((ch2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    ach[of] = (char)((ch & 0x1F) << 6 | ch2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    byte ch2 = ab[ofb++];
                    byte ch3 = ab[ofb++];
                    if ((ch2 & 0xC0) != 128 || (ch3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    ach[of] = (char)((ch & 0xF) << 12 | (ch2 & 0x3F) << 6 | ch3 & 0x3F);
                    continue block5;
                }
                default: {
                    throw new UTFDataFormatException("illegal leading UTF byte: " + ch);
                }
            }
        }
        return new String(ach);
    }
}

