/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class Utf8Writer
extends Writer {
    private OutputStream m_stream;
    private transient char[] m_achBuf;
    private static final int MAX_BUF = 1024;

    public Utf8Writer() {
        this(new ByteArrayOutputStream());
    }

    public Utf8Writer(OutputStream stream) {
        this.m_stream = stream;
    }

    public void write(int ch) throws IOException {
        OutputStream stream = this.m_stream;
        if (ch >= 1 && ch <= 127) {
            stream.write(ch);
        } else if (ch <= 2047) {
            stream.write(0xC0 | ch >>> 6 & 0x1F);
            stream.write(0x80 | ch >>> 0 & 0x3F);
        } else {
            stream.write(0xE0 | ch >>> 12 & 0xF);
            stream.write(0x80 | ch >>> 6 & 0x3F);
            stream.write(0x80 | ch >>> 0 & 0x3F);
        }
    }

    public void write(char[] ach) throws IOException {
        int cch = ach.length;
        for (int of = 0; of < cch; ++of) {
            this.write(ach[of]);
        }
    }

    public void write(char[] ach, int of, int cch) throws IOException {
        int ofEnd = of + cch;
        while (of < ofEnd) {
            this.write(ach[of]);
            ++of;
        }
    }

    public void write(String s) throws IOException {
        int cch = s.length();
        if (cch <= 1024) {
            this.write(s, 0, cch);
        } else {
            this.write(s.toCharArray(), 0, cch);
        }
    }

    public void write(String s, int of, int cch) throws IOException {
        char[] ach;
        if (cch <= 1024) {
            ach = this.m_achBuf;
            if (ach == null) {
                this.m_achBuf = ach = new char[1024];
            }
        } else {
            ach = new char[cch];
        }
        s.getChars(of, of + cch, ach, 0);
        this.write(ach, 0, cch);
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        this.flush();
    }

    public byte[] toByteArray() {
        return ((ByteArrayOutputStream)this.m_stream).toByteArray();
    }
}

