/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.InputStreaming;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class WrapperDataInputStream
extends InputStream
implements DataInput,
InputStreaming {
    private DataInput m_in;

    public WrapperDataInputStream(DataInput in) {
        this.m_in = in;
    }

    public DataInput getDataInput() {
        return this.m_in;
    }

    public void readFully(byte[] ab) throws IOException {
        this.m_in.readFully(ab);
    }

    public void readFully(byte[] ab, int of, int cb) throws IOException {
        this.m_in.readFully(ab, of, cb);
    }

    public int skipBytes(int cb) throws IOException {
        return this.m_in.skipBytes(cb);
    }

    public boolean readBoolean() throws IOException {
        return this.m_in.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.m_in.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.m_in.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.m_in.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.m_in.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.m_in.readChar();
    }

    public int readInt() throws IOException {
        return this.m_in.readInt();
    }

    public long readLong() throws IOException {
        return this.m_in.readLong();
    }

    public float readFloat() throws IOException {
        return this.m_in.readFloat();
    }

    public double readDouble() throws IOException {
        return this.m_in.readDouble();
    }

    public String readLine() throws IOException {
        return this.m_in.readLine();
    }

    public String readUTF() throws IOException {
        return this.m_in.readUTF();
    }

    public int read() throws IOException {
        DataInput in = this.m_in;
        if (in instanceof InputStream) {
            return ((InputStream)((Object)in)).read();
        }
        try {
            return this.readUnsignedByte();
        }
        catch (EOFException e) {
            return -1;
        }
    }

    public int read(byte[] ab) throws IOException {
        DataInput in = this.m_in;
        if (in instanceof InputStream) {
            return ((InputStream)((Object)in)).read(ab);
        }
        int cb = ab.length;
        for (int of = 0; of < cb; ++of) {
            try {
                ab[of] = (byte)this.readUnsignedByte();
                continue;
            }
            catch (EOFException e) {
                return cb == 0 ? -1 : cb;
            }
        }
        return cb;
    }

    public int read(byte[] ab, int of, int cb) throws IOException {
        DataInput in = this.m_in;
        if (in instanceof InputStream) {
            return ((InputStream)((Object)in)).read(ab, of, cb);
        }
        if (of < 0 || cb < 0 || of + cb > ab.length) {
            throw new IndexOutOfBoundsException("ab.length=" + ab.length + ", of=" + of + ", cb=" + cb);
        }
        int ofStart = of;
        int ofEnd = of + cb - 1;
        while (of <= ofEnd) {
            try {
                ab[of] = (byte)this.readUnsignedByte();
            }
            catch (EOFException e) {
                return of == ofStart ? -1 : of - ofStart;
            }
            ++of;
        }
        return cb;
    }

    public long skip(long cb) throws IOException {
        DataInput in = this.m_in;
        if (in instanceof InputStream) {
            return ((InputStream)((Object)in)).skip(cb);
        }
        if (cb > Integer.MAX_VALUE) {
            cb = Integer.MAX_VALUE;
        }
        return in.skipBytes((int)cb);
    }

    public int available() throws IOException {
        DataInput in = this.m_in;
        return in instanceof InputStream ? ((InputStream)((Object)in)).available() : 0;
    }

    public void close() throws IOException {
        DataInput in = this.m_in;
        if (in instanceof InputStream) {
            ((InputStream)((Object)in)).close();
        }
    }

    public void mark(int cbReadLimit) {
        DataInput in = this.m_in;
        if (in instanceof InputStream) {
            ((InputStream)((Object)in)).mark(cbReadLimit);
        }
    }

    public void reset() throws IOException {
        DataInput in = this.m_in;
        if (!(in instanceof InputStream)) {
            throw new IOException("mark not supported");
        }
        ((InputStream)((Object)in)).reset();
    }

    public boolean markSupported() {
        DataInput in = this.m_in;
        return in instanceof InputStream ? ((InputStream)((Object)in)).markSupported() : false;
    }
}

