/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.bdb;

import com.sleepycat.je.DatabaseException;
import com.tangosol.io.BinaryStore;
import com.tangosol.io.BinaryStoreManager;
import com.tangosol.io.bdb.BerkeleyDBBinaryStore;
import com.tangosol.io.bdb.DatabaseFactoryManager;
import com.tangosol.run.xml.XmlConfigurable;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.io.File;

public class BerkeleyDBBinaryStoreManager
extends Base
implements BinaryStoreManager,
XmlConfigurable {
    private static DatabaseFactoryManager s_factoryManager = new DatabaseFactoryManager();
    protected XmlElement m_xmlConfig;
    protected File m_dirParent;
    protected String m_sDbName;
    protected boolean m_fTemporary;

    public BerkeleyDBBinaryStoreManager() {
        this(null, null);
    }

    public BerkeleyDBBinaryStoreManager(File dirParent, String sDbName) {
        File file = this.m_dirParent = dirParent == null ? null : dirParent.getAbsoluteFile();
        if (sDbName == null || sDbName.length() == 0) {
            this.m_sDbName = null;
            this.m_fTemporary = true;
        } else {
            this.m_sDbName = sDbName;
            this.m_fTemporary = false;
        }
    }

    public String toString() {
        return "BerkeleyDBBinaryStoreManager {" + " Parent Dir: " + this.m_dirParent + " Temporary: " + this.m_fTemporary + " Config: " + this.m_xmlConfig + '}';
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || !(that instanceof BerkeleyDBBinaryStoreManager)) {
            return false;
        }
        BerkeleyDBBinaryStoreManager bdbThat = (BerkeleyDBBinaryStoreManager)that;
        return (this.m_xmlConfig == null ? bdbThat.m_xmlConfig == null : ((Object)this.m_xmlConfig).equals(bdbThat.m_xmlConfig)) && (this.m_dirParent == null ? bdbThat.m_dirParent == null : this.m_dirParent.equals(bdbThat.m_dirParent)) && this.m_fTemporary == bdbThat.m_fTemporary;
    }

    public int hashCode() {
        return (this.m_xmlConfig == null ? 0 : ((Object)this.m_xmlConfig).hashCode()) + (this.m_dirParent == null ? 0 : this.m_dirParent.hashCode()) + Boolean.valueOf(this.m_fTemporary).hashCode();
    }

    public BinaryStore createBinaryStore() {
        try {
            return new BerkeleyDBBinaryStore(this.m_sDbName, s_factoryManager.ensureFactory(this));
        }
        catch (DatabaseException e) {
            throw new WrapperException(e, "Failed to create a Berkeley DB Binary Store.");
        }
    }

    public void destroyBinaryStore(BinaryStore store) {
        if (store != null) {
            BerkeleyDBBinaryStore scStore = (BerkeleyDBBinaryStore)store;
            scStore.close();
        }
    }

    public XmlElement getConfig() {
        return this.m_xmlConfig;
    }

    public void setConfig(XmlElement xmlConfig) {
        this.m_xmlConfig = xmlConfig;
    }

    public static DatabaseFactoryManager getFactoryManager() {
        return s_factoryManager;
    }

    public File getParentDirectory() {
        return this.m_dirParent;
    }

    public boolean isTemporary() {
        return this.m_fTemporary;
    }
}

