/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.lh;

import com.tangosol.io.lh.JLHSession;
import com.tangosol.io.lh.LHException;
import com.tangosol.io.lh.LHNotActiveException;
import com.tangosol.io.lh.LHSelect;
import com.tangosol.io.lh.LHSubs;
import com.tangosol.io.lh.LHTable;
import java.util.Properties;

public class JLHSelect
implements LHSelect {
    private static final byte FM = -2;
    private static final byte RM = -1;
    private boolean m_SuppressFinalDelimiter;
    private byte m_SelectDelimiter;
    private JLHSession m_ThisSession;
    private LHTable Table;
    private boolean bActive;
    private JLHSelect SessionQueueNext;
    private JLHSelect SessionQueuePrevious;
    private JLHSelect TableQueueNext;
    private JLHSelect TableQueuePrevious;
    private boolean keys;
    private int group;
    private byte[][] elementData;
    private int elementMax;
    private int elementIx;
    private boolean nullflag;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JLHSelect(JLHSession Session, LHTable Table, Properties propOptions) {
        this.m_ThisSession = Session;
        this.Table = Table;
        this.keys = true;
        this.m_SelectDelimiter = (byte)-2;
        this.nullflag = false;
        this.m_SuppressFinalDelimiter = true;
        if (propOptions != null) {
            String property = propOptions.getProperty("SuppressFinalDelimiter");
            if (property != null) {
                Boolean bValue = new Boolean(property);
                this.m_SuppressFinalDelimiter = bValue;
            }
            if ((property = propOptions.getProperty("SelectDelimiter")) != null) {
                try {
                    this.m_SelectDelimiter = Byte.parseByte(property);
                    if (this.m_SelectDelimiter == 0) {
                        this.m_SelectDelimiter = (byte)-2;
                    }
                }
                catch (Exception e) {
                    this.m_SelectDelimiter = (byte)-2;
                }
            }
            if ((property = propOptions.getProperty("Fields")) != null && property.equalsIgnoreCase("Record")) {
                this.keys = false;
            }
        }
        Object object = this.m_ThisSession.m_syncSessionObjectList;
        synchronized (object) {
            if (this.m_ThisSession.LHSelectQueueTail == null) {
                this.m_ThisSession.LHSelectQueueHead = this;
            } else {
                this.m_ThisSession.LHSelectQueueTail.SessionQueueNext = this;
            }
            this.SessionQueueNext = null;
            this.SessionQueuePrevious = this.m_ThisSession.LHSelectQueueTail;
            this.m_ThisSession.LHSelectQueueTail = this;
        }
        object = Table.syncLHQueues;
        synchronized (object) {
            if (Table.LHSelectQueueTail == null) {
                Table.LHSelectQueueHead = this;
            } else {
                Table.LHSelectQueueTail.TableQueueNext = this;
            }
            this.TableQueueNext = null;
            this.TableQueuePrevious = Table.LHSelectQueueTail;
            Table.LHSelectQueueTail = this;
        }
        this.group = -1;
        this.elementData = new byte[8][];
        this.elementMax = 0;
        this.elementIx = 0;
        this.bActive = true;
    }

    public void close() throws LHException {
        if (this.m_ThisSession.m_iVerbose >= 2) {
            this.m_ThisSession.LogInfo("JLHSelect[" + this.hashCode() + "].close()", null);
        }
        this.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void finalize() {
        if (!this.bActive) {
            return;
        }
        this.bActive = false;
        try {
            this.clearSelect();
        }
        catch (Exception e) {
            // empty catch block
        }
        Object e = this.m_ThisSession.m_syncSessionObjectList;
        synchronized (e) {
            if (this.SessionQueuePrevious == null) {
                this.m_ThisSession.LHSelectQueueHead = this.SessionQueueNext;
            } else {
                this.SessionQueuePrevious.SessionQueueNext = this.SessionQueueNext;
            }
            if (this.SessionQueueNext == null) {
                this.m_ThisSession.LHSelectQueueTail = this.SessionQueuePrevious;
            } else {
                this.SessionQueueNext.SessionQueuePrevious = this.SessionQueuePrevious;
            }
        }
        e = this.Table.syncLHQueues;
        synchronized (e) {
            if (this.TableQueuePrevious == null) {
                this.Table.LHSelectQueueHead = this.TableQueueNext;
            } else {
                this.TableQueuePrevious.TableQueueNext = this.TableQueueNext;
            }
            if (this.TableQueueNext == null) {
                this.Table.LHSelectQueueTail = this.TableQueuePrevious;
            } else {
                this.TableQueueNext.TableQueuePrevious = this.TableQueuePrevious;
            }
            if (this.Table.LHFileQueueTail == null && this.Table.LHSelectQueueTail == null) {
                this.Table.CloseFiles();
            }
        }
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized byte[] readNext(boolean backward) throws LHException {
        if (this.m_ThisSession.m_iVerbose >= 2) {
            this.m_ThisSession.LogInfo("JLHSelect[" + this.hashCode() + "].readNext()", "backward - " + backward);
        }
        if (!this.bActive) {
            throw new LHNotActiveException("LHSelect");
        }
        if (this.nullflag) {
            this.nullflag = false;
            return null;
        }
        if (backward) {
            if (this.elementIx <= 0 && !this.FillElementData(backward)) {
                this.nullflag = true;
                return null;
            }
            --this.elementIx;
        } else {
            if (this.elementIx + 1 >= this.elementMax && !this.FillElementData(backward)) {
                this.nullflag = true;
                return null;
            }
            ++this.elementIx;
        }
        return this.elementData[this.elementIx];
    }

    public byte[] readNext() throws LHException {
        return this.readNext(false);
    }

    public synchronized byte[] readNextGroup(boolean backward) throws LHException {
        if (this.m_ThisSession.m_iVerbose >= 2) {
            this.m_ThisSession.LogInfo("JLHSelect[" + this.hashCode() + "].readNextGroup()", "backward - " + backward);
        }
        if (!this.bActive) {
            throw new LHNotActiveException("LHSelect");
        }
        byte[] groupData = null;
        if (backward) {
            int idx;
            if (this.elementIx <= 0 && !this.FillElementData(backward)) {
                return null;
            }
            int totalLength = 0;
            for (idx = this.elementIx - 1; idx >= 0; --idx) {
                totalLength += this.elementData[idx].length + 1;
            }
            if (this.m_SuppressFinalDelimiter && totalLength > 0) {
                --totalLength;
            }
            groupData = new byte[totalLength];
            int curPosition = 0;
            for (idx = this.elementIx - 1; idx >= 0; --idx) {
                System.arraycopy(this.elementData[idx], 0, groupData, curPosition, this.elementData[idx].length);
                curPosition += this.elementData[idx].length;
                if (this.m_SuppressFinalDelimiter && idx <= 0) continue;
                groupData[curPosition] = this.m_SelectDelimiter;
                ++curPosition;
            }
            this.elementIx = 0;
        } else {
            int idx;
            if (this.elementIx >= this.elementMax - 1 && !this.FillElementData(backward)) {
                return null;
            }
            int totalLength = 0;
            for (idx = this.elementIx + 1; idx < this.elementMax; ++idx) {
                totalLength += this.elementData[idx].length + 1;
            }
            if (this.m_SuppressFinalDelimiter && totalLength > 0) {
                --totalLength;
            }
            groupData = new byte[totalLength];
            int curPosition = 0;
            for (idx = this.elementIx + 1; idx < this.elementMax; ++idx) {
                System.arraycopy(this.elementData[idx], 0, groupData, curPosition, this.elementData[idx].length);
                curPosition += this.elementData[idx].length;
                if (this.m_SuppressFinalDelimiter && idx >= this.elementMax - 1) continue;
                groupData[curPosition] = this.m_SelectDelimiter;
                ++curPosition;
            }
            this.elementIx = this.elementMax - 1;
        }
        return groupData;
    }

    public byte[] readNextGroup() throws LHException {
        return this.readNext(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean FillElementData(boolean backward) throws LHException {
        boolean bl;
        boolean bClearSelect = true;
        this.Table.InitializeFileUse();
        LHSubs D = LHSubs.InitData(this.Table);
        if (this.group == -1) {
            this.SelectLock();
            if (backward) {
                this.group = this.Table.Modulo;
            }
        }
        this.elementMax = 0;
        do {
            if (backward) {
                if (--this.group < 0) {
                    bl = false;
                    return bl;
                }
            } else if (++this.group >= this.Table.Modulo) {
                bl = false;
                return bl;
            }
            D.F.group = this.group;
            D.LockGroupF(false);
            D.GetPrimaryFrame();
            while (!D.CheckEndOfGroup()) {
                int i;
                D.GetRecordLengths(false);
                if (this.keys) {
                    i = D.recidlength;
                } else {
                    D.SkipCount(D.recidlength);
                    i = D.reclength - D.len_recidlength - D.recidlength;
                }
                byte[] element = new byte[i];
                int offset = 0;
                while (i > 0) {
                    int j;
                    if (D.F.index >= this.Table.FrameSize) {
                        D.GetNextOverflowFrame();
                    }
                    if (i < (j = this.Table.FrameSize - D.F.index)) {
                        j = i;
                    }
                    System.arraycopy(D.F.buffer, D.F.index, element, offset, j);
                    offset += j;
                    i -= j;
                    D.F.index += j;
                }
                if (this.keys) {
                    D.SkipRecord();
                } else {
                    D.CheckRecordMarker(false);
                }
                if (this.elementMax >= this.elementData.length) {
                    byte[][] newData = new byte[this.elementMax + 8][];
                    System.arraycopy(this.elementData, 0, newData, 0, this.elementMax);
                    this.elementData = newData;
                }
                this.elementData[this.elementMax++] = element;
            }
            D.UnlockGroupF();
        } while (this.elementMax <= 0);
        this.elementIx = backward ? this.elementMax : -1;
        bClearSelect = false;
        bl = true;
        return bl;
        finally {
            try {
                D.TermData();
                if (bClearSelect) {
                    this.clearSelect();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearSelect() throws LHException {
        block11: {
            if (this.m_ThisSession.m_iVerbose >= 2) {
                this.m_ThisSession.LogInfo("JLHSelect[" + this.hashCode() + "].clearSelect()", null);
            }
            if (!this.bActive) {
                throw new LHNotActiveException("LHSelect");
            }
            if (this.group == -1) {
                return;
            }
            this.group = -1;
            this.Table.InitializeFileUse();
            LHSubs D = LHSubs.InitData(this.Table);
            try {
                if (this.Table.ReadOnly) break block11;
                Object object = this.Table.syncResize;
                synchronized (object) {
                    if ((this.Table.SizeLock & 1) != 0) {
                        D.LoadGroup0Header(true);
                        if ((this.Table.SizeLock & 1) != 0) {
                            this.Table.SizeLock &= 0xFFFFFFFE;
                            D.UnloadGroup0Header();
                        }
                    }
                }
            }
            finally {
                D.TermData();
                this.SelectUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SelectLock() {
        Object object = this.Table.syncResize;
        synchronized (object) {
            ++this.Table.SelectLocks;
        }
        LHSubs.UnlinkFromResize(this.Table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SelectUnlock() {
        Object object = this.Table.syncResize;
        synchronized (object) {
            if (this.Table.SelectLocks > 0) {
                --this.Table.SelectLocks;
                if (this.Table.SelectLocks == 0) {
                    Object object2 = this.Table.syncVerified;
                    synchronized (object2) {
                        if (this.Table.SizeLock <= 1 && this.Table.ModuloVerified != this.Table.Modulo) {
                            this.Table.ModuloVerified = 0;
                        }
                    }
                }
            }
        }
        LHSubs.CheckForResize(this.Table);
    }
}

