/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.lh;

import com.tangosol.io.lh.JLHFile;
import com.tangosol.io.lh.JLHSelect;
import com.tangosol.io.lh.JLHServer;
import com.tangosol.io.lh.LHBuffer;
import com.tangosol.io.lh.LHException;
import com.tangosol.io.lh.LHFile;
import com.tangosol.io.lh.LHFileFoundException;
import com.tangosol.io.lh.LHFileNotFoundException;
import com.tangosol.io.lh.LHIOException;
import com.tangosol.io.lh.LHInUseException;
import com.tangosol.io.lh.LHLock;
import com.tangosol.io.lh.LHMaximumUsersException;
import com.tangosol.io.lh.LHNotActiveException;
import com.tangosol.io.lh.LHOSFile;
import com.tangosol.io.lh.LHReadOnlyException;
import com.tangosol.io.lh.LHSession;
import com.tangosol.io.lh.LHSubs;
import com.tangosol.io.lh.LHTable;
import com.tangosol.io.lh.LHVolume;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class JLHSession
implements LHSession {
    private static Hashtable m_LHVolumes = new Hashtable();
    private JLHServer m_Server;
    JLHSession m_SessionListNext;
    JLHSession m_SessionListPrevious;
    boolean m_bActive;
    private String m_SerialNumber;
    private int m_MaximumUsers;
    public static final int VERB_LEVEL_MUTE = 0;
    public static final int VERB_LEVEL_ERROR = 1;
    public static final int VERB_LEVEL_INFO = 2;
    public static final int VERB_LEVEL_DEBUG = 3;
    int m_iVerbose = 1;
    Object m_syncSessionObjectList = new Object();
    JLHFile m_SessionFileListHead;
    JLHFile m_SessionFileListTail;
    JLHSelect LHSelectQueueHead;
    JLHSelect LHSelectQueueTail;
    Object syncLocks = new Object();
    LHLock FileLocks;
    LHLock RecordLocks;

    void LogError(String CalledId, String msg) {
        if (this.m_iVerbose >= 1) {
            JLHServer.LogMessage(CalledId, "*** ERROR ***" + msg);
        }
    }

    void LogInfo(String CalledId, String msg) {
        if (this.m_iVerbose >= 2) {
            JLHServer.LogMessage(CalledId, msg);
        }
    }

    void LogDebug(String msg) {
        if (this.m_iVerbose >= 3) {
            JLHServer.LogMessage(null, "DEBUG: " + msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JLHSession(JLHServer Server, Properties propertiesOptions) throws LHMaximumUsersException {
        this.LogInfo("JLHSession[" + this.hashCode() + "].JLHSession", "Creating...");
        this.m_Server = Server;
        Object object = this.m_Server.m_syncSessionList;
        synchronized (object) {
            if (!this.m_bActive) {
                this.m_SerialNumber = null;
                this.m_MaximumUsers = 0;
                if (propertiesOptions != null) {
                    String property = propertiesOptions.getProperty("MaximumUsers");
                    if (property != null) {
                        this.m_MaximumUsers = Integer.parseInt(property);
                    }
                    if ((property = propertiesOptions.getProperty("SerialNumber")) != null) {
                        this.m_SerialNumber = property;
                    }
                    if ((property = propertiesOptions.getProperty("VerbosityLevel")) != null) {
                        this.m_iVerbose = Integer.parseInt(property);
                    }
                }
                if (this.m_MaximumUsers != 0) {
                    int iUserCount = 0;
                    JLHSession Session = this.m_Server.m_SessionListHead;
                    while (Session != null) {
                        if (this.m_SerialNumber == null) {
                            if (Session.m_SerialNumber == null) {
                                ++iUserCount;
                            }
                        } else if (Session.m_SerialNumber != null && this.m_SerialNumber.equals(Session.m_SerialNumber)) {
                            ++iUserCount;
                        }
                        Session = Session.m_SessionListNext;
                    }
                    if (iUserCount >= this.m_MaximumUsers) {
                        throw new LHMaximumUsersException(this.m_SerialNumber, this.m_MaximumUsers);
                    }
                }
                if (this.m_Server.m_SessionListTail == null) {
                    LHSubs.startResize();
                    this.m_Server.m_SessionListHead = this;
                } else {
                    this.m_Server.m_SessionListTail.m_SessionListNext = this;
                }
                this.m_SessionListNext = null;
                this.m_SessionListPrevious = this.m_Server.m_SessionListTail;
                this.m_Server.m_SessionListTail = this;
                this.m_bActive = true;
            }
        }
    }

    public String GetHostName() {
        return this.m_Server.m_HostName;
    }

    public String GetSerialNumber() {
        return JLHServer.m_ServerSerialNumber;
    }

    public void unreferenced() {
        this.LogInfo("JLHSession[" + this.hashCode() + "].unreferenced()", null);
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() throws LHException {
        this.LogInfo("JLHSession[" + this.hashCode() + "].close()", null);
        this.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void finalize() {
        this.LogInfo("JLHSession[" + this.hashCode() + "].finalize()", "Cleaning up...");
        try {
            while (this.m_SessionFileListHead != null) {
                this.m_SessionFileListHead.close();
            }
            while (this.LHSelectQueueHead != null) {
                this.LHSelectQueueHead.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Object e = this.m_Server.m_syncSessionList;
        synchronized (e) {
            if (this.m_bActive) {
                this.m_bActive = false;
                if (this.m_SessionListPrevious == null) {
                    this.m_Server.m_SessionListHead = this.m_SessionListNext;
                } else {
                    this.m_SessionListPrevious.m_SessionListNext = this.m_SessionListNext;
                }
                if (this.m_SessionListNext == null) {
                    this.m_Server.m_SessionListTail = this.m_SessionListPrevious;
                } else {
                    this.m_SessionListNext.m_SessionListPrevious = this.m_SessionListPrevious;
                }
                if (this.m_Server.m_SessionListTail == null) {
                    LHSubs.stopResize();
                }
            }
        }
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockAll() throws LHException {
        this.LogInfo("JLHSession[" + this.hashCode() + "].unlockAll()", null);
        if (!this.m_bActive) {
            throw new LHNotActiveException("LHSession");
        }
        Object object = this.syncLocks;
        synchronized (object) {
            Object object2;
            while (this.FileLocks != null) {
                object2 = this.FileLocks.Table.syncLocks;
                synchronized (object2) {
                    this.FileLocks.File.ReleaseFileLock(this.FileLocks);
                }
            }
            while (this.RecordLocks != null) {
                object2 = this.RecordLocks.Table.syncLocks;
                synchronized (object2) {
                    this.RecordLocks.File.ReleaseRecordLock(this.RecordLocks);
                }
            }
        }
    }

    public void flush() throws LHException {
        this.LogInfo("JLHSession[" + this.hashCode() + "].flush()", null);
        if (!this.m_bActive) {
            throw new LHNotActiveException("LHSession");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFile(String name, Properties propertiesOptions) throws LHException {
        this.LogInfo("JLHSession[" + this.hashCode() + "].createFile()", name);
        if (!this.m_bActive) {
            throw new LHNotActiveException("LHSession");
        }
        LHTable Table = null;
        Object object = m_LHVolumes;
        synchronized (object) {
            Table = this.ParsePathName(name, false);
        }
        object = Table.syncLK;
        synchronized (object) {
            LHOSFile fh;
            SecurityManager security;
            if (Table.Volume.m_ReadOnly) {
                throw new LHReadOnlyException(Table.Name());
            }
            int iModulo = 1021;
            int iFrameSize = 8192;
            int iThreshold = 73;
            int iSizeLock = 0;
            if (propertiesOptions != null) {
                String property = propertiesOptions.getProperty("Modulo");
                if (property != null && (iModulo = Integer.parseInt(property)) <= 0) {
                    iModulo = 1;
                }
                if ((property = propertiesOptions.getProperty("FrameSize")) != null) {
                    iFrameSize = Integer.parseInt(property);
                    if (iFrameSize <= 0) {
                        iFrameSize = 256;
                    } else if (iFrameSize < 256) {
                        iFrameSize = 256;
                    }
                }
                if ((property = propertiesOptions.getProperty("Threshold")) != null) {
                    iThreshold = Integer.parseInt(property);
                    if (iThreshold <= 0) {
                        iThreshold = 204;
                    } else if (iThreshold < 25) {
                        iThreshold = 25;
                    } else if (iThreshold > 255) {
                        iThreshold = 255;
                    }
                }
                if ((property = propertiesOptions.getProperty("SizeLock")) != null) {
                    iSizeLock = Integer.parseInt(property);
                    if (iSizeLock <= 0) {
                        iSizeLock = 0;
                    } else if (iSizeLock > 65535) {
                        iSizeLock = 65535;
                    }
                }
                if ((property = propertiesOptions.getProperty("Temporary")) != null) {
                    Table.DeleteOnExit = Boolean.valueOf(property);
                }
            }
            String PathLK = Table.Name() + ".tp";
            String PathOV = Table.Name() + ".to";
            Table.FileLK = new File(PathLK);
            Table.FileOV = new File(PathOV);
            if (Table.FileLK.exists()) {
                Table.FileLK.delete();
            }
            if (Table.FileOV.exists()) {
                Table.FileOV.delete();
            }
            if ((security = System.getSecurityManager()) != null) {
                try {
                    security.checkWrite(PathLK);
                    security.checkWrite(PathOV);
                }
                catch (SecurityException se) {
                    this.LogError("JLHSession[" + this.hashCode() + "].createFile()", se.getMessage());
                    throw new LHReadOnlyException(Table.Name());
                }
            }
            try {
                fh = new LHOSFile(PathLK, false);
                if (Table.DeleteOnExit) {
                    Table.FileLK.deleteOnExit();
                }
            }
            catch (IOException ioe) {
                this.LogError("JLHSession[" + this.hashCode() + "].createFile()", ioe.getMessage());
                throw new LHIOException(Table.Name(), false, "Opening", ioe.getMessage());
            }
            LHBuffer Frame = new LHBuffer(iFrameSize);
            Frame.putType(26);
            Frame.putDataForward(0);
            Frame.putDataForwardSkip(0);
            Frame.putPrimaryModulo(iModulo);
            Frame.putGroup0FrameSize(iFrameSize);
            Frame.putGroup0Alpha(26 + 1 + (13 + 1) * (iModulo - 1));
            Frame.putGroup0Threshold(iThreshold);
            Frame.putGroup0SizeLock(iSizeLock);
            Frame.putGroup0RecordCount(0);
            Frame.putInt(26, 1, 128);
            Frame.fill(26 + 1, iFrameSize - (26 + 1), Table.Volume.m_FillCharacter);
            try {
                fh.write(0L, Frame.buffer, iFrameSize);
            }
            catch (IOException ioe) {
                this.LogError("JLHSession[" + this.hashCode() + "].createFile()", ioe.getMessage());
                throw new LHIOException(Table.Name(), false, "Writing", 0, 0, ioe.getMessage());
            }
            if (iModulo > 1) {
                Frame.putType(13);
                Frame.putInt(13, 1, 128);
                Frame.fill(13 + 1, 26 - (13 + 1), Table.Volume.m_FillCharacter);
                for (int i = 1; i < iModulo; ++i) {
                    try {
                        fh.write((long)i * (long)iFrameSize, Frame.buffer, iFrameSize);
                        continue;
                    }
                    catch (IOException ioe) {
                        this.LogError("JLHSession[" + this.hashCode() + "].createFile()", ioe.getMessage());
                        throw new LHIOException(Table.Name(), false, "Writing", i, i, ioe.getMessage());
                    }
                }
            }
            try {
                fh.close();
            }
            catch (IOException ioe) {
                this.LogError("JLHSession[" + this.hashCode() + "].createFile()", ioe.getMessage());
                throw new LHIOException(Table.Name(), false, "Closing", ioe.getMessage());
            }
            try {
                fh = new LHOSFile(PathOV, false);
                if (Table.DeleteOnExit) {
                    Table.FileOV.deleteOnExit();
                }
            }
            catch (IOException ioe) {
                this.LogError("JLHSession[" + this.hashCode() + "].createFile()", ioe.getMessage());
                throw new LHIOException(Table.Name(), true, "Opening", ioe.getMessage());
            }
            try {
                fh.close();
            }
            catch (IOException ioe) {
                this.LogError("JLHSession[" + this.hashCode() + "].createFile()", ioe.getMessage());
                throw new LHIOException(Table.Name(), true, "Closing", ioe.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFile(String name) throws LHException {
        this.LogInfo("JLHSession[" + this.hashCode() + "].deleteFile()", name);
        if (!this.m_bActive) {
            throw new LHNotActiveException("LHSession");
        }
        Hashtable hashtable = m_LHVolumes;
        synchronized (hashtable) {
            LHTable Table = this.ParsePathName(name, true);
            if (Table.Volume.m_ReadOnly) {
                throw new LHReadOnlyException(Table.Name());
            }
            if (Table.LHFileQueueHead != null || Table.LHSelectQueueHead != null) {
                throw new LHInUseException(Table.Name());
            }
            Table.CloseFiles();
            File fileLK = new File(Table.Name() + ".tp");
            File fileOV = new File(Table.Name() + ".to");
            fileLK.delete();
            fileOV.delete();
            if (fileLK.exists() || fileOV.exists()) {
                String sMsg = "Failed to delete file(s):" + (fileLK.exists() ? " \"" + fileLK + '\"' : "") + (fileOV.exists() ? " \"" + fileOV + '\"' : "");
                this.LogError("JLHSession[" + this.hashCode() + "].deleteFile()", sMsg);
                throw new LHFileFoundException(sMsg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LHFile openFile(String name, Properties propOptions) throws LHException {
        this.LogInfo("JLHSession[" + this.hashCode() + "].openFile()", name);
        if (!this.m_bActive) {
            throw new LHNotActiveException("LHSession");
        }
        Hashtable hashtable = m_LHVolumes;
        synchronized (hashtable) {
            return new JLHFile(this, this.ParsePathName(name, true), propOptions);
        }
    }

    private LHTable ParsePathName(String name, boolean bMustExist) throws LHException {
        File file = new File(name);
        String volumeName = LHVolume.ConvertToLocalPath(file.getParent(), null);
        if (volumeName == null) {
            throw new LHFileNotFoundException(name);
        }
        String fileName = file.getName();
        LHTable Table = null;
        LHVolume Volume = (LHVolume)m_LHVolumes.get(volumeName);
        if (Volume != null) {
            Table = Volume.get(fileName);
        }
        boolean bLKExists = true;
        if (Table == null || !Table.isLKOpen()) {
            File LK = new File(volumeName, fileName + ".tp");
            bLKExists = LK.exists();
        }
        if (bMustExist) {
            if (!bLKExists) {
                throw new LHFileNotFoundException(name);
            }
        } else if (bLKExists) {
            throw new LHFileFoundException(name);
        }
        if (Volume == null) {
            Volume = new LHVolume(volumeName);
            m_LHVolumes.put(volumeName, Volume);
        }
        if (Table == null) {
            Table = new LHTable(Volume, fileName);
            Volume.put(fileName, Table);
        }
        return Table;
    }
}

