/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.nio;

import com.tangosol.io.nio.ByteBufferManager;
import com.tangosol.util.Base;
import java.nio.ByteBuffer;

public abstract class AbstractBufferManager
extends Base
implements ByteBufferManager {
    private int m_cbInitial;
    private int m_cbMaximum;
    private int m_cbCurrent;
    private int m_cbGrow;
    private int m_cbShrink;
    private ByteBuffer m_buffer;

    protected AbstractBufferManager(int cbInitial, int cbMaximum) {
        this.setMinCapacity(cbInitial);
        this.setMaxCapacity(cbMaximum);
        this.setCapacity(cbInitial);
    }

    public ByteBuffer getBuffer() {
        return this.m_buffer;
    }

    protected void setBuffer(ByteBuffer buffer) {
        this.m_buffer = buffer;
    }

    public int getCapacity() {
        return this.m_cbCurrent;
    }

    protected void setCapacity(int cb) {
        this.m_cbCurrent = cb;
        this.calibrate();
    }

    public int getGrowthThreshold() {
        return this.m_cbGrow;
    }

    protected void setGrowthThreshold(int cb) {
        this.m_cbGrow = cb;
    }

    public int getShrinkageThreshold() {
        return this.m_cbShrink;
    }

    protected void setShrinkageThreshold(int cb) {
        this.m_cbShrink = cb;
    }

    public int getMinCapacity() {
        return this.m_cbInitial;
    }

    protected void setMinCapacity(int cb) {
        this.m_cbInitial = cb;
    }

    public int getMaxCapacity() {
        return this.m_cbMaximum;
    }

    protected void setMaxCapacity(int cb) {
        this.m_cbMaximum = cb;
    }

    protected int getMaxIncrement() {
        return 0x7FFFFFF;
    }

    public void grow(int cbRequired) {
        if (cbRequired > this.getGrowthThreshold()) {
            int cbOrig;
            if (cbRequired > this.getMaxCapacity()) {
                throw new IllegalArgumentException("cannot grow ByteBuffer; required=" + cbRequired + ", max=" + this.getMaxCapacity());
            }
            int cbNew = cbOrig = this.getCapacity();
            do {
                cbNew = Math.min(Math.min(cbNew * 2, this.getMaxCapacity()), cbNew + this.getMaxIncrement());
                this.setCapacity(cbNew);
            } while (cbRequired > this.getGrowthThreshold());
            this.allocateBuffer();
        }
    }

    public void shrink(int cbRequired) {
        if (cbRequired < this.getShrinkageThreshold()) {
            int cbOrig;
            int cbNew = cbOrig = this.getCapacity();
            do {
                cbNew = Math.max(cbNew / 2, this.getMinCapacity());
                this.setCapacity(cbNew);
            } while (cbRequired < this.getShrinkageThreshold());
            this.allocateBuffer();
        }
    }

    protected void calibrate() {
        int cb = this.getCapacity();
        this.setGrowthThreshold(cb >= this.getMaxCapacity() ? Integer.MAX_VALUE : Math.min((int)((double)cb * 0.9), this.getMaxCapacity()));
        this.setShrinkageThreshold(cb <= this.getMinCapacity() ? 0 : Math.max((int)((double)cb * 0.4), this.getMinCapacity()));
    }

    protected abstract void allocateBuffer();
}

