/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.nio;

import com.tangosol.io.BinaryStore;
import com.tangosol.io.nio.BinaryMap;
import com.tangosol.io.nio.ByteBufferManager;
import com.tangosol.io.nio.MappedBufferManager;
import com.tangosol.util.Binary;
import com.tangosol.util.SimpleEnumerator;
import java.util.Collections;
import java.util.Iterator;

public class BinaryMapStore
implements BinaryStore {
    private BinaryMap m_map;

    public BinaryMapStore(BinaryMap map) {
        this.m_map = map;
    }

    public Binary load(Binary binKey) {
        return (Binary)this.m_map.get(binKey);
    }

    public void store(Binary binKey, Binary binValue) {
        this.m_map.putAll(Collections.singletonMap(binKey, binValue));
    }

    public void erase(Binary binKey) {
        this.m_map.keySet().remove(binKey);
    }

    public void eraseAll() {
        this.m_map.clear();
    }

    public Iterator keys() {
        return new SimpleEnumerator(this.m_map.keySet().toArray());
    }

    public void close() {
        try {
            ByteBufferManager mgr = this.m_map.getBufferManager();
            if (mgr instanceof MappedBufferManager) {
                ((MappedBufferManager)mgr).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_map = null;
    }
}

