/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.nio;

import com.tangosol.io.InputStreaming;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream
implements InputStreaming {
    protected ByteBuffer m_buf;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.m_buf = buffer;
    }

    public ByteBuffer getByteBuffer() {
        return this.m_buf;
    }

    public int read() throws IOException {
        ByteBuffer buf = this.getByteBuffer();
        try {
            return buf.hasRemaining() ? buf.get() & 0xFF : -1;
        }
        catch (NullPointerException e) {
            throw this.potentialStreamClosedException(e);
        }
    }

    public int read(byte[] abDest, int ofDest, int cbDest) throws IOException {
        if (abDest == null || ofDest < 0 || cbDest < 0 || ofDest + cbDest > abDest.length) {
            if (abDest == null) {
                throw new IllegalArgumentException("null byte array");
            }
            throw new IllegalArgumentException("abDest.length=" + abDest.length + ", ofDest=" + ofDest + ", cbDest=" + cbDest);
        }
        int cbMaxSrc = this.available();
        if (cbDest > cbMaxSrc) {
            if (cbMaxSrc == 0) {
                return -1;
            }
            cbDest = cbMaxSrc;
        }
        this.getByteBuffer().get(abDest, ofDest, cbDest);
        return cbDest;
    }

    public long skip(long lcb) throws IOException {
        int cb = lcb > Integer.MAX_VALUE ? Integer.MAX_VALUE : (lcb < 0L ? 0 : (int)lcb);
        cb = Math.min(cb, this.available());
        ByteBuffer buffer = this.getByteBuffer();
        int of = buffer.position();
        buffer.position(of + cb);
        return cb;
    }

    public int available() throws IOException {
        try {
            return this.getByteBuffer().remaining();
        }
        catch (NullPointerException e) {
            throw this.potentialStreamClosedException(e);
        }
    }

    public void mark(int readlimit) {
        try {
            this.getByteBuffer().mark();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void reset() throws IOException {
        try {
            this.getByteBuffer().reset();
        }
        catch (NullPointerException e) {
            throw this.potentialStreamClosedException(e);
        }
    }

    public boolean markSupported() {
        return true;
    }

    public void close() throws IOException {
        this.m_buf = null;
    }

    protected NullPointerException potentialStreamClosedException(NullPointerException e) throws IOException {
        if (this.getByteBuffer() == null) {
            throw new IOException("stream closed");
        }
        throw e;
    }
}

