/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.nio;

import com.tangosol.io.AbstractReadBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufferReadBuffer
extends AbstractReadBuffer
implements ReadBuffer {
    private ByteBuffer m_buf;

    public ByteBufferReadBuffer(ByteBuffer buf) {
        this.m_buf = buf;
    }

    public ByteBuffer getByteBuffer() {
        return this.m_buf;
    }

    public int length() {
        return this.getByteBuffer().limit();
    }

    public byte byteAt(int of) {
        return this.getByteBuffer().get(of);
    }

    public void copyBytes(int ofBegin, int ofEnd, byte[] abDest, int ofDest) {
        ByteBuffer buf = this.getByteBuffer();
        buf.position(ofBegin);
        buf.get(abDest, ofDest, ofEnd - ofBegin);
    }

    public byte[] toByteArray(int of, int cb) {
        byte[] abNew;
        this.checkBounds(of, cb);
        if (cb == 0) {
            return NO_BYTES;
        }
        ByteBuffer buf = this.getByteBuffer();
        if (buf.hasArray() && !buf.isReadOnly()) {
            byte[] ab = buf.array();
            if ((of += buf.arrayOffset()) == 0 && cb == ab.length) {
                abNew = ab;
            } else {
                abNew = new byte[cb];
                System.arraycopy(ab, of, abNew, 0, cb);
            }
        } else {
            abNew = new byte[cb];
            buf.position(of);
            buf.get(abNew, 0, cb);
        }
        return abNew;
    }

    public Binary toBinary(int of, int cb) {
        ByteBuffer buf = this.getByteBuffer();
        if (buf.hasArray() && !buf.isReadOnly()) {
            this.checkBounds(of, cb);
            return new Binary(buf.array(), buf.arrayOffset() + of, cb);
        }
        return new Binary(this.toByteArray(of, cb));
    }

    public Object clone() {
        return new ByteBufferReadBuffer(this.getByteBuffer().duplicate());
    }

    protected ReadBuffer instantiateReadBuffer(int of, int cb) {
        ByteBuffer buf = this.getByteBuffer();
        buf.position(of);
        ByteBuffer bufSub = buf.slice();
        bufSub.limit(cb);
        return new ByteBufferReadBuffer(bufSub);
    }

    protected ReadBuffer.BufferInput instantiateBufferInput() {
        ByteBuffer buf = this.getByteBuffer().duplicate();
        buf.position(0);
        buf.mark();
        buf.order(ByteOrder.BIG_ENDIAN);
        return new ByteBufferInput(buf);
    }

    public class ByteBufferInput
    extends AbstractReadBuffer.AbstractBufferInput
    implements ReadBuffer.BufferInput {
        protected ByteBuffer m_buf;

        public ByteBufferInput(ByteBuffer buf) {
            this.m_buf = buf;
        }

        public ByteBuffer getByteBuffer() {
            return this.m_buf;
        }

        public int read() throws IOException {
            ByteBuffer buf = this.getByteBuffer();
            return buf.hasRemaining() ? buf.get() & 0xFF : -1;
        }

        public int read(byte[] abDest, int ofDest, int cbDest) throws IOException {
            if (abDest == null || ofDest < 0 || cbDest < 0 || ofDest + cbDest > abDest.length) {
                if (abDest == null) {
                    throw new IllegalArgumentException("null byte array");
                }
                throw new IllegalArgumentException("abDest.length=" + abDest.length + ", ofDest=" + ofDest + ", cbDest=" + cbDest);
            }
            ByteBuffer buf = this.getByteBuffer();
            int cbMaxSrc = buf.remaining();
            if (cbDest > cbMaxSrc) {
                if (cbMaxSrc == 0) {
                    return -1;
                }
                cbDest = cbMaxSrc;
            }
            buf.get(abDest, ofDest, cbDest);
            return cbDest;
        }

        public void mark(int readlimit) {
            this.getByteBuffer().mark();
        }

        public void reset() throws IOException {
            this.getByteBuffer().reset();
        }

        public int available() throws IOException {
            return this.getByteBuffer().remaining();
        }

        public byte readByte() throws IOException {
            try {
                return this.getByteBuffer().get();
            }
            catch (BufferUnderflowException e) {
                throw new EOFException();
            }
        }

        public short readShort() throws IOException {
            try {
                return this.getByteBuffer().getShort();
            }
            catch (BufferUnderflowException e) {
                throw new EOFException();
            }
        }

        public int readUnsignedShort() throws IOException {
            try {
                return this.getByteBuffer().getShort() & 0xFFFF;
            }
            catch (BufferUnderflowException e) {
                throw new EOFException();
            }
        }

        public char readChar() throws IOException {
            try {
                return this.getByteBuffer().getChar();
            }
            catch (BufferUnderflowException e) {
                throw new EOFException();
            }
        }

        public int readInt() throws IOException {
            try {
                return this.getByteBuffer().getInt();
            }
            catch (BufferUnderflowException e) {
                throw new EOFException();
            }
        }

        public long readLong() throws IOException {
            try {
                return this.getByteBuffer().getLong();
            }
            catch (BufferUnderflowException e) {
                throw new EOFException();
            }
        }

        public float readFloat() throws IOException {
            try {
                return this.getByteBuffer().getFloat();
            }
            catch (BufferUnderflowException e) {
                throw new EOFException();
            }
        }

        public double readDouble() throws IOException {
            try {
                return this.getByteBuffer().getDouble();
            }
            catch (BufferUnderflowException e) {
                throw new EOFException();
            }
        }

        public ReadBuffer readBuffer(int cb) throws IOException {
            if (cb < 0) {
                throw new IllegalArgumentException("cb=" + cb);
            }
            int of = this.getOffset();
            if (this.skip(cb) < (long)cb) {
                throw new EOFException();
            }
            return ByteBufferReadBuffer.this.getReadBuffer(of, cb);
        }

        public int getOffset() {
            return this.getByteBuffer().position();
        }

        public void setOffsetInternal(int of) {
            this.getByteBuffer().position(of);
        }

        protected String convertUTF(int of, int cb) throws IOException {
            byte[] ab;
            ByteBuffer buf = this.getByteBuffer();
            if (buf.hasArray() && !buf.isReadOnly()) {
                ab = buf.array();
                of += buf.arrayOffset();
            } else {
                ab = ByteBufferReadBuffer.this.toByteArray(of, cb);
                of = 0;
            }
            return ExternalizableHelper.convertUTF(ab, of, cb, this.getCharBuf(cb));
        }
    }
}

