/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.nio;

import com.tangosol.io.AbstractWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.nio.ByteBufferReadBuffer;
import com.tangosol.util.Binary;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufferWriteBuffer
extends AbstractWriteBuffer
implements WriteBuffer {
    private ByteBuffer m_buf;
    private transient ByteBufferReadBuffer m_bufUnsafe;

    public ByteBufferWriteBuffer(ByteBuffer buf) {
        if (buf.order() != ByteOrder.BIG_ENDIAN) {
            buf = buf.duplicate();
            buf.order(ByteOrder.BIG_ENDIAN);
        }
        this.m_buf = buf;
    }

    public ByteBuffer getByteBuffer() {
        return this.m_buf;
    }

    public void write(int ofDest, byte b) {
        ByteBuffer buf = this.getByteBuffer();
        int ofCur = buf.position();
        if (ofDest == ofCur) {
            buf.put(b);
        } else {
            buf.put(ofDest, b);
            if (ofDest > ofCur) {
                buf.position(ofDest + 1);
            }
        }
    }

    public void write(int ofDest, byte[] abSrc, int ofSrc, int cbSrc) {
        ByteBuffer buf = this.getByteBuffer();
        int ofCur = buf.position();
        if (ofDest == ofCur) {
            buf.put(abSrc, ofSrc, cbSrc);
        } else {
            int ofEnd = ofDest + cbSrc;
            if (ofEnd > buf.limit()) {
                throw new IndexOutOfBoundsException("ofDest=" + ofDest + ", cbSrc=" + cbSrc + ", getCapacity()=" + buf.limit());
            }
            buf.position(ofDest);
            try {
                buf.put(abSrc, ofSrc, cbSrc);
            }
            catch (RuntimeException e) {
                buf.position(ofCur);
                throw e;
            }
            if (ofEnd < ofCur) {
                buf.position(ofCur);
            }
        }
    }

    public void write(int ofDest, ReadBuffer bufSrc, int ofSrc, int cbSrc) {
        if (bufSrc instanceof ByteBufferReadBuffer) {
            ByteBuffer bufSrcBytes = ((ByteBufferReadBuffer)bufSrc).getByteBuffer();
            if (ofSrc + cbSrc != bufSrcBytes.limit()) {
                bufSrcBytes = bufSrcBytes.duplicate();
                bufSrcBytes.limit(ofSrc + cbSrc);
            }
            bufSrcBytes.position(ofSrc);
            ByteBuffer bufDestBytes = this.getByteBuffer();
            int ofCur = bufDestBytes.position();
            if (ofCur == ofDest) {
                bufDestBytes.put(bufSrcBytes);
            } else {
                int ofEnd = ofDest + cbSrc;
                if (ofEnd > bufDestBytes.limit()) {
                    throw new IndexOutOfBoundsException("ofDest=" + ofDest + ", cbSrc=" + cbSrc + ", getCapacity()=" + bufDestBytes.limit());
                }
                bufDestBytes.position(ofDest);
                try {
                    bufDestBytes.put(bufSrcBytes);
                }
                catch (RuntimeException e) {
                    bufDestBytes.position(ofCur);
                    throw e;
                }
                if (ofEnd < ofCur) {
                    bufDestBytes.position(ofCur);
                }
            }
        } else {
            super.write(ofDest, bufSrc, ofSrc, cbSrc);
        }
    }

    public int length() {
        return this.getByteBuffer().position();
    }

    public void retain(int of, int cb) {
        ByteBuffer buf = this.getByteBuffer();
        int cbBuf = buf.limit();
        if (of < 0 || cb < 0 || of + cb > cbBuf) {
            throw new IndexOutOfBoundsException("of=" + of + ", cb=" + cb + ", getCapacity()=" + cbBuf);
        }
        buf.position(of);
        buf.limit(of + cb);
        buf.compact();
        buf.limit(cbBuf);
        buf.position(cb);
    }

    public int getCapacity() {
        return this.getByteBuffer().limit();
    }

    public WriteBuffer.BufferOutput getBufferOutput(int of) {
        return new ByteBufferOutput(of);
    }

    public ReadBuffer getReadBuffer() {
        return this.toBinary();
    }

    public ReadBuffer getUnsafeReadBuffer() {
        ByteBufferReadBuffer bufUnsafe = this.m_bufUnsafe;
        if (bufUnsafe == null) {
            this.m_bufUnsafe = bufUnsafe = new ByteBufferReadBuffer(this.getByteBuffer().duplicate());
        }
        bufUnsafe.getByteBuffer().limit(this.getByteBuffer().position());
        return bufUnsafe;
    }

    public byte[] toByteArray() {
        return this.getUnsafeReadBuffer().toByteArray();
    }

    public Binary toBinary() {
        return this.getUnsafeReadBuffer().toBinary();
    }

    public Object clone() {
        ByteBuffer bufThis = this.getByteBuffer();
        int cbCur = bufThis.position();
        int cbMax = bufThis.limit();
        ByteBuffer bufThat = bufThis.isDirect() ? ByteBuffer.allocateDirect(cbMax) : ByteBuffer.allocate(cbMax);
        bufThis.limit(cbCur).position(0);
        bufThat.put(bufThis);
        bufThis.limit(cbMax).position(cbCur);
        return new ByteBufferWriteBuffer(bufThat);
    }

    public class ByteBufferOutput
    extends AbstractWriteBuffer.AbstractBufferOutput {
        public ByteBufferOutput(int of) {
            super(of);
        }

        public void writeShort(int n) throws IOException {
            ByteBuffer buf = ByteBufferWriteBuffer.this.getByteBuffer();
            int ofBuf = buf.position();
            int ofStream = this.m_ofWrite;
            int ofFinal = ofStream + 2;
            if (ofBuf == ofStream) {
                buf.putShort((short)n);
            } else if (ofFinal > ofBuf) {
                buf.position(ofStream);
                buf.putShort((short)n);
            } else {
                buf.putShort(ofStream, (short)n);
            }
            this.m_ofWrite = ofFinal;
        }

        public void writeChar(int ch) throws IOException {
            ByteBuffer buf = ByteBufferWriteBuffer.this.getByteBuffer();
            int ofBuf = buf.position();
            int ofStream = this.m_ofWrite;
            int ofFinal = ofStream + 2;
            if (ofBuf == ofStream) {
                buf.putChar((char)ch);
            } else if (ofFinal > ofBuf) {
                buf.position(ofStream);
                buf.putChar((char)ch);
            } else {
                buf.putChar(ofStream, (char)ch);
            }
            this.m_ofWrite = ofFinal;
        }

        public void writeInt(int n) throws IOException {
            ByteBuffer buf = ByteBufferWriteBuffer.this.getByteBuffer();
            int ofBuf = buf.position();
            int ofStream = this.m_ofWrite;
            int ofFinal = ofStream + 4;
            if (ofBuf == ofStream) {
                buf.putInt(n);
            } else if (ofFinal > ofBuf) {
                buf.position(ofStream);
                buf.putInt(n);
            } else {
                buf.putInt(ofStream, n);
            }
            this.m_ofWrite = ofFinal;
        }

        public void writeLong(long l) throws IOException {
            ByteBuffer buf = ByteBufferWriteBuffer.this.getByteBuffer();
            int ofBuf = buf.position();
            int ofStream = this.m_ofWrite;
            int ofFinal = ofStream + 8;
            if (ofBuf == ofStream) {
                buf.putLong(l);
            } else if (ofFinal > ofBuf) {
                buf.position(ofStream);
                buf.putLong(l);
            } else {
                buf.putLong(ofStream, l);
            }
            this.m_ofWrite = ofFinal;
        }

        public void writeFloat(float fl) throws IOException {
            ByteBuffer buf = ByteBufferWriteBuffer.this.getByteBuffer();
            int ofBuf = buf.position();
            int ofStream = this.m_ofWrite;
            int ofFinal = ofStream + 4;
            if (ofBuf == ofStream) {
                buf.putFloat(fl);
            } else if (ofFinal > ofBuf) {
                buf.position(ofStream);
                buf.putFloat(fl);
            } else {
                buf.putFloat(ofStream, fl);
            }
            this.m_ofWrite = ofFinal;
        }

        public void writeDouble(double dfl) throws IOException {
            ByteBuffer buf = ByteBufferWriteBuffer.this.getByteBuffer();
            int ofBuf = buf.position();
            int ofStream = this.m_ofWrite;
            int ofFinal = ofStream + 8;
            if (ofBuf == ofStream) {
                buf.putDouble(dfl);
            } else if (ofFinal > ofBuf) {
                buf.position(ofStream);
                buf.putDouble(dfl);
            } else {
                buf.putDouble(ofStream, dfl);
            }
            this.m_ofWrite = ofFinal;
        }
    }
}

