/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.nio;

import com.tangosol.io.nio.AbstractBufferManager;
import java.nio.ByteBuffer;

public class DirectBufferManager
extends AbstractBufferManager {
    protected static final boolean MODE_DEBUG = false;

    public DirectBufferManager(int cbInitial, int cbMaximum) {
        super(cbInitial, cbMaximum);
        this.allocateBuffer();
    }

    protected void allocateBuffer() {
        ByteBuffer bufOld = this.getBuffer();
        ByteBuffer bufNew = ByteBuffer.allocateDirect(this.getCapacity());
        if (bufOld != null) {
            int ofOld = bufOld.position();
            int cbOld = bufOld.capacity();
            int cbNew = bufNew.capacity();
            bufOld.position(0);
            if (cbOld > cbNew) {
                int cbChunk;
                int cbCopy;
                int cbBuf = Math.max(cbCopy, 16384);
                byte[] abBuf = new byte[cbBuf];
                for (cbCopy = Math.min(cbOld, cbNew); cbCopy > 0; cbCopy -= cbChunk) {
                    cbChunk = Math.min(cbBuf, cbCopy);
                    bufOld.get(abBuf, 0, cbChunk);
                    bufNew.put(abBuf, 0, cbChunk);
                }
            } else {
                bufNew.put(bufOld);
            }
            if (ofOld < cbNew) {
                bufNew.position(ofOld);
            }
        }
        bufOld = null;
        this.setBuffer(null);
        System.gc();
        Thread.yield();
        this.setBuffer(bufNew);
    }
}

