/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.pof.PofBufferReader;
import com.tangosol.io.pof.PofBufferWriter;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PortableObjectSerializer;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.SimpleParser;
import com.tangosol.run.xml.XmlConfigurable;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.SafeHashMap;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class ConfigurablePofContext
implements PofContext,
XmlConfigurable {
    public static final String PROPERTY_CONFIG = "tangosol.pof.config";
    public static final String DEFAULT_RESOURCE = System.getProperty("tangosol.pof.config", "coherence-pof-config.xml");
    private static final Map s_mapConfigurations = Collections.synchronizedMap(new WeakHashMap());
    private WeakReference m_refLoader;
    private String m_sUri;
    private XmlElement m_xml;
    private PofConfig m_cfg;
    private boolean m_fInterfaceAllowed;
    private boolean m_fSubclassAllowed;
    static /* synthetic */ Class class$com$tangosol$io$pof$PortableObject;
    static /* synthetic */ Class class$com$tangosol$io$pof$PofSerializer;

    public ConfigurablePofContext() {
        this((String)null);
    }

    public ConfigurablePofContext(String sLocator) {
        this.m_sUri = sLocator;
    }

    public ConfigurablePofContext(XmlElement xml) {
        this.setConfig(xml);
    }

    public XmlElement getConfig() {
        this.ensureInitialized();
        return this.m_cfg.m_xml;
    }

    public synchronized void setConfig(XmlElement xml) {
        this.checkNotInitialized();
        if (this.m_sUri == null) {
            this.m_sUri = "xml:" + Base.toDecString(((Object)xml).toString().hashCode(), 8);
        }
        this.m_xml = xml;
    }

    public ClassLoader getContextClassLoader() {
        ClassLoader loader = null;
        WeakReference ref = this.m_refLoader;
        if (ref != null && (loader = (ClassLoader)ref.get()) == null) {
            throw new IllegalStateException("ClassLoader is no longer available");
        }
        return loader;
    }

    public synchronized void setContextClassLoader(ClassLoader loader) {
        this.checkNotInitialized();
        this.m_refLoader = loader == null ? null : new WeakReference<ClassLoader>(loader);
        this.initialize();
    }

    public void serialize(WriteBuffer.BufferOutput out, Object o) throws IOException {
        PofBufferWriter writer = new PofBufferWriter(out, (PofContext)this);
        writer.writeObject(-1, o);
    }

    public Object deserialize(ReadBuffer.BufferInput in) throws IOException {
        PofBufferReader reader = new PofBufferReader(in, this);
        return reader.readObject(-1);
    }

    public PofSerializer getPofSerializer(int nTypeId) {
        PofSerializer serializer;
        this.ensureInitialized();
        try {
            serializer = this.m_cfg.m_aserByTypeId[nTypeId];
        }
        catch (IndexOutOfBoundsException e) {
            serializer = null;
        }
        if (serializer == null) {
            throw new IllegalArgumentException("unknown user type: " + nTypeId);
        }
        return serializer;
    }

    public int getUserTypeIdentifier(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        return this.getUserTypeIdentifier(o.getClass());
    }

    public int getUserTypeIdentifier(Class clz) {
        int nTypeId = this.getUserTypeIdentifierInternal(clz);
        if (nTypeId < 0) {
            throw new IllegalArgumentException("unknown user type: " + clz.getName());
        }
        return nTypeId;
    }

    public int getUserTypeIdentifier(String sClass) {
        int nTypeId = this.getUserTypeIdentifierInternal(sClass);
        if (nTypeId < 0) {
            throw new IllegalArgumentException("unknown user type: " + sClass);
        }
        return nTypeId;
    }

    public String getClassName(int nTypeId) {
        return this.getClass(nTypeId).getName();
    }

    public Class getClass(int nTypeId) {
        WeakReference refClass;
        this.ensureInitialized();
        try {
            refClass = this.m_cfg.m_arefClassByTypeId[nTypeId];
        }
        catch (IndexOutOfBoundsException e) {
            refClass = null;
        }
        if (refClass == null) {
            throw new IllegalArgumentException("unknown user type: " + nTypeId);
        }
        Class clz = (Class)refClass.get();
        if (clz == null) {
            throw new IllegalStateException("Class for user type " + nTypeId + " is no longer available");
        }
        return clz;
    }

    public boolean isUserType(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        return this.isUserType(o.getClass());
    }

    public boolean isUserType(Class clz) {
        return this.getUserTypeIdentifierInternal(clz) >= 0;
    }

    public boolean isUserType(String sClass) {
        return this.getUserTypeIdentifierInternal(sClass) >= 0;
    }

    protected int getUserTypeIdentifierInternal(Class clz) {
        int nTypeId;
        block7: {
            this.ensureInitialized();
            nTypeId = -1;
            Map mapClzToId = this.m_cfg.m_mapTypeIdByClass;
            Integer ITypeId = (Integer)mapClzToId.get(clz);
            if (ITypeId == null) {
                if (clz == null) {
                    throw new IllegalArgumentException("class is required");
                }
                if (this.isSubclassAllowed()) {
                    for (Class clzSuper = clz.getSuperclass(); clzSuper != null; clzSuper = clzSuper.getSuperclass()) {
                        ITypeId = (Integer)mapClzToId.get(clzSuper);
                        if (ITypeId == null) continue;
                        nTypeId = ITypeId;
                        mapClzToId.put(clz, ITypeId);
                        break block7;
                    }
                }
                if (this.isInterfaceAllowed()) {
                    Iterator iter = mapClzToId.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        Class clzCur = (Class)entry.getKey();
                        Integer ICurId = (Integer)entry.getValue();
                        if (clzCur == null || ICurId == null || !clzCur.isInterface() || !clzCur.isAssignableFrom(clz)) continue;
                        nTypeId = ICurId;
                        mapClzToId.put(clz, ICurId);
                        break;
                    }
                }
            } else {
                nTypeId = ITypeId;
            }
        }
        return nTypeId;
    }

    protected int getUserTypeIdentifierInternal(String sClass) {
        this.ensureInitialized();
        int nTypeId = -1;
        Map mapNameToId = this.m_cfg.m_mapTypeIdByClassName;
        Integer ITypeId = (Integer)mapNameToId.get(sClass);
        if (ITypeId == null) {
            if (sClass == null || sClass.length() == 0) {
                throw new IllegalArgumentException("class name is required");
            }
            if ((this.isSubclassAllowed() || this.isInterfaceAllowed()) && (nTypeId = this.getUserTypeIdentifier(this.loadClass(sClass))) >= 0) {
                mapNameToId.put(sClass, Base.makeInteger(nTypeId));
            }
        } else {
            nTypeId = ITypeId;
        }
        return nTypeId;
    }

    protected boolean isInitialized() {
        return this.m_cfg != null;
    }

    protected String getConfigLocation() {
        return this.m_sUri;
    }

    protected PofConfig getPofConfig() {
        return this.m_cfg;
    }

    protected boolean isInterfaceAllowed() {
        return this.m_fInterfaceAllowed;
    }

    protected boolean isSubclassAllowed() {
        return this.m_fSubclassAllowed;
    }

    protected void checkNotInitialized() {
        if (this.m_cfg != null) {
            throw new IllegalStateException("already initialized");
        }
    }

    protected void ensureInitialized() {
        if (this.m_cfg == null) {
            this.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void initialize() {
        if (this.m_cfg == null) {
            PofConfig cfg;
            Map mapConfigByURI;
            Map mapConfigByLoader;
            Map map = mapConfigByLoader = s_mapConfigurations;
            synchronized (map) {
                ClassLoader loader = this.getContextClassLoader();
                mapConfigByURI = (Map)mapConfigByLoader.get(loader);
                if (mapConfigByURI == null) {
                    mapConfigByURI = new SafeHashMap();
                    mapConfigByLoader.put(loader, mapConfigByURI);
                }
            }
            String sURI = this.m_sUri;
            if (sURI == null) {
                this.m_sUri = sURI = DEFAULT_RESOURCE;
            }
            if ((cfg = (PofConfig)mapConfigByURI.get(sURI)) == null) {
                cfg = this.createPofConfig();
                Map map2 = mapConfigByURI;
                synchronized (map2) {
                    if (mapConfigByURI.containsKey(sURI)) {
                        cfg = (PofConfig)mapConfigByURI.get(sURI);
                    } else {
                        mapConfigByURI.put(sURI, cfg);
                    }
                }
            }
            XmlElement xml = cfg.m_xml;
            this.m_fInterfaceAllowed = xml.getSafeElement("allow-interfaces").getBoolean();
            this.m_fSubclassAllowed = xml.getSafeElement("allow-subclasses").getBoolean();
            this.m_cfg = cfg;
            this.m_xml = xml;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected PofConfig createPofConfig() {
        String sURI = this.m_sUri;
        XmlElement xmlConfig = this.m_xml;
        if (xmlConfig == null) {
            URL url = this.loadResource(sURI);
            if (url == null) {
                this.report(sURI, -1, null, null, "Missing POF configuration");
            }
            try {
                xmlConfig = new SimpleParser().parseXml(url.openStream());
            }
            catch (IOException e) {
                this.report(sURI, -1, null, e, "Failed to parse POF configuration");
            }
        }
        boolean fAllowInterfaces = xmlConfig.getSafeElement("allow-interfaces").getBoolean();
        boolean fAllowSubclasses = xmlConfig.getSafeElement("allow-subclasses").getBoolean();
        XmlElement xmlAllTypes = xmlConfig.getElement("user-type-list");
        if (xmlAllTypes == null) {
            this.report(sURI, -1, null, null, "Missing <user-type-list> element");
        }
        ArrayList<String> listURI = null;
        while (xmlAllTypes.getElement("include") != null) {
            if (listURI == null) {
                listURI = new ArrayList<String>();
                listURI.add(sURI);
            }
            ArrayList<XmlDocument> listInclude = new ArrayList<XmlDocument>();
            Iterator iter = xmlAllTypes.getElements("include");
            while (iter.hasNext()) {
                String sIncludeURI = ((XmlElement)iter.next()).getString();
                iter.remove();
                if (listURI.contains(sIncludeURI)) {
                    this.report(sIncludeURI, -1, null, null, "Duplicate included POF configuration");
                } else {
                    listURI.add(sIncludeURI);
                }
                URL urlInclude = this.loadResource(sIncludeURI);
                if (urlInclude == null) {
                    this.report(sIncludeURI, -1, null, null, "Missing included POF configuration");
                }
                try {
                    listInclude.add(new SimpleParser().parseXml(urlInclude.openStream()));
                }
                catch (IOException e) {
                    this.report(sIncludeURI, -1, null, e, "Failed to parse included POF configuration");
                }
            }
            iter = listInclude.iterator();
            while (iter.hasNext()) {
                XmlElement xmlIncludeTypes = ((XmlElement)iter.next()).getSafeElement("user-type-list");
                XmlHelper.addElements(xmlAllTypes, xmlIncludeTypes.getElements("user-type"));
                XmlHelper.addElements(xmlAllTypes, xmlIncludeTypes.getElements("include"));
            }
        }
        List listTypes = xmlAllTypes.getElementList();
        int nMaxTypeId = -1;
        boolean fSomeMissing = false;
        boolean fSomePresent = false;
        Iterator iter = listTypes.iterator();
        while (iter.hasNext()) {
            XmlElement xmlId;
            XmlElement xmlType = (XmlElement)iter.next();
            if (!xmlType.getName().equals("user-type")) {
                this.report(sURI, -1, null, null, "<user-type-list> contains an illegal element: " + xmlType.getName());
            }
            if ((xmlId = xmlType.getElement("type-id")) == null) {
                fSomeMissing = true;
                if (!fSomePresent) continue;
                this.report(sURI, -1, null, null, "<user-type-list> contains a <user-type> that is missing a type ID value");
                continue;
            }
            int nTypeId = xmlId.getInt(-1);
            if (nTypeId < 0) {
                this.report(sURI, -1, null, null, "<user-type-list> contains a <user-type> that has a missing or invalid type ID value: " + xmlId.getString(null));
            }
            fSomePresent = true;
            if (fSomeMissing) {
                this.report(sURI, -1, null, null, "<user-type-list> contains a <user-type> that is missing a type ID value");
            }
            if (nTypeId <= nMaxTypeId) continue;
            nMaxTypeId = nTypeId;
        }
        boolean fAutoNumber = fSomeMissing;
        int cElements = fAutoNumber ? listTypes.size() : nMaxTypeId + 1;
        Map<Class, Integer> mapTypeIdByClass = Collections.synchronizedMap(new WeakHashMap());
        SafeHashMap mapTypeIdByClassName = new SafeHashMap();
        WeakReference[] arefClassByTypeId = new WeakReference[cElements];
        PofSerializer[] aserByTypeId = new PofSerializer[cElements];
        int cTypeIds = 0;
        Iterator iter2 = listTypes.iterator();
        while (iter2.hasNext()) {
            void var24_34;
            Class clz;
            String sClass;
            int nTypeId;
            XmlElement xmlType = (XmlElement)iter2.next();
            int n = nTypeId = fAutoNumber ? cTypeIds : xmlType.getElement("type-id").getInt();
            if (arefClassByTypeId[nTypeId] != null) {
                this.report(sURI, nTypeId, null, null, "Duplicate user type id");
            }
            if ((sClass = xmlType.getElement("class-name").getString()) == null || sClass.length() == 0) {
                this.report(sURI, nTypeId, null, null, "Missing class name");
            }
            final Integer ITypeId = Base.makeInteger(nTypeId);
            try {
                clz = this.loadClass(sClass);
            }
            catch (RuntimeException e) {
                throw this.report(sURI, nTypeId, sClass, e, "Unable to load class for user type");
            }
            if (!fAllowInterfaces && clz.isInterface()) {
                throw this.report(sURI, nTypeId, sClass, null, "User Type cannot be an interface (allow-interfaces=false)");
            }
            if (!fAllowSubclasses && Modifier.isAbstract(clz.getModifiers())) {
                throw this.report(sURI, nTypeId, sClass, null, "User Type cannot be an abstract class (allow-subclasses=false)");
            }
            XmlElement xmlSer = xmlType.getElement("serializer");
            if (xmlSer == null) {
                if (!(class$com$tangosol$io$pof$PortableObject == null ? ConfigurablePofContext.class$("com.tangosol.io.pof.PortableObject") : class$com$tangosol$io$pof$PortableObject).isAssignableFrom(clz)) throw this.report(sURI, nTypeId, sClass, null, "Missing PofSerializer configuration");
                PortableObjectSerializer portableObjectSerializer = new PortableObjectSerializer(nTypeId);
            } else {
                Iterator iterParam;
                Class clzSer;
                String sSerClass = xmlSer.getElement("class-name").getString();
                if (sSerClass == null || sSerClass.length() == 0) {
                    this.report(sURI, nTypeId, sClass, null, "Missing PofSerializer class name");
                }
                try {
                    clzSer = this.loadClass(sSerClass);
                }
                catch (RuntimeException e) {
                    throw this.report(sURI, nTypeId, sClass, e, "Unable to load PofSerializer class: " + sSerClass);
                }
                if (!(class$com$tangosol$io$pof$PofSerializer == null ? ConfigurablePofContext.class$("com.tangosol.io.pof.PofSerializer") : class$com$tangosol$io$pof$PofSerializer).isAssignableFrom(clzSer)) {
                    throw this.report(sURI, nTypeId, sClass, null, "Class is not a PofSerializer: " + sSerClass);
                }
                XmlElement xmlParams = xmlSer.getElement("init-params");
                if (xmlParams == null || (iterParam = xmlParams.getElements("init-param")).hasNext() && ((XmlElement)iterParam.next()).getElement("param-type") == null) {
                    try {
                        PofSerializer pofSerializer = (PofSerializer)ClassHelper.newInstance(clzSer, new Object[]{ITypeId, clz, this.getContextClassLoader()});
                    }
                    catch (Throwable e) {
                        try {
                            PofSerializer pofSerializer = (PofSerializer)ClassHelper.newInstance(clzSer, new Object[]{ITypeId, clz});
                        }
                        catch (Throwable e2) {
                            try {
                                PofSerializer pofSerializer = (PofSerializer)ClassHelper.newInstance(clzSer, new Object[]{ITypeId});
                            }
                            catch (Throwable e3) {
                                try {
                                    PofSerializer pofSerializer = (PofSerializer)clzSer.newInstance();
                                }
                                catch (Throwable e4) {
                                    throw this.report(sURI, nTypeId, sClass, e4, "Unable to instantiate PofSerializer class using predefined constructors: " + sSerClass);
                                }
                            }
                        }
                    }
                } else {
                    Object[] aoParams;
                    XmlHelper.ParameterResolver resolver = new XmlHelper.ParameterResolver(){

                        public Object resolveParameter(String sType, String sValue) {
                            if (sValue.equals("{type-id}")) {
                                return ITypeId;
                            }
                            if (sValue.equals("{class-name}")) {
                                return sClass;
                            }
                            if (sValue.equals("{class}")) {
                                return clz;
                            }
                            if (sValue.equals("{class-loader}")) {
                                return ConfigurablePofContext.this.getContextClassLoader();
                            }
                            return sValue;
                        }
                    };
                    try {
                        aoParams = XmlHelper.parseInitParams(xmlParams, resolver);
                    }
                    catch (RuntimeException e) {
                        throw this.report(sURI, nTypeId, sClass, e, "Error parsing constructor parameters for PofSerializer:" + sSerClass);
                    }
                    try {
                        PofSerializer pofSerializer = (PofSerializer)ClassHelper.newInstance(clzSer, aoParams);
                    }
                    catch (Throwable e) {
                        throw this.report(sURI, nTypeId, sClass, e, "Unable to instantiate PofSerializer class: " + sSerClass);
                    }
                }
            }
            if (var24_34 instanceof XmlConfigurable) {
                try {
                    SimpleElement xmlParams = new SimpleElement("config");
                    XmlHelper.transformInitParams(xmlParams, xmlSer.getSafeElement("init-params"));
                    ((XmlConfigurable)var24_34).setConfig(xmlParams);
                }
                catch (RuntimeException e) {
                    this.report(sURI, nTypeId, sClass, e, "Unable to configure PofSerializer");
                }
            }
            if (var24_34 instanceof ClassLoaderAware) {
                try {
                    ((ClassLoaderAware)var24_34).setContextClassLoader(this.getContextClassLoader());
                }
                catch (RuntimeException e) {
                    this.report(sURI, nTypeId, sClass, e, "Unable to set ContextClassLoader for PofSerializer");
                }
            }
            mapTypeIdByClass.put(clz, ITypeId);
            mapTypeIdByClassName.put(sClass, ITypeId);
            arefClassByTypeId[nTypeId] = new WeakReference<Class>(clz);
            aserByTypeId[nTypeId] = var24_34;
            ++cTypeIds;
        }
        PofConfig cfg = new PofConfig();
        cfg.m_xml = xmlConfig;
        cfg.m_mapTypeIdByClass = mapTypeIdByClass;
        cfg.m_mapTypeIdByClassName = mapTypeIdByClassName;
        cfg.m_arefClassByTypeId = arefClassByTypeId;
        cfg.m_aserByTypeId = aserByTypeId;
        return cfg;
    }

    protected Class loadClass(String sClass) {
        try {
            return ExternalizableHelper.loadClass(sClass, this.getContextClassLoader(), null);
        }
        catch (ClassNotFoundException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected URL loadResource(String sURI) {
        URL url = ExternalizableHelper.loadResource(sURI, this.getContextClassLoader(), null);
        if (url == null) {
            try {
                url = new URL(sURI);
                url.openStream().close();
            }
            catch (Exception e) {
                url = null;
            }
        }
        return url;
    }

    protected RuntimeException report(String sURI, int nTypeId, String sClass, Throwable e, String sText) {
        StringBuffer sb = new StringBuffer();
        if (sURI != null && sURI.length() > 0) {
            sb.append("Config=").append(sURI);
        }
        if (nTypeId >= 0) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("Type-Id=").append(nTypeId);
        }
        if (sClass != null && sClass.length() > 0) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("Class-Name=").append(sClass);
        }
        if (sb.length() > 0) {
            sText = sText + " (" + sb + ')';
        }
        throw e == null ? new IllegalStateException(sText) : Base.ensureRuntimeException(e, sText);
    }

    protected static class PofConfig {
        public XmlElement m_xml;
        public Map m_mapTypeIdByClass;
        public Map m_mapTypeIdByClassName;
        public WeakReference[] m_arefClassByTypeId;
        public PofSerializer[] m_aserByTypeId;

        protected PofConfig() {
        }
    }
}

