/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.pof.PofHelper;
import com.tangosol.io.pof.PofInputStream;
import com.tangosol.io.pof.PofOutputStream;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import java.io.Externalizable;
import java.io.IOException;

public class ExternalizablePofSerializer
extends PofHelper
implements PofSerializer {
    protected final int m_nTypeId;

    public ExternalizablePofSerializer(int nTypeId) {
        ExternalizablePofSerializer.azzert(nTypeId >= 0, "user type identifier cannot be negative");
        this.m_nTypeId = nTypeId;
    }

    public void serialize(PofWriter out, Object o) throws IOException {
        Externalizable externalizable;
        try {
            externalizable = (Externalizable)o;
        }
        catch (ClassCastException e) {
            String sClass = null;
            try {
                sClass = out.getPofContext().getClassName(this.m_nTypeId);
            }
            catch (Exception eIgnore) {
                // empty catch block
            }
            String sActual = null;
            try {
                sActual = o.getClass().getName();
            }
            catch (Exception eIgnore) {
                // empty catch block
            }
            throw new IOException("An exception occurred writing an Externalizable user type to a POF stream: type-id=" + this.m_nTypeId + (sClass == null ? "" : ", class-name=" + sClass) + (sActual == null ? "" : ", actual class-name=" + sActual) + ", exception=\n" + e);
        }
        externalizable.writeExternal(new PofOutputStream(out));
        out.writeRemainder(null);
    }

    public Object deserialize(PofReader in) throws IOException {
        Externalizable externalizable;
        try {
            externalizable = (Externalizable)in.getPofContext().getClass(this.m_nTypeId).newInstance();
        }
        catch (Exception e) {
            String sClass = null;
            try {
                sClass = in.getPofContext().getClassName(this.m_nTypeId);
            }
            catch (Exception eIgnore) {
                // empty catch block
            }
            throw new IOException("An exception occurred instantiating an Externalizable user type from a POF stream: type-id=" + this.m_nTypeId + (sClass == null ? "" : ", class-name=" + sClass) + ", exception=\n" + e);
        }
        try {
            externalizable.readExternal(new PofInputStream(in));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            String sClass = null;
            try {
                sClass = in.getPofContext().getClassName(this.m_nTypeId);
            }
            catch (Exception eIgnore) {
                // empty catch block
            }
            throw new IOException("An exception occurred reading an Externalizable user type from a POF stream: type-id=" + this.m_nTypeId + (sClass == null ? "" : ", class-name=" + sClass) + ", exception=\n" + e);
        }
        in.readRemainder();
        return externalizable;
    }
}

