/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.pof.PofHandler;
import com.tangosol.io.pof.PofHelper;
import com.tangosol.io.pof.RawQuad;
import com.tangosol.util.Binary;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.BigInteger;

public class LoggingPofHandler
extends PofHelper
implements PofHandler {
    private PrintWriter m_writer;
    private int m_cDepth;
    private String m_sIndent = "";
    private String m_sIdInfo;

    public LoggingPofHandler() {
    }

    public LoggingPofHandler(PrintWriter writer) {
        this.setPrintWriter(writer);
    }

    public void registerIdentity(int nId) {
        String sIdInfo = this.m_sIdInfo;
        sIdInfo = sIdInfo == null ? String.valueOf(nId) : sIdInfo + ", " + nId;
        this.m_sIdInfo = sIdInfo;
    }

    public void onNullReference(int iPos) {
        this.show(iPos, "null");
    }

    public void onIdentityReference(int iPos, int nId) {
        this.show(iPos, "reference=" + nId);
    }

    public void onInt16(int iPos, short n) {
        this.show(iPos, "int16=" + n + " (0x" + Integer.toHexString(n).toUpperCase() + ")");
    }

    public void onInt32(int iPos, int n) {
        this.show(iPos, "int32=" + n + " (0x" + Integer.toHexString(n).toUpperCase() + ")");
    }

    public void onInt64(int iPos, long n) {
        this.show(iPos, "int64=" + n + " (0x" + Long.toHexString(n).toUpperCase() + ")");
    }

    public void onInt128(int iPos, BigInteger n) {
        this.show(iPos, "int128=" + n);
    }

    public void onFloat32(int iPos, float fl) {
        this.show(iPos, "float32=" + fl);
    }

    public void onFloat64(int iPos, double dfl) {
        this.show(iPos, "float64=" + dfl);
    }

    public void onFloat128(int iPos, RawQuad qfl) {
        this.show(iPos, "float128 (bits)=" + qfl.getBits());
    }

    public void onDecimal32(int iPos, BigDecimal dec) {
        this.show(iPos, "decimal32=" + dec);
    }

    public void onDecimal64(int iPos, BigDecimal dec) {
        this.show(iPos, "decimal64=" + dec);
    }

    public void onDecimal128(int iPos, BigDecimal dec) {
        this.show(iPos, "decimal128=" + dec);
    }

    public void onBoolean(int iPos, boolean f) {
        this.show(iPos, "boolean=" + f);
    }

    public void onOctet(int iPos, int b) {
        this.show(iPos, "octet=" + (b & 0xFF) + " (0x" + LoggingPofHandler.toHex(b) + ")");
    }

    public void onOctetString(int iPos, Binary bin) {
        if (bin.length() > 16) {
            this.show(iPos, "binary=Binary(length=" + bin.length() + ", value=");
            this.print(LoggingPofHandler.indentString(LoggingPofHandler.toHexDump(bin.toByteArray(), 16), this.getIndent() + "    "));
        } else {
            this.show(iPos, "binary=" + bin);
        }
    }

    public void onChar(int iPos, char ch) {
        this.show(iPos, "char=" + LoggingPofHandler.toQuotedCharEscape(ch) + " (" + ch + " / 0x" + Integer.toHexString(ch).toUpperCase() + ")");
    }

    public void onCharString(int iPos, String s) {
        this.show(iPos, "char-string=" + LoggingPofHandler.toQuotedStringEscape(s));
    }

    public void onDate(int iPos, int nYear, int nMonth, int nDay) {
        this.show(iPos, "date=" + LoggingPofHandler.formatDate(nYear, nMonth, nDay));
    }

    public void onYearMonthInterval(int iPos, int cYears, int cMonths) {
        this.show(iPos, "year-month-inteval=" + cYears + "Y" + cMonths + "M");
    }

    public void onTime(int iPos, int nHour, int nMinute, int nSecond, int nNano, boolean fUTC) {
        this.show(iPos, "time=" + LoggingPofHandler.formatTime(nHour, nMinute, nSecond, nNano, fUTC));
    }

    public void onTime(int iPos, int nHour, int nMinute, int nSecond, int nNano, int nHourOffset, int nMinuteOffset) {
        this.show(iPos, "time=" + LoggingPofHandler.formatTime(nHour, nMinute, nSecond, nNano, nHourOffset, nMinuteOffset));
    }

    public void onTimeInterval(int iPos, int cHours, int cMinutes, int cSeconds, int cNanos) {
        this.show(iPos, "time-interval=" + LoggingPofHandler.formatTime(cHours, cMinutes, cSeconds, cNanos, false));
    }

    public void onDateTime(int iPos, int nYear, int nMonth, int nDay, int nHour, int nMinute, int nSecond, int nNano, boolean fUTC) {
        this.show(iPos, "date-time=" + LoggingPofHandler.formatDate(nYear, nMonth, nDay) + ' ' + LoggingPofHandler.formatTime(nHour, nMinute, nSecond, nNano, fUTC));
    }

    public void onDateTime(int iPos, int nYear, int nMonth, int nDay, int nHour, int nMinute, int nSecond, int nNano, int nHourOffset, int nMinuteOffset) {
        this.show(iPos, "date-time=" + LoggingPofHandler.formatDate(nYear, nMonth, nDay) + ' ' + LoggingPofHandler.formatTime(nHour, nMinute, nSecond, nNano, nHourOffset, nMinuteOffset));
    }

    public void onDayTimeInterval(int iPos, int cDays, int cHours, int cMinutes, int cSeconds, int cNanos) {
        this.show(iPos, "day-time-interval=" + cDays + "T" + LoggingPofHandler.formatTime(cHours, cMinutes, cSeconds, cNanos, false));
    }

    public void beginCollection(int iPos, int cElements) {
        this.begin(iPos, "collection[" + cElements + "]");
    }

    public void beginUniformCollection(int iPos, int cElements, int nType) {
        this.begin(iPos, "uniform-collection[" + cElements + "] (type-id=" + nType + ")");
    }

    public void beginArray(int iPos, int cElements) {
        this.begin(iPos, "array[" + cElements + "]");
    }

    public void beginUniformArray(int iPos, int cElements, int nType) {
        this.begin(iPos, "uniform-array[" + cElements + "] (type-id=" + nType + ")");
    }

    public void beginSparseArray(int iPos, int cElements) {
        this.begin(iPos, "sparse-array[" + cElements + "]");
    }

    public void beginUniformSparseArray(int iPos, int cElements, int nType) {
        this.begin(iPos, "uniform-sparse-array[" + cElements + "] (type-id=" + nType + ")");
    }

    public void beginMap(int iPos, int cElements) {
        this.begin(iPos, "uniform-map[" + cElements + "]");
    }

    public void beginUniformKeysMap(int iPos, int cElements, int nTypeKeys) {
        this.begin(iPos, "uniform-keys-map[" + cElements + "] (key type-id=" + nTypeKeys + ")");
    }

    public void beginUniformMap(int iPos, int cElements, int nTypeKeys, int nTypeValues) {
        this.begin(iPos, "uniform-map[" + cElements + "] (key type-id=" + nTypeKeys + ", value type-id=" + nTypeValues + ")");
    }

    public void beginUserType(int iPos, int nUserTypeId, int nVersionId) {
        this.begin(iPos, "user-type " + nUserTypeId + " (v" + nVersionId + ")");
    }

    public void endComplexValue() {
        this.end();
    }

    public PrintWriter getPrintWriter() {
        return this.m_writer;
    }

    public void setPrintWriter(PrintWriter writer) {
        this.m_writer = writer;
    }

    protected int getDepth() {
        return this.m_cDepth;
    }

    protected String getIndent() {
        return this.m_sIndent;
    }

    protected void begin(int iPos, String s) {
        this.show(iPos, s);
        this.adjustDepth(1);
    }

    protected void end() {
        this.adjustDepth(-1);
    }

    protected void adjustDepth(int cDelta) {
        int cDepth;
        if (cDelta < 0) {
            this.show(-1, "}");
        }
        this.m_cDepth = cDepth = Math.max(0, this.m_cDepth + cDelta);
        this.m_sIndent = LoggingPofHandler.dup("  ", cDepth);
        if (cDelta > 0) {
            this.show(-1, "{");
        }
    }

    protected void show(int iPos, String s) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_sIndent);
        if (iPos >= 0 && this.m_cDepth > 0) {
            sb.append('[').append(iPos).append("]=");
        }
        sb.append(s);
        String sIdInfo = this.m_sIdInfo;
        if (sIdInfo != null) {
            sb.append("    ; id=").append(sIdInfo);
            this.m_sIdInfo = null;
        }
        this.print(sb.toString());
    }

    protected void print(String s) {
        PrintWriter writer = this.m_writer;
        if (writer == null) {
            LoggingPofHandler.out(s);
        } else {
            writer.println(s);
        }
    }
}

