/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.WriteBuffer;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofHelper;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.RawDate;
import com.tangosol.io.pof.RawDateTime;
import com.tangosol.io.pof.RawDayTimeInterval;
import com.tangosol.io.pof.RawQuad;
import com.tangosol.io.pof.RawTime;
import com.tangosol.io.pof.RawTimeInterval;
import com.tangosol.io.pof.RawYearMonthInterval;
import com.tangosol.io.pof.WritingPofHandler;
import com.tangosol.util.Binary;
import com.tangosol.util.LongArray;
import com.tangosol.util.WrapperException;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class PofBufferWriter
extends PofHelper
implements PofWriter {
    protected WriteBuffer.BufferOutput m_out;
    protected PofContext m_ctx;
    protected WritingPofHandler m_handler;
    static /* synthetic */ Class class$com$tangosol$io$pof$PofBufferWriter;

    public PofBufferWriter(WriteBuffer.BufferOutput out, PofContext ctx) {
        PofBufferWriter.azzert(out != null, "BufferOutput cannot be null");
        PofBufferWriter.azzert(ctx != null, "PofContext cannot be null");
        this.m_out = out;
        this.m_ctx = ctx;
        this.m_handler = new WritingPofHandler(out);
    }

    public PofBufferWriter(WritingPofHandler handler, PofContext ctx) {
        PofBufferWriter.azzert(handler != null, "WritingPofHandler cannot be null");
        PofBufferWriter.azzert(ctx != null, "PofContext cannot be null");
        this.m_out = handler.getBufferOutput();
        this.m_ctx = ctx;
        this.m_handler = handler;
    }

    public void writeBoolean(int iProp, boolean f) throws IOException {
        this.beginProperty(iProp);
        try {
            this.getPofHandler().onBoolean(iProp, f);
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeByte(int iProp, byte b) throws IOException {
        this.beginProperty(iProp);
        try {
            this.getPofHandler().onOctet(iProp, b);
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeChar(int iProp, char ch) throws IOException {
        this.beginProperty(iProp);
        try {
            this.getPofHandler().onChar(iProp, ch);
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeShort(int iProp, short n) throws IOException {
        this.beginProperty(iProp);
        try {
            this.getPofHandler().onInt16(iProp, n);
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeInt(int iProp, int n) throws IOException {
        this.beginProperty(iProp);
        try {
            this.getPofHandler().onInt32(iProp, n);
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeLong(int iProp, long n) throws IOException {
        this.beginProperty(iProp);
        try {
            this.getPofHandler().onInt64(iProp, n);
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeFloat(int iProp, float fl) throws IOException {
        this.beginProperty(iProp);
        try {
            this.getPofHandler().onFloat32(iProp, fl);
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeDouble(int iProp, double dfl) throws IOException {
        this.beginProperty(iProp);
        try {
            this.getPofHandler().onFloat64(iProp, dfl);
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeBooleanArray(int iProp, boolean[] af) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (af == null) {
                handler.onNullReference(iProp);
            } else {
                int cElements = af.length;
                handler.registerIdentity(-1);
                handler.beginUniformArray(iProp, cElements, -11);
                for (int i = 0; i < cElements; ++i) {
                    handler.onBoolean(i, af[i]);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeByteArray(int iProp, byte[] ab) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (ab == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.beginUniformArray(iProp, ab.length, -12);
                this.getBufferOutput().write(ab);
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeCharArray(int iProp, char[] ach) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (ach == null) {
                handler.onNullReference(iProp);
            } else {
                int cElements = ach.length;
                handler.registerIdentity(-1);
                handler.beginUniformArray(iProp, cElements, -14);
                for (int i = 0; i < cElements; ++i) {
                    handler.onChar(i, ach[i]);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeShortArray(int iProp, short[] an) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (an == null) {
                handler.onNullReference(iProp);
            } else {
                int cElements = an.length;
                handler.registerIdentity(-1);
                handler.beginUniformArray(iProp, cElements, -1);
                for (int i = 0; i < cElements; ++i) {
                    handler.onInt16(i, an[i]);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeIntArray(int iProp, int[] an) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (an == null) {
                handler.onNullReference(iProp);
            } else {
                int cElements = an.length;
                handler.registerIdentity(-1);
                handler.beginUniformArray(iProp, cElements, -2);
                for (int i = 0; i < cElements; ++i) {
                    handler.onInt32(i, an[i]);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeLongArray(int iProp, long[] an) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (an == null) {
                handler.onNullReference(iProp);
            } else {
                int cElements = an.length;
                handler.registerIdentity(-1);
                handler.beginUniformArray(iProp, cElements, -3);
                for (int i = 0; i < cElements; ++i) {
                    handler.onInt64(i, an[i]);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeFloatArray(int iProp, float[] afl) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (afl == null) {
                handler.onNullReference(iProp);
            } else {
                int cElements = afl.length;
                handler.registerIdentity(-1);
                handler.beginUniformArray(iProp, cElements, -5);
                for (int i = 0; i < cElements; ++i) {
                    handler.onFloat32(i, afl[i]);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeDoubleArray(int iProp, double[] adfl) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (adfl == null) {
                handler.onNullReference(iProp);
            } else {
                int cElements = adfl.length;
                handler.registerIdentity(-1);
                handler.beginUniformArray(iProp, cElements, -6);
                for (int i = 0; i < cElements; ++i) {
                    handler.onFloat64(i, adfl[i]);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeBigInteger(int iProp, BigInteger n) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (n == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onInt128(iProp, n);
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeRawQuad(int iProp, RawQuad qfl) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (qfl == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onFloat128(iProp, qfl);
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeBigDecimal(int iProp, BigDecimal dec) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dec == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                switch (PofBufferWriter.calcDecimalSize(dec)) {
                    case 4: {
                        handler.onDecimal32(iProp, dec);
                        break;
                    }
                    case 8: {
                        handler.onDecimal64(iProp, dec);
                        break;
                    }
                    case 16: {
                        handler.onDecimal128(iProp, dec);
                        break;
                    }
                    default: {
                        throw PofBufferWriter.azzert();
                    }
                }
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeBinary(int iProp, Binary bin) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (bin == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onOctetString(iProp, bin);
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeString(int iProp, String s) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (s == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onCharString(iProp, s);
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeDate(int iProp, Date dt) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dt == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onDate(iProp, dt.getYear() + 1900, dt.getMonth() + 1, dt.getDate());
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeDateTime(int iProp, Date dt) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dt == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onDateTime(iProp, dt.getYear() + 1900, dt.getMonth() + 1, dt.getDate(), dt.getHours(), dt.getMinutes(), dt.getSeconds(), 0, false);
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeDateTime(int iProp, Timestamp dt) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dt == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onDateTime(iProp, dt.getYear() + 1900, dt.getMonth() + 1, dt.getDate(), dt.getHours(), dt.getMinutes(), dt.getSeconds(), dt.getNanos(), false);
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeDateTimeWithZone(int iProp, Date dt) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dt == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                int cMinuteOff = -dt.getTimezoneOffset();
                if (cMinuteOff == 0) {
                    handler.onDateTime(iProp, dt.getYear() + 1900, dt.getMonth() + 1, dt.getDate(), dt.getHours(), dt.getMinutes(), dt.getSeconds(), 0, true);
                } else {
                    int cHourOff = cMinuteOff / 60;
                    cMinuteOff = Math.abs(cMinuteOff);
                    handler.onDateTime(iProp, dt.getYear() + 1900, dt.getMonth() + 1, dt.getDate(), dt.getHours(), dt.getMinutes(), dt.getSeconds(), 0, cHourOff, cHourOff == 0 ? cMinuteOff : cMinuteOff % 60);
                }
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeDateTimeWithZone(int iProp, Timestamp dt) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dt == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                int cMinuteOff = -dt.getTimezoneOffset();
                if (cMinuteOff == 0) {
                    handler.onDateTime(iProp, dt.getYear() + 1900, dt.getMonth() + 1, dt.getDate(), dt.getHours(), dt.getMinutes(), dt.getSeconds(), dt.getNanos(), true);
                } else {
                    int cHourOff = cMinuteOff / 60;
                    cMinuteOff = Math.abs(cMinuteOff);
                    handler.onDateTime(iProp, dt.getYear() + 1900, dt.getMonth() + 1, dt.getDate(), dt.getHours(), dt.getMinutes(), dt.getSeconds(), dt.getNanos(), cHourOff, cHourOff == 0 ? cMinuteOff : cMinuteOff % 60);
                }
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeTime(int iProp, Date dt) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dt == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onTime(iProp, dt.getHours(), dt.getMinutes(), dt.getSeconds(), 0, false);
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeTime(int iProp, Timestamp dt) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dt == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onTime(iProp, dt.getHours(), dt.getMinutes(), dt.getSeconds(), dt.getNanos(), false);
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeTimeWithZone(int iProp, Date dt) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dt == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                int cMinuteOff = -dt.getTimezoneOffset();
                if (cMinuteOff == 0) {
                    handler.onTime(iProp, dt.getHours(), dt.getMinutes(), dt.getSeconds(), 0, true);
                } else {
                    int cHourOff = cMinuteOff / 60;
                    cMinuteOff = Math.abs(cMinuteOff);
                    handler.onTime(iProp, dt.getHours(), dt.getMinutes(), dt.getSeconds(), 0, cHourOff, cHourOff == 0 ? cMinuteOff : cMinuteOff % 60);
                }
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeTimeWithZone(int iProp, Timestamp dt) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dt == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                int cMinuteOff = -dt.getTimezoneOffset();
                if (cMinuteOff == 0) {
                    handler.onTime(iProp, dt.getHours(), dt.getMinutes(), dt.getSeconds(), dt.getNanos(), true);
                } else {
                    int cHourOff = cMinuteOff / 60;
                    cMinuteOff = Math.abs(cMinuteOff);
                    handler.onTime(iProp, dt.getHours(), dt.getMinutes(), dt.getSeconds(), dt.getNanos(), cHourOff, cHourOff == 0 ? cMinuteOff : cMinuteOff % 60);
                }
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeRawDate(int iProp, RawDate date) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (date == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onDate(iProp, date.getYear(), date.getMonth(), date.getDay());
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeRawTime(int iProp, RawTime time) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (time == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                if (time.hasTimezone()) {
                    if (time.isUTC()) {
                        handler.onTime(iProp, time.getHour(), time.getMinute(), time.getSecond(), time.getNano(), true);
                    } else {
                        handler.onTime(iProp, time.getHour(), time.getMinute(), time.getSecond(), time.getNano(), time.getHourOffset(), time.getMinuteOffset());
                    }
                } else {
                    handler.onTime(iProp, time.getHour(), time.getMinute(), time.getSecond(), time.getNano(), false);
                }
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeRawDateTime(int iProp, RawDateTime dt) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dt == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                RawDate date = dt.getRawDate();
                RawTime time = dt.getRawTime();
                if (time.hasTimezone()) {
                    if (time.isUTC()) {
                        handler.onDateTime(iProp, date.getYear(), date.getMonth(), date.getDay(), time.getHour(), time.getMinute(), time.getSecond(), time.getNano(), true);
                    } else {
                        handler.onDateTime(iProp, date.getYear(), date.getMonth(), date.getDay(), time.getHour(), time.getMinute(), time.getSecond(), time.getNano(), time.getHourOffset(), time.getMinuteOffset());
                    }
                } else {
                    handler.onDateTime(iProp, date.getYear(), date.getMonth(), date.getDay(), time.getHour(), time.getMinute(), time.getSecond(), time.getNano(), false);
                }
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeRawYearMonthInterval(int iProp, RawYearMonthInterval interval) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (interval == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onYearMonthInterval(iProp, interval.getYears(), interval.getMonths());
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeRawTimeInterval(int iProp, RawTimeInterval interval) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (interval == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onTimeInterval(iProp, interval.getHours(), interval.getMinutes(), interval.getSeconds(), interval.getNanos());
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeRawDayTimeInterval(int iProp, RawDayTimeInterval interval) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (interval == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onDayTimeInterval(iProp, interval.getDays(), interval.getHours(), interval.getMinutes(), interval.getSeconds(), interval.getNanos());
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeObject(int iProp, Object o) throws IOException {
        this.getPofHandler().registerIdentity(-1);
        switch (PofBufferWriter.getJavaTypeId(o, this.getPofContext())) {
            case 0: {
                this.beginProperty(iProp);
                try {
                    this.getPofHandler().onNullReference(iProp);
                }
                catch (Exception e) {
                    this.onException(e);
                }
                this.endProperty(iProp);
                break;
            }
            case 1: {
                this.writeBoolean(iProp, (Boolean)o);
                break;
            }
            case 2: {
                this.writeByte(iProp, (Byte)o);
                break;
            }
            case 3: {
                this.writeChar(iProp, ((Character)o).charValue());
                break;
            }
            case 4: {
                this.writeShort(iProp, (Short)o);
                break;
            }
            case 5: {
                this.writeInt(iProp, (Integer)o);
                break;
            }
            case 6: {
                this.writeLong(iProp, (Long)o);
                break;
            }
            case 7: {
                this.writeBigInteger(iProp, (BigInteger)o);
                break;
            }
            case 8: {
                this.writeFloat(iProp, ((Float)o).floatValue());
                break;
            }
            case 9: {
                this.writeDouble(iProp, (Double)o);
                break;
            }
            case 10: {
                this.writeRawQuad(iProp, (RawQuad)o);
                break;
            }
            case 11: {
                this.writeBigDecimal(iProp, (BigDecimal)o);
                break;
            }
            case 12: {
                this.writeBinary(iProp, (Binary)o);
                break;
            }
            case 13: {
                this.writeString(iProp, (String)o);
                break;
            }
            case 14: {
                this.writeDate(iProp, (Date)o);
                break;
            }
            case 15: {
                this.writeTimeWithZone(iProp, (Date)o);
                break;
            }
            case 16: {
                this.writeDateTimeWithZone(iProp, (Date)o);
                break;
            }
            case 17: {
                this.writeDateTimeWithZone(iProp, (Timestamp)o);
                break;
            }
            case 18: {
                this.writeRawDate(iProp, (RawDate)o);
                break;
            }
            case 19: {
                this.writeRawTime(iProp, (RawTime)o);
                break;
            }
            case 20: {
                this.writeRawDateTime(iProp, (RawDateTime)o);
                break;
            }
            case 21: {
                this.writeRawYearMonthInterval(iProp, (RawYearMonthInterval)o);
                break;
            }
            case 22: {
                this.writeRawTimeInterval(iProp, (RawTimeInterval)o);
                break;
            }
            case 23: {
                this.writeRawDayTimeInterval(iProp, (RawDayTimeInterval)o);
                break;
            }
            case 24: {
                this.writeBooleanArray(iProp, (boolean[])o);
                break;
            }
            case 25: {
                this.writeByteArray(iProp, (byte[])o);
                break;
            }
            case 26: {
                this.writeCharArray(iProp, (char[])o);
                break;
            }
            case 27: {
                this.writeShortArray(iProp, (short[])o);
                break;
            }
            case 28: {
                this.writeIntArray(iProp, (int[])o);
                break;
            }
            case 29: {
                this.writeLongArray(iProp, (long[])o);
                break;
            }
            case 30: {
                this.writeFloatArray(iProp, (float[])o);
                break;
            }
            case 31: {
                this.writeDoubleArray(iProp, (double[])o);
                break;
            }
            case 32: {
                this.writeObjectArray(iProp, (Object[])o);
                break;
            }
            case 33: {
                this.writeLongArray(iProp, (LongArray)o);
                break;
            }
            case 34: {
                this.writeCollection(iProp, (Collection)o);
                break;
            }
            case 35: {
                this.writeMap(iProp, (Map)o);
                break;
            }
            default: {
                this.beginProperty(iProp);
                try {
                    PofContext ctx = this.getPofContext();
                    int nTypeId = ctx.getUserTypeIdentifier(o);
                    UserTypeWriter writer = new UserTypeWriter(this.getPofHandler(), ctx, nTypeId, iProp);
                    ctx.getPofSerializer(nTypeId).serialize(writer, o);
                }
                catch (Exception e) {
                    this.onException(e);
                }
                this.endProperty(iProp);
            }
        }
    }

    public void writeObjectArray(int iProp, Object[] ao) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (ao == null) {
                handler.onNullReference(iProp);
            } else {
                int cElements = ao.length;
                handler.registerIdentity(-1);
                handler.beginArray(iProp, cElements);
                for (int i = 0; i < cElements; ++i) {
                    this.writeObject(i, ao[i]);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeObjectArray(int iProp, Object[] ao, Class clz) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (ao == null) {
                handler.onNullReference(iProp);
            } else {
                int nTypeId = PofBufferWriter.getPofTypeId(clz, this.getPofContext());
                int cElements = ao.length;
                handler.registerIdentity(-1);
                handler.beginUniformArray(iProp, cElements, nTypeId);
                for (int i = 0; i < cElements; ++i) {
                    Object o = ao[i];
                    PofBufferWriter.assertEqual(clz, o.getClass());
                    this.writeObject(i, ao[i]);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeCollection(int iProp, Collection coll) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (coll == null) {
                handler.onNullReference(iProp);
            } else {
                int cElements = coll.size();
                int cWritten = 0;
                handler.registerIdentity(-1);
                handler.beginCollection(iProp, cElements);
                Iterator iter = coll.iterator();
                while (iter.hasNext()) {
                    this.writeObject(cWritten, iter.next());
                    ++cWritten;
                }
                if (cWritten != cElements) {
                    throw new IOException("expected to write " + cElements + " objects but actually wrote " + cWritten);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeCollection(int iProp, Collection coll, Class clz) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (coll == null) {
                handler.onNullReference(iProp);
            } else {
                int nTypeId = PofBufferWriter.getPofTypeId(clz, this.getPofContext());
                int cElements = coll.size();
                int cWritten = 0;
                handler.registerIdentity(-1);
                handler.beginUniformCollection(iProp, cElements, nTypeId);
                Iterator iter = coll.iterator();
                while (iter.hasNext()) {
                    Object o = iter.next();
                    PofBufferWriter.assertEqual(clz, o.getClass());
                    this.writeObject(cWritten, o);
                    ++cWritten;
                }
                if (cWritten != cElements) {
                    throw new IOException("expected to write " + cElements + " objects but actually wrote " + cWritten);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeLongArray(int iProp, LongArray la) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (la == null) {
                handler.onNullReference(iProp);
            } else {
                long nSize = la.getLastIndex() + 1L;
                int cElements = la.getSize();
                int cWritten = 0;
                if (cElements > 0 && (la.getFirstIndex() < 0L || nSize > Integer.MAX_VALUE)) {
                    throw new IndexOutOfBoundsException("cannot encode LongArray[" + la.getFirstIndex() + ", " + la.getLastIndex() + "] as a POF sparse array");
                }
                handler.registerIdentity(-1);
                handler.beginSparseArray(iProp, (int)nSize);
                LongArray.Iterator iter = la.iterator();
                while (iter.hasNext()) {
                    Object o = iter.next();
                    int n = (int)iter.getIndex();
                    this.writeObject(n, o);
                    ++cWritten;
                }
                if (cWritten != cElements) {
                    throw new IOException("expected to write " + cElements + " objects but actually wrote " + cWritten);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeLongArray(int iProp, LongArray la, Class clz) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (la == null) {
                handler.onNullReference(iProp);
            } else {
                long nSize = la.getLastIndex() + 1L;
                int nTypeId = PofBufferWriter.getPofTypeId(clz, this.getPofContext());
                int cElements = la.getSize();
                int cWritten = 0;
                if (cElements > 0 && (la.getFirstIndex() < 0L || nSize > Integer.MAX_VALUE)) {
                    throw new IndexOutOfBoundsException("cannot encode LongArray[" + la.getFirstIndex() + ", " + la.getLastIndex() + "] as a POF sparse array");
                }
                handler.registerIdentity(-1);
                handler.beginUniformSparseArray(iProp, (int)nSize, nTypeId);
                LongArray.Iterator iter = la.iterator();
                while (iter.hasNext()) {
                    Object o = iter.next();
                    int n = (int)iter.getIndex();
                    PofBufferWriter.assertEqual(clz, o.getClass());
                    this.writeObject(n, o);
                    ++cWritten;
                }
                if (cWritten != cElements) {
                    throw new IOException("expected to write " + cElements + " objects but actually wrote " + cWritten);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeMap(int iProp, Map map) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (map == null) {
                handler.onNullReference(iProp);
            } else {
                int cElements = map.size();
                int cWritten = 0;
                handler.registerIdentity(-1);
                handler.beginMap(iProp, cElements);
                Iterator iter = map.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    Object oKey = entry.getKey();
                    Object oValue = entry.getValue();
                    this.writeObject(cWritten, oKey);
                    this.writeObject(cWritten, oValue);
                    ++cWritten;
                }
                if (cWritten != cElements) {
                    throw new IOException("expected to write " + cElements + " objects but actually wrote " + cWritten);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeMap(int iProp, Map map, Class clzKey) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (map == null) {
                handler.onNullReference(iProp);
            } else {
                int nTypeId = PofBufferWriter.getPofTypeId(clzKey, this.getPofContext());
                int cElements = map.size();
                int cWritten = 0;
                handler.registerIdentity(-1);
                handler.beginUniformKeysMap(iProp, cElements, nTypeId);
                Iterator iter = map.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    Object oKey = entry.getKey();
                    Object oValue = entry.getValue();
                    PofBufferWriter.assertEqual(clzKey, oKey.getClass());
                    this.writeObject(cWritten, oKey);
                    this.writeObject(cWritten, oValue);
                    ++cWritten;
                }
                if (cWritten != cElements) {
                    throw new IOException("expected to write " + cElements + " objects but actually wrote " + cWritten);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeMap(int iProp, Map map, Class clzKey, Class clzValue) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (map == null) {
                handler.onNullReference(iProp);
            } else {
                PofContext ctx = this.getPofContext();
                int nTypeIdKey = PofBufferWriter.getPofTypeId(clzKey, ctx);
                int nTypeIdValue = PofBufferWriter.getPofTypeId(clzValue, ctx);
                int cElements = map.size();
                int cWritten = 0;
                handler.registerIdentity(-1);
                handler.beginUniformMap(iProp, cElements, nTypeIdKey, nTypeIdValue);
                Iterator iter = map.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    Object oKey = entry.getKey();
                    Object oValue = entry.getValue();
                    PofBufferWriter.assertEqual(clzKey, oKey.getClass());
                    PofBufferWriter.assertEqual(clzValue, oValue.getClass());
                    this.writeObject(cWritten, oKey);
                    this.writeObject(cWritten, oValue);
                    ++cWritten;
                }
                if (cWritten != cElements) {
                    throw new IOException("expected to write " + cElements + " objects but actually wrote " + cWritten);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public PofContext getPofContext() {
        return this.m_ctx;
    }

    public void setPofContext(PofContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("PofContext cannot be null");
        }
        this.m_ctx = ctx;
    }

    public int getUserTypeId() {
        return -1;
    }

    public int getVersionId() {
        throw new IllegalStateException("not in a user type");
    }

    public void setVersionId(int nVersionId) {
        throw new IllegalStateException("not in a user type");
    }

    public void writeRemainder(Binary binProps) throws IOException {
        throw new IllegalStateException("not in a user type");
    }

    protected void beginProperty(int iProp) throws IOException {
        if (iProp > 0 && this.getPofHandler().getComplex() == null) {
            throw new IllegalArgumentException("not in a complex type");
        }
    }

    protected void endProperty(int iProp) {
    }

    protected void onException(Exception e) throws IOException {
        Throwable eOrig;
        if (e instanceof WrapperException && (eOrig = ((WrapperException)e).getOriginalException()) instanceof IOException) {
            throw (IOException)eOrig;
        }
        throw PofBufferWriter.ensureRuntimeException(e);
    }

    protected static void assertEqual(Class clz, Class clzTest) {
        if (!clz.equals(clzTest)) {
            throw new IllegalArgumentException("illegal class \"" + clzTest.getName() + "\"; expected \"" + clz.getName() + '\"');
        }
    }

    protected WriteBuffer.BufferOutput getBufferOutput() {
        return this.m_out;
    }

    protected WritingPofHandler getPofHandler() {
        return this.m_handler;
    }

    public static class UserTypeWriter
    extends PofBufferWriter {
        protected int m_nTypeId;
        protected int m_nVersionId;
        protected int m_iProp;
        protected int m_iPrevProp = -1;
        protected boolean m_fUserTypeBegin;
        protected boolean m_fUserTypeEnd;
        protected WritingPofHandler.Complex m_complex;
        static final /* synthetic */ boolean $assertionsDisabled;

        public UserTypeWriter(WriteBuffer.BufferOutput out, PofContext ctx, int nTypeId, int iProp) {
            super(out, ctx);
            if (!$assertionsDisabled && nTypeId < 0) {
                throw new AssertionError();
            }
            this.m_nTypeId = nTypeId;
            this.m_iProp = iProp;
        }

        public UserTypeWriter(WritingPofHandler handler, PofContext ctx, int nTypeId, int iProp) {
            super(handler, ctx);
            if (!$assertionsDisabled && nTypeId < 0) {
                throw new AssertionError();
            }
            this.m_nTypeId = nTypeId;
            this.m_iProp = iProp;
        }

        public void writeObject(int iProp, Object o) throws IOException {
            this.writeUserTypeInfo();
            super.writeObject(iProp, o);
        }

        public int getUserTypeId() {
            return this.m_nTypeId;
        }

        public int getVersionId() {
            return this.m_nVersionId;
        }

        public void setVersionId(int nVersionId) {
            if (nVersionId < 0) {
                throw new IllegalArgumentException("negative version identifier: " + nVersionId);
            }
            this.m_nVersionId = nVersionId;
        }

        public void writeRemainder(Binary binProps) throws IOException {
            this.writeUserTypeInfo();
            try {
                if (binProps != null) {
                    this.getBufferOutput().writeBuffer(binProps);
                }
                this.getPofHandler().endComplexValue();
            }
            catch (Exception e) {
                this.onException(e);
            }
            this.m_fUserTypeEnd = true;
            this.m_complex = null;
        }

        protected void beginProperty(int iProp) throws IOException {
            if (iProp < 0) {
                throw new IllegalArgumentException("negative property index: " + iProp);
            }
            this.writeUserTypeInfo();
            if (this.getPofHandler().getComplex() == this.m_complex && iProp <= this.m_iPrevProp) {
                throw new IllegalArgumentException("previous property index=" + this.m_iPrevProp + ", requested property index=" + iProp);
            }
        }

        protected void endProperty(int iProp) {
            if (this.getPofHandler().getComplex() == this.m_complex) {
                this.m_iPrevProp = iProp;
            }
        }

        protected void onException(Exception e) throws IOException {
            this.m_fUserTypeEnd = true;
            this.m_complex = null;
            super.onException(e);
        }

        protected void writeUserTypeInfo() throws IOException {
            if (this.m_fUserTypeEnd) {
                throw new EOFException("user type POF stream terminated");
            }
            if (!this.m_fUserTypeBegin) {
                WritingPofHandler handler = this.getPofHandler();
                try {
                    handler.beginUserType(this.m_iProp, this.getUserTypeId(), this.getVersionId());
                }
                catch (Exception e) {
                    this.onException(e);
                }
                this.m_fUserTypeBegin = true;
                this.m_complex = handler.getComplex();
            }
        }

        static {
            $assertionsDisabled = !(class$com$tangosol$io$pof$PofBufferWriter == null ? (class$com$tangosol$io$pof$PofBufferWriter = PofBufferWriter.class$("com.tangosol.io.pof.PofBufferWriter")) : class$com$tangosol$io$pof$PofBufferWriter).desiredAssertionStatus();
        }
    }
}

