/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.InputStreaming;
import com.tangosol.io.pof.PofReader;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;

public class PofInputStream
extends InputStream
implements InputStreaming,
DataInput,
ObjectInput {
    private PofReader m_in;
    private int m_nProp;

    public PofInputStream(PofReader in) {
        this.m_in = in;
    }

    public int read() throws IOException {
        return this.m_in.readByte(this.nextIndex());
    }

    public int read(byte[] ab) throws IOException {
        int cb;
        byte[] abActual = this.m_in.readByteArray(this.nextIndex());
        int cbActual = abActual.length;
        if (cbActual > (cb = ab.length)) {
            throw new IOException("read " + cbActual + " bytes, but buffer was only " + cb + " bytes long");
        }
        System.arraycopy(abActual, 0, ab, 0, cbActual);
        return cbActual;
    }

    public int read(byte[] ab, int of, int cb) throws IOException {
        byte[] abActual = this.m_in.readByteArray(this.nextIndex());
        int cbActual = abActual.length;
        if (cbActual > cb) {
            throw new IOException("read " + cbActual + " bytes, but buffer was only " + cb + " bytes long");
        }
        System.arraycopy(abActual, 0, ab, of, cbActual);
        return cbActual;
    }

    public long skip(long cb) throws IOException {
        byte[] abActual = this.m_in.readByteArray(this.nextIndex());
        int cbActual = abActual.length;
        if ((long)cbActual > cb) {
            throw new IOException("skipped" + cbActual + " bytes, but request was only for " + cb + " bytes");
        }
        return cbActual;
    }

    public int available() throws IOException {
        return 0;
    }

    public void close() throws IOException {
    }

    public void mark(int cbReadLimit) {
    }

    public void reset() throws IOException {
        throw new IOException();
    }

    public boolean markSupported() {
        return false;
    }

    public void readFully(byte[] ab) throws IOException {
        int cb;
        byte[] abActual = this.m_in.readByteArray(this.nextIndex());
        int cbActual = abActual.length;
        if (cbActual != (cb = ab.length)) {
            throw new IOException("read " + cbActual + " bytes, but buffer was " + cb + " bytes long");
        }
        System.arraycopy(abActual, 0, ab, 0, cbActual);
    }

    public void readFully(byte[] ab, int of, int cb) throws IOException {
        byte[] abActual = this.m_in.readByteArray(this.nextIndex());
        int cbActual = abActual.length;
        if (cbActual != cb) {
            throw new IOException("read " + cbActual + " bytes, but buffer was " + cb + " bytes long");
        }
        System.arraycopy(abActual, 0, ab, of, cbActual);
    }

    public int skipBytes(int cb) throws IOException {
        return (int)this.skip(cb);
    }

    public boolean readBoolean() throws IOException {
        return this.m_in.readBoolean(this.nextIndex());
    }

    public byte readByte() throws IOException {
        return this.m_in.readByte(this.nextIndex());
    }

    public int readUnsignedByte() throws IOException {
        return this.m_in.readByte(this.nextIndex()) & 0xFF;
    }

    public short readShort() throws IOException {
        return this.m_in.readShort(this.nextIndex());
    }

    public int readUnsignedShort() throws IOException {
        return this.m_in.readShort(this.nextIndex()) & 0xFFFF;
    }

    public char readChar() throws IOException {
        return this.m_in.readChar(this.nextIndex());
    }

    public int readInt() throws IOException {
        return this.m_in.readInt(this.nextIndex());
    }

    public long readLong() throws IOException {
        return this.m_in.readLong(this.nextIndex());
    }

    public float readFloat() throws IOException {
        return this.m_in.readFloat(this.nextIndex());
    }

    public double readDouble() throws IOException {
        return this.m_in.readDouble(this.nextIndex());
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String readUTF() throws IOException {
        return this.m_in.readString(this.nextIndex());
    }

    public Object readObject() throws IOException {
        return this.m_in.readObject(this.nextIndex());
    }

    public PofReader getPofReader() {
        return this.m_in;
    }

    public int nextIndex() {
        return this.m_nProp++;
    }
}

