/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class PortableException
extends RuntimeException
implements PortableObject,
Externalizable {
    private transient boolean m_fRemote;
    private transient String m_sMessage;
    private transient String m_sCauseMessage;
    private transient String m_sCauseDescription;
    private transient String m_sCauseToString;
    private transient String m_sCauseStackTrace;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PortableException() {
        this(null, null);
    }

    public PortableException(String s) {
        this(s, null);
    }

    public PortableException(String s, Throwable e) {
        super(s, e);
    }

    public PortableException(Throwable e) {
        this(null, e);
    }

    public String getMessage() {
        if (this.m_fRemote) {
            String sMessage = this.m_sCauseMessage;
            return sMessage == null ? this.getRemoteMessage() : this.getRemoteMessage() + ' ' + sMessage;
        }
        return super.getMessage();
    }

    public String getLocalizedMessage() {
        if (this.m_fRemote) {
            String sMessage = this.m_sCauseDescription;
            return sMessage == null ? this.getRemoteMessage() : this.getRemoteMessage() + ' ' + sMessage;
        }
        return super.getLocalizedMessage();
    }

    public String toString() {
        if (this.m_fRemote) {
            String sMessage = this.m_sCauseToString;
            return sMessage == null ? this.getRemoteMessage() : this.getRemoteMessage() + ' ' + sMessage;
        }
        return super.toString();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream stream) {
        String sStackTrace = this.m_sCauseStackTrace;
        if (sStackTrace == null || !this.m_fRemote) {
            super.printStackTrace(stream);
        } else {
            PrintStream printStream = stream;
            synchronized (printStream) {
                stream.print(this.getRemoteMessage());
                stream.print(' ');
                stream.print(sStackTrace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter writer) {
        String sStackTrace = this.m_sCauseStackTrace;
        if (sStackTrace == null || !this.m_fRemote) {
            super.printStackTrace(writer);
        } else {
            PrintWriter printWriter = writer;
            synchronized (printWriter) {
                writer.print(this.getRemoteMessage());
                writer.print(' ');
                writer.print(sStackTrace);
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_fRemote = true;
        this.m_sMessage = in.readUTF();
        Throwable e = (Throwable)in.readObject();
        if (e != null) {
            this.m_sCauseMessage = e.getMessage();
            this.m_sCauseDescription = e.getLocalizedMessage();
            this.m_sCauseToString = e.toString();
            this.m_sCauseStackTrace = this.getStackTrace(e);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(super.getMessage());
        out.writeObject(super.getCause());
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_fRemote = true;
        this.m_sMessage = in.readString(0);
        String sCauseMessage = in.readString(1);
        String sCauseDescription = in.readString(2);
        String sCauseToString = in.readString(3);
        if (sCauseDescription == null) {
            sCauseDescription = sCauseMessage;
        }
        if (sCauseToString == null) {
            sCauseToString = sCauseMessage;
        }
        this.m_sCauseMessage = sCauseMessage;
        this.m_sCauseDescription = sCauseDescription;
        this.m_sCauseToString = sCauseToString;
        this.m_sCauseStackTrace = in.readString(4);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeString(0, super.getMessage());
        Throwable e = super.getCause();
        if (e != null) {
            String sCauseMessage = e.getMessage();
            String sCauseDescription = e.getLocalizedMessage();
            String sCauseToString = e.toString();
            out.writeString(1, sCauseMessage);
            if (!Base.equals(sCauseMessage, sCauseDescription)) {
                out.writeString(2, sCauseDescription);
            }
            if (!Base.equals(sCauseMessage, sCauseToString)) {
                out.writeString(3, sCauseToString);
            }
            out.writeString(4, this.getStackTrace(e));
        }
    }

    protected String getRemoteMessage() {
        if (!$assertionsDisabled && !this.m_fRemote) {
            throw new AssertionError();
        }
        String s = this.m_sMessage;
        return s == null ? this.getClass().getName() + " (Remote)" : this.getClass().getName() + " (Remote: " + s + ")";
    }

    protected String getStackTrace(Throwable e) {
        if (!$assertionsDisabled && e == null) {
            throw new AssertionError();
        }
        StringWriter writer = new StringWriter();
        PrintWriter stream = new PrintWriter(writer);
        e.printStackTrace(stream);
        stream.flush();
        stream.close();
        return writer.toString();
    }

    static {
        $assertionsDisabled = !PortableException.class.desiredAssertionStatus();
    }
}

