/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.pof.PofHelper;
import com.tangosol.io.pof.RawDate;
import com.tangosol.io.pof.RawTime;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class RawDateTime
extends PofHelper {
    private RawDate m_date;
    private RawTime m_time;

    public RawDateTime(RawDate date, RawTime time) {
        if (date == null || time == null) {
            throw new IllegalArgumentException("date and time required");
        }
        this.m_date = date;
        this.m_time = time;
    }

    public RawDate getRawDate() {
        return this.m_date;
    }

    public RawTime getRawTime() {
        return this.m_time;
    }

    public Timestamp toSqlTimestamp() {
        Timestamp timestamp = new Timestamp(this.toJavaDate().getTime());
        timestamp.setNanos(this.getRawTime().getNano());
        return timestamp;
    }

    public Date toJavaDate() {
        Calendar calendar;
        RawDate date = this.getRawDate();
        RawTime time = this.getRawTime();
        TimeZone timezone = null;
        if (time != null && time.hasTimezone()) {
            StringBuffer sb = new StringBuffer();
            sb.append("GMT");
            if (!time.isUTC()) {
                int cHours = time.getHourOffset();
                int cMinutes = time.getMinuteOffset();
                if (cHours < 0) {
                    sb.append('-');
                    cHours = -cHours;
                } else {
                    sb.append('+');
                }
                sb.append(cHours).append(':').append(RawDateTime.toDecString(cMinutes, 2));
            }
            timezone = TimeZone.getTimeZone(sb.toString());
        }
        Calendar calendar2 = calendar = timezone == null ? Calendar.getInstance() : Calendar.getInstance(timezone);
        if (date != null) {
            calendar.set(1, date.getYear());
            calendar.set(2, date.getMonth() - 1);
            calendar.set(5, date.getDay());
        }
        if (time != null) {
            calendar.set(11, time.getHour());
            calendar.set(12, time.getMinute());
            calendar.set(13, time.getSecond());
            calendar.set(14, time.getNano() / 1000000);
        }
        return calendar.getTime();
    }

    public boolean equals(Object o) {
        if (o instanceof RawDateTime) {
            RawDateTime that = (RawDateTime)o;
            return this == that || this.getRawDate().equals(that.getRawDate()) && this.getRawTime().equals(that.getRawTime());
        }
        return false;
    }

    public int hashCode() {
        return this.getRawDate().hashCode() ^ this.getRawTime().hashCode();
    }

    public String toString() {
        return this.getRawDate().toString() + ' ' + this.getRawTime().toString();
    }
}

