/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.ConfigurablePofContext;
import com.tangosol.io.pof.EvolvablePortableObject;
import com.tangosol.io.pof.PofBufferWriter;
import com.tangosol.io.pof.PofHelper;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObjectSerializer;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.NullImplementation;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.WeakReference;

public class SafeConfigurablePofContext
extends ConfigurablePofContext {
    public SafeConfigurablePofContext() {
    }

    public SafeConfigurablePofContext(String sLocator) {
        super(sLocator);
    }

    public SafeConfigurablePofContext(XmlElement xml) {
        super(xml);
    }

    public PofSerializer getPofSerializer(int nTypeId) {
        PofSerializer serializer;
        if (nTypeId < 0) {
            throw new IllegalArgumentException("illegal user type: " + nTypeId);
        }
        this.ensureInitialized();
        PofSerializer[] aSerializer = this.getPofConfig().m_aserByTypeId;
        PofSerializer pofSerializer = serializer = nTypeId == Integer.MAX_VALUE || nTypeId >= aSerializer.length ? null : aSerializer[nTypeId];
        if (serializer == null) {
            return new PortableObjectSerializer(nTypeId);
        }
        return serializer;
    }

    public int getUserTypeIdentifier(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        if (o instanceof SafePofHolder) {
            return ((SafePofHolder)o).getTypeId();
        }
        Class<?> clz = o.getClass();
        int nTypeId = this.getUserTypeIdentifierInternal(clz);
        if (nTypeId < 0) {
            if (this.isUserType(clz)) {
                return Integer.MAX_VALUE;
            }
            throw new IllegalArgumentException("unknown user type: " + clz);
        }
        return nTypeId;
    }

    public int getUserTypeIdentifier(Class clz) {
        int nTypeId = this.getUserTypeIdentifierInternal(clz);
        if (nTypeId < 0) {
            if (this.isUserType(clz)) {
                return Integer.MAX_VALUE;
            }
            throw new IllegalArgumentException("unknown user type: " + clz);
        }
        return nTypeId;
    }

    public int getUserTypeIdentifier(String sClass) {
        int nTypeId = this.getUserTypeIdentifierInternal(sClass);
        if (nTypeId < 0) {
            if (this.isUserType(sClass)) {
                return Integer.MAX_VALUE;
            }
            throw new IllegalArgumentException("unknown user type: " + sClass);
        }
        return nTypeId;
    }

    public Class getClass(int nTypeId) {
        WeakReference refClass;
        if (nTypeId < 0) {
            throw new IllegalArgumentException("illegal user type: " + nTypeId);
        }
        this.ensureInitialized();
        WeakReference[] arefClass = this.getPofConfig().m_arefClassByTypeId;
        WeakReference weakReference = refClass = nTypeId == Integer.MAX_VALUE || nTypeId >= arefClass.length ? null : arefClass[nTypeId];
        if (refClass == null) {
            return SafePofHolder.class;
        }
        Class clz = (Class)refClass.get();
        if (clz == null) {
            throw new IllegalStateException("Class for user type " + nTypeId + " is no longer available");
        }
        return clz;
    }

    public boolean isUserType(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        return PofHelper.getJavaTypeId(o, NullImplementation.getPofContext()) == 36;
    }

    public boolean isUserType(Class clz) {
        if (clz == null) {
            throw new IllegalArgumentException("Class is required");
        }
        try {
            return PofHelper.getPofTypeId(clz, NullImplementation.getPofContext()) >= 0;
        }
        catch (IllegalArgumentException e) {
            return true;
        }
    }

    public boolean isUserType(String sClass) {
        if (sClass == null || sClass.length() == 0) {
            throw new IllegalArgumentException("Class name is required");
        }
        try {
            return this.isUserType(this.loadClass(sClass));
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static final class SafePofHolder
    extends ExternalizableHelper
    implements EvolvablePortableObject,
    Externalizable,
    ExternalizableLite {
        public static final int TYPE_ID = Integer.MAX_VALUE;
        private int m_nTypeId;
        private int m_nVersionId;
        private Binary m_binData;

        public SafePofHolder() {
        }

        public SafePofHolder(int nTypeId, int nVersion, Binary binData) {
            if (nTypeId < 0) {
                throw new IllegalArgumentException("Illegal user type identifier: " + nTypeId);
            }
            this.m_nTypeId = nTypeId;
            this.m_nVersionId = nVersion;
            this.m_binData = binData;
        }

        public void readExternal(PofReader in) {
            this.m_nTypeId = in.getUserTypeId();
        }

        public void writeExternal(PofWriter out) {
            if (out instanceof PofBufferWriter.UserTypeWriter) {
                PofBufferWriter.UserTypeWriter writer = (PofBufferWriter.UserTypeWriter)out;
                writer.m_nTypeId = this.m_nTypeId;
            } else if (out.getUserTypeId() != this.m_nTypeId) {
                throw new IllegalArgumentException("User type ID mismatch (" + out.getUserTypeId() + " != " + this.m_nTypeId + ')');
            }
        }

        public int getImplVersion() {
            return this.getDataVersion();
        }

        public int getDataVersion() {
            return this.m_nVersionId;
        }

        public void setDataVersion(int nVersionId) {
            this.m_nVersionId = nVersionId;
        }

        public Binary getFutureData() {
            return this.m_binData;
        }

        public void setFutureData(Binary binFuture) {
            this.m_binData = binFuture;
        }

        public void readExternal(ObjectInput in) throws IOException {
            this.readExternal((DataInput)in);
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            this.writeExternal((DataOutput)out);
        }

        public void readExternal(DataInput in) throws IOException {
            this.m_nTypeId = SafePofHolder.readInt(in);
            this.m_nVersionId = SafePofHolder.readInt(in);
            this.m_binData = (Binary)SafePofHolder.readObject(in);
        }

        public void writeExternal(DataOutput out) throws IOException {
            SafePofHolder.writeInt(out, this.m_nTypeId);
            SafePofHolder.writeInt(out, this.m_nVersionId);
            SafePofHolder.writeObject(out, this.m_binData);
        }

        public int hashCode() {
            Binary binData = this.m_binData;
            return binData == null ? 0 : binData.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof SafePofHolder) {
                SafePofHolder that = (SafePofHolder)o;
                return this.m_nTypeId == that.m_nTypeId && this.m_nVersionId == that.m_nVersionId && SafePofHolder.equals(this.m_binData, that.m_binData);
            }
            return false;
        }

        public String toString() {
            return "SafePofHolder(TypeId=" + this.m_nTypeId + ", VersionId=" + this.m_nVersionId + ", Data=" + this.m_binData + ')';
        }

        public int getTypeId() {
            return this.m_nTypeId;
        }

        public int getVersionId() {
            return this.m_nVersionId;
        }

        public Binary getData() {
            return this.m_binData;
        }
    }
}

