/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.WriteBuffer;
import com.tangosol.io.pof.PofConstants;
import com.tangosol.io.pof.PofHandler;
import com.tangosol.io.pof.PofHelper;
import com.tangosol.io.pof.RawQuad;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class WritingPofHandler
extends PofHelper
implements PofHandler,
PofConstants {
    private WriteBuffer.BufferOutput m_out;
    private Complex m_complex;
    private boolean m_fHasIdentity;
    static final /* synthetic */ boolean $assertionsDisabled;

    public WritingPofHandler(WriteBuffer.BufferOutput out) {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        this.m_out = out;
    }

    public void registerIdentity(int nId) {
        if (!$assertionsDisabled && this.m_fHasIdentity && nId >= 0) {
            throw new AssertionError();
        }
        if (nId >= 0) {
            WriteBuffer.BufferOutput out = this.m_out;
            try {
                out.writePackedInt(-31);
                out.writePackedInt(nId);
            }
            catch (IOException e) {
                throw WritingPofHandler.ensureRuntimeException(e);
            }
        }
        this.m_fHasIdentity = true;
    }

    public void onNullReference(int iPos) {
        if (!this.isSkippable()) {
            this.encodePosition(iPos);
            try {
                this.m_out.writePackedInt(-37);
            }
            catch (IOException e) {
                throw WritingPofHandler.ensureRuntimeException(e);
            }
        }
    }

    public void onIdentityReference(int iPos, int nId) {
        this.encodePosition(iPos);
        WriteBuffer.BufferOutput out = this.m_out;
        try {
            if (this.isTypeIdEncoded(-32)) {
                out.writePackedInt(-32);
            }
            out.writePackedInt(nId);
        }
        catch (IOException e) {
            throw WritingPofHandler.ensureRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onInt16(int iPos, short n) {
        if (n == 0) {
            if (this.isSkippable()) return;
        }
        boolean fCompressable = this.isCompressable();
        this.encodePosition(iPos);
        WriteBuffer.BufferOutput out = this.m_out;
        try {
            if (this.isTypeIdEncoded(-1)) {
                if (n >= -1 && n <= 22 && fCompressable) {
                    out.writePackedInt(WritingPofHandler.encodeTinyInt(n));
                    return;
                }
                out.writePackedInt(-1);
            }
            out.writePackedInt(n);
            return;
        }
        catch (IOException e) {
            throw WritingPofHandler.ensureRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onInt32(int iPos, int n) {
        if (n == 0) {
            if (this.isSkippable()) return;
        }
        boolean fCompressable = this.isCompressable();
        this.encodePosition(iPos);
        WriteBuffer.BufferOutput out = this.m_out;
        try {
            if (this.isTypeIdEncoded(-2)) {
                if (n >= -1 && n <= 22 && fCompressable) {
                    out.writePackedInt(WritingPofHandler.encodeTinyInt(n));
                    return;
                }
                out.writePackedInt(-2);
            }
            out.writePackedInt(n);
            return;
        }
        catch (IOException e) {
            throw WritingPofHandler.ensureRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onInt64(int iPos, long n) {
        if (n == 0L) {
            if (this.isSkippable()) return;
        }
        boolean fCompressable = this.isCompressable();
        this.encodePosition(iPos);
        WriteBuffer.BufferOutput out = this.m_out;
        try {
            if (this.isTypeIdEncoded(-3)) {
                if (n >= -1L && n <= 22L && fCompressable) {
                    out.writePackedInt(WritingPofHandler.encodeTinyInt((int)n));
                    return;
                }
                out.writePackedInt(-3);
            }
            out.writePackedLong(n);
            return;
        }
        catch (IOException e) {
            throw WritingPofHandler.ensureRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onInt128(int iPos, BigInteger n) {
        if (n.equals(BigInteger.ZERO)) {
            if (this.isSkippable()) return;
        }
        boolean fCompressable = this.isCompressable();
        this.encodePosition(iPos);
        WriteBuffer.BufferOutput out = this.m_out;
        try {
            if (this.isTypeIdEncoded(-4)) {
                int nTiny;
                if (n.bitLength() <= 7 && fCompressable && (nTiny = n.intValue()) >= -1 && nTiny <= 22) {
                    out.writePackedInt(WritingPofHandler.encodeTinyInt(nTiny));
                    return;
                }
                out.writePackedInt(-4);
            }
            WritingPofHandler.writeBigInteger(out, n);
            return;
        }
        catch (IOException e) {
            throw WritingPofHandler.ensureRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onFloat32(int iPos, float fl) {
        if (fl == 0.0f) {
            if (this.isSkippable()) return;
        }
        boolean fCompressable = this.isCompressable();
        this.encodePosition(iPos);
        WriteBuffer.BufferOutput out = this.m_out;
        try {
            if (!this.isTypeIdEncoded(-5)) {
                out.writeFloat(fl);
                return;
            }
            int nBits = Float.floatToIntBits(fl);
            if ((nBits & 0xFFFF) == 0 && fCompressable) {
                switch (nBits >>> 16) {
                    case 65408: {
                        out.writePackedInt(-39);
                        return;
                    }
                    case 32640: {
                        out.writePackedInt(-38);
                        return;
                    }
                    case 32704: {
                        out.writePackedInt(-40);
                        return;
                    }
                    case 0: 
                    case 16256: 
                    case 16384: 
                    case 16448: 
                    case 16512: 
                    case 16544: 
                    case 16576: 
                    case 16608: 
                    case 16640: 
                    case 16656: 
                    case 16672: 
                    case 16688: 
                    case 16704: 
                    case 16720: 
                    case 16736: 
                    case 16752: 
                    case 16768: 
                    case 16776: 
                    case 16784: 
                    case 16792: 
                    case 16800: 
                    case 16808: 
                    case 16816: 
                    case 49024: {
                        out.writePackedInt(WritingPofHandler.encodeTinyInt((int)fl));
                        return;
                    }
                }
            }
            out.writePackedInt(-5);
            out.writeInt(nBits);
            return;
        }
        catch (IOException e) {
            throw WritingPofHandler.ensureRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onFloat64(int iPos, double dfl) {
        if (dfl == 0.0) {
            if (this.isSkippable()) return;
        }
        boolean fCompressable = this.isCompressable();
        this.encodePosition(iPos);
        WriteBuffer.BufferOutput out = this.m_out;
        try {
            if (!this.isTypeIdEncoded(-6)) {
                out.writeDouble(dfl);
                return;
            }
            long nBits = Double.doubleToLongBits(dfl);
            if ((nBits & 0xFFFFFFFFFFFFL) == 0L && fCompressable) {
                switch ((int)(nBits >>> 48)) {
                    case 65520: {
                        out.writePackedInt(-39);
                        return;
                    }
                    case 32752: {
                        out.writePackedInt(-38);
                        return;
                    }
                    case 32760: {
                        out.writePackedInt(-40);
                        return;
                    }
                    case 0: 
                    case 16368: 
                    case 16384: 
                    case 16392: 
                    case 16400: 
                    case 16404: 
                    case 16408: 
                    case 16412: 
                    case 16416: 
                    case 16418: 
                    case 16420: 
                    case 16422: 
                    case 16424: 
                    case 16426: 
                    case 16428: 
                    case 16430: 
                    case 16432: 
                    case 16433: 
                    case 16434: 
                    case 16435: 
                    case 16436: 
                    case 16437: 
                    case 16438: 
                    case 49136: {
                        out.writePackedInt(-42 - (int)dfl);
                        return;
                    }
                }
            }
            out.writePackedInt(-6);
            out.writeLong(nBits);
            return;
        }
        catch (IOException e) {
            throw WritingPofHandler.ensureRuntimeException(e);
        }
    }

    public void onFloat128(int iPos, RawQuad qfl) {
        if (!qfl.equals(RawQuad.ZERO) || !this.isSkippable()) {
            this.encodePosition(iPos);
            WriteBuffer.BufferOutput out = this.m_out;
            try {
                if (this.isTypeIdEncoded(-7)) {
                    out.writePackedInt(-7);
                }
                out.writeBuffer(qfl.getBits());
            }
            catch (IOException e) {
                throw WritingPofHandler.ensureRuntimeException(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onDecimal32(int iPos, BigDecimal dec) {
        if (dec.scale() == 0 && dec.unscaledValue().equals(BigInteger.ZERO)) {
            if (this.isSkippable()) return;
        }
        boolean fCompressable = this.isCompressable();
        this.encodePosition(iPos);
        WriteBuffer.BufferOutput out = this.m_out;
        try {
            if (this.isTypeIdEncoded(-8)) {
                int nTiny;
                BigInteger n;
                if (dec.scale() == 0 && fCompressable && (n = dec.unscaledValue()).bitLength() <= 7 && (nTiny = n.intValue()) >= -1 && nTiny <= 22) {
                    out.writePackedInt(WritingPofHandler.encodeTinyInt(nTiny));
                    return;
                }
                out.writePackedInt(-8);
            }
            WritingPofHandler.writeBigDecimal(out, dec, 4);
            return;
        }
        catch (IOException e) {
            throw WritingPofHandler.ensureRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onDecimal64(int iPos, BigDecimal dec) {
        if (dec.scale() == 0 && dec.unscaledValue().equals(BigInteger.ZERO)) {
            if (this.isSkippable()) return;
        }
        boolean fCompressable = this.isCompressable();
        this.encodePosition(iPos);
        WriteBuffer.BufferOutput out = this.m_out;
        try {
            if (this.isTypeIdEncoded(-9)) {
                int nTiny;
                BigInteger n;
                if (dec.scale() == 0 && fCompressable && (n = dec.unscaledValue()).bitLength() <= 7 && (nTiny = n.intValue()) >= -1 && nTiny <= 22) {
                    out.writePackedInt(WritingPofHandler.encodeTinyInt(nTiny));
                    return;
                }
                out.writePackedInt(-9);
            }
            WritingPofHandler.writeBigDecimal(out, dec, 8);
            return;
        }
        catch (IOException e) {
            throw WritingPofHandler.ensureRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onDecimal128(int iPos, BigDecimal dec) {
        if (dec.scale() == 0 && dec.unscaledValue().equals(BigInteger.ZERO)) {
            if (this.isSkippable()) return;
        }
        boolean fCompressable = this.isCompressable();
        this.encodePosition(iPos);
        WriteBuffer.BufferOutput out = this.m_out;
        try {
            if (this.isTypeIdEncoded(-10)) {
                int nTiny;
                BigInteger n;
                if (dec.scale() == 0 && fCompressable && (n = dec.unscaledValue()).bitLength() <= 7 && (nTiny = n.intValue()) >= -1 && nTiny <= 22) {
                    out.writePackedInt(WritingPofHandler.encodeTinyInt(nTiny));
                    return;
                }
                out.writePackedInt(-10);
            }
            WritingPofHandler.writeBigDecimal(out, dec, 16);
            return;
        }
        catch (IOException e) {
            throw WritingPofHandler.ensureRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onBoolean(int iPos, boolean f) {
        if (!f) {
            if (this.isSkippable()) return;
        }
        boolean fCompressable = this.isCompressable();
        this.encodePosition(iPos);
        WriteBuffer.BufferOutput out = this.m_out;
        try {
            if (this.isTypeIdEncoded(-11)) {
                if (fCompressable) {
                    out.writePackedInt(f ? -34 : -33);
                    return;
                }
                out.writePackedInt(-11);
            }
            out.writePackedInt(f ? 1 : 0);
            return;
        }
        catch (IOException e) {
            throw WritingPofHandler.ensureRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onOctet(int iPos, int b) {
        if (b == 0) {
            if (this.isSkippable()) return;
        }
        boolean fCompressable = this.isCompressable();
        this.encodePosition(iPos);
        WriteBuffer.BufferOutput out = this.m_out;
        try {
            if (this.isTypeIdEncoded(-12)) {
                if (fCompressable) {
                    if ((b &= 0xFF) <= 22) {
                        out.writePackedInt(WritingPofHandler.encodeTinyInt(b));
                        return;
                    }
                    if (b == 255) {
                        out.writePackedInt(-41);
                        return;
                    }
                }
                out.writePackedInt(-12);
            }
            out.writeByte(b);
            return;
        }
        catch (IOException e) {
            throw WritingPofHandler.ensureRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onOctetString(int iPos, Binary bin) {
        if (bin.length() == 0) {
            if (this.isSkippable()) return;
        }
        boolean fCompressable = this.isCompressable();
        this.encodePosition(iPos);
        WriteBuffer.BufferOutput out = this.m_out;
        try {
            if (this.isTypeIdEncoded(-13)) {
                if (bin.length() == 0 && fCompressable) {
                    out.writePackedInt(-35);
                    return;
                }
                out.writePackedInt(-13);
            }
            out.writePackedInt(bin.length());
            out.writeBuffer(bin);
            return;
        }
        catch (IOException e) {
            throw WritingPofHandler.ensureRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onChar(int iPos, char ch) {
        if (ch == '\u0000') {
            if (this.isSkippable()) return;
        }
        boolean fCompressable = this.isCompressable();
        this.encodePosition(iPos);
        WriteBuffer.BufferOutput out = this.m_out;
        try {
            if (this.isTypeIdEncoded(-14)) {
                if (fCompressable) {
                    if (ch <= '\u0016') {
                        out.writePackedInt(WritingPofHandler.encodeTinyInt(ch));
                        return;
                    }
                    if (ch == '\uffff') {
                        out.writePackedInt(-41);
                        return;
                    }
                }
                out.writePackedInt(-14);
            }
            if (ch >= '\u0000' && ch <= '\u007f') {
                out.writeByte(ch);
                return;
            }
            if (ch <= '\u07ff') {
                int b0 = 0xC0 | ch >>> 6 & 0x1F;
                int b1 = 0x80 | ch & 0x3F;
                out.writeShort((short)(b0 << 8 | b1));
                return;
            }
            out.writeByte((byte)(0xE0 | ch >>> 12 & 0xF));
            out.writeByte((byte)(0x80 | ch >>> 6 & 0x3F));
            out.writeByte((byte)(0x80 | ch & 0x3F));
            return;
        }
        catch (IOException e) {
            throw WritingPofHandler.ensureRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onCharString(int iPos, String s) {
        if (s.length() == 0) {
            if (this.isSkippable()) return;
        }
        boolean fCompressable = this.isCompressable();
        this.encodePosition(iPos);
        WriteBuffer.BufferOutput out = this.m_out;
        try {
            if (this.isTypeIdEncoded(-15)) {
                if (s.length() == 0 && fCompressable) {
                    out.writePackedInt(-35);
                    return;
                }
                out.writePackedInt(-15);
            }
            out.writeSafeUTF(s);
            return;
        }
        catch (IOException e) {
            throw WritingPofHandler.ensureRuntimeException(e);
        }
    }

    public void onDate(int iPos, int nYear, int nMonth, int nDay) {
        this.encodePosition(iPos);
        WriteBuffer.BufferOutput out = this.m_out;
        try {
            if (this.isTypeIdEncoded(-16)) {
                out.writePackedInt(-16);
            }
            WritingPofHandler.writeDate(out, nYear, nMonth, nDay);
        }
        catch (IOException e) {
            throw WritingPofHandler.ensureRuntimeException(e);
        }
    }

    public void onYearMonthInterval(int iPos, int cYears, int cMonths) {
        this.encodePosition(iPos);
        WriteBuffer.BufferOutput out = this.m_out;
        try {
            if (this.isTypeIdEncoded(-17)) {
                out.writePackedInt(-17);
            }
            out.writePackedInt(cYears);
            out.writePackedInt(cMonths);
        }
        catch (IOException e) {
            throw WritingPofHandler.ensureRuntimeException(e);
        }
    }

    public void onTime(int iPos, int nHour, int nMinute, int nSecond, int nNano, boolean fUTC) {
        this.encodePosition(iPos);
        WriteBuffer.BufferOutput out = this.m_out;
        try {
            if (this.isTypeIdEncoded(-18)) {
                out.writePackedInt(-18);
            }
            WritingPofHandler.writeTime(out, nHour, nMinute, nSecond, nNano, fUTC ? 1 : 0, 0, 0);
        }
        catch (IOException e) {
            throw WritingPofHandler.ensureRuntimeException(e);
        }
    }

    public void onTime(int iPos, int nHour, int nMinute, int nSecond, int nNano, int nHourOffset, int nMinuteOffset) {
        this.encodePosition(iPos);
        WriteBuffer.BufferOutput out = this.m_out;
        try {
            if (this.isTypeIdEncoded(-18)) {
                out.writePackedInt(-18);
            }
            WritingPofHandler.writeTime(out, nHour, nMinute, nSecond, nNano, 2, nHourOffset, nMinuteOffset);
        }
        catch (IOException e) {
            throw WritingPofHandler.ensureRuntimeException(e);
        }
    }

    public void onTimeInterval(int iPos, int cHours, int cMinutes, int cSeconds, int cNanos) {
        this.encodePosition(iPos);
        WriteBuffer.BufferOutput out = this.m_out;
        try {
            if (this.isTypeIdEncoded(-19)) {
                out.writePackedInt(-19);
            }
            out.writePackedInt(cHours);
            out.writePackedInt(cMinutes);
            out.writePackedInt(cSeconds);
            out.writePackedInt(cNanos);
        }
        catch (IOException e) {
            throw WritingPofHandler.ensureRuntimeException(e);
        }
    }

    public void onDateTime(int iPos, int nYear, int nMonth, int nDay, int nHour, int nMinute, int nSecond, int nNano, boolean fUTC) {
        this.encodePosition(iPos);
        WriteBuffer.BufferOutput out = this.m_out;
        try {
            if (this.isTypeIdEncoded(-20)) {
                out.writePackedInt(-20);
            }
            WritingPofHandler.writeDate(out, nYear, nMonth, nDay);
            WritingPofHandler.writeTime(out, nHour, nMinute, nSecond, nNano, fUTC ? 1 : 0, 0, 0);
        }
        catch (IOException e) {
            throw WritingPofHandler.ensureRuntimeException(e);
        }
    }

    public void onDateTime(int iPos, int nYear, int nMonth, int nDay, int nHour, int nMinute, int nSecond, int nNano, int nHourOffset, int nMinuteOffset) {
        this.encodePosition(iPos);
        WriteBuffer.BufferOutput out = this.m_out;
        try {
            if (this.isTypeIdEncoded(-20)) {
                out.writePackedInt(-20);
            }
            WritingPofHandler.writeDate(out, nYear, nMonth, nDay);
            WritingPofHandler.writeTime(out, nHour, nMinute, nSecond, nNano, 2, nHourOffset, nMinuteOffset);
        }
        catch (IOException e) {
            throw WritingPofHandler.ensureRuntimeException(e);
        }
    }

    public void onDayTimeInterval(int iPos, int cDays, int cHours, int cMinutes, int cSeconds, int cNanos) {
        this.encodePosition(iPos);
        WriteBuffer.BufferOutput out = this.m_out;
        try {
            if (this.isTypeIdEncoded(-21)) {
                out.writePackedInt(-21);
            }
            out.writePackedInt(cDays);
            out.writePackedInt(cHours);
            out.writePackedInt(cMinutes);
            out.writePackedInt(cSeconds);
            out.writePackedInt(cNanos);
        }
        catch (IOException e) {
            throw WritingPofHandler.ensureRuntimeException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void beginCollection(int iPos, int cElements) {
        block5: {
            block4: {
                if (cElements != 0 || !this.isSkippable()) break block4;
                this.m_complex = new Complex(this.m_complex, false);
                break block5;
            }
            fCompressable = this.isCompressable();
            this.encodePosition(iPos);
            out = this.m_out;
            try {
                if (!this.isTypeIdEncoded(-22)) ** GOTO lbl14
                if (cElements == 0 && fCompressable) {
                    out.writePackedInt(-36);
                } else {
                    out.writePackedInt(-22);
lbl14:
                    // 2 sources

                    out.writePackedInt(cElements);
                }
            }
            catch (IOException e) {
                throw WritingPofHandler.ensureRuntimeException(e);
            }
            this.m_complex = new Complex(this.m_complex, false);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void beginUniformCollection(int iPos, int cElements, int nType) {
        block5: {
            block4: {
                if (cElements != 0 || !this.isSkippable()) break block4;
                this.m_complex = new Complex(this.m_complex, false);
                break block5;
            }
            fCompressable = this.isCompressable();
            this.encodePosition(iPos);
            out = this.m_out;
            try {
                if (!this.isTypeIdEncoded(-23)) ** GOTO lbl14
                if (cElements == 0 && fCompressable) {
                    out.writePackedInt(-36);
                } else {
                    out.writePackedInt(-23);
lbl14:
                    // 2 sources

                    out.writePackedInt(nType);
                    out.writePackedInt(cElements);
                }
            }
            catch (IOException e) {
                throw WritingPofHandler.ensureRuntimeException(e);
            }
            this.m_complex = new Complex(this.m_complex, false, nType);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void beginArray(int iPos, int cElements) {
        block5: {
            block4: {
                if (cElements != 0 || !this.isSkippable()) break block4;
                this.m_complex = new Complex(this.m_complex, false);
                break block5;
            }
            fCompressable = this.isCompressable();
            this.encodePosition(iPos);
            out = this.m_out;
            try {
                if (!this.isTypeIdEncoded(-24)) ** GOTO lbl14
                if (cElements == 0 && fCompressable) {
                    out.writePackedInt(-36);
                } else {
                    out.writePackedInt(-24);
lbl14:
                    // 2 sources

                    out.writePackedInt(cElements);
                }
            }
            catch (IOException e) {
                throw WritingPofHandler.ensureRuntimeException(e);
            }
            this.m_complex = new Complex(this.m_complex, false);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void beginUniformArray(int iPos, int cElements, int nType) {
        block5: {
            block4: {
                if (cElements != 0 || !this.isSkippable()) break block4;
                this.m_complex = new Complex(this.m_complex, false);
                break block5;
            }
            fCompressable = this.isCompressable();
            this.encodePosition(iPos);
            out = this.m_out;
            try {
                if (!this.isTypeIdEncoded(-25)) ** GOTO lbl14
                if (cElements == 0 && fCompressable) {
                    out.writePackedInt(-36);
                } else {
                    out.writePackedInt(-25);
lbl14:
                    // 2 sources

                    out.writePackedInt(nType);
                    out.writePackedInt(cElements);
                }
            }
            catch (IOException e) {
                throw WritingPofHandler.ensureRuntimeException(e);
            }
            this.m_complex = new Complex(this.m_complex, false, nType);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void beginSparseArray(int iPos, int cElements) {
        block5: {
            block4: {
                if (cElements != 0 || !this.isSkippable()) break block4;
                this.m_complex = new Complex(this.m_complex, false);
                break block5;
            }
            fCompressable = this.isCompressable();
            this.encodePosition(iPos);
            fTerminated = true;
            out = this.m_out;
            try {
                if (!this.isTypeIdEncoded(-26)) ** GOTO lbl16
                if (cElements == 0 && fCompressable) {
                    out.writePackedInt(-36);
                    fTerminated = false;
                } else {
                    out.writePackedInt(-26);
lbl16:
                    // 2 sources

                    out.writePackedInt(cElements);
                }
            }
            catch (IOException e) {
                throw WritingPofHandler.ensureRuntimeException(e);
            }
            this.m_complex = new Complex(this.m_complex, fTerminated);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void beginUniformSparseArray(int iPos, int cElements, int nType) {
        block5: {
            block4: {
                if (cElements != 0 || !this.isSkippable()) break block4;
                this.m_complex = new Complex(this.m_complex, false);
                break block5;
            }
            fCompressable = this.isCompressable();
            this.encodePosition(iPos);
            fTerminated = true;
            out = this.m_out;
            try {
                if (!this.isTypeIdEncoded(-27)) ** GOTO lbl16
                if (cElements == 0 && fCompressable) {
                    out.writePackedInt(-36);
                    fTerminated = false;
                } else {
                    out.writePackedInt(-27);
lbl16:
                    // 2 sources

                    out.writePackedInt(nType);
                    out.writePackedInt(cElements);
                }
            }
            catch (IOException e) {
                throw WritingPofHandler.ensureRuntimeException(e);
            }
            this.m_complex = new Complex(this.m_complex, fTerminated, nType);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void beginMap(int iPos, int cElements) {
        block5: {
            block4: {
                if (cElements != 0 || !this.isSkippable()) break block4;
                this.m_complex = new Complex(this.m_complex, false);
                break block5;
            }
            fCompressable = this.isCompressable();
            this.encodePosition(iPos);
            out = this.m_out;
            try {
                if (!this.isTypeIdEncoded(-28)) ** GOTO lbl14
                if (cElements == 0 && fCompressable) {
                    out.writePackedInt(-36);
                } else {
                    out.writePackedInt(-28);
lbl14:
                    // 2 sources

                    out.writePackedInt(cElements);
                }
            }
            catch (IOException e) {
                throw WritingPofHandler.ensureRuntimeException(e);
            }
            this.m_complex = new Complex(this.m_complex, false);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void beginUniformKeysMap(int iPos, int cElements, int nTypeKeys) {
        block5: {
            block4: {
                if (cElements != 0 || !this.isSkippable()) break block4;
                this.m_complex = new Complex(this.m_complex, false);
                break block5;
            }
            fCompressable = this.isCompressable();
            this.encodePosition(iPos);
            out = this.m_out;
            try {
                if (!this.isTypeIdEncoded(-29)) ** GOTO lbl14
                if (cElements == 0 && fCompressable) {
                    out.writePackedInt(-36);
                } else {
                    out.writePackedInt(-29);
lbl14:
                    // 2 sources

                    out.writePackedInt(nTypeKeys);
                    out.writePackedInt(cElements);
                }
            }
            catch (IOException e) {
                throw WritingPofHandler.ensureRuntimeException(e);
            }
            this.m_complex = new ComplexMap(this.m_complex, nTypeKeys);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void beginUniformMap(int iPos, int cElements, int nTypeKeys, int nTypeValues) {
        block5: {
            block4: {
                if (cElements != 0 || !this.isSkippable()) break block4;
                this.m_complex = new Complex(this.m_complex, false);
                break block5;
            }
            fCompressable = this.isCompressable();
            this.encodePosition(iPos);
            out = this.m_out;
            try {
                if (!this.isTypeIdEncoded(-30)) ** GOTO lbl14
                if (cElements == 0 && fCompressable) {
                    out.writePackedInt(-36);
                } else {
                    out.writePackedInt(-30);
lbl14:
                    // 2 sources

                    out.writePackedInt(nTypeKeys);
                    out.writePackedInt(nTypeValues);
                    out.writePackedInt(cElements);
                }
            }
            catch (IOException e) {
                throw WritingPofHandler.ensureRuntimeException(e);
            }
            this.m_complex = new ComplexMap(this.m_complex, nTypeKeys, nTypeValues);
        }
    }

    public void beginUserType(int iPos, int nUserTypeId, int nVersionId) {
        this.encodePosition(iPos);
        WriteBuffer.BufferOutput out = this.m_out;
        try {
            if (this.isTypeIdEncoded(nUserTypeId)) {
                out.writePackedInt(nUserTypeId);
            }
            out.writePackedInt(nVersionId);
        }
        catch (IOException e) {
            throw WritingPofHandler.ensureRuntimeException(e);
        }
        this.m_complex = new Complex(this.m_complex, true);
    }

    public void endComplexValue() {
        Complex complex = this.m_complex;
        if (complex.isSparse()) {
            try {
                this.m_out.writePackedInt(-1);
            }
            catch (IOException e) {
                throw WritingPofHandler.ensureRuntimeException(e);
            }
        }
        this.m_complex = complex.pop();
    }

    public WriteBuffer.BufferOutput getBufferOutput() {
        return this.m_out;
    }

    protected Complex getComplex() {
        return this.m_complex;
    }

    protected boolean isSkippable() {
        if (this.m_fHasIdentity) {
            return false;
        }
        Complex complex = this.m_complex;
        return complex != null && complex.isSparse();
    }

    protected boolean isCompressable() {
        return !this.m_fHasIdentity;
    }

    protected void encodePosition(int iPos) {
        Complex complex = this.m_complex;
        if (complex != null) {
            complex.onValue(iPos);
            if (iPos >= 0 && complex.isSparse()) {
                try {
                    this.m_out.writePackedInt(iPos);
                }
                catch (IOException e) {
                    throw WritingPofHandler.ensureRuntimeException(e);
                }
            }
        }
        this.m_fHasIdentity = false;
    }

    protected boolean isTypeIdEncoded(int nTypeId) {
        Complex complex = this.m_complex;
        if (!$assertionsDisabled && complex != null && complex.isUniform() && nTypeId != complex.getUniformType()) {
            throw new AssertionError();
        }
        return complex == null || !complex.isUniform();
    }

    static {
        $assertionsDisabled = !WritingPofHandler.class.desiredAssertionStatus();
    }

    public static class ComplexMap
    extends Complex {
        private boolean m_fKey;
        private boolean m_fUniformValue;
        private int m_nValueTypeId;

        public ComplexMap(Complex complexCurrent, int nUniformKeyTypeId) {
            super(complexCurrent, false, nUniformKeyTypeId);
        }

        public ComplexMap(Complex complexCurrent, int nUniformKeyTypeId, int nUniformValTypeId) {
            this(complexCurrent, nUniformKeyTypeId);
            this.m_fUniformValue = true;
            this.m_nValueTypeId = nUniformValTypeId;
        }

        public void onValue(int iPos) {
            this.m_fKey = !this.m_fKey;
        }

        public boolean isUniform() {
            return this.m_fKey ? super.isUniform() : this.m_fUniformValue;
        }

        public int getUniformType() {
            return this.m_fKey ? super.getUniformType() : this.m_nValueTypeId;
        }
    }

    public static class Complex
    extends Base {
        private boolean m_fSparse;
        private boolean m_fUniform;
        private int m_nTypeId;
        private Complex m_complexOuter;

        public Complex(Complex complexCurrent, boolean fEncodePosition) {
            this.m_complexOuter = complexCurrent;
            this.m_fSparse = fEncodePosition;
        }

        public Complex(Complex complexCurrent, boolean fEncodePosition, int nUniformTypeId) {
            this(complexCurrent, fEncodePosition);
            this.m_fUniform = true;
            this.m_nTypeId = nUniformTypeId;
        }

        public void onValue(int iPos) {
        }

        public boolean isUniform() {
            return this.m_fUniform;
        }

        public int getUniformType() {
            return this.m_nTypeId;
        }

        public boolean isSparse() {
            return this.m_fSparse;
        }

        public Complex pop() {
            return this.m_complexOuter;
        }
    }
}

